import numpy as np
import pinocchio as pin
import subprocess
from .. import core as jiminy
from ..core import ContactSensor as ContactSensor, discretize_heightmap as discretize_heightmap
from ..dynamics import Trajectory as Trajectory
from .meshcat.utilities import interactive_mode as interactive_mode
from .panda3d.panda3d_visualizer import Panda3dApp as Panda3dApp, Panda3dViewer as Panda3dViewer, Panda3dVisualizer as Panda3dVisualizer, ShapeType as ShapeType, Tuple3FType as Tuple3FType, Tuple4FType as Tuple4FType, convert_bvh_collision_geometry_to_primitive as convert_bvh_collision_geometry_to_primitive
from _typeshed import Incomplete
from multiprocessing import Process as ProcessMP
from psutil import Process
from threading import RLock
from typing import Any, Callable, Sequence, TypedDict, overload

REPLAY_FRAMERATE: int
CAMERA_INV_TRANSFORM_PANDA3D: Incomplete
CAMERA_INV_TRANSFORM_MESHCAT: Incomplete
DEFAULT_CAMERA_XYZRPY_ABS: Incomplete
DEFAULT_CAMERA_XYZRPY_REL: Incomplete
DEFAULT_WATERMARK_MAXSIZE: Incomplete
CONTACT_FORCE_SCALE: float
EXTERNAL_FORCE_SCALE: float
COLORS: Incomplete
LOGGER: Incomplete

@overload
def interp1d(t_in: np.ndarray, y_in: np.ndarray, t_out: float) -> float: ...
@overload
def interp1d(t_in: np.ndarray, y_in: np.ndarray, t_out: np.ndarray) -> np.ndarray: ...
def is_display_available() -> bool: ...
def get_default_backend() -> str: ...
def get_backend_type(backend_name: str) -> type: ...
def sleep(dt: float) -> None: ...
def get_color_code(color: str | Tuple4FType | None) -> Tuple4FType | None: ...

class _ProcessWrapper:
    def __init__(self, proc: ProcessMP | subprocess.Popen | Process | Panda3dApp) -> None: ...
    def __del__(self) -> None: ...
    def is_parent(self) -> bool: ...
    def is_alive(self) -> bool: ...
    def wait(self, timeout: float) -> None: ...
    def kill(self) -> None: ...
CameraPoseType = tuple[Tuple3FType | None, Tuple3FType | None, int | str | None]

class CameraMotionBreakpointType(TypedDict, total=True):
    t: float
    pose: tuple[Tuple3FType, Tuple3FType]
CameraMotionType = Sequence[CameraMotionBreakpointType]
Matrix3FType = np.ndarray
RotationType = Tuple4FType | Matrix3FType
FramePoseType = tuple[Tuple3FType, RotationType]

class MarkerDataType(TypedDict, total=True):
    pose: np.ndarray | Callable[[], np.ndarray]
    scale: Tuple3FType | Callable[[], Tuple3FType]
    color: Tuple4FType | Callable[[], Tuple4FType] | None

class Viewer:
    backend: str | None
    window_name: str
    robot_name: Incomplete
    robot_color: Incomplete
    scene_name: Incomplete
    use_theoretical_model: Incomplete
    delete_robot_on_close: Incomplete
    markers: Incomplete
    f_external: Incomplete
    is_backend_parent: Incomplete
    def __init__(self, robot: jiminy.Model, use_theoretical_model: bool = False, robot_color: str | Tuple4FType | None = None, lock: RLock | None = None, backend: str | None = None, open_gui_if_parent: bool | None = None, delete_robot_on_close: bool = False, robot_name: str | None = None, scene_name: str = 'world', display_com: bool = False, display_dcm: bool = False, display_contact_frames: bool = False, display_contact_forces: bool = False, display_f_external: Sequence[bool] | bool | None = None, **kwargs: Any) -> None: ...
    def __del__(self) -> None: ...
    @staticmethod
    def open_gui() -> None: ...
    @staticmethod
    def has_gui() -> bool: ...
    @staticmethod
    def wait(require_client: bool = False) -> None: ...
    @staticmethod
    def is_alive() -> bool: ...
    def is_open(self: Incomplete | None = None) -> bool: ...
    def close(self: Incomplete | None = None) -> None: ...
    @staticmethod
    def connect_backend(backend: str | None = None) -> None: ...
    @staticmethod
    def set_watermark(img_fullpath: str | None = None, width: int | None = None, height: int | None = None) -> None: ...
    @staticmethod
    def set_legend(labels: Sequence[str] | None = None) -> None: ...
    @staticmethod
    def set_clock(t: float | None = None) -> None: ...
    @staticmethod
    def get_camera_transform() -> tuple[Tuple3FType, Tuple3FType]: ...
    def set_camera_transform(self: Incomplete | None = None, position: Tuple3FType | None = None, rotation: Tuple3FType | None = None, relative: str | int | None = None, wait: bool = False) -> None: ...
    def set_camera_lookat(self, position: Tuple3FType, relative: str | int | None = None, wait: bool = False) -> None: ...
    @staticmethod
    def register_camera_motion(camera_motion: CameraMotionType) -> None: ...
    @staticmethod
    def remove_camera_motion() -> None: ...
    def attach_camera(self, relative: str | int, position: Tuple3FType | None = None, rotation: Tuple3FType | None = None, lock_relative_pose: bool | None = None) -> None: ...
    @staticmethod
    def detach_camera() -> None: ...
    def set_color(self, color: str | Tuple4FType | None = None) -> None: ...
    @staticmethod
    def update_floor(ground_profile: jiminy.HeightmapFunction | None = None, x_range: tuple[float, float] = (-10.0, 10.0), y_range: tuple[float, float] = (-10.0, 10.0), grid_unit: tuple[float, float] = (0.04, 0.04), simplify_mesh: bool = False, show_vertices: bool = False) -> None: ...
    @staticmethod
    def capture_frame(width: int | None = None, height: int | None = None, raw_data: bool = False) -> np.ndarray | bytes: ...
    @staticmethod
    def save_frame(image_path: str, width: int | None = None, height: int | None = None) -> None: ...
    def display_visuals(self, visibility: bool) -> None: ...
    def display_collisions(self, visibility: bool) -> None: ...
    def add_marker(self, name: str, shape: ShapeType, pose: pin.SE3 | tuple[Tuple3FType | None, RotationType | None] | Callable[[], FramePoseType] = (None, None), scale: float | Tuple3FType | Callable[[], Tuple3FType] = 1.0, color: str | Tuple4FType | None | Callable[[], Tuple4FType] = None, always_foreground: bool = True, remove_if_exists: bool = False, auto_refresh: bool = True, **shape_kwargs: Any) -> MarkerDataType: ...
    def display_center_of_mass(self, visibility: bool) -> None: ...
    def display_capture_point(self, visibility: bool) -> None: ...
    def display_contact_frames(self, visibility: bool) -> None: ...
    def display_contact_forces(self, visibility: bool) -> None: ...
    def display_external_forces(self, visibility: Sequence[bool] | bool) -> None: ...
    def remove_marker(self, name: str) -> None: ...
    def refresh(self, force_update_visual: bool = False, force_update_collision: bool = False, wait: bool = False) -> None: ...
    def display(self, q: np.ndarray, v: np.ndarray | None = None, xyz_offset: np.ndarray | None = None, update_hook: Callable[[], None] | None = None, wait: bool = False) -> None: ...
    def replay(self, trajectory: Trajectory, time_interval: np.ndarray | tuple[float, float] = ..., speed_ratio: float = 1.0, xyz_offset: np.ndarray | None = None, update_hook: Callable[[float, np.ndarray, np.ndarray], None] | None = None, enable_clock: bool = False, wait: bool = False) -> None: ...
