"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined throug the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    /**
     *
     */
    constructor(domainName) {
        this.domainName = domainName;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    /**
     *
     */
    constructor(api) {
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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