"""
    Nuaudit

    Nanaged Audit Trails for Cloud Applications.  # noqa: E501

    The version of the OpenAPI document: 0.15.0
    Contact: support@nuaudit.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nuaudit_python_autogen.api_client import ApiClient, Endpoint as _Endpoint
from nuaudit_python_autogen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nuaudit_python_autogen.model.api_client import APIClient
from nuaudit_python_autogen.model.error_message import ErrorMessage
from nuaudit_python_autogen.model.http_validation_error import HTTPValidationError
from nuaudit_python_autogen.model.role import Role
from nuaudit_python_autogen.model.role_mutation import RoleMutation
from nuaudit_python_autogen.model.user import User


class RolesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_api_client_to_role_endpoint = _Endpoint(
            settings={
                'response_type': ([APIClient],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/api_clients/{api_client_id}',
                'operation_id': 'add_api_client_to_role',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                    'api_client_id',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                    'api_client_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                    'api_client_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                    'api_client_id': 'api_client_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                    'api_client_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.add_user_to_role_endpoint = _Endpoint(
            settings={
                'response_type': ([User],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/users/{user_id}',
                'operation_id': 'add_user_to_role',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                    'user_id',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_role_endpoint = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles',
                'operation_id': 'create_role',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_mutation',
                ],
                'required': [
                    'organization_id',
                    'role_mutation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_mutation':
                        (RoleMutation,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_mutation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_role_endpoint = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}',
                'operation_id': 'delete_role',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_api_clients_for_role_endpoint = _Endpoint(
            settings={
                'response_type': ([User],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/api_clients',
                'operation_id': 'list_api_clients_for_role',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_roles_endpoint = _Endpoint(
            settings={
                'response_type': ([Role],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles',
                'operation_id': 'list_roles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                ],
                'required': [
                    'organization_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_users_for_role_endpoint = _Endpoint(
            settings={
                'response_type': ([User],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/users',
                'operation_id': 'list_users_for_role',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_api_client_from_role_endpoint = _Endpoint(
            settings={
                'response_type': ([APIClient],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/api_clients/{api_client_id}',
                'operation_id': 'remove_api_client_from_role',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                    'api_client_id',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                    'api_client_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                    'api_client_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                    'api_client_id': 'api_client_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                    'api_client_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_user_from_role_endpoint = _Endpoint(
            settings={
                'response_type': ([User],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}/users/{user_id}',
                'operation_id': 'remove_user_from_role',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                    'user_id',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_role_endpoint = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/roles/{role_id}',
                'operation_id': 'update_role',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'role_id',
                    'role_mutation',
                ],
                'required': [
                    'organization_id',
                    'role_id',
                    'role_mutation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'role_id':
                        (str,),
                    'role_mutation':
                        (RoleMutation,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'role_id': 'role_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'role_id': 'path',
                    'role_mutation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def add_api_client_to_role(
        self,
        organization_id,
        role_id,
        api_client_id,
        **kwargs
    ):
        """Add Api Client To Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_api_client_to_role(organization_id, role_id, api_client_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):
            api_client_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [APIClient]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        kwargs['api_client_id'] = \
            api_client_id
        return self.add_api_client_to_role_endpoint.call_with_http_info(**kwargs)

    def add_user_to_role(
        self,
        organization_id,
        role_id,
        user_id,
        **kwargs
    ):
        """Add User To Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_user_to_role(organization_id, role_id, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [User]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        kwargs['user_id'] = \
            user_id
        return self.add_user_to_role_endpoint.call_with_http_info(**kwargs)

    def create_role(
        self,
        organization_id,
        role_mutation,
        **kwargs
    ):
        """Create Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_role(organization_id, role_mutation, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_mutation (RoleMutation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Role
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_mutation'] = \
            role_mutation
        return self.create_role_endpoint.call_with_http_info(**kwargs)

    def delete_role(
        self,
        organization_id,
        role_id,
        **kwargs
    ):
        """Delete Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_role(organization_id, role_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Role
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        return self.delete_role_endpoint.call_with_http_info(**kwargs)

    def list_api_clients_for_role(
        self,
        organization_id,
        role_id,
        **kwargs
    ):
        """List Api Clients For Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_api_clients_for_role(organization_id, role_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [User]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        return self.list_api_clients_for_role_endpoint.call_with_http_info(**kwargs)

    def list_roles(
        self,
        organization_id,
        **kwargs
    ):
        """List Roles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_roles(organization_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Role]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        return self.list_roles_endpoint.call_with_http_info(**kwargs)

    def list_users_for_role(
        self,
        organization_id,
        role_id,
        **kwargs
    ):
        """List Users For Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_users_for_role(organization_id, role_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [User]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        return self.list_users_for_role_endpoint.call_with_http_info(**kwargs)

    def remove_api_client_from_role(
        self,
        organization_id,
        role_id,
        api_client_id,
        **kwargs
    ):
        """Remove Api Client From Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_api_client_from_role(organization_id, role_id, api_client_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):
            api_client_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [APIClient]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        kwargs['api_client_id'] = \
            api_client_id
        return self.remove_api_client_from_role_endpoint.call_with_http_info(**kwargs)

    def remove_user_from_role(
        self,
        organization_id,
        role_id,
        user_id,
        **kwargs
    ):
        """Remove User From Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_from_role(organization_id, role_id, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [User]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        kwargs['user_id'] = \
            user_id
        return self.remove_user_from_role_endpoint.call_with_http_info(**kwargs)

    def update_role(
        self,
        organization_id,
        role_id,
        role_mutation,
        **kwargs
    ):
        """Update Role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_role(organization_id, role_id, role_mutation, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            role_id (str):
            role_mutation (RoleMutation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Role
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['role_id'] = \
            role_id
        kwargs['role_mutation'] = \
            role_mutation
        return self.update_role_endpoint.call_with_http_info(**kwargs)

