import numpy as np
import pinocchio as pin
from . import core as jiminy
from _typeshed import Incomplete
from typing import Any, Callable, Sequence, Tuple, TypedDict

LOGGER: Incomplete

def SE3ToXYZRPY(M: pin.SE3) -> np.ndarray: ...
def XYZRPYToSE3(xyzrpy: np.ndarray) -> np.ndarray: ...
def XYZRPYToXYZQuat(xyzrpy: np.ndarray) -> np.ndarray: ...
def XYZQuatToXYZRPY(xyzquat: np.ndarray) -> np.ndarray: ...
def velocityXYZRPYToXYZQuat(xyzrpy: np.ndarray, dxyzrpy: np.ndarray) -> np.ndarray: ...
def velocityXYZQuatToXYZRPY(xyzquat: np.ndarray, v: np.ndarray) -> np.ndarray: ...

class State:
    t: Incomplete
    q: Incomplete
    v: Incomplete
    a: Incomplete
    tau: Incomplete
    contact_frames: Incomplete
    f_ext: Incomplete
    def __init__(self, t: float, q: np.ndarray, v: np.ndarray | None = None, a: np.ndarray | None = None, tau: np.ndarray | None = None, contact_frames: Sequence[str] | None = None, f_ext: Sequence[np.ndarray] | None = None, copy: bool = False, **kwargs: Any) -> None: ...

class TrajectoryDataType(TypedDict, total=False):
    evolution_robot: Sequence[State]
    robot: jiminy.Robot | None
    use_theoretical_model: bool

def update_quantities(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray | None = None, acceleration: np.ndarray | None = None, update_physics: bool = True, update_com: bool = True, update_energy: bool = True, update_jacobian: bool = False, update_collisions: bool = True, use_theoretical_model: bool = True) -> None: ...
def get_body_world_transform(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = True, copy: bool = True) -> pin.SE3: ...
def get_body_world_velocity(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = True) -> pin.SE3: ...
def get_body_world_acceleration(robot: jiminy.Model, body_name: str, use_theoretical_model: bool = True) -> pin.SE3: ...
def compute_transform_contact(robot: jiminy.Model, ground_profile: Callable[[np.ndarray], Tuple[float, np.ndarray]] | None = None) -> pin.SE3: ...
def compute_freeflyer_state_from_fixed_body(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray | None = None, acceleration: np.ndarray | None = None, fixed_body_name: str | None = None, ground_profile: Callable[[np.ndarray], Tuple[float, np.ndarray]] | None = None, use_theoretical_model: bool | None = None) -> None: ...
def compute_efforts_from_fixed_body(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray, acceleration: np.ndarray, fixed_body_name: str, use_theoretical_model: bool = True) -> Tuple[np.ndarray, pin.Force]: ...
def compute_inverse_dynamics(robot: jiminy.Model, position: np.ndarray, velocity: np.ndarray, acceleration: np.ndarray, use_theoretical_model: bool = False) -> np.ndarray: ...
def compute_freeflyer(trajectory_data: TrajectoryDataType, freeflyer_continuity: bool = True) -> None: ...
def compute_efforts(trajectory_data: TrajectoryDataType) -> None: ...
