import numpy as np
import os
from . import core as jiminy
from .dynamics import TrajectoryDataType as TrajectoryDataType
from .log import build_robot_from_log as build_robot_from_log, read_log as read_log
from .plot import TabbedFigure as TabbedFigure
from .robot import BaseJiminyRobot as BaseJiminyRobot, generate_default_hardware_description_file as generate_default_hardware_description_file
from .viewer import CameraPoseType as CameraPoseType, Viewer as Viewer, extract_replay_data_from_log as extract_replay_data_from_log, get_default_backend as get_default_backend, interactive_mode as interactive_mode, play_trajectories as play_trajectories
from _typeshed import Incomplete
from typing import Any, Callable, Dict, List, Sequence

LOGGER: Incomplete
DEFAULT_UPDATE_PERIOD: float
DEFAULT_GROUND_STIFFNESS: float
DEFAULT_GROUND_DAMPING: float
ProfileForceFunc = Callable[[float, np.ndarray, np.ndarray, np.ndarray], None]

class Simulator:
    viewer_kwargs: Incomplete
    engine: Incomplete
    stepper_state: Incomplete
    is_simulation_running: Incomplete
    def __init__(self, robot: jiminy.Robot, viewer_kwargs: Dict[str, Any] | None = None, **kwargs: Any) -> None: ...
    @classmethod
    def build(cls, urdf_path: str, hardware_path: str | None = None, mesh_path_dir: str | None = None, has_freeflyer: bool = True, config_path: str | None = None, avoid_instable_collisions: bool = True, debug: bool = False, *, robot_name: str = '', **kwargs: Any) -> Simulator: ...
    def add_robot(self, name: str, urdf_path: str, hardware_path: str | None = None, mesh_path_dir: str | None = None, has_freeflyer: bool = True, avoid_instable_collisions: bool = True, debug: bool = False) -> None: ...
    def __del__(self) -> None: ...
    def __getattr__(self, name: str) -> Any: ...
    def __dir__(self) -> List[str]: ...
    @property
    def viewer(self) -> Viewer | None: ...
    @property
    def viewers(self) -> Sequence[Viewer]: ...
    @property
    def robot(self) -> jiminy.Robot: ...
    @property
    def robot_state(self) -> jiminy.RobotState: ...
    @property
    def is_viewer_available(self) -> bool: ...
    def register_profile_force(self, frame_name: str, force_func: ProfileForceFunc, update_period: float = 0.0) -> None: ...
    def register_impulse_force(self, frame_name: str, t: float, dt: float, force: np.ndarray) -> None: ...
    def seed(self, seed: np.uint32 | np.ndarray) -> None: ...
    def reset(self, remove_all_forces: bool = False) -> None: ...
    def start(self, q_init: np.ndarray | Dict[str, np.ndarray], v_init: np.ndarray | Dict[str, np.ndarray], a_init: np.ndarray | Dict[str, np.ndarray] | None = None, is_state_theoretical: bool | None = None) -> None: ...
    def simulate(self, t_end: float, q_init: np.ndarray | Dict[str, np.ndarray], v_init: np.ndarray | Dict[str, np.ndarray], a_init: np.ndarray | Dict[str, np.ndarray] | None = None, is_state_theoretical: bool | None = None, callback: Callable[[], bool] | None = None, log_path: str | None = None, show_progress_bar: bool = True) -> None: ...
    def render(self, return_rgb_array: bool = False, width: int | None = None, height: int | None = None, camera_pose: CameraPoseType | None = None, update_ground_profile: bool | None = None, **kwargs: Any) -> np.ndarray | None: ...
    def replay(self, extra_logs_files: Sequence[Dict[str, np.ndarray]] = (), extra_trajectories: Sequence[TrajectoryDataType] = (), **kwargs: Any) -> None: ...
    def close(self) -> None: ...
    def plot(self, enable_flexiblity_data: bool = False, block: bool | None = None, **kwargs: Any) -> TabbedFigure: ...
    def export_options(self, config_path: str | os.PathLike) -> None: ...
    def import_options(self, config_path: str | os.PathLike) -> None: ...
