F     }(X  // quantum ripple-carry adder from Cuccaro et al, quant-ph/0410184
OPENQASM 2.0;
include "qelib1.inc";
gate majority a,b,c 
{ 
  cx c,b; 
  cx c,a; 
  ccx a,b,c; 
}
gate unmaj a,b,c 
{ 
  ccx a,b,c; 
  cx c,a; 
  cx a,b; 
}
qreg cin[1];
qreg a[4];
qreg b[4];
qreg cout[1];
creg ans[5];
// set input states
x a[0]; // a = 0001
x b;    // b = 1111
// add a to b, storing result in b
majority cin[0],b[0],a[0];
majority a[0],b[1],a[1];
majority a[1],b[2],a[2];
majority a[2],b[3],a[3];
cx a[3],cout[0];
unmaj a[2],b[3],a[3];
unmaj a[1],b[2],a[2];
unmaj a[0],b[1],a[1];
unmaj cin[0],b[0],a[0];
measure b[0] -> ans[0];
measure b[1] -> ans[1];
measure b[2] -> ans[2];
measure b[3] -> ans[3];
measure cout[0] -> ans[4];
}
1000000010G?      sX  OPENQASM 2.0;
include "qelib1.inc";
qreg q[4];
creg c[4];
x q[0];
x q[1];
h q[3];
cx q[2],q[3];
t q[0];
t q[1];
t q[2];
tdg q[3];
cx q[0],q[1];
cx q[2],q[3];
cx q[3],q[0];
cx q[1],q[2];
cx q[0],q[1];
cx q[2],q[3];
tdg q[0];
tdg q[1];
tdg q[2];
t q[3];
cx q[0],q[1];
cx q[2],q[3];
s q[3];
cx q[3],q[0];
h q[3];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
measure q[3] -> c[3];
}(0000G2w0001G94 Wn0110G93w΅]F0111G93w΅]F1000G+t1001G?      1110G2|Lpa]1111G2|Lpa]uX}  // Generated from Cirq v0.8.0

OPENQASM 2.0;
include "qelib1.inc";


// Qubits: [0, 1, 2]
qreg q[3];
creg c[3];


u3(pi*0.5,0,pi*0.0564006755) q[2];
u3(pi*0.5,pi*1.5,pi*0.2945501109) q[1];
u3(pi*0.5,pi*1.5,pi*1.5) q[0];
cz q[1],q[2];
u3(pi*0.1242949803,0,0) q[2];
u3(pi*0.1242949803,pi*0.5,pi*1.5) q[1];
cz q[1],q[2];
u3(pi*0.0298311566,pi*1.5,pi*0.5) q[2];
u3(pi*0.7273849664,pi*1.5,pi*1.0) q[1];
cz q[0],q[1];
u3(pi*0.328242091,0,0) q[1];
u3(pi*0.328242091,pi*0.5,pi*1.5) q[0];
cz q[0],q[1];
u3(pi*0.1374475291,pi*2.0,pi*1.5) q[1];
u3(pi*0.9766098537,0,0) q[0];
cz q[1],q[2];
u3(pi*0.2326621647,0,0) q[2];
u3(pi*0.2326621647,pi*0.5,pi*1.5) q[1];
cz q[1],q[2];
u3(pi*0.5780153762,pi*0.5,pi*0.5) q[2];
u3(pi*0.6257049652,pi*0.5,0) q[1];
cz q[0],q[1];
u3(pi*0.328242091,0,0) q[1];
u3(pi*0.328242091,pi*0.5,pi*1.5) q[0];
cz q[0],q[1];
u3(pi*0.6817377913,0,pi*0.5) q[1];
u3(pi*0.5,pi*0.3593182384,pi*1.5) q[0];
cz q[1],q[2];
u3(pi*0.1242949803,0,0) q[2];
u3(pi*0.1242949803,pi*0.5,pi*1.5) q[1];
cz q[1],q[2];
u3(pi*0.5,pi*1.3937948052,0) q[2];
u3(pi*0.5,pi*1.1556453697,pi*0.5) q[1];

measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];

}(000G?     001G9,<010G9oqh011G95az100G9So101G9 OY"110G9$6?:111G9q;uX  // Generated from Cirq v0.8.0

OPENQASM 2.0;
include "qelib1.inc";


// Qubits: [(0, 0), (0, 1), (1, 0), (1, 1)]
qreg q[4];
creg m_b[1];
creg m_y[1];
creg m_a[1];
creg m_x[1];


h q[0];
h q[1];
h q[3];
cx q[0],q[2];
rx(pi*-0.25) q[0];

// Gate: CNOT**0.5
ry(pi*-0.5) q[2];
u3(pi*0.5,0,pi*0.75) q[3];
u3(pi*0.5,0,pi*0.25) q[2];
rx(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*0.25) q[3];
ry(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[3],q[2];
u3(pi*0.5,pi*0.5,pi*1.0) q[3];
u3(pi*0.5,pi*1.0,pi*1.0) q[2];
ry(pi*0.5) q[2];

// Gate: CNOT**0.5
ry(pi*-0.5) q[0];
u3(pi*0.5,0,pi*0.75) q[1];
u3(pi*0.5,0,pi*0.25) q[0];
rx(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*0.25) q[1];
ry(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[1],q[0];
u3(pi*0.5,pi*0.5,pi*1.0) q[1];
u3(pi*0.5,pi*1.0,pi*1.0) q[0];
ry(pi*0.5) q[0];

measure q[2] -> m_b[0];
measure q[3] -> m_y[0];
measure q[0] -> m_a[0];
measure q[1] -> m_x[0];
}(0000G?PO3?0001G?30010G?PO3?0011G?3y0100G?30101G?PO3?0110G?3w0111G?PO3?1000G?PO3?1001G?3w1010G?3y1011G?PO3?1100G?3w1101G?PO3?1110G?PO3?1111G?3wuOPENQASM 2.0;
include "qelib1.inc";
qreg bits[4];
creg c[4];

h bits[0];
cx bits[0],bits[1];
cx bits[1],bits[2];
cx bits[2],bits[3];

measure bits[0] -> c[0];
measure bits[1] -> c[1];
measure bits[2] -> c[2];
measure bits[3] -> c[3];
}(0000G?     1111G?     u// Implementation of Deutsch algorithm with two qubits for f(x)=x
OPENQASM 2.0;
include "qelib1.inc";

qreg q[2];
creg c[2];

x q[1];
h q[0];
h q[1];
cx q[0],q[1];
h q[0];
measure q[0] -> c[0];
measure q[1] -> c[1];
}(00G2      01G?     10G9Cw΅]K11G?     uX  // A TWO QUBIT CIRCIUT 3 LAYERS DEEP 
// Generated from Cirq v0.8.0

OPENQASM 2.0;
include "qelib1.inc";

// Qubits: [(0, 0), (0, 1)]
qreg q[2];
creg ans[2];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];

// Gate: ZZ**1.1
rz(pi*1.1) q[0];
rz(pi*1.1) q[1];
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.65,pi*1.0) q[0];
u3(pi*0.5,pi*0.15,0) q[1];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[0];
u3(0,0,pi*0.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*1.0,0,pi*0.5) q[0];
u3(pi*1.0,0,pi*1.5) q[1];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.5,pi*0.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

// Gate: ZZ**1.1
rz(pi*1.1) q[1];
rz(pi*1.1) q[0];
u3(pi*0.5,0,pi*0.25) q[1];
u3(pi*0.5,pi*1.0,pi*0.75) q[0];
rx(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*0.4) q[1];
ry(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[1],q[0];
u3(pi*0.5,pi*0.65,pi*1.0) q[1];
u3(pi*0.5,pi*0.15,0) q[0];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[1];
u3(0,0,pi*0.5) q[0];
rx(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*0.4) q[1];
ry(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[1],q[0];
u3(pi*1.0,0,pi*0.5) q[1];
u3(pi*1.0,0,pi*1.5) q[0];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];
rx(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*0.4) q[1];
ry(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[1],q[0];
u3(pi*0.5,pi*0.5,pi*0.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];

rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

// Gate: CNOT**1.1
ry(pi*-0.5) q[1];
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.05) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.3,pi*1.0) q[0];
u3(pi*0.5,pi*1.8,0) q[1];
ry(pi*0.5) q[1];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.05) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.3,pi*1.0) q[0];
u3(pi*0.5,pi*1.8,0) q[1];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];

// Gate: ZZ**1.1
rz(pi*1.1) q[0];
rz(pi*1.1) q[1];
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.65,pi*1.0) q[0];
u3(pi*0.5,pi*0.15,0) q[1];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[0];
u3(0,0,pi*0.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*1.0,0,pi*0.5) q[0];
u3(pi*1.0,0,pi*1.5) q[1];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.5,pi*0.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

// Gate: ZZ**1.1
rz(pi*1.1) q[1];
rz(pi*1.1) q[0];
u3(pi*0.5,0,pi*0.25) q[1];
u3(pi*0.5,pi*1.0,pi*0.75) q[0];
rx(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*0.4) q[1];
ry(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[1],q[0];
u3(pi*0.5,pi*0.65,pi*1.0) q[1];
u3(pi*0.5,pi*0.15,0) q[0];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[1];
u3(0,0,pi*0.5) q[0];
rx(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*0.4) q[1];
ry(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[1],q[0];
u3(pi*1.0,0,pi*0.5) q[1];
u3(pi*1.0,0,pi*1.5) q[0];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];
rx(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*0.4) q[1];
ry(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[1],q[0];
u3(pi*0.5,pi*0.5,pi*0.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];

rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

measure q[0] -> ans[0];
measure q[1] -> ans[1];
}(00G?}B01G?Bw?p10G?ȺOʌ11G?HųuXY  // EIGHT QUBIT DEEP ( 16 dimensions ) 
// Generated from Cirq v0.8.0

OPENQASM 2.0;
include "qelib1.inc";

// Qubits: [(0, 0), (0, 1), (0, 2), (0, 3), (0, 4), (0, 5), (0, 6), (0, 7)]
qreg q[8];
creg ans[8];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];

// Gate: ZZ**1.1
rz(pi*1.1) q[0];
rz(pi*1.1) q[1];
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.65,pi*1.0) q[0];
u3(pi*0.5,pi*0.15,0) q[1];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[0];
u3(0,0,pi*0.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*1.0,0,pi*0.5) q[0];
u3(pi*1.0,0,pi*1.5) q[1];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.5,pi*0.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];
rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];

// Gate: ZZ**1.1
rz(pi*1.1) q[2];
rz(pi*1.1) q[3];
u3(pi*0.5,0,pi*0.25) q[2];
u3(pi*0.5,pi*1.0,pi*0.75) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.4) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*0.5,pi*0.65,pi*1.0) q[2];
u3(pi*0.5,pi*0.15,0) q[3];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[2];
u3(0,0,pi*0.5) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.4) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*1.0,0,pi*0.5) q[2];
u3(pi*1.0,0,pi*1.5) q[3];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[2];
u3(pi*0.5,pi*0.5,pi*1.5) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.4) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*0.5,pi*0.5,pi*0.5) q[2];
u3(pi*0.5,pi*0.5,pi*1.5) q[3];

rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];
rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];
rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];
rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];

// Gate: ZZ**1.1
rz(pi*1.1) q[4];
rz(pi*1.1) q[5];
u3(pi*0.5,0,pi*0.25) q[4];
u3(pi*0.5,pi*1.0,pi*0.75) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.4) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*0.65,pi*1.0) q[4];
u3(pi*0.5,pi*0.15,0) q[5];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[4];
u3(0,0,pi*0.5) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.4) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*1.0,0,pi*0.5) q[4];
u3(pi*1.0,0,pi*1.5) q[5];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[4];
u3(pi*0.5,pi*0.5,pi*1.5) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.4) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*0.5,pi*0.5) q[4];
u3(pi*0.5,pi*0.5,pi*1.5) q[5];

rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];
rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];
rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];
rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];

// Gate: ZZ**1.1
rz(pi*1.1) q[6];
rz(pi*1.1) q[7];
u3(pi*0.5,0,pi*0.25) q[6];
u3(pi*0.5,pi*1.0,pi*0.75) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.4) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*0.5,pi*0.65,pi*1.0) q[6];
u3(pi*0.5,pi*0.15,0) q[7];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[6];
u3(0,0,pi*0.5) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.4) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*1.0,0,pi*0.5) q[6];
u3(pi*1.0,0,pi*1.5) q[7];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[6];
u3(pi*0.5,pi*0.5,pi*1.5) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.4) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*0.5,pi*0.5,pi*0.5) q[6];
u3(pi*0.5,pi*0.5,pi*1.5) q[7];

rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];
rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];

// Gate: ZZ**1.1
rz(pi*1.1) q[1];
rz(pi*1.1) q[2];
u3(pi*0.5,0,pi*0.25) q[1];
u3(pi*0.5,pi*1.0,pi*0.75) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.4) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*0.65,pi*1.0) q[1];
u3(pi*0.5,pi*0.15,0) q[2];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[1];
u3(0,0,pi*0.5) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.4) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*1.0,0,pi*0.5) q[1];
u3(pi*1.0,0,pi*1.5) q[2];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.4) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*0.5,pi*0.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[2];

rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];
rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];
rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];

// Gate: ZZ**1.1
rz(pi*1.1) q[3];
rz(pi*1.1) q[4];
u3(pi*0.5,0,pi*0.25) q[3];
u3(pi*0.5,pi*1.0,pi*0.75) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.4) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*0.5,pi*0.65,pi*1.0) q[3];
u3(pi*0.5,pi*0.15,0) q[4];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[3];
u3(0,0,pi*0.5) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.4) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*1.0,0,pi*0.5) q[3];
u3(pi*1.0,0,pi*1.5) q[4];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[3];
u3(pi*0.5,pi*0.5,pi*1.5) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.4) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*0.5,pi*0.5,pi*0.5) q[3];
u3(pi*0.5,pi*0.5,pi*1.5) q[4];

rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];
rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];
rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];
rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];

// Gate: ZZ**1.1
rz(pi*1.1) q[5];
rz(pi*1.1) q[6];
u3(pi*0.5,0,pi*0.25) q[5];
u3(pi*0.5,pi*1.0,pi*0.75) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.4) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*0.5,pi*0.65,pi*1.0) q[5];
u3(pi*0.5,pi*0.15,0) q[6];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[5];
u3(0,0,pi*0.5) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.4) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*1.0,0,pi*0.5) q[5];
u3(pi*1.0,0,pi*1.5) q[6];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[5];
u3(pi*0.5,pi*0.5,pi*1.5) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.4) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*0.5,pi*0.5,pi*0.5) q[5];
u3(pi*0.5,pi*0.5,pi*1.5) q[6];

rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];
rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];
rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

// Gate: ZZ**1.1
rz(pi*1.1) q[7];
rz(pi*1.1) q[0];
u3(pi*0.5,0,pi*0.25) q[7];
u3(pi*0.5,pi*1.0,pi*0.75) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.4) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*0.5,pi*0.65,pi*1.0) q[7];
u3(pi*0.5,pi*0.15,0) q[0];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[7];
u3(0,0,pi*0.5) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.4) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*1.0,0,pi*0.5) q[7];
u3(pi*1.0,0,pi*1.5) q[0];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[7];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.4) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*0.5,pi*0.5,pi*0.5) q[7];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];

rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

// Gate: CNOT**1.1
ry(pi*-0.5) q[1];
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.05) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.3,pi*1.0) q[0];
u3(pi*0.5,pi*1.8,0) q[1];
ry(pi*0.5) q[1];

// Gate: CNOT**1.1
ry(pi*-0.5) q[3];
u3(pi*0.5,0,pi*0.25) q[2];
u3(pi*0.5,pi*1.0,pi*0.75) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.05) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*0.5,pi*0.3,pi*1.0) q[2];
u3(pi*0.5,pi*1.8,0) q[3];
ry(pi*0.5) q[3];

// Gate: CNOT**1.1
ry(pi*-0.5) q[5];
u3(pi*0.5,0,pi*0.25) q[4];
u3(pi*0.5,pi*1.0,pi*0.75) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.05) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*0.3,pi*1.0) q[4];
u3(pi*0.5,pi*1.8,0) q[5];
ry(pi*0.5) q[5];

// Gate: CNOT**1.1
ry(pi*-0.5) q[7];
u3(pi*0.5,0,pi*0.25) q[6];
u3(pi*0.5,pi*1.0,pi*0.75) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.05) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*0.5,pi*0.3,pi*1.0) q[6];
u3(pi*0.5,pi*1.8,0) q[7];
ry(pi*0.5) q[7];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.05) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.3,pi*1.0) q[0];
u3(pi*0.5,pi*1.8,0) q[1];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[2];
u3(pi*0.5,pi*1.0,pi*0.75) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.05) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*0.5,pi*0.3,pi*1.0) q[2];
u3(pi*0.5,pi*1.8,0) q[3];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[4];
u3(pi*0.5,pi*1.0,pi*0.75) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.05) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*0.3,pi*1.0) q[4];
u3(pi*0.5,pi*1.8,0) q[5];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[6];
u3(pi*0.5,pi*1.0,pi*0.75) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.05) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*0.5,pi*0.3,pi*1.0) q[6];
u3(pi*0.5,pi*1.8,0) q[7];

// Gate: CNOT**1.1
ry(pi*-0.5) q[2];
u3(pi*0.5,0,pi*0.25) q[1];
u3(pi*0.5,pi*1.0,pi*0.75) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.05) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*0.3,pi*1.0) q[1];
u3(pi*0.5,pi*1.8,0) q[2];
ry(pi*0.5) q[2];

// Gate: CNOT**1.1
ry(pi*-0.5) q[4];
u3(pi*0.5,0,pi*0.25) q[3];
u3(pi*0.5,pi*1.0,pi*0.75) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.05) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*0.5,pi*0.3,pi*1.0) q[3];
u3(pi*0.5,pi*1.8,0) q[4];
ry(pi*0.5) q[4];

// Gate: CNOT**1.1
ry(pi*-0.5) q[6];
u3(pi*0.5,0,pi*0.25) q[5];
u3(pi*0.5,pi*1.0,pi*0.75) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.05) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*0.5,pi*0.3,pi*1.0) q[5];
u3(pi*0.5,pi*1.8,0) q[6];
ry(pi*0.5) q[6];

// Gate: CNOT**1.1
ry(pi*-0.5) q[0];
u3(pi*0.5,0,pi*0.25) q[7];
u3(pi*0.5,pi*1.0,pi*0.75) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.05) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*0.5,pi*0.3,pi*1.0) q[7];
u3(pi*0.5,pi*1.8,0) q[0];
ry(pi*0.5) q[0];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[1];
u3(pi*0.5,pi*1.0,pi*0.75) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.05) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*0.3,pi*1.0) q[1];
u3(pi*0.5,pi*1.8,0) q[2];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[3];
u3(pi*0.5,pi*1.0,pi*0.75) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.05) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*0.5,pi*0.3,pi*1.0) q[3];
u3(pi*0.5,pi*1.8,0) q[4];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[5];
u3(pi*0.5,pi*1.0,pi*0.75) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.05) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*0.5,pi*0.3,pi*1.0) q[5];
u3(pi*0.5,pi*1.8,0) q[6];

// Gate: CZ**1.1
u3(pi*0.5,0,pi*0.25) q[7];
u3(pi*0.5,pi*1.0,pi*0.75) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.05) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*0.5,pi*0.3,pi*1.0) q[7];
u3(pi*0.5,pi*1.8,0) q[0];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];

// Gate: ZZ**1.1
rz(pi*1.1) q[0];
rz(pi*1.1) q[1];
u3(pi*0.5,0,pi*0.25) q[0];
u3(pi*0.5,pi*1.0,pi*0.75) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.65,pi*1.0) q[0];
u3(pi*0.5,pi*0.15,0) q[1];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[0];
u3(0,0,pi*0.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*1.0,0,pi*0.5) q[0];
u3(pi*1.0,0,pi*1.5) q[1];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.5,pi*0.5) q[0];
u3(pi*0.5,pi*0.5,pi*1.5) q[1];

rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];
rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];

// Gate: ZZ**1.1
rz(pi*1.1) q[2];
rz(pi*1.1) q[3];
u3(pi*0.5,0,pi*0.25) q[2];
u3(pi*0.5,pi*1.0,pi*0.75) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.4) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*0.5,pi*0.65,pi*1.0) q[2];
u3(pi*0.5,pi*0.15,0) q[3];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[2];
u3(0,0,pi*0.5) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.4) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*1.0,0,pi*0.5) q[2];
u3(pi*1.0,0,pi*1.5) q[3];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[2];
u3(pi*0.5,pi*0.5,pi*1.5) q[3];
rx(pi*0.5) q[2];
cx q[2],q[3];
rx(pi*0.4) q[2];
ry(pi*0.5) q[3];
cx q[3],q[2];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[2],q[3];
u3(pi*0.5,pi*0.5,pi*0.5) q[2];
u3(pi*0.5,pi*0.5,pi*1.5) q[3];

rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];
rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];
rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];
rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];

// Gate: ZZ**1.1
rz(pi*1.1) q[4];
rz(pi*1.1) q[5];
u3(pi*0.5,0,pi*0.25) q[4];
u3(pi*0.5,pi*1.0,pi*0.75) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.4) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*0.65,pi*1.0) q[4];
u3(pi*0.5,pi*0.15,0) q[5];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[4];
u3(0,0,pi*0.5) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.4) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*1.0,0,pi*0.5) q[4];
u3(pi*1.0,0,pi*1.5) q[5];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[4];
u3(pi*0.5,pi*0.5,pi*1.5) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.4) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*0.5,pi*0.5) q[4];
u3(pi*0.5,pi*0.5,pi*1.5) q[5];

rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];
rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];
rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];
rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];

// Gate: ZZ**1.1
rz(pi*1.1) q[6];
rz(pi*1.1) q[7];
u3(pi*0.5,0,pi*0.25) q[6];
u3(pi*0.5,pi*1.0,pi*0.75) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.4) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*0.5,pi*0.65,pi*1.0) q[6];
u3(pi*0.5,pi*0.15,0) q[7];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[6];
u3(0,0,pi*0.5) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.4) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*1.0,0,pi*0.5) q[6];
u3(pi*1.0,0,pi*1.5) q[7];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[6];
u3(pi*0.5,pi*0.5,pi*1.5) q[7];
rx(pi*0.5) q[6];
cx q[6],q[7];
rx(pi*0.4) q[6];
ry(pi*0.5) q[7];
cx q[7],q[6];
rx(pi*-0.5) q[7];
rz(pi*0.5) q[7];
cx q[6],q[7];
u3(pi*0.5,pi*0.5,pi*0.5) q[6];
u3(pi*0.5,pi*0.5,pi*1.5) q[7];

rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];
rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];
rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];

// Gate: ZZ**1.1
rz(pi*1.1) q[1];
rz(pi*1.1) q[2];
u3(pi*0.5,0,pi*0.25) q[1];
u3(pi*0.5,pi*1.0,pi*0.75) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.4) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*0.65,pi*1.0) q[1];
u3(pi*0.5,pi*0.15,0) q[2];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[1];
u3(0,0,pi*0.5) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.4) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*1.0,0,pi*0.5) q[1];
u3(pi*1.0,0,pi*1.5) q[2];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.4) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*0.5,pi*0.5) q[1];
u3(pi*0.5,pi*0.5,pi*1.5) q[2];

rx(pi*0.3501408748) q[1];
ry(pi*0.3501408748) q[1];
rz(pi*0.3501408748) q[1];
rx(pi*0.3501408748) q[2];
ry(pi*0.3501408748) q[2];
rz(pi*0.3501408748) q[2];
rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];
rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];

// Gate: ZZ**1.1
rz(pi*1.1) q[3];
rz(pi*1.1) q[4];
u3(pi*0.5,0,pi*0.25) q[3];
u3(pi*0.5,pi*1.0,pi*0.75) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.4) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*0.5,pi*0.65,pi*1.0) q[3];
u3(pi*0.5,pi*0.15,0) q[4];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[3];
u3(0,0,pi*0.5) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.4) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*1.0,0,pi*0.5) q[3];
u3(pi*1.0,0,pi*1.5) q[4];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[3];
u3(pi*0.5,pi*0.5,pi*1.5) q[4];
rx(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*0.4) q[3];
ry(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[3],q[4];
u3(pi*0.5,pi*0.5,pi*0.5) q[3];
u3(pi*0.5,pi*0.5,pi*1.5) q[4];

rx(pi*0.3501408748) q[3];
ry(pi*0.3501408748) q[3];
rz(pi*0.3501408748) q[3];
rx(pi*0.3501408748) q[4];
ry(pi*0.3501408748) q[4];
rz(pi*0.3501408748) q[4];
rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];
rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];

// Gate: ZZ**1.1
rz(pi*1.1) q[5];
rz(pi*1.1) q[6];
u3(pi*0.5,0,pi*0.25) q[5];
u3(pi*0.5,pi*1.0,pi*0.75) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.4) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*0.5,pi*0.65,pi*1.0) q[5];
u3(pi*0.5,pi*0.15,0) q[6];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[5];
u3(0,0,pi*0.5) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.4) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*1.0,0,pi*0.5) q[5];
u3(pi*1.0,0,pi*1.5) q[6];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[5];
u3(pi*0.5,pi*0.5,pi*1.5) q[6];
rx(pi*0.5) q[5];
cx q[5],q[6];
rx(pi*0.4) q[5];
ry(pi*0.5) q[6];
cx q[6],q[5];
rx(pi*-0.5) q[6];
rz(pi*0.5) q[6];
cx q[5],q[6];
u3(pi*0.5,pi*0.5,pi*0.5) q[5];
u3(pi*0.5,pi*0.5,pi*1.5) q[6];

rx(pi*0.3501408748) q[5];
ry(pi*0.3501408748) q[5];
rz(pi*0.3501408748) q[5];
rx(pi*0.3501408748) q[6];
ry(pi*0.3501408748) q[6];
rz(pi*0.3501408748) q[6];
rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

// Gate: ZZ**1.1
rz(pi*1.1) q[7];
rz(pi*1.1) q[0];
u3(pi*0.5,0,pi*0.25) q[7];
u3(pi*0.5,pi*1.0,pi*0.75) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.4) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*0.5,pi*0.65,pi*1.0) q[7];
u3(pi*0.5,pi*0.15,0) q[0];

// Gate: YY**1.1
u3(0,pi*1.0,pi*0.5) q[7];
u3(0,0,pi*0.5) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.4) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*1.0,0,pi*0.5) q[7];
u3(pi*1.0,0,pi*1.5) q[0];

// Gate: XX**1.1
u3(pi*0.5,pi*1.5,pi*1.5) q[7];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];
rx(pi*0.5) q[7];
cx q[7],q[0];
rx(pi*0.4) q[7];
ry(pi*0.5) q[0];
cx q[0],q[7];
rx(pi*-0.5) q[0];
rz(pi*0.5) q[0];
cx q[7],q[0];
u3(pi*0.5,pi*0.5,pi*0.5) q[7];
u3(pi*0.5,pi*0.5,pi*1.5) q[0];

rx(pi*0.3501408748) q[7];
ry(pi*0.3501408748) q[7];
rz(pi*0.3501408748) q[7];
rx(pi*0.3501408748) q[0];
ry(pi*0.3501408748) q[0];
rz(pi*0.3501408748) q[0];

measure q[0] -> ans[0];
measure q[1] -> ans[1];
measure q[2] -> ans[2];
measure q[3] -> ans[3];
measure q[4] -> ans[4];
measure q[5] -> ans[5];
measure q[6] -> ans[6];
measure q[7] -> ans[7];


}(00000000G?SG00000001G?}!ό00000010G?H00000011G?gK*00000100G?}!׌00000101G?ǎKF00000110G?\L&-;00000111G?N}00001000G?H00001001G?T/00001010G?T"g00001011G?J6#00001100G?gK.00001101G?kۯ֌00001110G?_`T00001111G?b׌ά00010000G?}!ڌ00010001G?3Mh@00010010G?J¥/00010011G?4\BT4׌00010100G?ǎKF̌00010101G?@Gޯ׌00010110G?VRBH9M00010111G?#ox00011000G?\L&-B00011001G?"Č00011010G?lpUV(00011011G?G%=00011100G?N00011101G?Tڐ00011110G?c*ҋ00011111G?X]{00100000G?H00100001G?J¥A00100010G?H)a喌00100011G?C+A00100100G?T600100101G?Exd00100110G?Ycww00100111G?_
jی00101000G?T"b00101001G?tR)00101010G?E#00101011G?)lm#R00101100G?J6#00101101G?9Cۀ00101110G?BJO.00101111G?=kT00110000G?gK/00110001G?4\BT4ی00110010G?C+=00110011G?OǇ76s00110100G?kۯ00110101G?B#-e00110110G?Zygl00110111G?6{b{00111000G?_`T00111001G?-Xx`bJ00111010G?\Oـ00111011G?ST5;00111100G?b׌ά00111101G?2~:q00111110G?DU;00111111G?:01000000G?}!ߌ01000001G?ǎKFȌ01000010G?T801000011G?kۯߌ01000100G?3Mh@~01000101G?@Gޯ01000110G?"01000111G?Tڐ01001000G?J¥301001001G?Exd801001010G?tR401001011G?9Cۀ
01001100G?4\BT4Ҍ01001101G?B#-k01001110G?-Xx`b501001111G?2~:o01010000G?ǎKFǌ01010001G?@Gޯ01010010G?Exd*01010011G?B#-d01010100G?@Gޯ01010101G?Ruv01010110G?6F=01010111G?2zg01011000G?VRBH9N01011001G?6FN01011010G?3.Hq01011011G?O^sa#01011100G?#od01011101G?2zg01011110G?>(b8N01011111G?SѶNnH01100000G?\L&-901100001G?VRBH9N01100010G?Ycww01100011G?Zygl01100100G?"01100101G?6F401100110G?d朒!01100111G?\f401101000G?lpUV(01101001G?3.Hh01101010G?@#ހ)01101011G?S|.U01101100G?G%B01101101G?O^sa-01101110G?^ߙJ&̌01101111G?6^E01110000G?N01110001G?#oғ01110010G?_
jی01110011G?6{b{n01110100G?Tڐ01110101G?2zg01110110G?\f401110111G?hKDf01111000G?c*ҋ01111001G?>(b8r01111010G?a
101111011G?IKCN01111100G?X]{،01111101G?SѶNn=01111110G?Wem01111111G?4Bڌ10000000G?H10000001G?\L&-010000010G?T"Y10000011G?_`T10000100G?J¥10000101G?VRBH9N	10000110G?lpUV10000111G?c*x10001000G?H)a册10001001G?Ycww10001010G?E#
10001011G?BJO&10001100G?C++10001101G?Zygd10001110G?\Oـ10001111G?DU(10010000G?T:10010001G?"10010010G?tR+10010011G?-Xx`bV10010100G?Exd310010101G?6F@10010110G?3.Hf10010111G?>(b8@10011000G?Ycww10011001G?d朒10011010G?@#ހ10011011G?^ߙJ&10011100G?_
j10011101G?\f410011110G?a
110011111G?Wem	10100000G?T"W10100001G?lpUV&10100010G?E#10100011G?\Oـ	10100100G?tR?10100101G?3.Ho10100110G?@#ހ/10100111G?a
1~10101000G?E#10101001G?@#ހ710101010G?H \10101011G>ΞK10101100G?)lm#`10101101G?S|.U10101110G>ΞLk10101111G?10110000G?J6#10110001G?G%>10110010G?)lm#10110011G?ST5>10110100G?9Cۀ,10110101G?O^sa10110110G?S|.U10110111G?IKCO10111000G?BJO710111001G?^ߙJ&̌10111010G>ΞKJ10111011G?dُԁhی10111100G?=kW10111101G?6^E10111110G?10111111G?P Ǎ11000000G?gK.11000001G?N11000010G?J6#̌11000011G?b׌ά11000100G?4\BT4ی11000101G?#oҗ11000110G?G%:11000111G?X]{Ќ11001000G?C+A11001001G?_
j11001010G?)lm#11001011G?=kb11001100G?OǇ76k11001101G?6{b{11001110G?ST5@11001111G?; 11010000G?kۯ11010001G?Tڐx11010010G?9Cۀ11010011G?2~:o11010100G?B#-k11010101G?2zg11010110G?O^sa11010111G?SѶNn;11011000G?Zygt11011001G?\f411011010G?S|.U11011011G?6^E11011100G?6{b{11011101G?hKDd11011110G?IKC^11011111G?4B11100000G?_`Tǌ11100001G?c*~11100010G?BJO211100011G?DU=11100100G?-Xx`be11100101G?>(b8N11100110G?^ߙJ&11100111G?Wem11101000G?\Oـ11101001G?a
1x11101010G>ΞKČ11101011G?11101100G?ST5B11101101G?IKCE11101110G?dُԁh،11101111G?P A11110000G?b׌ά11110001G?X]{11110010G?=kW11110011G?; 11110100G?2~:b11110101G?SѶNn911110110G?6^E11110111G?4B܌11111000G?DUH11111001G?Wem11111010G?11111011G?P Aʌ11111100G?;	11111101G?4B11111110G?P Aʌ11111111G?K^zauX  // Error correction: distance-three 5-qubit code, from the paper "Benchmarking gate-based quantum computers" by K. Michielsen et al.

OPENQASM 2.0;
include "qelib1.inc";

qreg q[5];
creg c[5];

h q[0];
h q[1];
id q[2];
h q[3];
h q[4];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
cx q[4],q[2];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
sdg q[4];
cx q[4],q[2];
h q[2];
cx q[4],q[2];
h q[2];
cx q[0],q[2];
h q[0];
h q[2];
cx q[0],q[2];
h q[0];
h q[2];
cx q[0],q[2];
cx q[3],q[2];
cx q[0],q[2];
h q[0];
h q[2];
cx q[0],q[2];
h q[0];
h q[2];
cx q[0],q[2];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
cx q[3],q[2];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
h q[1];
h q[2];
cx q[1],q[2];
cx q[3],q[2];
cx q[0],q[2];
h q[3];
h q[4];
cx q[3],q[2];
h q[2];
h q[3];
cx q[3],q[2];
h q[2];
h q[3];
cx q[3],q[2];
cx q[0],q[2];
cx q[3],q[2];
h q[2];
h q[3];
cx q[3],q[2];
h q[2];
h q[3];
cx q[3],q[2];
cx q[4],q[2];
h q[2];
h q[4];
cx q[4],q[2];
h q[2];
h q[4];
cx q[4],q[2];
cx q[0],q[2];
cx q[4],q[2];
h q[2];
h q[4];
cx q[4],q[2];
h q[2];
h q[4];
cx q[4],q[2];
cx q[1],q[2] ;
h q[2];
cx q[1],q[2];
h q[1];
cx q[4],q[2];
cx q[0],q[1];
h q[2];
h q[4];
h q[1];
cx q[4],q[2];
h q[2];
h q[4];
cx q[4],q[2];
cx q[1],q[2];
cx q[4],q[2];
h q[2];
h q[4];
cx q[4],q[2];
h q[2];
h q[4];
cx q[4],q[2];
sdg q[1];
h q[2];
h q[3];
h q[4];

measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
measure q[3] -> c[3];
measure q[4] -> c[4];
}(00000G?     00001G9k!Dx00010G9o%ӌ00011G?     00100G9lF)00101G?     00110G?     00111G9oAU`G101000G9ao4N01001G?     01010G?     01011G9[{n01100G?     01101G9H+P01110G9sbj01111G?     10000G9rJ~10001G?     10010G?     10011G9)+{Wb10100G?     10101G99wZ10110G9RmČ10111G?     11000G?     11001G9X,11010G921ض11011G?     11100G9]i11101G?     11110G?     11111G9*xuXJ  OPENQASM 2.0;
include "qelib1.inc";
qreg q[3];
creg c[3];
x q[0];
x q[1];
cx q[2],q[1];
cx q[0],q[1];
h q[2];
t q[0];
tdg q[1];
t q[2];
cx q[2],q[1];
cx q[0],q[2];
t q[1];
cx q[0],q[1];
tdg q[2];
tdg q[1];
cx q[0],q[2];
cx q[2],q[1];
t q[1];
h q[2];
cx q[2],q[1];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
}(011G9R{.ތ101G?uX#  // Name of Experiment: Grover N=2 A=10 v1

OPENQASM 2.0;
include "qelib1.inc";


qreg q[2];
creg c[2];

h q[0];
h q[1];

h q[1];
cx q[0],q[1];
h q[1];

h q[0];
h q[1];
x q[0];
x q[1];
h q[1];
cx q[0],q[1];
h q[1];
x q[0];
x q[1];

h q[0];
h q[1];
measure q[0] -> c[0];
measure q[1] -> c[1];
}(00G2wÌ01G93w΅]M11G?     uX3  OPENQASM 2.0;
include "qelib1.inc";
qreg q0[1];
qreg q1[5];
qreg q2[1];
creg meas[7];
rz(-pi/4) q0[0];
ry(pi) q0[0];
rz(pi/4) q0[0];
rx(3.8098602) q1[0];
ry(-pi/2) q1[0];
cx q1[0],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[0],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(-1.7108829) q1[0];
rx(3.8098602) q1[1];
ry(-pi/2) q1[1];
cx q1[1],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[1],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[1];
cx q1[1],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[1],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(-3.4217658) q1[1];
rx(3.8098602) q1[2];
ry(-pi/2) q1[2];
cx q1[2],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[2];
cx q1[2],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[2];
cx q1[2],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[2];
cx q1[2],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(-0.56034639) q1[2];
rx(3.8098602) q1[3];
ry(-pi/2) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[3];
cx q1[3],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(-1.1206928) q1[3];
rx(3.8098602) q1[4];
ry(-pi/2) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(0.6682675) q0[0];
rz(0.6682675) q1[4];
cx q1[4],q0[0];
rz(2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(-pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-2.4733252) q0[0];
rz(2.4710034) q1[4];
ry(pi/2) q1[4];
cx q1[3],q1[4];
rz(pi/4) q1[4];
cx q1[3],q1[4];
h q1[3];
rz(-pi/4) q1[4];
cx q1[2],q1[4];
rz(pi/8) q1[4];
cx q1[2],q1[4];
rz(-pi/4) q1[2];
cx q1[2],q1[3];
rz(pi/4) q1[3];
cx q1[2],q1[3];
h q1[2];
rz(-pi/4) q1[3];
rz(-pi/8) q1[4];
cx q1[1],q1[4];
rz(pi/16) q1[4];
cx q1[1],q1[4];
rz(-pi/8) q1[1];
cx q1[1],q1[3];
rz(pi/8) q1[3];
cx q1[1],q1[3];
rz(-pi/4) q1[1];
cx q1[1],q1[2];
rz(pi/4) q1[2];
cx q1[1],q1[2];
h q1[1];
rz(-pi/4) q1[2];
rz(-pi/8) q1[3];
rz(-pi/16) q1[4];
cx q1[0],q1[4];
rz(pi/32) q1[4];
cx q1[0],q1[4];
rz(-pi/16) q1[0];
cx q1[0],q1[3];
rz(pi/16) q1[3];
cx q1[0],q1[3];
rz(-pi/8) q1[0];
cx q1[0],q1[2];
rz(pi/8) q1[2];
cx q1[0],q1[2];
rz(-pi/4) q1[0];
cx q1[0],q1[1];
rz(pi/4) q1[1];
cx q1[0],q1[1];
h q1[0];
rz(-pi/4) q1[1];
rz(-pi/8) q1[2];
rz(-pi/16) q1[3];
rz(-pi/32) q1[4];
ry(0.28967817) q2[0];
cx q1[4],q2[0];
ry(-0.07880704) q2[0];
cx q1[3],q2[0];
ry(-0.10745406) q2[0];
cx q1[4],q2[0];
ry(0.059433034) q2[0];
cx q1[2],q2[0];
ry(0.037086759) q2[0];
cx q1[4],q2[0];
ry(-0.11113425) q2[0];
cx q1[3],q2[0];
ry(-0.090469198) q2[0];
cx q1[4],q2[0];
ry(0.11644025) q2[0];
cx q1[1],q2[0];
ry(0.097611808) q2[0];
cx q1[4],q2[0];
ry(-0.09205678) q2[0];
cx q1[3],q2[0];
ry(-0.11154458) q2[0];
cx q1[4],q2[0];
ry(0.033985812) q2[0];
cx q1[2],q2[0];
ry(0.049624102) q2[0];
cx q1[4],q2[0];
ry(-0.10831791) q2[0];
cx q1[3],q2[0];
ry(-0.083772717) q2[0];
cx q1[4],q2[0];
ry(0.16223736) q2[0];
cx q1[0],q2[0];
ry(0.14683263) q2[0];
cx q1[4],q2[0];
ry(-0.084469198) q2[0];
cx q1[3],q2[0];
ry(-0.10841311) q2[0];
cx q1[4],q2[0];
ry(0.048240009) q2[0];
cx q1[2],q2[0];
ry(0.033623576) q2[0];
cx q1[4],q2[0];
ry(-0.11157749) q2[0];
cx q1[3],q2[0];
ry(-0.092239785) q2[0];
cx q1[4],q2[0];
ry(0.094908439) q2[0];
cx q1[1],q2[0];
ry(0.10838905) q2[0];
cx q1[4],q2[0];
ry(-0.090848564) q2[0];
cx q1[3],q2[0];
ry(-0.11118869) q2[0];
cx q1[4],q2[0];
ry(0.036333382) q2[0];
cx q1[2],q2[0];
ry(0.055353647) q2[0];
cx q1[4],q2[0];
ry(-0.107649) q2[0];
cx q1[3],q2[0];
ry(-0.080853948) q2[0];
cx q1[4],q2[0];
ry(0.20101829) q2[0];
cx q1[0],q2[0];
rx(-3*pi/4) q1[0];
ry(-pi/2) q1[0];
cx q1[0],q1[1];
rz(-pi/4) q1[1];
cx q1[0],q1[1];
rz(pi/8) q1[0];
cx q1[0],q1[2];
rz(5*pi/4) q1[1];
ry(pi/2) q1[1];
rz(pi/4) q1[1];
rz(-pi/8) q1[2];
cx q1[0],q1[2];
rz(pi/16) q1[0];
cx q1[0],q1[3];
rz(pi/8) q1[2];
cx q1[1],q1[2];
rz(-pi/4) q1[2];
cx q1[1],q1[2];
rz(pi/8) q1[1];
rz(5*pi/4) q1[2];
ry(pi/2) q1[2];
rz(pi/4) q1[2];
rz(-pi/16) q1[3];
cx q1[0],q1[3];
rz(pi/32) q1[0];
cx q1[0],q1[4];
rz(pi/16) q1[3];
cx q1[1],q1[3];
rz(-pi/8) q1[3];
cx q1[1],q1[3];
rz(pi/16) q1[1];
rz(pi/8) q1[3];
cx q1[2],q1[3];
rz(-pi/4) q1[3];
cx q1[2],q1[3];
rz(pi/8) q1[2];
rz(5*pi/4) q1[3];
ry(pi/2) q1[3];
rz(pi/4) q1[3];
rz(-pi/32) q1[4];
cx q1[0],q1[4];
rz(-0.6682675) q1[0];
rz(pi/32) q1[4];
cx q1[1],q1[4];
rz(-pi/16) q1[4];
cx q1[1],q1[4];
rz(-0.6682675) q1[1];
rz(pi/16) q1[4];
cx q1[2],q1[4];
rz(-pi/8) q1[4];
cx q1[2],q1[4];
rz(-0.6682675) q1[2];
rz(pi/8) q1[4];
cx q1[3],q1[4];
rz(-pi/4) q1[4];
cx q1[3],q1[4];
rz(-0.6682675) q1[3];
rz(-3*pi/4) q1[4];
ry(pi/2) q1[4];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[4];
cx q1[4],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[4],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[3];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[3];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[3];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[3];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[3];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[3];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[3];
cx q1[3],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[3],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
cx q1[2],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[2];
cx q1[2],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[2];
cx q1[2],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[2];
cx q1[2],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[2],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
cx q1[1],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[1],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
rz(-0.6682675) q1[1];
cx q1[1],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[1],q0[0];
ry(1.0108711) q0[0];
rz(-0.6682675) q0[0];
cx q1[0],q0[0];
rz(-2.4733252) q0[0];
ry(1.0108711) q0[0];
rz(pi) q0[0];
cx q1[0],q0[0];
ry(1.0108711) q0[0];
rz(0.90252883) q0[0];
rz(-1.5288845) q1[0];
ry(pi/2) q1[0];
rz(-6.1993617) q1[1];
ry(pi/2) q1[1];
rz(3.30924) q1[2];
ry(pi/2) q1[2];
rz(3.4768873) q1[3];
ry(pi/2) q1[3];
rz(3.8121819) q1[4];
ry(pi/2) q1[4];
barrier q0[0],q1[0],q1[1],q1[2],q1[3],q1[4],q2[0];
measure q0[0] -> meas[0];
measure q1[0] -> meas[1];
measure q1[1] -> meas[2];
measure q1[2] -> meas[3];
measure q1[3] -> meas[4];
measure q1[4] -> meas[5];
measure q2[0] -> meas[6];
}(0000000G?ˬ/0000001G?
0000010G>ժIF0000011G>9ҽ0000100G>#%0000101G>^죤M0000110G>_rG`0000111G>5P,樌0001000G>=*0001001G>n:-0001010G?Y7:0001011G>0]0001100G>j{0001101G>ܫW0001110G?+^?Ќ0001111G>0010000G>1	VB݌0010001G>"h0010010G>pۥ~3)0010011G>_;uH20010100G>DlQ50010101G>3`Fi0010110G>cR0010111G>R`0011000G>~'0011001G>x.c0011010G>gg#\|0011011G>λl_^{0011100G>2_0011101G>]%?|0011110G>S80011111G>amIҌ0100000G>o+!t0100001G>]$Ex0100010G>!R0100011G>[#\I0100100G>wxݗ 0100101G>f*K;.0100110G>7S!dm0100111G>~;Ɍ0101000G>ojF0101001G>Fbf0101010G? Ga_0101011G>e%0101100G>3?0101101G>c0101110G?0k0101111G>5ɒˌ0110000G>1z0110001G>8a0110010G>>0110011G>0110100G>Pvw0110101G>>Jd|0110110G>SB*0110111G>B:H0111000G>uR[Ό0111001G>0111010G>MY0111011G>
`0111100G>zS0111101G>I%b0111110G>荬0111111G>3[1000000G?":%1000001G?Æ31000010G>%tTM1000011G>=1000100G>Nvq=1000101G>(:1000110G>	B;1000111G>
6Č1001000G>͸ez1001001G>潭01001010G>1001011G>wk_H1001100G>⽓Ό1001101G>ю~1001110G>)H1001111G>σ@ƌ1010000G>BU1010001G>1Ɣ̌1010010G>vPΌ1010011G>獴U1010100G>u1010101G>qO8ό1010110G>i ZH1010111G>XXFR*1011000G>7rBM1011001G>rm1011010G>+hl51011011G>w
1011100G>{~B:1011101G>U=j1011110G>-F1011111G>r%҉vR1100000G>b1hv1100001G>Q d!\1100010G>ȩ}1100011G>@sJ1100100G>0krZ1100101G>E*`1100110G>LRj1100111G>|E1101000G>_$qy1101001G>٣i|1101010G?
)\7;1101011G>#
T1101100G>=w1101101G>l 1101110G?A%kӌ1101111G?	.pi1110000G>m@`ތ1110001G>1110010G>:7W1110011G>7O}1110100G>2(S1110101G> +Ռ1110110G>li*1110111G>)6ko1111000G>3,O1111001G><1111010G>>3T1111011G>z
U1111100G>)Uȁ1111101G>rwwb1111110G>ƲP1111111G>B0 uX  OPENQASM 2.0;
include "qelib1.inc";
qreg q[4];
creg c[4];
h q[0];
h q[1];
h q[2];
h q[3];
x q[0];
x q[2];
h q[1];
h q[3];
cx q[0],q[1];
cx q[2],q[3];
h q[1];
h q[3];
x q[0];
x q[2];
h q[0];
h q[1];
h q[2];
h q[3];
h q[1];
h q[3];
cx q[0],q[1];
cx q[2],q[3];
h q[1];
h q[3];
h q[0];
h q[1];
h q[2];
h q[3];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
measure q[3] -> c[3];
}(0000G2A+J8Ќ0001G9#D0010G+|.0011G1E٬}s0100G9#D0101G?     0110G2nB|*0111G9CC1000G+DW)1001G2Y
1010G+px2	2e1011G+M01100G2ٮw1101G9C>1110G+lkX1111G23@auX  // QFT and measure, version 2
OPENQASM 2.0;
include "qelib1.inc";
qreg q[4];
creg c0[1];
creg c1[1];
creg c2[1];
creg c3[1];
h q;
barrier q;
h q[0];
measure q[0] -> c0[0];
if(c0==1) u1(pi/2) q[1];
h q[1];
measure q[1] -> c1[0];
if(c0==1) u1(pi/4) q[2];
if(c1==1) u1(pi/2) q[2];
h q[2];
measure q[2] -> c2[0];
if(c0==1) u1(pi/8) q[3];
if(c1==1) u1(pi/4) q[3];
if(c2==1) u1(pi/2) q[3];
h q[3];
measure q[3] -> c3[0];
}(0000G?     0001G98Tn0010G9:#?[0011G2riqv0100G98Tn0101G2~|\0110G2,0111G+׼ >1000G9:#?[1001G2&ke1010G2tN֌1011G+p PM1100G2&ke1101G+O1110G+󇢖1111G%&]jYuX'  OPENQASM 2.0;
include "qelib1.inc";
qreg reg[10];
creg c[10];

h reg[0];
h reg[1];
h reg[2];
h reg[3];
h reg[4];
h reg[5];
h reg[6];
h reg[7];
h reg[8];
h reg[9];
rz(-3.000000e-01) reg[0];
rz(3.000000e-01) reg[1];
rz(3.000000e-01) reg[1];
cx reg[0],reg[1];
rz(-3.000000e-01) reg[1];
cx reg[0],reg[1];
rz(-3.600000e-01) reg[2];
rz(3.600000e-01) reg[3];
rz(3.600000e-01) reg[3];
cx reg[2],reg[3];
rz(-3.600000e-01) reg[3];
cx reg[2],reg[3];
rz(-1.200000e-01) reg[4];
rz(1.200000e-01) reg[5];
rz(1.200000e-01) reg[5];
cx reg[4],reg[5];
rz(-1.200000e-01) reg[5];
cx reg[4],reg[5];
rz(2.200000e-01) reg[6];
rz(-2.200000e-01) reg[7];
rz(-2.200000e-01) reg[7];
cx reg[6],reg[7];
rz(2.200000e-01) reg[7];
cx reg[6],reg[7];
rz(8.000000e-02) reg[8];
rz(-8.000000e-02) reg[9];
rz(-8.000000e-02) reg[9];
cx reg[8],reg[9];
rz(8.000000e-02) reg[9];
cx reg[8],reg[9];
rz(2.600000e-01) reg[1];
rz(-2.600000e-01) reg[2];
rz(-2.600000e-01) reg[2];
cx reg[1],reg[2];
rz(2.600000e-01) reg[2];
cx reg[1],reg[2];
rz(-2.600000e-01) reg[3];
rz(2.600000e-01) reg[4];
rz(2.600000e-01) reg[4];
cx reg[3],reg[4];
rz(-2.600000e-01) reg[4];
cx reg[3],reg[4];
rz(3.800000e-01) reg[5];
rz(-3.800000e-01) reg[6];
rz(-3.800000e-01) reg[6];
cx reg[5],reg[6];
rz(3.800000e-01) reg[6];
cx reg[5],reg[6];
rz(-2.600000e-01) reg[7];
rz(2.600000e-01) reg[8];
rz(2.600000e-01) reg[8];
cx reg[7],reg[8];
rz(-2.600000e-01) reg[8];
cx reg[7],reg[8];
h reg[0];
rz(-1.920000e+00) reg[0];
h reg[0];
rz(-2.880000e-01) reg[0];
h reg[1];
rz(-1.920000e+00) reg[1];
h reg[1];
rz(8.640000e-01) reg[1];
h reg[2];
rz(-1.920000e+00) reg[2];
h reg[2];
rz(1.152000e+00) reg[2];
h reg[3];
rz(-1.920000e+00) reg[3];
h reg[3];
rz(-1.056000e+00) reg[3];
h reg[4];
rz(-1.920000e+00) reg[4];
h reg[4];
rz(-1.440000e+00) reg[4];
h reg[5];
rz(-1.920000e+00) reg[5];
h reg[5];
rz(-5.760000e-01) reg[5];
h reg[6];
rz(-1.920000e+00) reg[6];
h reg[6];
rz(1.536000e+00) reg[6];
h reg[7];
rz(-1.920000e+00) reg[7];
h reg[7];
rz(-2.880000e-01) reg[7];
h reg[8];
rz(-1.920000e+00) reg[8];
h reg[8];
rz(1.248000e+00) reg[8];
h reg[9];
rz(-1.920000e+00) reg[9];
h reg[9];
rz(-1.824000e+00) reg[9];
rz(-9.000000e-01) reg[0];
rz(9.000000e-01) reg[1];
rz(9.000000e-01) reg[1];
cx reg[0],reg[1];
rz(-9.000000e-01) reg[1];
cx reg[0],reg[1];
rz(-1.080000e+00) reg[2];
rz(1.080000e+00) reg[3];
rz(1.080000e+00) reg[3];
cx reg[2],reg[3];
rz(-1.080000e+00) reg[3];
cx reg[2],reg[3];
rz(-3.600000e-01) reg[4];
rz(3.600000e-01) reg[5];
rz(3.600000e-01) reg[5];
cx reg[4],reg[5];
rz(-3.600000e-01) reg[5];
cx reg[4],reg[5];
rz(6.600000e-01) reg[6];
rz(-6.600000e-01) reg[7];
rz(-6.600000e-01) reg[7];
cx reg[6],reg[7];
rz(6.600000e-01) reg[7];
cx reg[6],reg[7];
rz(2.400000e-01) reg[8];
rz(-2.400000e-01) reg[9];
rz(-2.400000e-01) reg[9];
cx reg[8],reg[9];
rz(2.400000e-01) reg[9];
cx reg[8],reg[9];
rz(7.800000e-01) reg[1];
rz(-7.800000e-01) reg[2];
rz(-7.800000e-01) reg[2];
cx reg[1],reg[2];
rz(7.800000e-01) reg[2];
cx reg[1],reg[2];
rz(-7.800000e-01) reg[3];
rz(7.800000e-01) reg[4];
rz(7.800000e-01) reg[4];
cx reg[3],reg[4];
rz(-7.800000e-01) reg[4];
cx reg[3],reg[4];
rz(1.140000e+00) reg[5];
rz(-1.140000e+00) reg[6];
rz(-1.140000e+00) reg[6];
cx reg[5],reg[6];
rz(1.140000e+00) reg[6];
cx reg[5],reg[6];
rz(-7.800000e-01) reg[7];
rz(7.800000e-01) reg[8];
rz(7.800000e-01) reg[8];
cx reg[7],reg[8];
rz(-7.800000e-01) reg[8];
cx reg[7],reg[8];
h reg[0];
rz(-9.600000e-01) reg[0];
h reg[0];
rz(-1.440000e-01) reg[0];
h reg[1];
rz(-9.600000e-01) reg[1];
h reg[1];
rz(4.320000e-01) reg[1];
h reg[2];
rz(-9.600000e-01) reg[2];
h reg[2];
rz(5.760000e-01) reg[2];
h reg[3];
rz(-9.600000e-01) reg[3];
h reg[3];
rz(-5.280000e-01) reg[3];
h reg[4];
rz(-9.600000e-01) reg[4];
h reg[4];
rz(-7.200000e-01) reg[4];
h reg[5];
rz(-9.600000e-01) reg[5];
h reg[5];
rz(-2.880000e-01) reg[5];
h reg[6];
rz(-9.600000e-01) reg[6];
h reg[6];
rz(7.680000e-01) reg[6];
h reg[7];
rz(-9.600000e-01) reg[7];
h reg[7];
rz(-1.440000e-01) reg[7];
h reg[8];
rz(-9.600000e-01) reg[8];
h reg[8];
rz(6.240000e-01) reg[8];
h reg[9];
rz(-9.600000e-01) reg[9];
h reg[9];
rz(-9.120000e-01) reg[9];
rz(-1.500000e+00) reg[0];
rz(1.500000e+00) reg[1];
rz(1.500000e+00) reg[1];
cx reg[0],reg[1];
rz(-1.500000e+00) reg[1];
cx reg[0],reg[1];
rz(-1.800000e+00) reg[2];
rz(1.800000e+00) reg[3];
rz(1.800000e+00) reg[3];
cx reg[2],reg[3];
rz(-1.800000e+00) reg[3];
cx reg[2],reg[3];
rz(-6.000000e-01) reg[4];
rz(6.000000e-01) reg[5];
rz(6.000000e-01) reg[5];
cx reg[4],reg[5];
rz(-6.000000e-01) reg[5];
cx reg[4],reg[5];
rz(1.100000e+00) reg[6];
rz(-1.100000e+00) reg[7];
rz(-1.100000e+00) reg[7];
cx reg[6],reg[7];
rz(1.100000e+00) reg[7];
cx reg[6],reg[7];
rz(4.000000e-01) reg[8];
rz(-4.000000e-01) reg[9];
rz(-4.000000e-01) reg[9];
cx reg[8],reg[9];
rz(4.000000e-01) reg[9];
cx reg[8],reg[9];
rz(1.300000e+00) reg[1];
rz(-1.300000e+00) reg[2];
rz(-1.300000e+00) reg[2];
cx reg[1],reg[2];
rz(1.300000e+00) reg[2];
cx reg[1],reg[2];
rz(-1.300000e+00) reg[3];
rz(1.300000e+00) reg[4];
rz(1.300000e+00) reg[4];
cx reg[3],reg[4];
rz(-1.300000e+00) reg[4];
cx reg[3],reg[4];
rz(1.900000e+00) reg[5];
rz(-1.900000e+00) reg[6];
rz(-1.900000e+00) reg[6];
cx reg[5],reg[6];
rz(1.900000e+00) reg[6];
cx reg[5],reg[6];
rz(-1.300000e+00) reg[7];
rz(1.300000e+00) reg[8];
rz(1.300000e+00) reg[8];
cx reg[7],reg[8];
rz(-1.300000e+00) reg[8];
cx reg[7],reg[8];
h reg[0];
rz(-0.000000e+00) reg[0];
h reg[0];
rz(-0.000000e+00) reg[0];
h reg[1];
rz(-0.000000e+00) reg[1];
h reg[1];
rz(0.000000e+00) reg[1];
h reg[2];
rz(-0.000000e+00) reg[2];
h reg[2];
rz(0.000000e+00) reg[2];
h reg[3];
rz(-0.000000e+00) reg[3];
h reg[3];
rz(-0.000000e+00) reg[3];
h reg[4];
rz(-0.000000e+00) reg[4];
h reg[4];
rz(-0.000000e+00) reg[4];
h reg[5];
rz(-0.000000e+00) reg[5];
h reg[5];
rz(-0.000000e+00) reg[5];
h reg[6];
rz(-0.000000e+00) reg[6];
h reg[6];
rz(0.000000e+00) reg[6];
h reg[7];
rz(-0.000000e+00) reg[7];
h reg[7];
rz(-0.000000e+00) reg[7];
h reg[8];
rz(-0.000000e+00) reg[8];
h reg[8];
rz(0.000000e+00) reg[8];
h reg[9];
rz(-0.000000e+00) reg[9];
h reg[9];
rz(-0.000000e+00) reg[9];
rz(-2.100000e+00) reg[0];
rz(2.100000e+00) reg[1];
rz(2.100000e+00) reg[1];
cx reg[0],reg[1];
rz(-2.100000e+00) reg[1];
cx reg[0],reg[1];
rz(-2.520000e+00) reg[2];
rz(2.520000e+00) reg[3];
rz(2.520000e+00) reg[3];
cx reg[2],reg[3];
rz(-2.520000e+00) reg[3];
cx reg[2],reg[3];
rz(-8.400000e-01) reg[4];
rz(8.400000e-01) reg[5];
rz(8.400000e-01) reg[5];
cx reg[4],reg[5];
rz(-8.400000e-01) reg[5];
cx reg[4],reg[5];
rz(1.540000e+00) reg[6];
rz(-1.540000e+00) reg[7];
rz(-1.540000e+00) reg[7];
cx reg[6],reg[7];
rz(1.540000e+00) reg[7];
cx reg[6],reg[7];
rz(5.600000e-01) reg[8];
rz(-5.600000e-01) reg[9];
rz(-5.600000e-01) reg[9];
cx reg[8],reg[9];
rz(5.600000e-01) reg[9];
cx reg[8],reg[9];
rz(1.820000e+00) reg[1];
rz(-1.820000e+00) reg[2];
rz(-1.820000e+00) reg[2];
cx reg[1],reg[2];
rz(1.820000e+00) reg[2];
cx reg[1],reg[2];
rz(-1.820000e+00) reg[3];
rz(1.820000e+00) reg[4];
rz(1.820000e+00) reg[4];
cx reg[3],reg[4];
rz(-1.820000e+00) reg[4];
cx reg[3],reg[4];
rz(2.660000e+00) reg[5];
rz(-2.660000e+00) reg[6];
rz(-2.660000e+00) reg[6];
cx reg[5],reg[6];
rz(2.660000e+00) reg[6];
cx reg[5],reg[6];
rz(-1.820000e+00) reg[7];
rz(1.820000e+00) reg[8];
rz(1.820000e+00) reg[8];
cx reg[7],reg[8];
rz(-1.820000e+00) reg[8];
cx reg[7],reg[8];
h reg[0];
rz(9.600000e-01) reg[0];
h reg[0];
rz(1.440000e-01) reg[0];
h reg[1];
rz(9.600000e-01) reg[1];
h reg[1];
rz(-4.320000e-01) reg[1];
h reg[2];
rz(9.600000e-01) reg[2];
h reg[2];
rz(-5.760000e-01) reg[2];
h reg[3];
rz(9.600000e-01) reg[3];
h reg[3];
rz(5.280000e-01) reg[3];
h reg[4];
rz(9.600000e-01) reg[4];
h reg[4];
rz(7.200000e-01) reg[4];
h reg[5];
rz(9.600000e-01) reg[5];
h reg[5];
rz(2.880000e-01) reg[5];
h reg[6];
rz(9.600000e-01) reg[6];
h reg[6];
rz(-7.680000e-01) reg[6];
h reg[7];
rz(9.600000e-01) reg[7];
h reg[7];
rz(1.440000e-01) reg[7];
h reg[8];
rz(9.600000e-01) reg[8];
h reg[8];
rz(-6.240000e-01) reg[8];
h reg[9];
rz(9.600000e-01) reg[9];
h reg[9];
rz(9.120000e-01) reg[9];
rz(-2.700000e+00) reg[0];
rz(2.700000e+00) reg[1];
rz(2.700000e+00) reg[1];
cx reg[0],reg[1];
rz(-2.700000e+00) reg[1];
cx reg[0],reg[1];
rz(-3.240000e+00) reg[2];
rz(3.240000e+00) reg[3];
rz(3.240000e+00) reg[3];
cx reg[2],reg[3];
rz(-3.240000e+00) reg[3];
cx reg[2],reg[3];
rz(-1.080000e+00) reg[4];
rz(1.080000e+00) reg[5];
rz(1.080000e+00) reg[5];
cx reg[4],reg[5];
rz(-1.080000e+00) reg[5];
cx reg[4],reg[5];
rz(1.980000e+00) reg[6];
rz(-1.980000e+00) reg[7];
rz(-1.980000e+00) reg[7];
cx reg[6],reg[7];
rz(1.980000e+00) reg[7];
cx reg[6],reg[7];
rz(7.200000e-01) reg[8];
rz(-7.200000e-01) reg[9];
rz(-7.200000e-01) reg[9];
cx reg[8],reg[9];
rz(7.200000e-01) reg[9];
cx reg[8],reg[9];
rz(2.340000e+00) reg[1];
rz(-2.340000e+00) reg[2];
rz(-2.340000e+00) reg[2];
cx reg[1],reg[2];
rz(2.340000e+00) reg[2];
cx reg[1],reg[2];
rz(-2.340000e+00) reg[3];
rz(2.340000e+00) reg[4];
rz(2.340000e+00) reg[4];
cx reg[3],reg[4];
rz(-2.340000e+00) reg[4];
cx reg[3],reg[4];
rz(3.420000e+00) reg[5];
rz(-3.420000e+00) reg[6];
rz(-3.420000e+00) reg[6];
cx reg[5],reg[6];
rz(3.420000e+00) reg[6];
cx reg[5],reg[6];
rz(-2.340000e+00) reg[7];
rz(2.340000e+00) reg[8];
rz(2.340000e+00) reg[8];
cx reg[7],reg[8];
rz(-2.340000e+00) reg[8];
cx reg[7],reg[8];
h reg[0];
rz(1.920000e+00) reg[0];
h reg[0];
rz(2.880000e-01) reg[0];
h reg[1];
rz(1.920000e+00) reg[1];
h reg[1];
rz(-8.640000e-01) reg[1];
h reg[2];
rz(1.920000e+00) reg[2];
h reg[2];
rz(-1.152000e+00) reg[2];
h reg[3];
rz(1.920000e+00) reg[3];
h reg[3];
rz(1.056000e+00) reg[3];
h reg[4];
rz(1.920000e+00) reg[4];
h reg[4];
rz(1.440000e+00) reg[4];
h reg[5];
rz(1.920000e+00) reg[5];
h reg[5];
rz(5.760000e-01) reg[5];
h reg[6];
rz(1.920000e+00) reg[6];
h reg[6];
rz(-1.536000e+00) reg[6];
h reg[7];
rz(1.920000e+00) reg[7];
h reg[7];
rz(2.880000e-01) reg[7];
h reg[8];
rz(1.920000e+00) reg[8];
h reg[8];
rz(-1.248000e+00) reg[8];
h reg[9];
rz(1.920000e+00) reg[9];
h reg[9];
rz(1.824000e+00) reg[9];

measure reg[0] -> c[0];
measure reg[1] -> c[1];
measure reg[2] -> c[2];
measure reg[3] -> c[3];
measure reg[4] -> c[4];
measure reg[5] -> c[5];
measure reg[6] -> c[6];
measure reg[7] -> c[7];
measure reg[8] -> c[8];
measure reg[9] -> c[9];

R      }(
0000000000G>\Z
0000000001G?	
0000000010G?
}E
0000000011G>Q
0000000100G?P(
0000000101G>
0000000110G>
,L
0000000111G>Anʌ
0000001000G?0Qǌ
0000001001G?B
K)
0000001010G?I2
0000001011G?CЌ
0000001100G?<
T	
0000001101G?8ό
0000001110G?sU
0000001111G>cHb
0000010000G?KY.9
0000010001G?`YŌ
0000010010G?d^YnQ6
0000010011G?[v 
0000010100G?PYc
0000010101G?;#\|
0000010110G>Iԑ!t
0000010111G?!4
0000011000G>Ќ
0000011001G>o"
0000011010G?+;1
0000011011G?`
0000011100G>!MT
0000011101G>K
3z5
0000011110G? 3m҆:
0000011111G?5S
0000100000G?UsF
0000100001G?14r
0000100010G?1{2	
0000100011G?'WxQzm
0000100100G?5f,E
0000100101G>
0000100110G>1=Ќ
0000100111G>@-FKm
0000101000G?6v
0000101001G?2#oQy
0000101010G?=#
0000101011G?8
8<7
0000101100G?-s
0000101101G?#!(ĳǌ
0000101110G?-g
0000101111G>
'w?O
0000110000G?5iA'Ό
0000110001G?F(
0000110010G?Nj
0000110011G?EԗoN
0000110100G?9sP
0000110101G?'<ZZp
0000110110G>XM
0000110111G?	B!{
0000111000G?J~
0000111001G?"7
0000111010G?8FMŌ
0000111011G?en
0000111100G?g'ls
0000111101G?NBD
0000111110G>t/
0000111111G?#.O
0001000000G?~[:
0001000001G?#
0001000010G?ʖ¨
0001000011G?w&5
0001000100G?.v)
0001000101G?%w'L
0001000110G>Oz
0001000111G>x$Ǧ
0001001000G?#Ό
0001001001G?53Hzg
0001001010G?>
0001001011G?6~4&
0001001100G?+9&6
0001001101G?)k;
0001001110G>ۍo
0001001111G>]UbMa
0001010000G?DP4
0001010001G?X}
0001010010G?\Ϲ&
0001010011G?SQ
0001010100G?J7ԉ7
0001010101G?6F+
0001010110G>])Wfˌ
0001010111G?;
0001011000G>铓C
0001011001G>+k
0001011010G?/=ja.
0001011011G?U~]k
0001011100G>QQy0
0001011101G>i|
0001011110G?Zb~
0001011111G?0/oS
0001100000G?/T #
0001100001G?Ixi
0001100010G?J6o
0001100011G?@㚡`ތ
0001100100G?5T?-
0001100101G?c
0001100110G>b;z˄
0001100111G>jG
0001101000G?&}_
˽
0001101001G??
wM
0001101010G?K]
0001101011G?F22P
0001101100G?=O˟y-
0001101101G?2[< ,͌
0001101110G? DSq
0001101111G?:A
0001110000G?F@"6
0001110001G?U|ɗ
0001110010G?^h1
0001110011G?VsC
0001110100G?Hj 
0001110101G?5p
0001110110G> T~
0001110111G? bz
0001111000G?({㐌
0001111001G?0dQ))
0001111010G?8ٓ
0001111011G?0ቌ
0001111100G? Cx䅌
0001111101G?1\vm
0001111110G>\Z
0001111111G?3)sK
0010000000G>HX>k
0010000001G?AD
0010000010G?
s
0010000011G>XV
0010000100G?
;мA
0010000101G>M
0010000110G>1A
0010000111G>`.G
0010001000G?0󤷌
0010001001G?Bj8
0010001010G?I߫d
0010001011G?CW`
0010001100G?:G?$}i
0010001101G?6Č
0010001110G?
n
0010001111G>ZJ\
0010010000G?Kd
0010010001G?^٤Ket
0010010010G?c~~،
0010010011G?YkerOR
0010010100G?OE(
0010010101G?<4>V
0010010110G>sOv
0010010111G?$p}v
0010011000G>RnČ
0010011001G>x
0010011010G?2/ᶠ~
0010011011G? 1tҌ
0010011100G>5V
0010011101G>）Q
0010011110G?%N
0010011111G?6ht
0010100000G?-
0010100001G?FXBIr
0010100010G?J 
0010100011G?B 6A
0010100100G?4Ez

0010100101G??
0010100110G>.UCV
0010100111G>WRJ
0010101000G?z̺
0010101001G?)g
0010101010G?5f'G
0010101011G?1[<
0010101100G?(b
0010101101G?C
0010101110G?}Bس
0010101111G?TNs
0010110000G?1Һ-
0010110001G?@N]\sŌ
0010110010G?G\3
0010110011G?BE
0010110100G?5?<0͂
0010110101G?$wU7
0010110110G>]
0010110111G?
ɣ

0010111000G?"'s<
0010111001G?+O/
0010111010G?/T
0010111011G?&Z55%
0010111100G?">Vsv
0010111101G?)qU
0010111110G>NӲ
0010111111G?#`
0011000000G?RgpT
0011000001G?5JFڌ
0011000010G?8pۜ
0011000011G?,݌
0011000100G?
0011000101G?%Ό
0011000110G? 0I
0011000111G?^
0011001000G?M-ޅՌ
0011001001G?_|Y6
0011001010G?bLt
0011001011G?\i
_\
0011001100G?W
=xb
0011001101G?QQ2ƌ
0011001110G?(^	)Dd
0011001111G?K[
0011010000G?f/&
0011010001G?{+>
0011010010G?w
0011010011G?v۫
0011010100G?kZ
0011010101G?X%.̌
0011010110G>|9
0011010111G??Vʋ
0011011000G>˸S
0011011001G>"
0011011010G?AGǘ
0011011011G?-sv
0011011100G?&hHS
0011011101G>e'
0011011110G?*s>]n
0011011111G?Qt
0011100000G?/EX
0011100001G?K޳U
0011100010G?J&*:f
0011100011G?@NWPi
0011100100G?605IÌ
0011100101G?a
0011100110G>֪O
0011100111G>C\^ߝ
0011101000G?3[
0011101001G?J>
0011101010G?[
0011101011G?Uw3܌
0011101100G?D1+ʁ
0011101101G?<W8/54
0011101110G?&[f
0011101111G?D(܌
0011110000G?YZ#X
0011110001G?im!-
0011110010G?q5
0011110011G?jgm4
0011110100G?^ L!s
0011110101G?KAsRA
0011110110G>Uk1I}
0011110111G?-y?R
0011111000G?4'{.5
0011111001G?;	+)l
0011111010G?E^k;2
0011111011G?=U?s
0011111100G?-o׌
0011111101G?Acox
0011111110G?LA&
0011111111G?Bċ
0100000000G>!
0100000001G?gŔ
0100000010G?kE*?
0100000011G>$A
0100000100G?c
0100000101G>NY͌
0100000110G>q\
0100000111G>M /
0100001000G?.Zug
0100001001G?AbE
0100001010G?G>)
0100001011G?AD|^
0100001100G?:I
0100001101G?5}Յa
0100001110G?_<]
0100001111G>SQA0
0100010000G?KpCڸ\
0100010001G?_!,
0100010010G?cb}
0100010011G?Z}4'rm
0100010100G?P(t,
0100010101G?<4tw
0100010110G>wϓ:Ì
0100010111G?"q
0100011000G>ڌ
0100011001G>{_
0100011010G?.m֌
0100011011G?BaGό
0100011100G>FAd
0100011101G>8,PF
0100011110G?<^ik/
0100011111G?6
r
0100100000G? {Y
0100100001G?;s{#
0100100010G?=&1-
0100100011G?2!>
0100100100G?'8
0100100101G?
kpy
0100100110G>w
0100100111G>dub
0100101000G?"￉Ռ
0100101001G?2K/DC6
0100101010G?@@.
bx
0100101011G?:MU
0100101100G?.'j
0100101101G?#Nޅ%
0100101110G? 
0100101111G>W)
0100110000G?<qf0
0100110001G?LFqQ
0100110010G?St\
0100110011G?L
L
0100110100G?@mOz
0100110101G?.ٷv
0100110110G>\[:̌
0100110111G?\ˬߌ
0100111000G?-Qh
0100111001G?$|Č
0100111010G?+
-LB
0100111011G?##u|ӌ
0100111100G?^[[ 
0100111101G?%Gό
0100111110G>Cؕ
0100111111G?(I;<
0101000000G?W;^
0101000001G?*Xt"V
0101000010G?0)
0101000011G?%ӌ
0101000100G?\F.+
0101000101G?.
0101000110G>Ó[y

0101000111G>faU
0101001000G>*ոC
0101001001G?Z
0101001010G?D;Y
0101001011G?߰rPPO
0101001100G?9|
0101001101G>MNU
0101001110G>{Ӌ
0101001111G>u
0101010000G?l͔-C
0101010001G?'Z
0101010010G?#!
֌
0101010011G?Qzm}
0101010100G?Gq4
0101010101G>ߌ=
0101010110G>}+t
\
0101010111G>V
N
0101011000G>y%,17
0101011001G>:FZ+
0101011010G>/
0101011011G>he5s
0101011100G>h؀uՌ
0101011101G>>7֌
0101011110G>ꍌ
0101011111G?b
0101100000G?f$Č
0101100001G?O hM
0101100010G? ^Wt|
0101100011G?7
0101100100G?	u|
0101100101G>1XW
0101100110G>VῐuW
0101100111G>Q
0101101000G?
.g`
0101101001G?Bbk
0101101010G?BD
0101101011G?4
0101101100G?o0B
0101101101G?c
0101101110G>J
0101101111G>ɷ^}
0101110000G?ȫzw
0101110001G?'ƁD
0101110010G?3~Mj
0101110011G?+͊jPz
0101110100G?j
0101110101G?G[
0101110110G>jɌ
0101110111G>B"lM
0101111000G>*=
0101111001G>9`
0101111010G?mz
0101111011G>A<╌
0101111100G>4v
0101111101G>kO?
0101111110G>Why
0101111111G?oz
0110000000G>Ge>@Ԍ
0110000001G>߰ӯI~
0110000010G>s:Ɍ
0110000011G>m <
0110000100G>wѥ;
0110000101G>{^
0110000110G>LLf
0110000111G>'T
0110001000G>q8
0110001001G>d<
0110001010G>%G6
0110001011G>I
0110001100G>Pc̢
0110001101G>7#Ճ
0110001110G>L
0110001111G>MY
0110010000G>rȌ
0110010001G>[pT3@
0110010010G>Жc
0110010011G>D2
0110010100G>Gm
0110010101G>^!

0110010110G>8c`?
0110010111G>
&
0110011000G>g@vh
0110011001G>:֌
0110011010G>4
0110011011G>Κo
0110011100G>vi}
0110011101G>nF-g
0110011110G>^
l
0110011111G>&2
0110100000G>"P@
0110100001G?B) 
0110100010G?
܌
0110100011G?K
0110100100G> i%%
0110100101G>ᦺ+v
0110100110G>|̂
0110100111G>w{a
0110101000G>Īx(8
0110101001G>-ap.#Ҍ
0110101010G>s{g
0110101011G>bA))U
0110101100G>-7aP
0110101101G>l>,
0110101110G>&]j
0110101111G>oofL
0110110000G>F} c
0110110001G?	݊Q
0110110010G?~
0110110011G?	B˱
0110110100G>yEUZ
0110110101G>z
Ќ
0110110110G>[ZC
0110110111G>ST
0110111000G>[+
0110111001G>
0110111010G>E֣
0110111011G>}X
0110111100G>r
0110111101G>َ
0110111110G>Bó
0110111111G>ܯV-
0111000000G>F
0111000001G?
0111000010G?:*݌
0111000011G?
r4ɸ
0111000100G>׈KЌ
0111000101G>\f
0111000110G>ǤC
0111000111G?Ths&
0111001000G?5 .N
0111001001G?Ę
0111001010G?I'evvK
0111001011G?CQjh
0111001100G??H
0111001101G?9VX"uT
0111001110G?
&r
0111001111G?*
0111010000G?P2J
0111010001G?cX
0111010010G?gC?xp
0111010011G?_8z	
0111010100G?SSߟ
0111010101G?AfyB
0111010110G>A=
0111010111G?# AՌ
0111011000G>ĥӌ
0111011001G>+>MzY
0111011010G?*'MP
0111011011G?
0111011100G?I

0111011101G>d;蔌
0111011110G?c-wm
0111011111G?5"ތ
0111100000G?!~[:
0111100001G?;l;
0111100010G?< #j^
0111100011G?1Z{
0111100100G?&檔
0111100101G?
Ev
0111100110G>~=
0111100111G>{z?
0111101000G?^ʴ
0111101001G?0 \
0111101010G?B.
0111101011G?<"Ftӌ
0111101100G?*7 |
0111101101G?"dsJ
0111101110G?}@9
0111101111G? ،
0111110000G?>ˢ
0111110001G?NZ1b
0111110010G?TE
0111110011G?N?I,b
0111110100G?B<g
0111110101G?0fK
0111110110G>1dN@
0111110111G?̪x:
0111111000G?nڌ
0111111001G?$&.΀ў
0111111010G?.>*SȌ
0111111011G?$CF(7
0111111100G?
0111111101G?'#mc
0111111110G>j}@;
0111111111G?'e!p
1000000000G?/d
1000000001G?1pKKߵ
1000000010G?/:
1000000011G?7Ys
1000000100G?o`
1000000101G?uu*_
1000000110G>*z7
1000000111G>+
5
1000001000G?E=yu
1000001001G?Wֿ8
1000001010G?\5
1000001011G?UQv
1000001100G?RQ_ܚ+
1000001101G?L˧b
1000001110G?%i_	
1000001111G?Q
1000010000G?an"]ތ
1000010001G?t~䰠
1000010010G?y+&ݴތ
1000010011G?p_6
1000010100G?di$
1000010101G?RRo9
1000010110G>\6֌
1000010111G?882h
1000011000G>?m
1000011001G>􃨱J
1000011010G??"3 
1000011011G?*Bs[
1000011100G?ry
1000011101G>ɣv
1000011110G?&8=m;
1000011111G?LWF͌
1000100000G?+VЖ
1000100001G?Hl"
1000100010G?G4*
1000100011G?<kʭ
1000100100G?3Ԍ
1000100101G?Im/6
1000100110G>жD
1000100111G>ӳ4S
1000101000G?5f̌
1000101001G?LA%
1000101010G?\`
1000101011G?VԌ
1000101100G?D=
1000101101G?=E
1000101110G?$ȯΌ
1000101111G?RE?
1000110000G?[+2
1000110001G?k@!9
1000110010G?s8W
1000110011G?kۇ
1000110100G?__
1000110101G?M)0
1000110110G>Q^t
1000110111G?0i/3
1000111000G?4xRh
1000111001G?9/
1000111010G?F]-]
1000111011G?>-- 
1000111100G?*-2,
1000111101G?A:
1000111110G?o!D
1000111111G?Bw`@
1001000000G?Q|H
1001000001G?6Xӵ
1001000010G?@H
1001000011G?51c
1001000100G?oʃ
1001000101G?͈jm
1001000110G>糑$!
1001000111G?߀a"
1001001000G?7Է#Ί
1001001001G?I =
1001001010G?G1?
1001001011G?Cɕ
1001001100G?DQ87T
1001001101G?;9EL
1001001110G?Y^7_
1001001111G?;K
1001010000G?Oi
1001010001G?cG$Ȓj%
1001010010G?gg@j
1001010011G?`w&,;
1001010100G?RŔ$1
1001010101G?A7zo
1001010110G>7ZS
1001010111G?$xr$|h
1001011000G>k@&
1001011001G?ևC
1001011010G?،
1001011011G? Ny
1001011100G?#7
1001011101G>ь
1001011110G?&O
1001011111G?5ϭuB
1001100000G? 
Lr
1001100001G?3
PZ
1001100010G?5|rd
1001100011G?,f|
1001100100G?(ӌ
1001100101G?2
1001100110G>'͓V*
1001100111G>3II
1001101000G?9
1001101001G?)*?QI
1001101010G?A<	o
1001101011G?:Ŵ	
1001101100G?F\_
1001101101G?]ث_	
1001101110G?yMΌ
1001101111G?&~|ڌ
1001110000G?C-
1001110001G?S=׌
1001110010G?ZoGs
1001110011G?S회
1001110100G?GzVn E
1001110101G?4,fÆ
1001110110G>C&
1001110111G?
(P 
1001111000G?;Du
1001111001G?%'M
1001111010G?,v3B
1001111011G? eVE
1001111100G?(
1001111101G?%R
1001111110G> ݭ}
1001111111G?$|ܑC
1010000000G?
1010000001G?#a7ka
1010000010G?U#Fx9
1010000011G>ޢ
1010000100G?!pCۂˌ
1010000101G?L!
1010000110G>E
1010000111G?1"y
1010001000G?OA
1010001001G?aer
1010001010G?hIgqT
1010001011G?b	
1010001100G?WZg#j 
1010001101G?Uty
1010001110G?(dM
1010001111G?!-
1010010000G?l<o?q
1010010001G?0A
1010010010G?0<D=
1010010011G?z{笐u
1010010100G?p6eס
1010010101G?]z
ό
1010010110G>.*T
1010010111G?Al	@P
1010011000G?*fω
1010011001G? 33ߌ
1010011010G?SglX_
1010011011G?BC"܌
1010011100G?py
1010011101G?Ƶk
1010011110G?%6R
1010011111G?T_
1010100000G?Kq LM
1010100001G?f
1010100010G?hO@aJʌ
1010100011G?__ٙ
1010100100G?S_,_
1010100101G?8
[0
1010100110G>҂|
1010100111G?⛌
1010101000G?<'
1010101001G?V)s7
1010101010G?cz
1010101011G?_#2@
1010101100G?TF}b
1010101101G?GTAw
1010101110G?9|H%
1010101111G?$j΢
1010110000G?_4_νy
1010110001G?nrf-6
1010110010G?t
1010110011G?o(HÀ,
1010110100G?b@7R
1010110101G?P΁
1010110110G>s<
1010110111G?7,HJ
1010111000G?Di)s
1010111001G?LP	
1010111010G?R-2
1010111011G?IbMЌ
1010111100G?@iG
1010111101G?L.
1010111110G?W7OO
1010111111G?MA^
1011000000G?s+ƌ
1011000001G?8GD6
1011000010G?;8ߌ
1011000011G?0£
1011000100G?$
%̒
1011000101G?Ȅ
1011000110G>E&Ì
1011000111G>⻌
1011001000G?5;p
1011001001G?H"gfӌ
1011001010G?KѮ
1011001011G?Eڌ
1011001100G?D^xʶ!
1011001101G?<O
1011001110G?Gf
1011001111G>_
1011010000G?Ofσf
1011010001G?b{P
1011010010G?g.Սц
1011010011G?^
3u
1011010100G?Q樓
1011010101G?@.?T+
1011010110G>H[
1011010111G?) .F'A
1011011000G>*S9
1011011001G>GUx|
1011011010G?^Swa
1011011011G?Aҗ
1011011100G?|֌
1011011101G>Д4XZ
1011011110G?
n
1011011111G?:sX!?
1011100000G> hY9
1011100001G?J
1011100010G?@g1
1011100011G?	@%>
1011100100G>[Z݃
1011100101G>Q 
1011100110G>
1011100111G>1V
1011101000G?l
1011101001G?-|
1011101010G?7OM
1011101011G?34f
1011101100G?#'
1011101101G?-;Jod
1011101110G>W,͌
1011101111G>Asy*
1011110000G?6
1011110001G?G{֌
1011110010G?Q_c6
1011110011G?I#R
1011110100G?; 
Ͳ
1011110101G?)\
1011110110G>'ٱ+Y
1011110111G?
Ff
1011111000G?;Wό
1011111001G?	
.:
1011111010G?lƌ
1011111011G?Kd
1011111100G>lн@
1011111101G?(9nu
1011111110G>>oXG
1011111111G?a!g
1100000000G?v{}Ƃ
1100000001G?:`H
1100000010G?2$])
1100000011G?x:
1100000100G?)d50
1100000101G?O0
1100000110G>S"ٌ
1100000111G>PW
1100001000G?Rr
1100001001G?dƚ
1100001010G?klPی
1100001011G?ebբ
1100001100G?`pŌ
1100001101G?[*Ҍ
1100001110G?6TXu
1100001111G?	:
1100010000G?nr
1100010001G?rBx
1100010010G?TW
1100010011G?~b%2
1100010100G?qX>
1100010101G?^1Yb
1100010110G>Qձ
1100010111G?DY
@
1100011000G?<~h
1100011001G?J"0L
1100011010G?KF7fl{
1100011011G?5n|訌
1100011100G?[eX
1100011101G?!#5$2Ȍ
1100011110G?#k
1100011111G?WOG׌
1100100000G?,:X[
1100100001G?Lҥ
1100100010G?LbbA
1100100011G?BH!
1100100100G?8,;"1M
1100100101G?' D
1100100110G>͵
1100100111G>	
1100101000G?9=ܑ
1100101001G?P@H
1100101010G?[㧩1
1100101011G?VoU\X
1100101100G?I?F
1100101101G?A:FpM
1100101110G?)5ƌ
1100101111G>)pJү
1100110000G?U|
1100110001G?f4﯌
1100110010G?nXez
1100110011G?fC:f
1100110100G?Z*]،
1100110101G?H⭌
1100110110G>@
i
1100110111G?/j,
1100111000G?24Z鞬
1100111001G?6'Y#
1100111010G?<A]q
1100111011G?4S
1100111100G?(}c
1100111101G?72J4
1100111110G?Cv
1100111111G?A2 
1101000000G?3_
1101000001G??FK
1101000010G?<Z˔
1101000011G?0 q؟
1101000100G?9KM
1101000101G?.
1101000110G?
1101000111G?wҌ
1101001000G?KhGn~ 
1101001001G?]>E
1101001010G?f$$Jⴌ
1101001011G?`NGAƌ
1101001100G?S3Q
1101001101G?R%J⊌
1101001110G? hu!q
1101001111G?(4󈚨
1101010000G?lQ|
1101010001G?(Mp
1101010010G?5՜l
1101010011G?{ H
1101010100G?r#
4!*
1101010101G?^;
1101010110G>_r
1101010111G?@]{4
1101011000G?9D=0
1101011001G?&57
1101011010G?VJ
.Nٌ
1101011011G?Ehz
1101011100G?/
1101011101G?	9
e
1101011110G?-+~\YJ
1101011111G?V_`0
1101100000G?TfvЌ
1101100001G?pl7-Q͌
1101100010G?q*c[=
1101100011G?f
^6c
1101100100G?\m6
1101100101G?AK]
1101100110G>.JonO
1101100111G?n
1101101000G?K.Ō
1101101001G?ckhI
1101101010G?qQ$	K
1101101011G?kzu
Я/
1101101100G?b>
1101101101G?V﷯
1101101110G?E3YՂ
1101101111G?,O}:
1101110000G?j*g
1101110001G?y≖KS
1101110010G?BUt3
1101110011G?zқ6
1101110100G?m7Lb6
1101110101G?Z`kŊId
1101110110G>8Pf< 
1101110111G?D2 
1101111000G?NOK
1101111001G?TuČ
1101111010G?^#@w
1101111011G?TW`
1101111100G?Ec+%
1101111101G?Usq
1101111110G?9㩌
1101111111G?XRS
1110000000G?-
1110000001G?MT@Č
1110000010G?Jꁭi
1110000011G?=]X
1110000100G?>L1p
1110000101G?,x{vO=
1110000110G?+bh
1110000111G>@D
1110001000G?LEՌ
1110001001G?`싎
1110001010G?f-fV
1110001011G?`ۤ+zT
1110001100G?Yc
1110001101G?SX
1110001110G?0'bi
1110001111G>m:
1110010000G?gQ)k
1110010001G?z~
1110010010G?
1110010011G?u
J
1110010100G?jW۠
1110010101G?X1/
1110010110G>~T
1110010111G?D	f̙
1110011000G?"j
1110011001G?;
1110011010G?O!
1110011011G?=Hٗ
1110011100G?Vm	
1110011101G?vn
1110011110G?")Č
1110011111G?U)
1110100000G?LbEy
1110100001G?edDA,
1110100010G?j-nq
1110100011G?al>s
1110100100G?S_
1110100101G?:@)bkS
1110100110G>ϳY
1110100111G?
j3ߌ
1110101000G?0皌
1110101001G?Kcj[
1110101010G?V<#
1110101011G?QExU
1110101100G?J"-8
1110101101G?7$#B؏
1110101110G?-`qKnw
1110101111G?#Sg)6u
1110110000G?TdY
1110110001G?cJഌ
1110110010G?kT(
1110110011G?ebqՌ
1110110100G?W~ǌ
1110110101G?FTDz
1110110110G> 
1110110111G?0,Jn
1110111000G?C\Y=r
1110111001G?Khc)
1110111010G?PTW
1110111011G?HF>`
1110111100G?BGᰌ
1110111101G?K2$|
L
1110111110G?Aҍ?
1110111111G?EBJ趌
1111000000G?  ^
1111000001G?V$L2
1111000010G?Xeո
1111000011G?MΎ{Y
1111000100G?>zM
1111000101G?'-
1111000110G?$4
1111000111G?5^
1111001000G?r88
1111001001G?C_.@
1111001010G?.
1111001011G?W=
1111001100G?}
1111001101G?w>d
1111001110G?N+!F8
1111001111G?@ed{
1111010000G?"
1111010001G?!

1111010010G?,0
1111010011G?cߙ,
1111010100G?K"
1111010101G?P P 
1111010110G>YX
1111010111G?cܿ
1111011000G?)K
1111011001G?p)i
1111011010G?gF?ؽ
1111011011G?S)
D
1111011100G?LYlH݌
1111011101G>Җݿ
1111011110G?PĹ
1111011111G?vN'
1111100000G?Vt
1111100001G?rȥ+f8
1111100010G?r<Pǌ
1111100011G?g.{N
1111100100G?^Pڒ
1111100101G??Y>۪Ì
1111100110G>4Kk
1111100111G?;Du(
1111101000G?Waٌ
1111101001G?p5<f2
1111101010G?+,e
1111101011G?zdEL
1111101100G?h#ь
1111101101G?a"<
1111101110G?M`#@
1111101111G?;T7w
1111110000G?@RG׌
1111110001G?R٭
1111110010G?^
1111110011G?-B7
1111110100G?|ӌ
1111110101G?pךV
1111110110G>&)0
1111110111G?Q=
1111111000G?Z;1~
1111111001G?a,W
1111111010G?j=8
1111111011G?bYь
1111111100G?RM،
1111111101G?edԌ
1111111110G?-KŔ1
1111111111G?f`xZu// Name of Experiment: iswap v4

OPENQASM 2.0;
include "qelib1.inc";

qreg q[2];
creg c[2];

x q[0];
s q[0];
s q[1];
h q[0];
cx q[0],q[1];
h q[0];
h q[1];
cx q[0],q[1];
h q[0];
measure q[0] -> c[0];
measure q[1] -> c[1];
}(00G93w΅]M01G2w10G?     11G93w΅]MuX  // Name of Experiment: lineair_solver_in_0 v3
// Description: 1bit lineair solver
// Solver for a linear equation for one quantumbit

OPENQASM 2.0;
include "qelib1.inc";

qreg q[3];
creg c[3];

h q[0];
x q[2];
cx q[0],q[1];
h q[0];
h q[1];
h q[2];
cx q[2],q[1];
h q[1];
h q[2];
u3(-0.58,0,0) q[2];
h q[1];
h q[2];
cx q[2],q[1];
h q[1];
h q[2];
h q[0];
u3(0.58,0,0) q[2];
cx q[0],q[1];
h q[0];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
}(000G?8Nf001G?8Nf010G8d\Q011G8?O100G?^101G?{bc110G91^y2111G81~?^uX9  // Name of Experiment: LPN circuit 2 v1

OPENQASM 2.0;
include "qelib1.inc";

qreg q[5];
creg c[5];

h q[0];
h q[1];
h q[3];
h q[4];
cx q[3], q[2];
cx q[0], q[2];
h q[0];
h q[1];
h q[2];
h q[3];
h q[4];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
measure q[3] -> c[3];
measure q[4] -> c[4];
}(00000G?     00001G9#w΅]M00100G9*#?[00101G9(Tn01000G9(Tn01001G9*#?[01100G9#w΅]M01101G?     uX  // Name of Experiment: pea_3*pi/8 v3

OPENQASM 2.0;
include "qelib1.inc";


qreg q[5];
creg c[4];
gate cu1fixed c,t {
u1 (-3*pi/8) t;
cx c,t;
u1 (3*pi/8) t;
cx c,t;
}
gate ctu c,t {
cu1fixed c,t;
}

h q[0];
h q[1];
h q[2];
h q[3];
ctu q[3],q[4];
ctu q[2],q[4];
ctu q[2],q[4];
ctu q[1],q[4];
ctu q[1],q[4];
ctu q[1],q[4];
ctu q[1],q[4];
ctu q[0],q[4];
ctu q[0],q[4];
ctu q[0],q[4];
ctu q[0],q[4];
ctu q[0],q[4];
ctu q[0],q[4];
ctu q[0],q[4];
ctu q[0],q[4];
h q[0];
cu1(-pi/2) q[0],q[1];
h q[1];
cu1(-pi/4) q[0],q[2];
cu1(-pi/2) q[1],q[2];
h q[2];
cu1(-pi/8) q[0],q[3];
cu1(-pi/4) q[1],q[3];
cu1(-pi/2) q[2],q[3];
h q[3];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
measure q[3] -> c[3];

}(00000G96[ w00001G9UGmx00010G9fXۺ،00011G?     00100G9fXۺь00101G9Vu28 00110G96[ r00111G9SEC01000G9$7Whj01001G9"*J/01010G9h 01011G9P!6m01100G9h ǌ01101G9IN4O~b01110G9$7Whi01111G9A%YuX:  // Finding the max of the cost function: C = -1 + z(0)z(2) - 2 z(0)z(1)z(2) - 3 z(1) 
// Starting with p = 1
// Generated from Cirq v0.8.0

OPENQASM 2.0;
include "qelib1.inc";

// Qubits: [(0, 0), (1, 0), (2, 0)]
qreg q[3];
creg m2[1];
creg m0[1];
creg m1[1];

h q[0];
h q[1];
h q[2];
cx q[0],q[2];
rz(pi*1.79986) q[2];
cx q[0],q[2];
cx q[0],q[1];
cx q[1],q[2];
rz(pi*-3.59973) q[2];
cx q[1],q[2];
cx q[0],q[1];
rx(pi*0.545344) q[2];
rz(pi*-5.39959) q[1];
rx(pi*0.545344) q[0];
measure q[2] -> m2[0];
rx(pi*0.545344) q[1];
measure q[0] -> m0[0];
measure q[1] -> m1[0];

}(000G?݌001G?010G?ՊlL011G?Ҿ100G?101G?ٌ110G?Ҿ111G?ՊlLuX  // Generated from Cirq v0.8.0

OPENQASM 2.0;
include "qelib1.inc";


// Qubits: [0, 1, 2, 3, 4, 5]
qreg q[6];
creg mm[6];


h q[0];
h q[1];
h q[2];
h q[3];
h q[4];
h q[5];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[0];
rz(pi*-0.9153964903) q[1];
u3(pi*0.5,0,0) q[0];
u3(pi*0.5,pi*1.0,0) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.4153964903) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[0];
u3(pi*0.5,pi*0.9153964903,0) q[1];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[0];
rz(pi*-0.9153964903) q[2];
u3(pi*0.5,0,0) q[0];
u3(pi*0.5,pi*1.0,0) q[2];
rx(pi*0.5) q[0];
cx q[0],q[2];
rx(pi*0.4153964903) q[0];
ry(pi*0.5) q[2];
cx q[2],q[0];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[0],q[2];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[0];
u3(pi*0.5,pi*0.9153964903,0) q[2];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[0];
rz(pi*-0.9153964903) q[5];
u3(pi*0.5,0,0) q[0];
u3(pi*0.5,pi*1.0,0) q[5];
rx(pi*0.5) q[0];
cx q[0],q[5];
rx(pi*0.4153964903) q[0];
ry(pi*0.5) q[5];
cx q[5],q[0];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[0],q[5];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[0];
u3(pi*0.5,pi*0.9153964903,0) q[5];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[1];
rz(pi*-0.9153964903) q[2];
u3(pi*0.5,0,0) q[1];
u3(pi*0.5,pi*1.0,0) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.4153964903) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[1];
u3(pi*0.5,pi*0.9153964903,0) q[2];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[1];
rz(pi*-0.9153964903) q[3];
u3(pi*0.5,0,0) q[1];
u3(pi*0.5,pi*1.0,0) q[3];
rx(pi*0.5) q[1];
cx q[1],q[3];
rx(pi*0.4153964903) q[1];
ry(pi*0.5) q[3];
cx q[3],q[1];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[1],q[3];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[1];
u3(pi*0.5,pi*0.9153964903,0) q[3];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[2];
rz(pi*-0.9153964903) q[4];
u3(pi*0.5,0,0) q[2];
u3(pi*0.5,pi*1.0,0) q[4];
rx(pi*0.5) q[2];
cx q[2],q[4];
rx(pi*0.4153964903) q[2];
ry(pi*0.5) q[4];
cx q[4],q[2];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[2],q[4];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[2];
u3(pi*0.5,pi*0.9153964903,0) q[4];

rx(pi*-0.6320733477) q[0];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[4];
rz(pi*-0.9153964903) q[3];
u3(pi*0.5,0,0) q[4];
u3(pi*0.5,pi*1.0,0) q[3];
rx(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*0.4153964903) q[4];
ry(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[4],q[3];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[4];
u3(pi*0.5,pi*0.9153964903,0) q[3];

rx(pi*-0.6320733477) q[1];
rx(pi*-0.6320733477) q[2];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[4];
rz(pi*-0.9153964903) q[5];
u3(pi*0.5,0,0) q[4];
u3(pi*0.5,pi*1.0,0) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.4153964903) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[4];
u3(pi*0.5,pi*0.9153964903,0) q[5];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[0];
rz(pi*0.1487377097) q[1];
u3(pi*0.5,0,pi*1.8013661765) q[0];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[1];
rx(pi*0.5) q[0];
cx q[0],q[1];
rx(pi*0.3512622903) q[0];
ry(pi*0.5) q[1];
cx q[1],q[0];
rx(pi*-0.5) q[1];
rz(pi*0.5) q[1];
cx q[0],q[1];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[0];
u3(pi*0.5,pi*1.0498961138,0) q[1];

// Gate: ZZ**-0.9153964902652879
rz(pi*-0.9153964903) q[3];
rz(pi*-0.9153964903) q[5];
u3(pi*0.5,0,0) q[3];
u3(pi*0.5,pi*1.0,0) q[5];
rx(pi*0.5) q[3];
cx q[3],q[5];
rx(pi*0.4153964903) q[3];
ry(pi*0.5) q[5];
cx q[5],q[3];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[3],q[5];
u3(pi*0.5,pi*0.9153964903,pi*1.0) q[3];
u3(pi*0.5,pi*0.9153964903,0) q[5];

rx(pi*-0.6320733477) q[4];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[0];
rz(pi*0.1487377097) q[2];
u3(pi*0.5,0,pi*1.8013661765) q[0];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[2];
rx(pi*0.5) q[0];
cx q[0],q[2];
rx(pi*0.3512622903) q[0];
ry(pi*0.5) q[2];
cx q[2],q[0];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[0],q[2];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[0];
u3(pi*0.5,pi*1.0498961138,0) q[2];

rx(pi*-0.6320733477) q[3];
rx(pi*-0.6320733477) q[5];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[1];
rz(pi*0.1487377097) q[2];
u3(pi*0.5,0,pi*1.8013661765) q[1];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[2];
rx(pi*0.5) q[1];
cx q[1],q[2];
rx(pi*0.3512622903) q[1];
ry(pi*0.5) q[2];
cx q[2],q[1];
rx(pi*-0.5) q[2];
rz(pi*0.5) q[2];
cx q[1],q[2];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[1];
u3(pi*0.5,pi*1.0498961138,0) q[2];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[0];
rz(pi*0.1487377097) q[5];
u3(pi*0.5,0,pi*1.8013661765) q[0];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[5];
rx(pi*0.5) q[0];
cx q[0],q[5];
rx(pi*0.3512622903) q[0];
ry(pi*0.5) q[5];
cx q[5],q[0];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[0],q[5];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[0];
u3(pi*0.5,pi*1.0498961138,0) q[5];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[1];
rz(pi*0.1487377097) q[3];
u3(pi*0.5,0,pi*1.8013661765) q[1];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[3];
rx(pi*0.5) q[1];
cx q[1],q[3];
rx(pi*0.3512622903) q[1];
ry(pi*0.5) q[3];
cx q[3],q[1];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[1],q[3];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[1];
u3(pi*0.5,pi*1.0498961138,0) q[3];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[2];
rz(pi*0.1487377097) q[4];
u3(pi*0.5,0,pi*1.8013661765) q[2];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[4];
rx(pi*0.5) q[2];
cx q[2],q[4];
rx(pi*0.3512622903) q[2];
ry(pi*0.5) q[4];
cx q[4],q[2];
rx(pi*-0.5) q[4];
rz(pi*0.5) q[4];
cx q[2],q[4];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[2];
u3(pi*0.5,pi*1.0498961138,0) q[4];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[4];
rz(pi*0.1487377097) q[3];
u3(pi*0.5,0,pi*1.8013661765) q[4];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[3];
rx(pi*0.5) q[4];
cx q[4],q[3];
rx(pi*0.3512622903) q[4];
ry(pi*0.5) q[3];
cx q[3],q[4];
rx(pi*-0.5) q[3];
rz(pi*0.5) q[3];
cx q[4],q[3];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[4];
u3(pi*0.5,pi*1.0498961138,0) q[3];

rx(pi*-0.6710086873) q[0];
rx(pi*-0.6710086873) q[1];
rx(pi*-0.6710086873) q[2];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[4];
rz(pi*0.1487377097) q[5];
u3(pi*0.5,0,pi*1.8013661765) q[4];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[5];
rx(pi*0.5) q[4];
cx q[4],q[5];
rx(pi*0.3512622903) q[4];
ry(pi*0.5) q[5];
cx q[5],q[4];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[4],q[5];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[4];
u3(pi*0.5,pi*1.0498961138,0) q[5];

// Gate: ZZ**0.14873770971193984
rz(pi*0.1487377097) q[3];
rz(pi*0.1487377097) q[5];
u3(pi*0.5,0,pi*1.8013661765) q[3];
u3(pi*0.5,pi*1.0,pi*1.8013661765) q[5];
rx(pi*0.5) q[3];
cx q[3],q[5];
rx(pi*0.3512622903) q[3];
ry(pi*0.5) q[5];
cx q[5],q[3];
rx(pi*-0.5) q[5];
rz(pi*0.5) q[5];
cx q[3],q[5];
u3(pi*0.5,pi*1.0498961138,pi*1.0) q[3];
u3(pi*0.5,pi*1.0498961138,0) q[5];

rx(pi*-0.6710086873) q[4];
rx(pi*-0.6710086873) q[3];
rx(pi*-0.6710086873) q[5];
measure q[0] -> mm[0];
measure q[1] -> mm[1];
measure q[2] -> mm[2];
measure q[3] -> mm[3];
measure q[4] -> mm[4];
measure q[5] -> mm[5];
}(000000G?{MCp000001G?|000010G?|000011G?\k000100G?|000101G?\k000110G?\k000111G?}wuB001000G?|001001G?27&>001010G?r	B'001011G?iR{001100G?27&>001101G?Qf001110G?iR뇌001111G?\kS010000G?|
010001G?27&>~010010G?27&>010011G?Qm010100G?r	B010101G?iRx010110G?iR010111G?\k]011000G?\k011001G?Qs011010G?iR늌011011G?27&?011100G?iR011101G?27&?011110G?r	Bl011111G?|Į100000G?|100001G?r	B100010G?27&>100011G?iRu100100G?27&>100101G?iRz100110G?Qs100111G?\k_101000G?\k101001G?iR넌101010G?iR뗌101011G?r	Bj101100G?Q101101G?27&?
101110G?27&?101111G?|İ110000G?\k110001G?iR댌110010G?Q110011G?27&?110100G?iR늌110101G?r	Bs110110G?27&?110111G?|Ĺ111000G?}wuBC111001G?\ki111010G?\kk111011G?|İ111100G?\kk111101G?|Ķ111110G?|Ķ111111G?{MCЬuX  // Name of Experiment: Encoder into bit-flip code with parity checks (qubits 0,1,3) v2

OPENQASM 2.0;
include "qelib1.inc";

qreg q[5];
creg c[5];

h q[2];
t q[2];
h q[2];
h q[0];
h q[1];
h q[2];
cx q[1], q[2];
cx q[0], q[2];
h q[0];
h q[1];
h q[3];
cx q[3], q[2];
h q[2];
h q[3];
cx q[3], q[2];
cx q[0], q[2];
cx q[1], q[2];
h q[2];
h q[4];
cx q[4], q[2];
h q[2];
h q[4];
cx q[4], q[2];
cx q[1], q[2];
cx q[3], q[2];


measure q[2] -> c[2];
measure q[4] -> c[4];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[3] -> c[3];
}(00000G?PO3?00001G2PO3?00010G2g.jV00011G2F
닊00100G91a?00101G2_ˌ00110G2`;fon00111G2s==01000G2v01001G2Y501010G2aLfAՌ01011G?¾3l01100G2/01101G2ֱ֌01110G+]#Dl01111G9?=Q10000G9@;fol10001G94&ELת210010G2]ӷ-10011G2D_Дs10100G9O,10101G2i?^V10110G9 xU(j10111G9 >Og n311000G2wy8p11001G2B;:5Hތ11010G+T_=R11011G8PO3?11100G96.*ս11101G9	11110G+0q11111G9QuXe  // Repetition code syndrome measurement
OPENQASM 2.0;
include "qelib1.inc";
qreg q[3];
qreg a[2];
creg c[3];
creg syn[2];
gate syndrome d1,d2,d3,a1,a2 
{ 
  cx d1,a1; cx d2,a1; 
  cx d2,a2; cx d3,a2; 
}
x q[0]; // error
barrier q;
syndrome q[0],q[1],q[2],a[0],a[1];
measure a -> syn;
if(syn==1) x q[0];
if(syn==2) x q[2];
if(syn==3) x q[1];
measure q -> c;
}01001G?      sX!  // quantum Fourier transform
OPENQASM 2.0;
include "qelib1.inc";
qreg q[4];
creg c[4];
x q[0]; 
x q[2];
barrier q;
h q[0];
cu1(pi/2) q[1],q[0];
h q[1];
cu1(pi/4) q[2],q[0];
cu1(pi/2) q[2],q[1];
h q[2];
cu1(pi/8) q[3],q[0];
cu1(pi/4) q[3],q[1];
cu1(pi/2) q[3],q[2];
h q[3];
measure q -> c;
}(0000G?     0001G?     0010G?     0011G?     0100G?     0101G?     0110G?     0111G?     1000G?     1001G?     1010G?     1011G?     1100G?     1101G?     1110G?     1111G?     uX;  OPENQASM 2.0;
include "qelib1.inc";
qreg q[9];
creg c[6];
//This initializes 9 quantum and 6 classical registers.

// initialize ancilla qubits
h q[0];
h q[1];
h q[2];
h q[3];
h q[4];
h q[5];
// eigenstates of the unitary operator
x q[6];
x q[7];
x q[8];
//I extended the pattern formed by the 3-qubit and 6-qubit implementations.

barrier q; // unitary operator
ccx q[5], q[6], q[7];
cz q[7], q[8];
ccx q[5], q[6], q[7];
//This 4-qubit controlled-Z gate is from this webpage.

barrier q; // inverse Quantum Fourier Transform (QFT)
cu1(-pi/32) q[5], q[0];
cu1(-pi/16) q[5], q[1];
cu1(-pi/8) q[5], q[2];
cu1(-pi/4) q[5], q[3];
cu1(-pi/2) q[5], q[4];
cu1(-pi/16) q[4], q[0];
cu1(-pi/8) q[4], q[1];
cu1(-pi/4) q[4], q[2];
cu1(-pi/2) q[4], q[3];
cu1(-pi/8) q[3], q[0];
cu1(-pi/4) q[3], q[1];
cu1(-pi/2) q[3], q[2];
cu1(-pi/4) q[2], q[0];
cu1(-pi/2) q[2], q[1];
cu1(-pi/2) q[1], q[0];
//This would obviously be more efficient using Python FOR loops, but you can copy-and-paste that from IBM Q Experience and there鈥檚 no fun in that. If I eventually implement this in Shor鈥檚 algorithm, I鈥檒l use Python.

barrier q; // output should be 32 (binary 100000)
h q[0];
measure q[0] -> c[0];
h q[1];
measure q[1] -> c[1];
h q[2];
measure q[2] -> c[2];
h q[3];
measure q[3] -> c[3];
h q[4];
measure q[4] -> c[4];
h q[5];
measure q[5] -> c[5];
}(	111000000G?9P	111000001G?d~w	111000010G?6ь	111000011G?g8V	111000100G?eM3
	111000101G?qB!J	111000110G?BolUJ	111000111G?l	OÌ	111001000G?H.`~	111001001G?qB!H	111001010G?h%݌	111001011G?D6'7	111001100G?eC	111001101G?ntgK	111001110G?4	111001111G?٬)(	111010000G?"	111010001G?g8V	111010010G?p;hҐ	111010011G?Xwʌ	111010100G?|NVC	111010101G?D6'?	111010110G?}/
	111010111G?| 	111011000G?I!	111011001G?l	OÌ	111011010G?eVTU	111011011G?| 	111011100G? c	111011101G?٬)(	111011110G?09݌	111011111G?f+ĵ	111100000G?oJ	111100001G?9M	111100010G?~~	111100011G?"	111100100G?<ii	111100101G?H.`~	111100110G?kUz>&̌	111100111G?I#	111101000G?<ik	111101001G?eM3
	111101010G?ѡ	111101011G?|NVC	111101100G?pxT	111101101G?eD	111101110G?S|	111101111G? c	111110000G?~~	111110001G?6Ό	111110010G?%ۀԌ	111110011G?p;hҒ	111110100G?ў	111110101G?h%	111110110G?~@iȿ	111110111G?eVTU	111111000G?kUz>&̌	111111001G?BolUJ	111111010G?~@i	111111011G?}/
	111111100G?S}	111111101G?4	111111110G?>	111111111G?09uOPENQASM 2.0;
include "qelib1.inc";
qreg q[4];
creg c[4];

h q[0];
h q[1];
h q[2];
h q[3];

measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
measure q[3] -> c[3];
}(0000G?     0001G?     0010G?     0011G?     0100G?     0101G?     0110G?     0111G?     1000G?     1001G?     1010G?     1011G?     1100G?     1101G?     1110G?     1111G?     uX  OPENQASM 2.0;
include "qelib1.inc";
qreg q1[2];
creg c1[2];
u3(1.5705854245991118,-3.1667235621803993,-1.58730875641222e-05) q1[0];
u3(0.7864502280785407,1.4997452219669574,0.050219564359156976) q1[1];
cx q1[0],q1[1];
u3(0.050224804187928476,-3.3306690738754696e-15,3.1415926535897967) q1[0];
u3(1.6418473665068425,-1.5707963267948966,3.141592653589794) q1[1];
cx q1[0],q1[1];
u3(1.4956790561350626e-05,1.5707963268001452,3.1415926535845444) q1[0];
u3(1.5707963267948966,1.5707963267948968,3.141592653589793) q1[1];
cx q1[0],q1[1];
u3(1.5705854245991133,-3.1416085266773286,-0.02513090859065059) q1[0];
u3(2.3547213646862812,3.091394193838764,-0.07102121943155337) q1[1];
measure q1[0] -> c1[0];
measure q1[1] -> c1[1];

}(00G?/T01G?d;&10G?dX_811G?d;&uXw  OPENQASM 2.0;
include "qelib1.inc";
qreg q[6];
creg c[6];
// This initializes 6 quantum registers and 6 classical registers.

h q[0];
h q[1];
h q[2];
// The first 3 qubits are put into superposition states.

barrier q;
cx q[2], q[4];
x q[3];
cx q[2], q[3];
ccx q[0], q[1], q[3];
x q[0];
x q[1];
ccx q[0], q[1], q[3];
x q[0];
x q[1];
x q[3];
// This applies the secret structure: s=110.

barrier q;
h q[0];
h q[1];
h q[2];

// This measures the first 3 qubits.
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];

// This measures the second 3 qubits.
measure q[3] -> c[3];
measure q[4] -> c[4];
measure q[5] -> c[5];
}(000000G?     000001G8C:000010G8C:000011G?     000100G?     000101G8C:000110G8C:000111G?     001000G?     001001G90!001010G90!001011G?     001100G?     001101G90!001110G90!001111G?     010000G?     010001G90!010010G90!010011G?     010100G?     010101G90!010110G90!010111G?     011000G?     011001G8C:011010G8C:011011G?     011100G?     011101G8C:011110G8C:011111G?     uXR  // Teleportation using 3 qubits.
// Description: Based on the example given by S. Fedortchenko (https://arxiv.org/pdf/1607.02398.pdf) 

OPENQASM 2.0;
include "qelib1.inc";

qreg q[3];
creg c[3];

h q[0];
t q[0];
h q[0];
h q[2];
s q[0];
cx q[2],q[1];
cx q[0],q[1];
h q[0];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
}(000G?PO3?001G?PO3?010G?3i011G?3i100G?3i101G?3i110G?PO3?111G?PO3?uX:  OPENQASM 2.0;
include "qelib1.inc";

qreg a[3];
creg c[3];

x a[0];
x a[1];
h a[2];
cx a[1],a[2];
tdg a[2];
cx a[0],a[2];
t a[2];
cx a[1],a[2];
tdg a[2];
cx a[0],a[2];
tdg a[1];
t a[2];
cx a[0],a[1];
h a[2];
tdg a[1];
cx a[0],a[1];
t a[0];
s a[1];
measure a[0] -> c[0];
measure a[1] -> c[1];
measure a[2] -> c[2];
}(011G9?111G?uX  // Generated from Cirq v0.8.0

OPENQASM 2.0;
include "qelib1.inc";

// Qubits: [0, 1, 2, 3]
qreg q[4];
creg c[4];

x q[0];
x q[1];

// Gate: PhasedISWAP**0.9951774602384953
rz(pi*0.25) q[1];
rz(pi*-0.25) q[2];
cx q[1],q[2];
h q[1];
cx q[2],q[1];
rz(pi*0.4975887301) q[1];
cx q[2],q[1];
rz(pi*-0.4975887301) q[1];
h q[1];
cx q[1],q[2];
rz(pi*-0.25) q[1];
rz(pi*0.25) q[2];

rz(0) q[2];

// Gate: PhasedISWAP**-0.5024296754026449
rz(pi*0.25) q[0];
rz(pi*-0.25) q[1];
cx q[0],q[1];
h q[0];
cx q[1],q[0];
rz(pi*-0.2512148377) q[0];
cx q[1],q[0];
rz(pi*0.2512148377) q[0];
h q[0];
cx q[0],q[1];
rz(pi*-0.25) q[0];
rz(pi*0.25) q[1];

rz(0) q[1];

// Gate: PhasedISWAP**-0.49760685888033646
rz(pi*0.25) q[2];
rz(pi*-0.25) q[3];
cx q[2],q[3];
h q[2];
cx q[3],q[2];
rz(pi*-0.2488034294) q[2];
cx q[3],q[2];
rz(pi*0.2488034294) q[2];
h q[2];
cx q[2],q[3];
rz(pi*-0.25) q[2];
rz(pi*0.25) q[3];

rz(0) q[3];

// Gate: PhasedISWAP**0.004822678143889672
rz(pi*0.25) q[1];
rz(pi*-0.25) q[2];
cx q[1],q[2];
h q[1];
cx q[2],q[1];
rz(pi*0.0024113391) q[1];
cx q[2],q[1];
rz(pi*-0.0024113391) q[1];
h q[1];
cx q[1],q[2];
rz(pi*-0.25) q[1];
rz(pi*0.25) q[2];

rz(0) q[2];

measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
measure q[3] -> c[3];
}(0000G8l6*+ӌ0011G>AE\RM0101G?S0110G?>@c1001G?σ~Υ1010G?֗1100G>AL%	1111G8K+XuXH  // Name of Experiment: W-state v1

OPENQASM 2.0;
include "qelib1.inc";


qreg q[3];
creg c[3];
gate cH a,b {
h b;
sdg b;
cx a,b;
h b;
t b;
cx a,b;
t b;
h b;
s b;
x b;
s a;
 }

u3(1.91063,0,0) q[0];
cH q[0],q[1];
ccx q[0],q[1],q[2];
x q[0];
x q[1];
cx q[0],q[1];
measure q[0] -> c[0];
measure q[1] -> c[1];
measure q[2] -> c[2];
}(001G?U[jy010G?UR"J4011G8e ό100G?UR"J4uu.