import pandas as pd


def pre_processing(self, basic_df: pd.DataFrame,  y_label='y', test_size=0.2, **kwargs):
    # 缺失值处理


    pass


""":cvar

1、缺失值的处理

删除变量：若变量的缺失率较高直接删除（大于80%）
定值填充：工程中常见用-9999进行替代
统计量填充：若缺失率较低（小于95%）且重要性较低，均匀分布，均值填补，倾斜分布，中位数填补。
插值法填充：包括随机插值，多重差补法，热平台插补，拉格朗日插值，牛顿插值等
模型填充：使用回归、贝叶斯、随机森林、决策树等模型对缺失数据进行预测。

2、离群点处理
简单统计分析：根据箱线图、各分位点判断是否存在异常，例如pandas的describe函数可以快速发现异常值。
3  原则：若数据存在正态分布，偏离均值的3  之外. 通常定义  范围内的点为离群点。
基于绝对离差中位数（MAD）：这是一种稳健对抗离群数据的距离值方法，采用计算各观测值与平均值的距离总和的方法。放大了离群值的影响。
基于距离：通过定义对象之间的临近性度量，根据距离判断异常对象是否远离其他对象，缺点是计算复杂度较高，不适用于大数据集和存在不同密度区域的数据集
基于密度：离群点的局部密度显著低于大部分近邻点，适用于非均匀的数据集
基于聚类：利用聚类算法，丢弃远离其他簇的小簇。
总结来看，在数据处理阶段将离群点作为影响数据质量的异常点考虑，而不是作为通常所说的异常检测目标点，因而楼主一般采用较为简单直观的方法，结合箱线图和MAD的统计方法判断变量的离群点。
具体的处理手段：

根据异常点的数量和影响，考虑是否将该条记录删除，信息损失多
若对数据做了log-scale 对数变换后消除了异常值，则此方法生效，且不损失信息
平均值或中位数替代异常点，简单高效，信息的损失较少
在训练树模型时，树模型对离群点的鲁棒性较高，无信息损失，不影响模型训练效果

3、噪声处理

噪声是变量的随机误差和方差，是观测点和真实点之间的误差，即  。通常的处理办法：对数据进行分箱操作，等频或等宽分箱，然后用每个箱的平均数，中位数或者边界值（不同数据分布，处理方法不同）代替箱中所有的数，起到平滑数据的作用。另外一种做法是，建立该变量和预测变量的回归模型，根据回归系数和预测变量，反解出自变量的近似值。

1、维度规约

用于数据分析的数据可能包含数以百计的属性，其中大部分属性与挖掘任务不相关，是冗余的。维度归约通过删除不相关的属性，来减少数据量，并保证信息的损失最小。

属性子集选择：目标是找出最小属性集，使得数据类的概率分布尽可能地接近使用所有属性的原分布。在压缩 的属性集上挖掘还有其它的优点。它减少了出现在发现模式上的属性的数目，使得模式更易于理解。

逐步向前选择：该过程由空属性集开始，选择原属性集中最好的属性，并将它添加到该集合
中。在其后的每一次迭代，将原属性集剩下的属性中的最好的属性添加到该集合中。
逐步向后删除：该过程由整个属性集开始。在每一步，删除掉尚在属性集中的最坏属性。
向前选择和向后删除的结合：向前选择和向后删除方法可以结合在一起，每一步选择一个最 好的属性，并在剩余属性中删除一个最坏的属性。
python scikit-learn 中的递归特征消除算法Recursive feature elimination (RFE)，就是利用这样的思想进行特征子集筛选的，一般考虑建立SVM或回归模型。

单变量重要性：分析单变量和目标变量的相关性，删除预测能力较低的变量。这种方法不同于属性子集选择，通常从统计学和信息的角度去分析。

pearson相关系数和卡方检验，分析目标变量和单变量的相关性。
回归系数：训练线性回归或逻辑回归，提取每个变量的表决系数，进行重要性排序。
树模型的Gini指数：训练决策树模型，提取每个变量的重要度，即Gini指数进行排序。
Lasso正则化：训练回归模型时，加入L1正则化参数，将特征向量稀疏化。
IV指标：风控模型中，通常求解每个变量的IV值，来定义变量的重要度，一般将阀值设定在0.02以上。
以上提到的方法，没有讲解具体的理论知识和实现方法，需要同学们自己去熟悉掌握。楼主通常的做法是根据业务需求来定，如果基于业务的用户或商品特征，需要较多的解释性，考虑采用统计上的一些方法，如变量的分布曲线，直方图等，再计算相关性指标，最后去考虑一些模型方法。如果建模需要，则通常采用模型方法去筛选特征，如果用一些更为复杂的GBDT，DNN等模型，建议不做特征选择，而做特征交叉。

2、维度变换：

维度变换是将现有数据降低到更小的维度，尽量保证数据信息的完整性。楼主将介绍常用的几种有损失的维度变换方法，将大大地提高实践中建模的效率

主成分分析（PCA）和因子分析（FA）：PCA通过空间映射的方式，将当前维度映射到更低的维度，使得每个变量在新空间的方差最大。FA则是找到当前特征向量的公因子（维度更小），用公因子的线性组合来描述当前的特征向量。
奇异值分解（SVD）：SVD的降维可解释性较低，且计算量比PCA大，一般用在稀疏矩阵上降维，例如图片压缩，推荐系统。
聚类：将某一类具有相似性的特征聚到单个变量，从而大大降低维度。
线性组合：将多个变量做线性回归，根据每个变量的表决系数，赋予变量权重，可将该类变量根据权重组合成一个变量。
流行学习：流行学习中一些复杂的非线性方法，可参考skearn：LLE Example
数据变换
数据变换包括对数据进行规范化，离散化，稀疏化处理，达到适用于挖掘的目的。

规范化处理：数据中不同特征的量纲可能不一致，数值间的差别可能很大，不进行处理可能会影响到数据分析的结果，因此，需要对数据按照一定比例进行缩放，使之落在一个特定的区域，便于进行综合分析。特别是基于距离的挖掘方法，聚类，KNN，SVM一定要做规范化处理。
最大 - 最小规范化：将数据映射到[0,1]区间，


Z-Score标准化：处理后的数据均值为0，方差为1，


Log变换：在时间序列数据中，对于数据量级相差较大的变量，通常做Log函数的变换，  .


2、离散化处理：数据离散化是指将连续的数据进行分段，使其变为一段段离散化的区间。分段的原则有基于等距离、等频率或优化的方法。数据离散化的原因主要有以下几点：

模型需要：比如决策树、朴素贝叶斯等算法，都是基于离散型的数据展开的。如果要使用该类算法，必须将离散型的数据进行。有效的离散化能减小算法的时间和空间开销，提高系统对样本的分类聚类能力和抗噪声能力。
离散化的特征相对于连续型特征更易理解。
可以有效的克服数据中隐藏的缺陷，使模型结果更加稳定。
等频法：使得每个箱中的样本数量相等，例如总样本n=100，分成k=5个箱，则分箱原则是保证落入每个箱的样本量=20。

等宽法：使得属性的箱宽度相等，例如年龄变量（0-100之间），可分成 [0,20]，[20,40]，[40,60]，[60,80]，[80,100]五个等宽的箱。

聚类法：根据聚类出来的簇，每个簇中的数据为一个箱，簇的数量模型给定。

3、稀疏化处理：针对离散型且标称变量，无法进行有序的LabelEncoder时，通常考虑将变量做0，1哑变量的稀疏化处理，例如动物类型变量中含有猫，狗，猪，羊四个不同值，将该变量转换成is_猪，is_猫，is_狗，is_羊四个哑变量。若是变量的不同值较多，则根据频数，将出现次数较少的值统一归为一类'rare'。稀疏化处理既有利于模型快速收敛，又能提升模型的抗噪能力。

总结
以上介绍了数据预处理中会用到的大部分方法和技术，完全适用于初学者学习掌握，并且对于实践建模会有大幅度提升。以上方法的代码实现，均可在python的pandas和sklearn中完成。大家可根据需要去查阅学习，网上资料也很多，楼主只提供方法和经验上的借鉴，希望每个认真学习巩固的同学都能得到提升。
"""