# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class EarthLimbConstraint(BaseModel):
    """
    For a given Earth limb avoidance angle, is a given coordinate inside this constraint?  Parameters ---------- name     The name of the constraint. short_name     The short name of the constraint. min_angle     The minimum angle from the Earth limb that the spacecraft can point.  Methods ------- __call__(coord, ephemeris, earth_radius_angle=None)     Checks if a given coordinate is inside the constraint.
    """ # noqa: E501
    short_name: Optional[StrictStr] = 'Earth'
    name: Optional[StrictStr] = 'Earth Limb'
    min_angle: Optional[Union[Annotated[float, Field(le=180.0, strict=True, ge=0.0)], Annotated[int, Field(le=180, strict=True, ge=0)]]] = None
    max_angle: Optional[Union[Annotated[float, Field(le=180.0, strict=True, ge=0.0)], Annotated[int, Field(le=180, strict=True, ge=0)]]] = None
    __properties: ClassVar[List[str]] = ["short_name", "name", "min_angle", "max_angle"]

    @field_validator('short_name')
    def short_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Earth']):
            raise ValueError("must be one of enum values ('Earth')")
        return value

    @field_validator('name')
    def name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Earth Limb']):
            raise ValueError("must be one of enum values ('Earth Limb')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EarthLimbConstraint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if min_angle (nullable) is None
        # and model_fields_set contains the field
        if self.min_angle is None and "min_angle" in self.model_fields_set:
            _dict['min_angle'] = None

        # set to None if max_angle (nullable) is None
        # and model_fields_set contains the field
        if self.max_angle is None and "max_angle" in self.model_fields_set:
            _dict['max_angle'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EarthLimbConstraint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "short_name": obj.get("short_name") if obj.get("short_name") is not None else 'Earth',
            "name": obj.get("name") if obj.get("name") is not None else 'Earth Limb',
            "min_angle": obj.get("min_angle"),
            "max_angle": obj.get("max_angle")
        })
        return _obj


