# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from across.sdk.v1.models.filter import Filter
from across.sdk.v1.models.id_name_schema import IDNameSchema
from across.sdk.v1.models.instrument_constraints_inner import InstrumentConstraintsInner
from across.sdk.v1.models.point import Point
from across.sdk.v1.models.visibility_type import VisibilityType
from typing import Optional, Set
from typing_extensions import Self

class TelescopeInstrument(BaseModel):
    """
    A Pydantic model class representing a created Instrument for the Telescope Endpoint  Notes ----- Inherits from InstrumentBase  Methods ------- from_orm(instrument: InstrumentModel, include_footprints: bool, include_filters: bool) -> Instrument     Static method that instantiates this class from a Instrument database record
    """ # noqa: E501
    id: StrictStr
    created_on: datetime
    name: StrictStr
    short_name: StrictStr
    telescope: Optional[IDNameSchema] = None
    footprints: Optional[List[List[Point]]] = None
    filters: Optional[List[Filter]] = None
    constraints: Optional[List[InstrumentConstraintsInner]] = None
    visibility_type: Optional[VisibilityType] = None
    __properties: ClassVar[List[str]] = ["id", "created_on", "name", "short_name", "telescope", "footprints", "filters", "constraints", "visibility_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TelescopeInstrument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of telescope
        if self.telescope:
            _dict['telescope'] = self.telescope.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in footprints (list of list)
        _items = []
        if self.footprints:
            for _item_footprints in self.footprints:
                if _item_footprints:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_footprints if _inner_item is not None]
                    )
            _dict['footprints'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict['filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in constraints (list)
        _items = []
        if self.constraints:
            for _item_constraints in self.constraints:
                if _item_constraints:
                    _items.append(_item_constraints.to_dict())
            _dict['constraints'] = _items
        # set to None if telescope (nullable) is None
        # and model_fields_set contains the field
        if self.telescope is None and "telescope" in self.model_fields_set:
            _dict['telescope'] = None

        # set to None if footprints (nullable) is None
        # and model_fields_set contains the field
        if self.footprints is None and "footprints" in self.model_fields_set:
            _dict['footprints'] = None

        # set to None if filters (nullable) is None
        # and model_fields_set contains the field
        if self.filters is None and "filters" in self.model_fields_set:
            _dict['filters'] = None

        # set to None if constraints (nullable) is None
        # and model_fields_set contains the field
        if self.constraints is None and "constraints" in self.model_fields_set:
            _dict['constraints'] = None

        # set to None if visibility_type (nullable) is None
        # and model_fields_set contains the field
        if self.visibility_type is None and "visibility_type" in self.model_fields_set:
            _dict['visibility_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TelescopeInstrument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_on": obj.get("created_on"),
            "name": obj.get("name"),
            "short_name": obj.get("short_name"),
            "telescope": IDNameSchema.from_dict(obj["telescope"]) if obj.get("telescope") is not None else None,
            "footprints": [
                    [Point.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["footprints"]
                ] if obj.get("footprints") is not None else None,
            "filters": [Filter.from_dict(_item) for _item in obj["filters"]] if obj.get("filters") is not None else None,
            "constraints": [InstrumentConstraintsInner.from_dict(_item) for _item in obj["constraints"]] if obj.get("constraints") is not None else None,
            "visibility_type": obj.get("visibility_type")
        })
        return _obj


