# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from across.sdk.v1.models.wavelength_unit import WavelengthUnit
from typing import Optional, Set
from typing_extensions import Self

class WavelengthBandpass(BaseModel):
    """
    A class representing a bandpass filter defined in terms of wavelength.  Inherits from `BaseBandpass`, this class specializes the filter to operate in the wavelength domain and provides additional functionality for wavelength-based filters.  Attributes:     type (Literal['WAVELENGTH']): A constant string indicating the type of the bandpass filter.     central_wavelength (float | None): The central wavelength of the filter.     bandwidth (float | None): The bandwidth of the filter.     unit (WavelengthUnit): The unit of measurement for the wavelength.  Methods:     model_post_init(__context: Any) -> None:         Performs validation and calculation of central wavelength and bandwidth based on the min/max range
    """ # noqa: E501
    filter_name: Optional[StrictStr] = None
    min: Optional[Union[StrictFloat, StrictInt]] = None
    max: Optional[Union[StrictFloat, StrictInt]] = None
    type: Optional[StrictStr] = 'WAVELENGTH'
    central_wavelength: Optional[Union[StrictFloat, StrictInt]] = None
    peak_wavelength: Optional[Union[StrictFloat, StrictInt]] = None
    bandwidth: Optional[Union[StrictFloat, StrictInt]] = None
    unit: WavelengthUnit
    __properties: ClassVar[List[str]] = ["filter_name", "min", "max", "type", "central_wavelength", "peak_wavelength", "bandwidth", "unit"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['WAVELENGTH']):
            raise ValueError("must be one of enum values ('WAVELENGTH')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WavelengthBandpass from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if filter_name (nullable) is None
        # and model_fields_set contains the field
        if self.filter_name is None and "filter_name" in self.model_fields_set:
            _dict['filter_name'] = None

        # set to None if min (nullable) is None
        # and model_fields_set contains the field
        if self.min is None and "min" in self.model_fields_set:
            _dict['min'] = None

        # set to None if max (nullable) is None
        # and model_fields_set contains the field
        if self.max is None and "max" in self.model_fields_set:
            _dict['max'] = None

        # set to None if central_wavelength (nullable) is None
        # and model_fields_set contains the field
        if self.central_wavelength is None and "central_wavelength" in self.model_fields_set:
            _dict['central_wavelength'] = None

        # set to None if peak_wavelength (nullable) is None
        # and model_fields_set contains the field
        if self.peak_wavelength is None and "peak_wavelength" in self.model_fields_set:
            _dict['peak_wavelength'] = None

        # set to None if bandwidth (nullable) is None
        # and model_fields_set contains the field
        if self.bandwidth is None and "bandwidth" in self.model_fields_set:
            _dict['bandwidth'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WavelengthBandpass from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "filter_name": obj.get("filter_name"),
            "min": obj.get("min"),
            "max": obj.get("max"),
            "type": obj.get("type") if obj.get("type") is not None else 'WAVELENGTH',
            "central_wavelength": obj.get("central_wavelength"),
            "peak_wavelength": obj.get("peak_wavelength"),
            "bandwidth": obj.get("bandwidth"),
            "unit": obj.get("unit")
        })
        return _obj


