"""Initial full model setup

Revision ID: ecb1788b7e08
Revises: 53df0e286532
Create Date: 2023-12-21 06:39:09.346006

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "ecb1788b7e08"
down_revision: Union[str, None] = "53df0e286532"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "cpe",
        sa.Column("_id", sa.BigInteger(), nullable=False),
        sa.Column("id", sa.String(length=50), nullable=True),
        sa.Column("cpeName", sa.String(length=50), nullable=True),
        sa.Column("cpeNameId", sa.String(length=50), nullable=True),
        sa.Column("created", sa.DateTime(), nullable=True),
        sa.Column("deprecated", sa.Boolean(), nullable=True),
        sa.Column("deprecatedBy", sa.String(length=50), nullable=True),
        sa.Column("lastModified", sa.DateTime(), nullable=True),
        sa.Column("padded_version", sa.String(length=50), nullable=True),
        sa.Column("product", sa.String(length=50), nullable=True),
        sa.Column("stem", sa.String(length=50), nullable=True),
        sa.Column("title", sa.String(length=150), nullable=True),
        sa.Column("vendor", sa.String(length=50), nullable=True),
        sa.Column("version", sa.String(length=50), nullable=True),
        sa.PrimaryKeyConstraint("_id"),
    )
    op.create_index(op.f("ix_cpe__id"), "cpe", ["_id"], unique=True)
    op.create_index(op.f("ix_cpe_cpeName"), "cpe", ["cpeName"], unique=False)
    op.create_index(op.f("ix_cpe_deprecated"), "cpe", ["deprecated"], unique=False)
    op.create_index(op.f("ix_cpe_id"), "cpe", ["id"], unique=True)
    op.create_index(op.f("ix_cpe_lastModified"), "cpe", ["lastModified"], unique=False)
    op.create_index(
        op.f("ix_cpe_padded_version"), "cpe", ["padded_version"], unique=False
    )
    op.create_index(op.f("ix_cpe_product"), "cpe", ["product"], unique=False)
    op.create_index(op.f("ix_cpe_stem"), "cpe", ["stem"], unique=False)
    op.create_index(op.f("ix_cpe_title"), "cpe", ["title"], unique=False)
    op.create_index(op.f("ix_cpe_vendor"), "cpe", ["vendor"], unique=False)
    op.create_table(
        "cpeother",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_cpeother_id"), "cpeother", ["id"], unique=True)
    op.create_table(
        "cves",
        sa.Column("_id", sa.BigInteger(), nullable=False),
        sa.Column("id", sa.String(length=50), nullable=True),
        sa.Column("access", sa.JSON(), nullable=True),
        sa.Column("assigner", sa.String(length=50), nullable=True),
        sa.Column("cvss", sa.Float(), nullable=True),
        sa.Column("cvss3", sa.Float(), nullable=True),
        sa.Column("cvssSource", sa.String(length=50), nullable=True),
        sa.Column("cvssTime", sa.DateTime(), nullable=True),
        sa.Column("cvssVector", sa.String(length=100), nullable=True),
        sa.Column("cwe", sa.String(length=50), nullable=True),
        sa.Column("epss", sa.Float(), nullable=True),
        sa.Column("epssMetric", sa.JSON(), nullable=True),
        sa.Column("exploitabilityScore", sa.Float(), nullable=True),
        sa.Column("impact", sa.JSON(), nullable=True),
        sa.Column("impactScore", sa.Float(), nullable=True),
        sa.Column("lastModified", sa.DateTime(), nullable=True),
        sa.Column("modified", sa.DateTime(), nullable=True),
        sa.Column("products", sa.JSON(), nullable=True),
        sa.Column("published", sa.DateTime(), nullable=True),
        sa.Column("references", sa.JSON(), nullable=True),
        sa.Column("status", sa.String(length=25), nullable=True),
        sa.Column("summary", sa.Text(), nullable=True),
        sa.Column("vendors", sa.JSON(), nullable=True),
        sa.Column("vulnerable_configuration", sa.JSON(), nullable=True),
        sa.Column("vulnerable_configuration_cpe_2_2", sa.JSON(), nullable=True),
        sa.Column("vulnerable_configuration_stems", sa.JSON(), nullable=True),
        sa.Column("vulnerable_product", sa.JSON(), nullable=True),
        sa.Column("vulnerable_product_stems", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("_id"),
    )
    op.create_index(op.f("ix_cves__id"), "cves", ["_id"], unique=True)
    op.create_index(op.f("ix_cves_assigner"), "cves", ["assigner"], unique=False)
    op.create_index(op.f("ix_cves_cvss"), "cves", ["cvss"], unique=False)
    op.create_index(op.f("ix_cves_cvss3"), "cves", ["cvss3"], unique=False)
    op.create_index(op.f("ix_cves_cwe"), "cves", ["cwe"], unique=False)
    op.create_index(op.f("ix_cves_epss"), "cves", ["epss"], unique=False)
    op.create_index(op.f("ix_cves_id"), "cves", ["id"], unique=True)
    op.create_index(
        op.f("ix_cves_lastModified"), "cves", ["lastModified"], unique=False
    )
    op.create_index(op.f("ix_cves_modified"), "cves", ["modified"], unique=False)
    op.create_index(op.f("ix_cves_published"), "cves", ["published"], unique=False)
    op.create_index(op.f("ix_cves_status"), "cves", ["status"], unique=False)
    op.create_table(
        "cwe",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("name", sa.String(length=250), nullable=True),
        sa.Column("status", sa.String(length=25), nullable=True),
        sa.Column("weaknessabs", sa.String(length=25), nullable=True),
        sa.Column("related_weaknesses", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_cwe_id"), "cwe", ["id"], unique=True)
    op.create_index(op.f("ix_cwe_name"), "cwe", ["name"], unique=False)
    op.create_index(op.f("ix_cwe_status"), "cwe", ["status"], unique=False)
    op.create_table(
        "mgmt_blacklist",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_mgmt_blacklist_id"), "mgmt_blacklist", ["id"], unique=True)
    op.create_table(
        "mgmt_whitelist",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_mgmt_whitelist_id"), "mgmt_whitelist", ["id"], unique=True)
    op.create_table(
        "via4",
        sa.Column("_id", sa.Integer(), nullable=False),
        sa.Column("id", sa.String(length=50), nullable=True),
        sa.Column("db", sa.String(length=25), nullable=True),
        sa.Column("searchables", sa.JSON(), nullable=True),
        sa.Column("sources", sa.JSON(), nullable=True),
        sa.Column("msbulletin", sa.JSON(), nullable=True),
        sa.Column("redhat", sa.JSON(), nullable=True),
        sa.Column("refmap", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("_id"),
    )
    op.create_index(op.f("ix_via4__id"), "via4", ["_id"], unique=True)
    op.create_index(op.f("ix_via4_id"), "via4", ["id"], unique=False)
    op.create_index(
        op.f("ix_capec_typical_severity"), "capec", ["typical_severity"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_capec_typical_severity"), table_name="capec")
    op.drop_index(op.f("ix_via4_id"), table_name="via4")
    op.drop_index(op.f("ix_via4__id"), table_name="via4")
    op.drop_table("via4")
    op.drop_index(op.f("ix_mgmt_whitelist_id"), table_name="mgmt_whitelist")
    op.drop_table("mgmt_whitelist")
    op.drop_index(op.f("ix_mgmt_blacklist_id"), table_name="mgmt_blacklist")
    op.drop_table("mgmt_blacklist")
    op.drop_index(op.f("ix_cwe_status"), table_name="cwe")
    op.drop_index(op.f("ix_cwe_name"), table_name="cwe")
    op.drop_index(op.f("ix_cwe_id"), table_name="cwe")
    op.drop_table("cwe")
    op.drop_index(op.f("ix_cves_status"), table_name="cves")
    op.drop_index(op.f("ix_cves_published"), table_name="cves")
    op.drop_index(op.f("ix_cves_modified"), table_name="cves")
    op.drop_index(op.f("ix_cves_lastModified"), table_name="cves")
    op.drop_index(op.f("ix_cves_id"), table_name="cves")
    op.drop_index(op.f("ix_cves_epss"), table_name="cves")
    op.drop_index(op.f("ix_cves_cwe"), table_name="cves")
    op.drop_index(op.f("ix_cves_cvss3"), table_name="cves")
    op.drop_index(op.f("ix_cves_cvss"), table_name="cves")
    op.drop_index(op.f("ix_cves_assigner"), table_name="cves")
    op.drop_index(op.f("ix_cves__id"), table_name="cves")
    op.drop_table("cves")
    op.drop_index(op.f("ix_cpeother_id"), table_name="cpeother")
    op.drop_table("cpeother")
    op.drop_index(op.f("ix_cpe_vendor"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_title"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_stem"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_product"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_padded_version"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_lastModified"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_id"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_deprecated"), table_name="cpe")
    op.drop_index(op.f("ix_cpe_cpeName"), table_name="cpe")
    op.drop_index(op.f("ix_cpe__id"), table_name="cpe")
    op.drop_table("cpe")
    # ### end Alembic commands ###
