/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.config;

import io.ray.runtime.serializer.MessagePackSerializer;
import io.ray.serve.common.Constants;
import io.ray.serve.config.AutoscalingConfig;
import io.ray.serve.exception.RayServeException;
import io.ray.serve.generated.DeploymentConfig;
import io.ray.serve.generated.DeploymentLanguage;
import io.ray.serve.util.MessageFormatter;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.collect.Lists;
import io.ray.shaded.com.google.protobuf.ByteString;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;

public class DeploymentConfig
implements Serializable {
    private static final long serialVersionUID = 5965977837248820843L;
    private Integer numReplicas = 1;
    private Integer maxConcurrentQueries = 100;
    private Integer maxOngoingRequests = 100;
    private Object userConfig;
    private Double gracefulShutdownWaitLoopS = Constants.DEFAULT_GRACEFUL_SHUTDOWN_WAIT_LOOP_S;
    private Double gracefulShutdownTimeoutS = Constants.DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT_S;
    private Double healthCheckPeriodS = Constants.DEFAULT_HEALTH_CHECK_PERIOD_S;
    private Double healthCheckTimeoutS = Constants.DEFAULT_HEALTH_CHECK_TIMEOUT_S;
    private AutoscalingConfig autoscalingConfig;
    private Boolean isCrossLanguage = false;
    private DeploymentLanguage deploymentLanguage = DeploymentLanguage.JAVA;
    private String version;
    private String prevVersion;

    public Integer getNumReplicas() {
        return this.numReplicas;
    }

    public DeploymentConfig setNumReplicas(Integer numReplicas) {
        if (numReplicas != null) {
            this.numReplicas = numReplicas;
        }
        return this;
    }

    public Integer getMaxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    public Integer getMaxOngoingRequests() {
        return this.maxOngoingRequests;
    }

    public DeploymentConfig setMaxConcurrentQueries(Integer maxConcurrentQueries) {
        if (maxConcurrentQueries != null) {
            Preconditions.checkArgument(maxConcurrentQueries > 0, "max_concurrent_queries must be > 0");
            this.maxConcurrentQueries = maxConcurrentQueries;
        }
        return this;
    }

    public DeploymentConfig setMaxOngoingRequests(Integer maxOngoingRequests) {
        if (maxOngoingRequests != null) {
            Preconditions.checkArgument(maxOngoingRequests > 0, "max_ongoing_requests must be > 0");
            this.maxOngoingRequests = maxOngoingRequests;
        }
        return this;
    }

    public Object getUserConfig() {
        return this.userConfig;
    }

    public DeploymentConfig setUserConfig(Object userConfig) {
        this.userConfig = userConfig;
        return this;
    }

    public Double getGracefulShutdownWaitLoopS() {
        return this.gracefulShutdownWaitLoopS;
    }

    public DeploymentConfig setGracefulShutdownWaitLoopS(Double gracefulShutdownWaitLoopS) {
        if (gracefulShutdownWaitLoopS != null) {
            this.gracefulShutdownWaitLoopS = gracefulShutdownWaitLoopS;
        }
        return this;
    }

    public Double getGracefulShutdownTimeoutS() {
        return this.gracefulShutdownTimeoutS;
    }

    public DeploymentConfig setGracefulShutdownTimeoutS(Double gracefulShutdownTimeoutS) {
        if (gracefulShutdownTimeoutS != null) {
            this.gracefulShutdownTimeoutS = gracefulShutdownTimeoutS;
        }
        return this;
    }

    public Double getHealthCheckPeriodS() {
        return this.healthCheckPeriodS;
    }

    public DeploymentConfig setHealthCheckPeriodS(Double healthCheckPeriodS) {
        if (healthCheckPeriodS != null) {
            this.healthCheckPeriodS = healthCheckPeriodS;
        }
        return this;
    }

    public Double getHealthCheckTimeoutS() {
        return this.healthCheckTimeoutS;
    }

    public DeploymentConfig setHealthCheckTimeoutS(Double healthCheckTimeoutS) {
        if (healthCheckTimeoutS != null) {
            this.healthCheckTimeoutS = healthCheckTimeoutS;
        }
        return this;
    }

    public AutoscalingConfig getAutoscalingConfig() {
        return this.autoscalingConfig;
    }

    public DeploymentConfig setAutoscalingConfig(AutoscalingConfig autoscalingConfig) {
        this.autoscalingConfig = autoscalingConfig;
        return this;
    }

    public boolean isCrossLanguage() {
        return this.isCrossLanguage;
    }

    public DeploymentConfig setCrossLanguage(Boolean isCrossLanguage) {
        if (isCrossLanguage != null) {
            this.isCrossLanguage = isCrossLanguage;
        }
        return this;
    }

    public DeploymentLanguage getDeploymentLanguage() {
        return this.deploymentLanguage;
    }

    public DeploymentConfig setDeploymentLanguage(DeploymentLanguage deploymentLanguage) {
        if (deploymentLanguage != null) {
            this.deploymentLanguage = deploymentLanguage;
            this.isCrossLanguage = deploymentLanguage != DeploymentLanguage.JAVA;
        }
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public DeploymentConfig setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getPrevVersion() {
        return this.prevVersion;
    }

    public void setPrevVersion(String prevVersion) {
        this.prevVersion = prevVersion;
    }

    public byte[] toProtoBytes() {
        Integer maxOngoingRequests = this.maxOngoingRequests == null ? this.maxConcurrentQueries : this.maxOngoingRequests;
        DeploymentConfig.Builder builder = io.ray.serve.generated.DeploymentConfig.newBuilder().setNumReplicas(this.numReplicas).setMaxOngoingRequests(maxOngoingRequests).setMaxQueuedRequests(-1).setGracefulShutdownWaitLoopS(this.gracefulShutdownWaitLoopS).setGracefulShutdownTimeoutS(this.gracefulShutdownTimeoutS).setHealthCheckPeriodS(this.healthCheckPeriodS).setHealthCheckTimeoutS(this.healthCheckTimeoutS).setIsCrossLanguage(this.isCrossLanguage).setDeploymentLanguage(this.deploymentLanguage).setVersion(this.version);
        if (null != this.userConfig) {
            builder.setUserConfig(ByteString.copyFrom(MessagePackSerializer.encode(this.userConfig).getKey()));
        }
        if (null != this.autoscalingConfig) {
            builder.setAutoscalingConfig(this.autoscalingConfig.toProto());
        }
        return builder.build().toByteArray();
    }

    public io.ray.serve.generated.DeploymentConfig toProto() {
        DeploymentConfig.Builder builder = io.ray.serve.generated.DeploymentConfig.newBuilder().setNumReplicas(this.numReplicas).setMaxOngoingRequests(this.maxOngoingRequests).setGracefulShutdownWaitLoopS(this.gracefulShutdownWaitLoopS).setGracefulShutdownTimeoutS(this.gracefulShutdownTimeoutS).setHealthCheckPeriodS(this.healthCheckPeriodS).setHealthCheckTimeoutS(this.healthCheckTimeoutS).setIsCrossLanguage(this.isCrossLanguage).setDeploymentLanguage(this.deploymentLanguage);
        if (null != this.userConfig) {
            builder.setUserConfig(ByteString.copyFrom(MessagePackSerializer.encode(this.userConfig).getKey()));
        }
        if (null != this.autoscalingConfig) {
            builder.setAutoscalingConfig(this.autoscalingConfig.toProto());
        }
        return builder.build();
    }

    public static DeploymentConfig fromProto(io.ray.serve.generated.DeploymentConfig proto) {
        DeploymentConfig deploymentConfig = new DeploymentConfig();
        if (proto == null) {
            return deploymentConfig;
        }
        deploymentConfig.setNumReplicas(proto.getNumReplicas());
        deploymentConfig.setMaxConcurrentQueries(proto.getMaxOngoingRequests());
        deploymentConfig.setMaxOngoingRequests(proto.getMaxOngoingRequests());
        deploymentConfig.setGracefulShutdownWaitLoopS(proto.getGracefulShutdownWaitLoopS());
        deploymentConfig.setGracefulShutdownTimeoutS(proto.getGracefulShutdownTimeoutS());
        deploymentConfig.setCrossLanguage(proto.getIsCrossLanguage());
        if (proto.getDeploymentLanguage() == DeploymentLanguage.UNRECOGNIZED) {
            throw new RayServeException(MessageFormatter.format("Unrecognized deployment language {}. Deployment language must be in {}.", proto.getDeploymentLanguage(), Lists.newArrayList(DeploymentLanguage.values())));
        }
        deploymentConfig.setDeploymentLanguage(proto.getDeploymentLanguage());
        if (proto.getUserConfig() != null && proto.getUserConfig().size() != 0) {
            deploymentConfig.setUserConfig(MessagePackSerializer.decode(proto.getUserConfig().toByteArray(), Object.class));
        }
        return deploymentConfig;
    }

    public static DeploymentConfig fromProtoBytes(byte[] bytes) {
        DeploymentConfig deploymentConfig = new DeploymentConfig();
        if (bytes == null) {
            return deploymentConfig;
        }
        io.ray.serve.generated.DeploymentConfig proto = null;
        try {
            proto = io.ray.serve.generated.DeploymentConfig.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RayServeException("Failed to parse DeploymentConfig from protobuf bytes.", e);
        }
        return DeploymentConfig.fromProto(proto);
    }
}

