import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementIdentityProviderGoogleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#api_management_name ApiManagementIdentityProviderGoogle#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#client_id ApiManagementIdentityProviderGoogle#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#client_secret ApiManagementIdentityProviderGoogle#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#id ApiManagementIdentityProviderGoogle#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#resource_group_name ApiManagementIdentityProviderGoogle#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#timeouts ApiManagementIdentityProviderGoogle#timeouts}
    */
    readonly timeouts?: ApiManagementIdentityProviderGoogleTimeouts;
}
export interface ApiManagementIdentityProviderGoogleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#create ApiManagementIdentityProviderGoogle#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#delete ApiManagementIdentityProviderGoogle#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#read ApiManagementIdentityProviderGoogle#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google#update ApiManagementIdentityProviderGoogle#update}
    */
    readonly update?: string;
}
export declare function apiManagementIdentityProviderGoogleTimeoutsToTerraform(struct?: ApiManagementIdentityProviderGoogleTimeoutsOutputReference | ApiManagementIdentityProviderGoogleTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementIdentityProviderGoogleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementIdentityProviderGoogleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementIdentityProviderGoogleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google azurerm_api_management_identity_provider_google}
*/
export declare class ApiManagementIdentityProviderGoogle extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_identity_provider_google";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_google azurerm_api_management_identity_provider_google} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementIdentityProviderGoogleConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementIdentityProviderGoogleConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementIdentityProviderGoogleTimeoutsOutputReference;
    putTimeouts(value: ApiManagementIdentityProviderGoogleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementIdentityProviderGoogleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
