import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorRuleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#cdn_frontdoor_profile_id CdnFrontdoorRuleSet#cdn_frontdoor_profile_id}
    */
    readonly cdnFrontdoorProfileId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#id CdnFrontdoorRuleSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#name CdnFrontdoorRuleSet#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#timeouts CdnFrontdoorRuleSet#timeouts}
    */
    readonly timeouts?: CdnFrontdoorRuleSetTimeouts;
}
export interface CdnFrontdoorRuleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#create CdnFrontdoorRuleSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#delete CdnFrontdoorRuleSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#read CdnFrontdoorRuleSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set#update CdnFrontdoorRuleSet#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorRuleSetTimeoutsToTerraform(struct?: CdnFrontdoorRuleSetTimeoutsOutputReference | CdnFrontdoorRuleSetTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRuleSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set azurerm_cdn_frontdoor_rule_set}
*/
export declare class CdnFrontdoorRuleSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_rule_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_rule_set azurerm_cdn_frontdoor_rule_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorRuleSetConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorRuleSetConfig);
    private _cdnFrontdoorProfileId?;
    get cdnFrontdoorProfileId(): string;
    set cdnFrontdoorProfileId(value: string);
    get cdnFrontdoorProfileIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorRuleSetTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorRuleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorRuleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
