import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLbConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#id DataAzurermLb#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#name DataAzurermLb#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#resource_group_name DataAzurermLb#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#timeouts DataAzurermLb#timeouts}
    */
    readonly timeouts?: DataAzurermLbTimeouts;
}
export interface DataAzurermLbFrontendIpConfiguration {
}
export declare function dataAzurermLbFrontendIpConfigurationToTerraform(struct?: DataAzurermLbFrontendIpConfiguration): any;
export declare class DataAzurermLbFrontendIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLbFrontendIpConfiguration | undefined;
    set internalValue(value: DataAzurermLbFrontendIpConfiguration | undefined);
    get id(): string;
    get name(): string;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get privateIpAddressVersion(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
    get zones(): string[];
}
export declare class DataAzurermLbFrontendIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLbFrontendIpConfigurationOutputReference;
}
export interface DataAzurermLbTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#read DataAzurermLb#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLbTimeoutsToTerraform(struct?: DataAzurermLbTimeoutsOutputReference | DataAzurermLbTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLbTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLbTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLbTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/lb azurerm_lb}
*/
export declare class DataAzurermLb extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_lb";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/lb azurerm_lb} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLbConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLbConfig);
    private _frontendIpConfiguration;
    get frontendIpConfiguration(): DataAzurermLbFrontendIpConfigurationList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermLbTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLbTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLbTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
