"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesClusterNodePool = exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = exports.KubernetesClusterNodePoolTimeoutsOutputReference = exports.kubernetesClusterNodePoolTimeoutsToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = exports.KubernetesClusterNodePoolKubeletConfigOutputReference = exports.kubernetesClusterNodePoolKubeletConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function kubernetesClusterNodePoolKubeletConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_unsafe_sysctls: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.allowedUnsafeSysctls),
        container_log_max_line: cdktf.numberToTerraform(struct.containerLogMaxLine),
        container_log_max_size_mb: cdktf.numberToTerraform(struct.containerLogMaxSizeMb),
        cpu_cfs_quota_enabled: cdktf.booleanToTerraform(struct.cpuCfsQuotaEnabled),
        cpu_cfs_quota_period: cdktf.stringToTerraform(struct.cpuCfsQuotaPeriod),
        cpu_manager_policy: cdktf.stringToTerraform(struct.cpuManagerPolicy),
        image_gc_high_threshold: cdktf.numberToTerraform(struct.imageGcHighThreshold),
        image_gc_low_threshold: cdktf.numberToTerraform(struct.imageGcLowThreshold),
        pod_max_pid: cdktf.numberToTerraform(struct.podMaxPid),
        topology_manager_policy: cdktf.stringToTerraform(struct.topologyManagerPolicy),
    };
}
exports.kubernetesClusterNodePoolKubeletConfigToTerraform = kubernetesClusterNodePoolKubeletConfigToTerraform;
class KubernetesClusterNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedUnsafeSysctls !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedUnsafeSysctls = this._allowedUnsafeSysctls;
        }
        if (this._containerLogMaxLine !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxLine = this._containerLogMaxLine;
        }
        if (this._containerLogMaxSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxSizeMb = this._containerLogMaxSizeMb;
        }
        if (this._cpuCfsQuotaEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaEnabled = this._cpuCfsQuotaEnabled;
        }
        if (this._cpuCfsQuotaPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaPeriod = this._cpuCfsQuotaPeriod;
        }
        if (this._cpuManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuManagerPolicy = this._cpuManagerPolicy;
        }
        if (this._imageGcHighThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcHighThreshold = this._imageGcHighThreshold;
        }
        if (this._imageGcLowThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcLowThreshold = this._imageGcLowThreshold;
        }
        if (this._podMaxPid !== undefined) {
            hasAnyValues = true;
            internalValueResult.podMaxPid = this._podMaxPid;
        }
        if (this._topologyManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.topologyManagerPolicy = this._topologyManagerPolicy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allowedUnsafeSysctls = undefined;
            this._containerLogMaxLine = undefined;
            this._containerLogMaxSizeMb = undefined;
            this._cpuCfsQuotaEnabled = undefined;
            this._cpuCfsQuotaPeriod = undefined;
            this._cpuManagerPolicy = undefined;
            this._imageGcHighThreshold = undefined;
            this._imageGcLowThreshold = undefined;
            this._podMaxPid = undefined;
            this._topologyManagerPolicy = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allowedUnsafeSysctls = value.allowedUnsafeSysctls;
            this._containerLogMaxLine = value.containerLogMaxLine;
            this._containerLogMaxSizeMb = value.containerLogMaxSizeMb;
            this._cpuCfsQuotaEnabled = value.cpuCfsQuotaEnabled;
            this._cpuCfsQuotaPeriod = value.cpuCfsQuotaPeriod;
            this._cpuManagerPolicy = value.cpuManagerPolicy;
            this._imageGcHighThreshold = value.imageGcHighThreshold;
            this._imageGcLowThreshold = value.imageGcLowThreshold;
            this._podMaxPid = value.podMaxPid;
            this._topologyManagerPolicy = value.topologyManagerPolicy;
        }
    }
    get allowedUnsafeSysctls() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_unsafe_sysctls'));
    }
    set allowedUnsafeSysctls(value) {
        this._allowedUnsafeSysctls = value;
    }
    resetAllowedUnsafeSysctls() {
        this._allowedUnsafeSysctls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedUnsafeSysctlsInput() {
        return this._allowedUnsafeSysctls;
    }
    get containerLogMaxLine() {
        return this.getNumberAttribute('container_log_max_line');
    }
    set containerLogMaxLine(value) {
        this._containerLogMaxLine = value;
    }
    resetContainerLogMaxLine() {
        this._containerLogMaxLine = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxLineInput() {
        return this._containerLogMaxLine;
    }
    get containerLogMaxSizeMb() {
        return this.getNumberAttribute('container_log_max_size_mb');
    }
    set containerLogMaxSizeMb(value) {
        this._containerLogMaxSizeMb = value;
    }
    resetContainerLogMaxSizeMb() {
        this._containerLogMaxSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxSizeMbInput() {
        return this._containerLogMaxSizeMb;
    }
    get cpuCfsQuotaEnabled() {
        return this.getBooleanAttribute('cpu_cfs_quota_enabled');
    }
    set cpuCfsQuotaEnabled(value) {
        this._cpuCfsQuotaEnabled = value;
    }
    resetCpuCfsQuotaEnabled() {
        this._cpuCfsQuotaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaEnabledInput() {
        return this._cpuCfsQuotaEnabled;
    }
    get cpuCfsQuotaPeriod() {
        return this.getStringAttribute('cpu_cfs_quota_period');
    }
    set cpuCfsQuotaPeriod(value) {
        this._cpuCfsQuotaPeriod = value;
    }
    resetCpuCfsQuotaPeriod() {
        this._cpuCfsQuotaPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaPeriodInput() {
        return this._cpuCfsQuotaPeriod;
    }
    get cpuManagerPolicy() {
        return this.getStringAttribute('cpu_manager_policy');
    }
    set cpuManagerPolicy(value) {
        this._cpuManagerPolicy = value;
    }
    resetCpuManagerPolicy() {
        this._cpuManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuManagerPolicyInput() {
        return this._cpuManagerPolicy;
    }
    get imageGcHighThreshold() {
        return this.getNumberAttribute('image_gc_high_threshold');
    }
    set imageGcHighThreshold(value) {
        this._imageGcHighThreshold = value;
    }
    resetImageGcHighThreshold() {
        this._imageGcHighThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcHighThresholdInput() {
        return this._imageGcHighThreshold;
    }
    get imageGcLowThreshold() {
        return this.getNumberAttribute('image_gc_low_threshold');
    }
    set imageGcLowThreshold(value) {
        this._imageGcLowThreshold = value;
    }
    resetImageGcLowThreshold() {
        this._imageGcLowThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcLowThresholdInput() {
        return this._imageGcLowThreshold;
    }
    get podMaxPid() {
        return this.getNumberAttribute('pod_max_pid');
    }
    set podMaxPid(value) {
        this._podMaxPid = value;
    }
    resetPodMaxPid() {
        this._podMaxPid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podMaxPidInput() {
        return this._podMaxPid;
    }
    get topologyManagerPolicy() {
        return this.getStringAttribute('topology_manager_policy');
    }
    set topologyManagerPolicy(value) {
        this._topologyManagerPolicy = value;
    }
    resetTopologyManagerPolicy() {
        this._topologyManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topologyManagerPolicyInput() {
        return this._topologyManagerPolicy;
    }
}
exports.KubernetesClusterNodePoolKubeletConfigOutputReference = KubernetesClusterNodePoolKubeletConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolKubeletConfigOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolKubeletConfigOutputReference", version: "2.0.18" };
function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fs_aio_max_nr: cdktf.numberToTerraform(struct.fsAioMaxNr),
        fs_file_max: cdktf.numberToTerraform(struct.fsFileMax),
        fs_inotify_max_user_watches: cdktf.numberToTerraform(struct.fsInotifyMaxUserWatches),
        fs_nr_open: cdktf.numberToTerraform(struct.fsNrOpen),
        kernel_threads_max: cdktf.numberToTerraform(struct.kernelThreadsMax),
        net_core_netdev_max_backlog: cdktf.numberToTerraform(struct.netCoreNetdevMaxBacklog),
        net_core_optmem_max: cdktf.numberToTerraform(struct.netCoreOptmemMax),
        net_core_rmem_default: cdktf.numberToTerraform(struct.netCoreRmemDefault),
        net_core_rmem_max: cdktf.numberToTerraform(struct.netCoreRmemMax),
        net_core_somaxconn: cdktf.numberToTerraform(struct.netCoreSomaxconn),
        net_core_wmem_default: cdktf.numberToTerraform(struct.netCoreWmemDefault),
        net_core_wmem_max: cdktf.numberToTerraform(struct.netCoreWmemMax),
        net_ipv4_ip_local_port_range_max: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMax),
        net_ipv4_ip_local_port_range_min: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMin),
        net_ipv4_neigh_default_gc_thresh1: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh1),
        net_ipv4_neigh_default_gc_thresh2: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh2),
        net_ipv4_neigh_default_gc_thresh3: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh3),
        net_ipv4_tcp_fin_timeout: cdktf.numberToTerraform(struct.netIpv4TcpFinTimeout),
        net_ipv4_tcp_keepalive_intvl: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveIntvl),
        net_ipv4_tcp_keepalive_probes: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveProbes),
        net_ipv4_tcp_keepalive_time: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveTime),
        net_ipv4_tcp_max_syn_backlog: cdktf.numberToTerraform(struct.netIpv4TcpMaxSynBacklog),
        net_ipv4_tcp_max_tw_buckets: cdktf.numberToTerraform(struct.netIpv4TcpMaxTwBuckets),
        net_ipv4_tcp_tw_reuse: cdktf.booleanToTerraform(struct.netIpv4TcpTwReuse),
        net_netfilter_nf_conntrack_buckets: cdktf.numberToTerraform(struct.netNetfilterNfConntrackBuckets),
        net_netfilter_nf_conntrack_max: cdktf.numberToTerraform(struct.netNetfilterNfConntrackMax),
        vm_max_map_count: cdktf.numberToTerraform(struct.vmMaxMapCount),
        vm_swappiness: cdktf.numberToTerraform(struct.vmSwappiness),
        vm_vfs_cache_pressure: cdktf.numberToTerraform(struct.vmVfsCachePressure),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._fsAioMaxNr !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsAioMaxNr = this._fsAioMaxNr;
        }
        if (this._fsFileMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsFileMax = this._fsFileMax;
        }
        if (this._fsInotifyMaxUserWatches !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsInotifyMaxUserWatches = this._fsInotifyMaxUserWatches;
        }
        if (this._fsNrOpen !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsNrOpen = this._fsNrOpen;
        }
        if (this._kernelThreadsMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.kernelThreadsMax = this._kernelThreadsMax;
        }
        if (this._netCoreNetdevMaxBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreNetdevMaxBacklog = this._netCoreNetdevMaxBacklog;
        }
        if (this._netCoreOptmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreOptmemMax = this._netCoreOptmemMax;
        }
        if (this._netCoreRmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemDefault = this._netCoreRmemDefault;
        }
        if (this._netCoreRmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemMax = this._netCoreRmemMax;
        }
        if (this._netCoreSomaxconn !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreSomaxconn = this._netCoreSomaxconn;
        }
        if (this._netCoreWmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemDefault = this._netCoreWmemDefault;
        }
        if (this._netCoreWmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemMax = this._netCoreWmemMax;
        }
        if (this._netIpv4IpLocalPortRangeMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMax = this._netIpv4IpLocalPortRangeMax;
        }
        if (this._netIpv4IpLocalPortRangeMin !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMin = this._netIpv4IpLocalPortRangeMin;
        }
        if (this._netIpv4NeighDefaultGcThresh1 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh1 = this._netIpv4NeighDefaultGcThresh1;
        }
        if (this._netIpv4NeighDefaultGcThresh2 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh2 = this._netIpv4NeighDefaultGcThresh2;
        }
        if (this._netIpv4NeighDefaultGcThresh3 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh3 = this._netIpv4NeighDefaultGcThresh3;
        }
        if (this._netIpv4TcpFinTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpFinTimeout = this._netIpv4TcpFinTimeout;
        }
        if (this._netIpv4TcpKeepaliveIntvl !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveIntvl = this._netIpv4TcpKeepaliveIntvl;
        }
        if (this._netIpv4TcpKeepaliveProbes !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveProbes = this._netIpv4TcpKeepaliveProbes;
        }
        if (this._netIpv4TcpKeepaliveTime !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveTime = this._netIpv4TcpKeepaliveTime;
        }
        if (this._netIpv4TcpMaxSynBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxSynBacklog = this._netIpv4TcpMaxSynBacklog;
        }
        if (this._netIpv4TcpMaxTwBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxTwBuckets = this._netIpv4TcpMaxTwBuckets;
        }
        if (this._netIpv4TcpTwReuse !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpTwReuse = this._netIpv4TcpTwReuse;
        }
        if (this._netNetfilterNfConntrackBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackBuckets = this._netNetfilterNfConntrackBuckets;
        }
        if (this._netNetfilterNfConntrackMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackMax = this._netNetfilterNfConntrackMax;
        }
        if (this._vmMaxMapCount !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmMaxMapCount = this._vmMaxMapCount;
        }
        if (this._vmSwappiness !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmSwappiness = this._vmSwappiness;
        }
        if (this._vmVfsCachePressure !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmVfsCachePressure = this._vmVfsCachePressure;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._fsAioMaxNr = undefined;
            this._fsFileMax = undefined;
            this._fsInotifyMaxUserWatches = undefined;
            this._fsNrOpen = undefined;
            this._kernelThreadsMax = undefined;
            this._netCoreNetdevMaxBacklog = undefined;
            this._netCoreOptmemMax = undefined;
            this._netCoreRmemDefault = undefined;
            this._netCoreRmemMax = undefined;
            this._netCoreSomaxconn = undefined;
            this._netCoreWmemDefault = undefined;
            this._netCoreWmemMax = undefined;
            this._netIpv4IpLocalPortRangeMax = undefined;
            this._netIpv4IpLocalPortRangeMin = undefined;
            this._netIpv4NeighDefaultGcThresh1 = undefined;
            this._netIpv4NeighDefaultGcThresh2 = undefined;
            this._netIpv4NeighDefaultGcThresh3 = undefined;
            this._netIpv4TcpFinTimeout = undefined;
            this._netIpv4TcpKeepaliveIntvl = undefined;
            this._netIpv4TcpKeepaliveProbes = undefined;
            this._netIpv4TcpKeepaliveTime = undefined;
            this._netIpv4TcpMaxSynBacklog = undefined;
            this._netIpv4TcpMaxTwBuckets = undefined;
            this._netIpv4TcpTwReuse = undefined;
            this._netNetfilterNfConntrackBuckets = undefined;
            this._netNetfilterNfConntrackMax = undefined;
            this._vmMaxMapCount = undefined;
            this._vmSwappiness = undefined;
            this._vmVfsCachePressure = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._fsAioMaxNr = value.fsAioMaxNr;
            this._fsFileMax = value.fsFileMax;
            this._fsInotifyMaxUserWatches = value.fsInotifyMaxUserWatches;
            this._fsNrOpen = value.fsNrOpen;
            this._kernelThreadsMax = value.kernelThreadsMax;
            this._netCoreNetdevMaxBacklog = value.netCoreNetdevMaxBacklog;
            this._netCoreOptmemMax = value.netCoreOptmemMax;
            this._netCoreRmemDefault = value.netCoreRmemDefault;
            this._netCoreRmemMax = value.netCoreRmemMax;
            this._netCoreSomaxconn = value.netCoreSomaxconn;
            this._netCoreWmemDefault = value.netCoreWmemDefault;
            this._netCoreWmemMax = value.netCoreWmemMax;
            this._netIpv4IpLocalPortRangeMax = value.netIpv4IpLocalPortRangeMax;
            this._netIpv4IpLocalPortRangeMin = value.netIpv4IpLocalPortRangeMin;
            this._netIpv4NeighDefaultGcThresh1 = value.netIpv4NeighDefaultGcThresh1;
            this._netIpv4NeighDefaultGcThresh2 = value.netIpv4NeighDefaultGcThresh2;
            this._netIpv4NeighDefaultGcThresh3 = value.netIpv4NeighDefaultGcThresh3;
            this._netIpv4TcpFinTimeout = value.netIpv4TcpFinTimeout;
            this._netIpv4TcpKeepaliveIntvl = value.netIpv4TcpKeepaliveIntvl;
            this._netIpv4TcpKeepaliveProbes = value.netIpv4TcpKeepaliveProbes;
            this._netIpv4TcpKeepaliveTime = value.netIpv4TcpKeepaliveTime;
            this._netIpv4TcpMaxSynBacklog = value.netIpv4TcpMaxSynBacklog;
            this._netIpv4TcpMaxTwBuckets = value.netIpv4TcpMaxTwBuckets;
            this._netIpv4TcpTwReuse = value.netIpv4TcpTwReuse;
            this._netNetfilterNfConntrackBuckets = value.netNetfilterNfConntrackBuckets;
            this._netNetfilterNfConntrackMax = value.netNetfilterNfConntrackMax;
            this._vmMaxMapCount = value.vmMaxMapCount;
            this._vmSwappiness = value.vmSwappiness;
            this._vmVfsCachePressure = value.vmVfsCachePressure;
        }
    }
    get fsAioMaxNr() {
        return this.getNumberAttribute('fs_aio_max_nr');
    }
    set fsAioMaxNr(value) {
        this._fsAioMaxNr = value;
    }
    resetFsAioMaxNr() {
        this._fsAioMaxNr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsAioMaxNrInput() {
        return this._fsAioMaxNr;
    }
    get fsFileMax() {
        return this.getNumberAttribute('fs_file_max');
    }
    set fsFileMax(value) {
        this._fsFileMax = value;
    }
    resetFsFileMax() {
        this._fsFileMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsFileMaxInput() {
        return this._fsFileMax;
    }
    get fsInotifyMaxUserWatches() {
        return this.getNumberAttribute('fs_inotify_max_user_watches');
    }
    set fsInotifyMaxUserWatches(value) {
        this._fsInotifyMaxUserWatches = value;
    }
    resetFsInotifyMaxUserWatches() {
        this._fsInotifyMaxUserWatches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsInotifyMaxUserWatchesInput() {
        return this._fsInotifyMaxUserWatches;
    }
    get fsNrOpen() {
        return this.getNumberAttribute('fs_nr_open');
    }
    set fsNrOpen(value) {
        this._fsNrOpen = value;
    }
    resetFsNrOpen() {
        this._fsNrOpen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsNrOpenInput() {
        return this._fsNrOpen;
    }
    get kernelThreadsMax() {
        return this.getNumberAttribute('kernel_threads_max');
    }
    set kernelThreadsMax(value) {
        this._kernelThreadsMax = value;
    }
    resetKernelThreadsMax() {
        this._kernelThreadsMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kernelThreadsMaxInput() {
        return this._kernelThreadsMax;
    }
    get netCoreNetdevMaxBacklog() {
        return this.getNumberAttribute('net_core_netdev_max_backlog');
    }
    set netCoreNetdevMaxBacklog(value) {
        this._netCoreNetdevMaxBacklog = value;
    }
    resetNetCoreNetdevMaxBacklog() {
        this._netCoreNetdevMaxBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreNetdevMaxBacklogInput() {
        return this._netCoreNetdevMaxBacklog;
    }
    get netCoreOptmemMax() {
        return this.getNumberAttribute('net_core_optmem_max');
    }
    set netCoreOptmemMax(value) {
        this._netCoreOptmemMax = value;
    }
    resetNetCoreOptmemMax() {
        this._netCoreOptmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreOptmemMaxInput() {
        return this._netCoreOptmemMax;
    }
    get netCoreRmemDefault() {
        return this.getNumberAttribute('net_core_rmem_default');
    }
    set netCoreRmemDefault(value) {
        this._netCoreRmemDefault = value;
    }
    resetNetCoreRmemDefault() {
        this._netCoreRmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemDefaultInput() {
        return this._netCoreRmemDefault;
    }
    get netCoreRmemMax() {
        return this.getNumberAttribute('net_core_rmem_max');
    }
    set netCoreRmemMax(value) {
        this._netCoreRmemMax = value;
    }
    resetNetCoreRmemMax() {
        this._netCoreRmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemMaxInput() {
        return this._netCoreRmemMax;
    }
    get netCoreSomaxconn() {
        return this.getNumberAttribute('net_core_somaxconn');
    }
    set netCoreSomaxconn(value) {
        this._netCoreSomaxconn = value;
    }
    resetNetCoreSomaxconn() {
        this._netCoreSomaxconn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreSomaxconnInput() {
        return this._netCoreSomaxconn;
    }
    get netCoreWmemDefault() {
        return this.getNumberAttribute('net_core_wmem_default');
    }
    set netCoreWmemDefault(value) {
        this._netCoreWmemDefault = value;
    }
    resetNetCoreWmemDefault() {
        this._netCoreWmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemDefaultInput() {
        return this._netCoreWmemDefault;
    }
    get netCoreWmemMax() {
        return this.getNumberAttribute('net_core_wmem_max');
    }
    set netCoreWmemMax(value) {
        this._netCoreWmemMax = value;
    }
    resetNetCoreWmemMax() {
        this._netCoreWmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemMaxInput() {
        return this._netCoreWmemMax;
    }
    get netIpv4IpLocalPortRangeMax() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_max');
    }
    set netIpv4IpLocalPortRangeMax(value) {
        this._netIpv4IpLocalPortRangeMax = value;
    }
    resetNetIpv4IpLocalPortRangeMax() {
        this._netIpv4IpLocalPortRangeMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMaxInput() {
        return this._netIpv4IpLocalPortRangeMax;
    }
    get netIpv4IpLocalPortRangeMin() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_min');
    }
    set netIpv4IpLocalPortRangeMin(value) {
        this._netIpv4IpLocalPortRangeMin = value;
    }
    resetNetIpv4IpLocalPortRangeMin() {
        this._netIpv4IpLocalPortRangeMin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMinInput() {
        return this._netIpv4IpLocalPortRangeMin;
    }
    get netIpv4NeighDefaultGcThresh1() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh1');
    }
    set netIpv4NeighDefaultGcThresh1(value) {
        this._netIpv4NeighDefaultGcThresh1 = value;
    }
    resetNetIpv4NeighDefaultGcThresh1() {
        this._netIpv4NeighDefaultGcThresh1 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh1Input() {
        return this._netIpv4NeighDefaultGcThresh1;
    }
    get netIpv4NeighDefaultGcThresh2() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh2');
    }
    set netIpv4NeighDefaultGcThresh2(value) {
        this._netIpv4NeighDefaultGcThresh2 = value;
    }
    resetNetIpv4NeighDefaultGcThresh2() {
        this._netIpv4NeighDefaultGcThresh2 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh2Input() {
        return this._netIpv4NeighDefaultGcThresh2;
    }
    get netIpv4NeighDefaultGcThresh3() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh3');
    }
    set netIpv4NeighDefaultGcThresh3(value) {
        this._netIpv4NeighDefaultGcThresh3 = value;
    }
    resetNetIpv4NeighDefaultGcThresh3() {
        this._netIpv4NeighDefaultGcThresh3 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh3Input() {
        return this._netIpv4NeighDefaultGcThresh3;
    }
    get netIpv4TcpFinTimeout() {
        return this.getNumberAttribute('net_ipv4_tcp_fin_timeout');
    }
    set netIpv4TcpFinTimeout(value) {
        this._netIpv4TcpFinTimeout = value;
    }
    resetNetIpv4TcpFinTimeout() {
        this._netIpv4TcpFinTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpFinTimeoutInput() {
        return this._netIpv4TcpFinTimeout;
    }
    get netIpv4TcpKeepaliveIntvl() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_intvl');
    }
    set netIpv4TcpKeepaliveIntvl(value) {
        this._netIpv4TcpKeepaliveIntvl = value;
    }
    resetNetIpv4TcpKeepaliveIntvl() {
        this._netIpv4TcpKeepaliveIntvl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveIntvlInput() {
        return this._netIpv4TcpKeepaliveIntvl;
    }
    get netIpv4TcpKeepaliveProbes() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_probes');
    }
    set netIpv4TcpKeepaliveProbes(value) {
        this._netIpv4TcpKeepaliveProbes = value;
    }
    resetNetIpv4TcpKeepaliveProbes() {
        this._netIpv4TcpKeepaliveProbes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveProbesInput() {
        return this._netIpv4TcpKeepaliveProbes;
    }
    get netIpv4TcpKeepaliveTime() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_time');
    }
    set netIpv4TcpKeepaliveTime(value) {
        this._netIpv4TcpKeepaliveTime = value;
    }
    resetNetIpv4TcpKeepaliveTime() {
        this._netIpv4TcpKeepaliveTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveTimeInput() {
        return this._netIpv4TcpKeepaliveTime;
    }
    get netIpv4TcpMaxSynBacklog() {
        return this.getNumberAttribute('net_ipv4_tcp_max_syn_backlog');
    }
    set netIpv4TcpMaxSynBacklog(value) {
        this._netIpv4TcpMaxSynBacklog = value;
    }
    resetNetIpv4TcpMaxSynBacklog() {
        this._netIpv4TcpMaxSynBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxSynBacklogInput() {
        return this._netIpv4TcpMaxSynBacklog;
    }
    get netIpv4TcpMaxTwBuckets() {
        return this.getNumberAttribute('net_ipv4_tcp_max_tw_buckets');
    }
    set netIpv4TcpMaxTwBuckets(value) {
        this._netIpv4TcpMaxTwBuckets = value;
    }
    resetNetIpv4TcpMaxTwBuckets() {
        this._netIpv4TcpMaxTwBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxTwBucketsInput() {
        return this._netIpv4TcpMaxTwBuckets;
    }
    get netIpv4TcpTwReuse() {
        return this.getBooleanAttribute('net_ipv4_tcp_tw_reuse');
    }
    set netIpv4TcpTwReuse(value) {
        this._netIpv4TcpTwReuse = value;
    }
    resetNetIpv4TcpTwReuse() {
        this._netIpv4TcpTwReuse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpTwReuseInput() {
        return this._netIpv4TcpTwReuse;
    }
    get netNetfilterNfConntrackBuckets() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_buckets');
    }
    set netNetfilterNfConntrackBuckets(value) {
        this._netNetfilterNfConntrackBuckets = value;
    }
    resetNetNetfilterNfConntrackBuckets() {
        this._netNetfilterNfConntrackBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackBucketsInput() {
        return this._netNetfilterNfConntrackBuckets;
    }
    get netNetfilterNfConntrackMax() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_max');
    }
    set netNetfilterNfConntrackMax(value) {
        this._netNetfilterNfConntrackMax = value;
    }
    resetNetNetfilterNfConntrackMax() {
        this._netNetfilterNfConntrackMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackMaxInput() {
        return this._netNetfilterNfConntrackMax;
    }
    get vmMaxMapCount() {
        return this.getNumberAttribute('vm_max_map_count');
    }
    set vmMaxMapCount(value) {
        this._vmMaxMapCount = value;
    }
    resetVmMaxMapCount() {
        this._vmMaxMapCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmMaxMapCountInput() {
        return this._vmMaxMapCount;
    }
    get vmSwappiness() {
        return this.getNumberAttribute('vm_swappiness');
    }
    set vmSwappiness(value) {
        this._vmSwappiness = value;
    }
    resetVmSwappiness() {
        this._vmSwappiness = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmSwappinessInput() {
        return this._vmSwappiness;
    }
    get vmVfsCachePressure() {
        return this.getNumberAttribute('vm_vfs_cache_pressure');
    }
    set vmVfsCachePressure(value) {
        this._vmVfsCachePressure = value;
    }
    resetVmVfsCachePressure() {
        this._vmVfsCachePressure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmVfsCachePressureInput() {
        return this._vmVfsCachePressure;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference", version: "2.0.18" };
function kubernetesClusterNodePoolLinuxOsConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        swap_file_size_mb: cdktf.numberToTerraform(struct.swapFileSizeMb),
        transparent_huge_page_defrag: cdktf.stringToTerraform(struct.transparentHugePageDefrag),
        transparent_huge_page_enabled: cdktf.stringToTerraform(struct.transparentHugePageEnabled),
        sysctl_config: kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct.sysctlConfig),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // sysctl_config - computed: false, optional: true, required: false
        this._sysctlConfig = new KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference(this, "sysctl_config");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._swapFileSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.swapFileSizeMb = this._swapFileSizeMb;
        }
        if (this._transparentHugePageDefrag !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageDefrag = this._transparentHugePageDefrag;
        }
        if (this._transparentHugePageEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageEnabled = this._transparentHugePageEnabled;
        }
        if (this._sysctlConfig?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.sysctlConfig = this._sysctlConfig?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._swapFileSizeMb = undefined;
            this._transparentHugePageDefrag = undefined;
            this._transparentHugePageEnabled = undefined;
            this._sysctlConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._swapFileSizeMb = value.swapFileSizeMb;
            this._transparentHugePageDefrag = value.transparentHugePageDefrag;
            this._transparentHugePageEnabled = value.transparentHugePageEnabled;
            this._sysctlConfig.internalValue = value.sysctlConfig;
        }
    }
    get swapFileSizeMb() {
        return this.getNumberAttribute('swap_file_size_mb');
    }
    set swapFileSizeMb(value) {
        this._swapFileSizeMb = value;
    }
    resetSwapFileSizeMb() {
        this._swapFileSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapFileSizeMbInput() {
        return this._swapFileSizeMb;
    }
    get transparentHugePageDefrag() {
        return this.getStringAttribute('transparent_huge_page_defrag');
    }
    set transparentHugePageDefrag(value) {
        this._transparentHugePageDefrag = value;
    }
    resetTransparentHugePageDefrag() {
        this._transparentHugePageDefrag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageDefragInput() {
        return this._transparentHugePageDefrag;
    }
    get transparentHugePageEnabled() {
        return this.getStringAttribute('transparent_huge_page_enabled');
    }
    set transparentHugePageEnabled(value) {
        this._transparentHugePageEnabled = value;
    }
    resetTransparentHugePageEnabled() {
        this._transparentHugePageEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageEnabledInput() {
        return this._transparentHugePageEnabled;
    }
    get sysctlConfig() {
        return this._sysctlConfig;
    }
    putSysctlConfig(value) {
        this._sysctlConfig.internalValue = value;
    }
    resetSysctlConfig() {
        this._sysctlConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sysctlConfigInput() {
        return this._sysctlConfig.internalValue;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigOutputReference;
_c = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolLinuxOsConfigOutputReference", version: "2.0.18" };
function kubernetesClusterNodePoolTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.kubernetesClusterNodePoolTimeoutsToTerraform = kubernetesClusterNodePoolTimeoutsToTerraform;
class KubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.KubernetesClusterNodePoolTimeoutsOutputReference = KubernetesClusterNodePoolTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolTimeoutsOutputReference", version: "2.0.18" };
function kubernetesClusterNodePoolUpgradeSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_surge: cdktf.stringToTerraform(struct.maxSurge),
    };
}
exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = kubernetesClusterNodePoolUpgradeSettingsToTerraform;
class KubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxSurge !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxSurge = this._maxSurge;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maxSurge = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maxSurge = value.maxSurge;
        }
    }
    get maxSurge() {
        return this.getStringAttribute('max_surge');
    }
    set maxSurge(value) {
        this._maxSurge = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxSurgeInput() {
        return this._maxSurge;
    }
}
exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = KubernetesClusterNodePoolUpgradeSettingsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolUpgradeSettingsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolUpgradeSettingsOutputReference", version: "2.0.18" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}
*/
class KubernetesClusterNodePool extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterNodePoolConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_kubernetes_cluster_node_pool',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.24.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // kubelet_config - computed: false, optional: true, required: false
        this._kubeletConfig = new KubernetesClusterNodePoolKubeletConfigOutputReference(this, "kubelet_config");
        // linux_os_config - computed: false, optional: true, required: false
        this._linuxOsConfig = new KubernetesClusterNodePoolLinuxOsConfigOutputReference(this, "linux_os_config");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new KubernetesClusterNodePoolTimeoutsOutputReference(this, "timeouts");
        // upgrade_settings - computed: false, optional: true, required: false
        this._upgradeSettings = new KubernetesClusterNodePoolUpgradeSettingsOutputReference(this, "upgrade_settings");
        this._capacityReservationGroupId = config.capacityReservationGroupId;
        this._enableAutoScaling = config.enableAutoScaling;
        this._enableHostEncryption = config.enableHostEncryption;
        this._enableNodePublicIp = config.enableNodePublicIp;
        this._evictionPolicy = config.evictionPolicy;
        this._fipsEnabled = config.fipsEnabled;
        this._hostGroupId = config.hostGroupId;
        this._id = config.id;
        this._kubeletDiskType = config.kubeletDiskType;
        this._kubernetesClusterId = config.kubernetesClusterId;
        this._maxCount = config.maxCount;
        this._maxPods = config.maxPods;
        this._minCount = config.minCount;
        this._mode = config.mode;
        this._name = config.name;
        this._nodeCount = config.nodeCount;
        this._nodeLabels = config.nodeLabels;
        this._nodePublicIpPrefixId = config.nodePublicIpPrefixId;
        this._nodeTaints = config.nodeTaints;
        this._orchestratorVersion = config.orchestratorVersion;
        this._osDiskSizeGb = config.osDiskSizeGb;
        this._osDiskType = config.osDiskType;
        this._osSku = config.osSku;
        this._osType = config.osType;
        this._podSubnetId = config.podSubnetId;
        this._priority = config.priority;
        this._proximityPlacementGroupId = config.proximityPlacementGroupId;
        this._scaleDownMode = config.scaleDownMode;
        this._spotMaxPrice = config.spotMaxPrice;
        this._tags = config.tags;
        this._ultraSsdEnabled = config.ultraSsdEnabled;
        this._vmSize = config.vmSize;
        this._vnetSubnetId = config.vnetSubnetId;
        this._workloadRuntime = config.workloadRuntime;
        this._zones = config.zones;
        this._kubeletConfig.internalValue = config.kubeletConfig;
        this._linuxOsConfig.internalValue = config.linuxOsConfig;
        this._timeouts.internalValue = config.timeouts;
        this._upgradeSettings.internalValue = config.upgradeSettings;
    }
    get capacityReservationGroupId() {
        return this.getStringAttribute('capacity_reservation_group_id');
    }
    set capacityReservationGroupId(value) {
        this._capacityReservationGroupId = value;
    }
    resetCapacityReservationGroupId() {
        this._capacityReservationGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get capacityReservationGroupIdInput() {
        return this._capacityReservationGroupId;
    }
    get enableAutoScaling() {
        return this.getBooleanAttribute('enable_auto_scaling');
    }
    set enableAutoScaling(value) {
        this._enableAutoScaling = value;
    }
    resetEnableAutoScaling() {
        this._enableAutoScaling = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableAutoScalingInput() {
        return this._enableAutoScaling;
    }
    get enableHostEncryption() {
        return this.getBooleanAttribute('enable_host_encryption');
    }
    set enableHostEncryption(value) {
        this._enableHostEncryption = value;
    }
    resetEnableHostEncryption() {
        this._enableHostEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHostEncryptionInput() {
        return this._enableHostEncryption;
    }
    get enableNodePublicIp() {
        return this.getBooleanAttribute('enable_node_public_ip');
    }
    set enableNodePublicIp(value) {
        this._enableNodePublicIp = value;
    }
    resetEnableNodePublicIp() {
        this._enableNodePublicIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableNodePublicIpInput() {
        return this._enableNodePublicIp;
    }
    get evictionPolicy() {
        return this.getStringAttribute('eviction_policy');
    }
    set evictionPolicy(value) {
        this._evictionPolicy = value;
    }
    resetEvictionPolicy() {
        this._evictionPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evictionPolicyInput() {
        return this._evictionPolicy;
    }
    get fipsEnabled() {
        return this.getBooleanAttribute('fips_enabled');
    }
    set fipsEnabled(value) {
        this._fipsEnabled = value;
    }
    resetFipsEnabled() {
        this._fipsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fipsEnabledInput() {
        return this._fipsEnabled;
    }
    get hostGroupId() {
        return this.getStringAttribute('host_group_id');
    }
    set hostGroupId(value) {
        this._hostGroupId = value;
    }
    resetHostGroupId() {
        this._hostGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostGroupIdInput() {
        return this._hostGroupId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get kubeletDiskType() {
        return this.getStringAttribute('kubelet_disk_type');
    }
    set kubeletDiskType(value) {
        this._kubeletDiskType = value;
    }
    resetKubeletDiskType() {
        this._kubeletDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletDiskTypeInput() {
        return this._kubeletDiskType;
    }
    get kubernetesClusterId() {
        return this.getStringAttribute('kubernetes_cluster_id');
    }
    set kubernetesClusterId(value) {
        this._kubernetesClusterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesClusterIdInput() {
        return this._kubernetesClusterId;
    }
    get maxCount() {
        return this.getNumberAttribute('max_count');
    }
    set maxCount(value) {
        this._maxCount = value;
    }
    resetMaxCount() {
        this._maxCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxCountInput() {
        return this._maxCount;
    }
    get maxPods() {
        return this.getNumberAttribute('max_pods');
    }
    set maxPods(value) {
        this._maxPods = value;
    }
    resetMaxPods() {
        this._maxPods = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPodsInput() {
        return this._maxPods;
    }
    get minCount() {
        return this.getNumberAttribute('min_count');
    }
    set minCount(value) {
        this._minCount = value;
    }
    resetMinCount() {
        this._minCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minCountInput() {
        return this._minCount;
    }
    get mode() {
        return this.getStringAttribute('mode');
    }
    set mode(value) {
        this._mode = value;
    }
    resetMode() {
        this._mode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get modeInput() {
        return this._mode;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nodeCount() {
        return this.getNumberAttribute('node_count');
    }
    set nodeCount(value) {
        this._nodeCount = value;
    }
    resetNodeCount() {
        this._nodeCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeCountInput() {
        return this._nodeCount;
    }
    get nodeLabels() {
        return this.getStringMapAttribute('node_labels');
    }
    set nodeLabels(value) {
        this._nodeLabels = value;
    }
    resetNodeLabels() {
        this._nodeLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeLabelsInput() {
        return this._nodeLabels;
    }
    get nodePublicIpPrefixId() {
        return this.getStringAttribute('node_public_ip_prefix_id');
    }
    set nodePublicIpPrefixId(value) {
        this._nodePublicIpPrefixId = value;
    }
    resetNodePublicIpPrefixId() {
        this._nodePublicIpPrefixId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePublicIpPrefixIdInput() {
        return this._nodePublicIpPrefixId;
    }
    get nodeTaints() {
        return this.getListAttribute('node_taints');
    }
    set nodeTaints(value) {
        this._nodeTaints = value;
    }
    resetNodeTaints() {
        this._nodeTaints = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeTaintsInput() {
        return this._nodeTaints;
    }
    get orchestratorVersion() {
        return this.getStringAttribute('orchestrator_version');
    }
    set orchestratorVersion(value) {
        this._orchestratorVersion = value;
    }
    resetOrchestratorVersion() {
        this._orchestratorVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orchestratorVersionInput() {
        return this._orchestratorVersion;
    }
    get osDiskSizeGb() {
        return this.getNumberAttribute('os_disk_size_gb');
    }
    set osDiskSizeGb(value) {
        this._osDiskSizeGb = value;
    }
    resetOsDiskSizeGb() {
        this._osDiskSizeGb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskSizeGbInput() {
        return this._osDiskSizeGb;
    }
    get osDiskType() {
        return this.getStringAttribute('os_disk_type');
    }
    set osDiskType(value) {
        this._osDiskType = value;
    }
    resetOsDiskType() {
        this._osDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskTypeInput() {
        return this._osDiskType;
    }
    get osSku() {
        return this.getStringAttribute('os_sku');
    }
    set osSku(value) {
        this._osSku = value;
    }
    resetOsSku() {
        this._osSku = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osSkuInput() {
        return this._osSku;
    }
    get osType() {
        return this.getStringAttribute('os_type');
    }
    set osType(value) {
        this._osType = value;
    }
    resetOsType() {
        this._osType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osTypeInput() {
        return this._osType;
    }
    get podSubnetId() {
        return this.getStringAttribute('pod_subnet_id');
    }
    set podSubnetId(value) {
        this._podSubnetId = value;
    }
    resetPodSubnetId() {
        this._podSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podSubnetIdInput() {
        return this._podSubnetId;
    }
    get priority() {
        return this.getStringAttribute('priority');
    }
    set priority(value) {
        this._priority = value;
    }
    resetPriority() {
        this._priority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get priorityInput() {
        return this._priority;
    }
    get proximityPlacementGroupId() {
        return this.getStringAttribute('proximity_placement_group_id');
    }
    set proximityPlacementGroupId(value) {
        this._proximityPlacementGroupId = value;
    }
    resetProximityPlacementGroupId() {
        this._proximityPlacementGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proximityPlacementGroupIdInput() {
        return this._proximityPlacementGroupId;
    }
    get scaleDownMode() {
        return this.getStringAttribute('scale_down_mode');
    }
    set scaleDownMode(value) {
        this._scaleDownMode = value;
    }
    resetScaleDownMode() {
        this._scaleDownMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scaleDownModeInput() {
        return this._scaleDownMode;
    }
    get spotMaxPrice() {
        return this.getNumberAttribute('spot_max_price');
    }
    set spotMaxPrice(value) {
        this._spotMaxPrice = value;
    }
    resetSpotMaxPrice() {
        this._spotMaxPrice = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spotMaxPriceInput() {
        return this._spotMaxPrice;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get ultraSsdEnabled() {
        return this.getBooleanAttribute('ultra_ssd_enabled');
    }
    set ultraSsdEnabled(value) {
        this._ultraSsdEnabled = value;
    }
    resetUltraSsdEnabled() {
        this._ultraSsdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ultraSsdEnabledInput() {
        return this._ultraSsdEnabled;
    }
    get vmSize() {
        return this.getStringAttribute('vm_size');
    }
    set vmSize(value) {
        this._vmSize = value;
    }
    // Temporarily expose input value. Use with caution.
    get vmSizeInput() {
        return this._vmSize;
    }
    get vnetSubnetId() {
        return this.getStringAttribute('vnet_subnet_id');
    }
    set vnetSubnetId(value) {
        this._vnetSubnetId = value;
    }
    resetVnetSubnetId() {
        this._vnetSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vnetSubnetIdInput() {
        return this._vnetSubnetId;
    }
    get workloadRuntime() {
        return this.getStringAttribute('workload_runtime');
    }
    set workloadRuntime(value) {
        this._workloadRuntime = value;
    }
    resetWorkloadRuntime() {
        this._workloadRuntime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workloadRuntimeInput() {
        return this._workloadRuntime;
    }
    get zones() {
        return cdktf.Fn.tolist(this.getListAttribute('zones'));
    }
    set zones(value) {
        this._zones = value;
    }
    resetZones() {
        this._zones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zonesInput() {
        return this._zones;
    }
    get kubeletConfig() {
        return this._kubeletConfig;
    }
    putKubeletConfig(value) {
        this._kubeletConfig.internalValue = value;
    }
    resetKubeletConfig() {
        this._kubeletConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletConfigInput() {
        return this._kubeletConfig.internalValue;
    }
    get linuxOsConfig() {
        return this._linuxOsConfig;
    }
    putLinuxOsConfig(value) {
        this._linuxOsConfig.internalValue = value;
    }
    resetLinuxOsConfig() {
        this._linuxOsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linuxOsConfigInput() {
        return this._linuxOsConfig.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get upgradeSettings() {
        return this._upgradeSettings;
    }
    putUpgradeSettings(value) {
        this._upgradeSettings.internalValue = value;
    }
    resetUpgradeSettings() {
        this._upgradeSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upgradeSettingsInput() {
        return this._upgradeSettings.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            capacity_reservation_group_id: cdktf.stringToTerraform(this._capacityReservationGroupId),
            enable_auto_scaling: cdktf.booleanToTerraform(this._enableAutoScaling),
            enable_host_encryption: cdktf.booleanToTerraform(this._enableHostEncryption),
            enable_node_public_ip: cdktf.booleanToTerraform(this._enableNodePublicIp),
            eviction_policy: cdktf.stringToTerraform(this._evictionPolicy),
            fips_enabled: cdktf.booleanToTerraform(this._fipsEnabled),
            host_group_id: cdktf.stringToTerraform(this._hostGroupId),
            id: cdktf.stringToTerraform(this._id),
            kubelet_disk_type: cdktf.stringToTerraform(this._kubeletDiskType),
            kubernetes_cluster_id: cdktf.stringToTerraform(this._kubernetesClusterId),
            max_count: cdktf.numberToTerraform(this._maxCount),
            max_pods: cdktf.numberToTerraform(this._maxPods),
            min_count: cdktf.numberToTerraform(this._minCount),
            mode: cdktf.stringToTerraform(this._mode),
            name: cdktf.stringToTerraform(this._name),
            node_count: cdktf.numberToTerraform(this._nodeCount),
            node_labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._nodeLabels),
            node_public_ip_prefix_id: cdktf.stringToTerraform(this._nodePublicIpPrefixId),
            node_taints: cdktf.listMapper(cdktf.stringToTerraform, false)(this._nodeTaints),
            orchestrator_version: cdktf.stringToTerraform(this._orchestratorVersion),
            os_disk_size_gb: cdktf.numberToTerraform(this._osDiskSizeGb),
            os_disk_type: cdktf.stringToTerraform(this._osDiskType),
            os_sku: cdktf.stringToTerraform(this._osSku),
            os_type: cdktf.stringToTerraform(this._osType),
            pod_subnet_id: cdktf.stringToTerraform(this._podSubnetId),
            priority: cdktf.stringToTerraform(this._priority),
            proximity_placement_group_id: cdktf.stringToTerraform(this._proximityPlacementGroupId),
            scale_down_mode: cdktf.stringToTerraform(this._scaleDownMode),
            spot_max_price: cdktf.numberToTerraform(this._spotMaxPrice),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            ultra_ssd_enabled: cdktf.booleanToTerraform(this._ultraSsdEnabled),
            vm_size: cdktf.stringToTerraform(this._vmSize),
            vnet_subnet_id: cdktf.stringToTerraform(this._vnetSubnetId),
            workload_runtime: cdktf.stringToTerraform(this._workloadRuntime),
            zones: cdktf.listMapper(cdktf.stringToTerraform, false)(this._zones),
            kubelet_config: kubernetesClusterNodePoolKubeletConfigToTerraform(this._kubeletConfig.internalValue),
            linux_os_config: kubernetesClusterNodePoolLinuxOsConfigToTerraform(this._linuxOsConfig.internalValue),
            timeouts: kubernetesClusterNodePoolTimeoutsToTerraform(this._timeouts.internalValue),
            upgrade_settings: kubernetesClusterNodePoolUpgradeSettingsToTerraform(this._upgradeSettings.internalValue),
        };
    }
}
exports.KubernetesClusterNodePool = KubernetesClusterNodePool;
_f = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePool[_f] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePool", version: "2.0.18" };
// =================
// STATIC PROPERTIES
// =================
KubernetesClusterNodePool.tfResourceType = "azurerm_kubernetes_cluster_node_pool";
//# sourceMappingURL=data:application/json;base64,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