import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LinuxWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#app_settings LinuxWebApp#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_affinity_enabled LinuxWebApp#client_affinity_enabled}
    */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_certificate_enabled LinuxWebApp#client_certificate_enabled}
    */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_certificate_mode LinuxWebApp#client_certificate_mode}
    */
    readonly clientCertificateMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#enabled LinuxWebApp#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#https_only LinuxWebApp#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#id LinuxWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#key_vault_reference_identity_id LinuxWebApp#key_vault_reference_identity_id}
    */
    readonly keyVaultReferenceIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#location LinuxWebApp#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#name LinuxWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#resource_group_name LinuxWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#service_plan_id LinuxWebApp#service_plan_id}
    */
    readonly servicePlanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#tags LinuxWebApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#virtual_network_subnet_id LinuxWebApp#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
    /**
    * The local path and filename of the Zip packaged application to deploy to this Windows Web App. **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` on the App in `app_settings`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#zip_deploy_file LinuxWebApp#zip_deploy_file}
    */
    readonly zipDeployFile?: string;
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#auth_settings LinuxWebApp#auth_settings}
    */
    readonly authSettings?: LinuxWebAppAuthSettings;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#backup LinuxWebApp#backup}
    */
    readonly backup?: LinuxWebAppBackup;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#connection_string LinuxWebApp#connection_string}
    */
    readonly connectionString?: LinuxWebAppConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#identity LinuxWebApp#identity}
    */
    readonly identity?: LinuxWebAppIdentity;
    /**
    * logs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#logs LinuxWebApp#logs}
    */
    readonly logs?: LinuxWebAppLogs;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#site_config LinuxWebApp#site_config}
    */
    readonly siteConfig: LinuxWebAppSiteConfig;
    /**
    * sticky_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#sticky_settings LinuxWebApp#sticky_settings}
    */
    readonly stickySettings?: LinuxWebAppStickySettings;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#storage_account LinuxWebApp#storage_account}
    */
    readonly storageAccount?: LinuxWebAppStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#timeouts LinuxWebApp#timeouts}
    */
    readonly timeouts?: LinuxWebAppTimeouts;
}
export interface LinuxWebAppSiteCredential {
}
export declare function linuxWebAppSiteCredentialToTerraform(struct?: LinuxWebAppSiteCredential): any;
export declare class LinuxWebAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSiteCredential | undefined;
    set internalValue(value: LinuxWebAppSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class LinuxWebAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSiteCredentialOutputReference;
}
export interface LinuxWebAppAuthSettingsActiveDirectory {
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#allowed_audiences LinuxWebApp#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_id LinuxWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret for the Client ID. Cannot be used with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret LinuxWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The App Setting name that contains the client secret of the Client. Cannot be used with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret_setting_name LinuxWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
}
export declare function linuxWebAppAuthSettingsActiveDirectoryToTerraform(struct?: LinuxWebAppAuthSettingsActiveDirectoryOutputReference | LinuxWebAppAuthSettingsActiveDirectory): any;
export declare class LinuxWebAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppAuthSettingsActiveDirectory | undefined;
    set internalValue(value: LinuxWebAppAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
}
export interface LinuxWebAppAuthSettingsFacebook {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#app_id LinuxWebApp#app_id}
    */
    readonly appId: string;
    /**
    * The App Secret of the Facebook app used for Facebook Login. Cannot be specified with `app_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#app_secret LinuxWebApp#app_secret}
    */
    readonly appSecret?: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login. Cannot be specified with `app_secret`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#app_secret_setting_name LinuxWebApp#app_secret_setting_name}
    */
    readonly appSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#oauth_scopes LinuxWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppAuthSettingsFacebookToTerraform(struct?: LinuxWebAppAuthSettingsFacebookOutputReference | LinuxWebAppAuthSettingsFacebook): any;
export declare class LinuxWebAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppAuthSettingsFacebook | undefined;
    set internalValue(value: LinuxWebAppAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    resetAppSecret(): void;
    get appSecretInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    resetAppSecretSettingName(): void;
    get appSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppAuthSettingsGithub {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_id LinuxWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret of the GitHub app used for GitHub Login. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret LinuxWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret_setting_name LinuxWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#oauth_scopes LinuxWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppAuthSettingsGithubToTerraform(struct?: LinuxWebAppAuthSettingsGithubOutputReference | LinuxWebAppAuthSettingsGithub): any;
export declare class LinuxWebAppAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppAuthSettingsGithub | undefined;
    set internalValue(value: LinuxWebAppAuthSettingsGithub | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppAuthSettingsGoogle {
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_id LinuxWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret associated with the Google web application.  Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret LinuxWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret_setting_name LinuxWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. If not specified, "openid", "profile", and "email" are used as default scopes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#oauth_scopes LinuxWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppAuthSettingsGoogleToTerraform(struct?: LinuxWebAppAuthSettingsGoogleOutputReference | LinuxWebAppAuthSettingsGoogle): any;
export declare class LinuxWebAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppAuthSettingsGoogle | undefined;
    set internalValue(value: LinuxWebAppAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppAuthSettingsMicrosoft {
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_id LinuxWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret LinuxWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#client_secret_setting_name LinuxWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * The list of OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. If not specified, `wl.basic` is used as the default scope.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#oauth_scopes LinuxWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppAuthSettingsMicrosoftToTerraform(struct?: LinuxWebAppAuthSettingsMicrosoftOutputReference | LinuxWebAppAuthSettingsMicrosoft): any;
export declare class LinuxWebAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppAuthSettingsMicrosoft | undefined;
    set internalValue(value: LinuxWebAppAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppAuthSettingsTwitter {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#consumer_key LinuxWebApp#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#consumer_secret LinuxWebApp#consumer_secret}
    */
    readonly consumerSecret?: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#consumer_secret_setting_name LinuxWebApp#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName?: string;
}
export declare function linuxWebAppAuthSettingsTwitterToTerraform(struct?: LinuxWebAppAuthSettingsTwitterOutputReference | LinuxWebAppAuthSettingsTwitter): any;
export declare class LinuxWebAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppAuthSettingsTwitter | undefined;
    set internalValue(value: LinuxWebAppAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    resetConsumerSecret(): void;
    get consumerSecretInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    resetConsumerSecretSettingName(): void;
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface LinuxWebAppAuthSettings {
    /**
    * Specifies a map of Login Parameters to send to the OpenID Connect authorization endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#additional_login_parameters LinuxWebApp#additional_login_parameters}
    */
    readonly additionalLoginParameters?: {
        [key: string]: string;
    };
    /**
    * Specifies a list of External URLs that can be redirected to as part of logging in or logging out of the Windows Web App.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#allowed_external_redirect_urls LinuxWebApp#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The default authentication provider to use when multiple providers are configured. Possible values include: `AzureActiveDirectory`, `Facebook`, `Google`, `MicrosoftAccount`, `Twitter`, `Github`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#default_provider LinuxWebApp#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Should the Authentication / Authorization feature be enabled?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#enabled LinuxWebApp#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The OpenID Connect Issuer URI that represents the entity which issues access tokens.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#issuer LinuxWebApp#issuer}
    */
    readonly issuer?: string;
    /**
    * The RuntimeVersion of the Authentication / Authorization feature in use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#runtime_version LinuxWebApp#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#token_refresh_extension_hours LinuxWebApp#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Should the Windows Web App durably store platform-specific security tokens that are obtained during login flows? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#token_store_enabled LinuxWebApp#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The action to take when an unauthenticated client attempts to access the app. Possible values include: `RedirectToLoginPage`, `AllowAnonymous`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#unauthenticated_client_action LinuxWebApp#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#active_directory LinuxWebApp#active_directory}
    */
    readonly activeDirectory?: LinuxWebAppAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#facebook LinuxWebApp#facebook}
    */
    readonly facebook?: LinuxWebAppAuthSettingsFacebook;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#github LinuxWebApp#github}
    */
    readonly github?: LinuxWebAppAuthSettingsGithub;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#google LinuxWebApp#google}
    */
    readonly google?: LinuxWebAppAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#microsoft LinuxWebApp#microsoft}
    */
    readonly microsoft?: LinuxWebAppAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#twitter LinuxWebApp#twitter}
    */
    readonly twitter?: LinuxWebAppAuthSettingsTwitter;
}
export declare function linuxWebAppAuthSettingsToTerraform(struct?: LinuxWebAppAuthSettingsOutputReference | LinuxWebAppAuthSettings): any;
export declare class LinuxWebAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppAuthSettings | undefined;
    set internalValue(value: LinuxWebAppAuthSettings | undefined);
    private _additionalLoginParameters?;
    get additionalLoginParameters(): {
        [key: string]: string;
    };
    set additionalLoginParameters(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParameters(): void;
    get additionalLoginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): LinuxWebAppAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: LinuxWebAppAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): LinuxWebAppAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): LinuxWebAppAuthSettingsFacebookOutputReference;
    putFacebook(value: LinuxWebAppAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): LinuxWebAppAuthSettingsFacebook | undefined;
    private _github;
    get github(): LinuxWebAppAuthSettingsGithubOutputReference;
    putGithub(value: LinuxWebAppAuthSettingsGithub): void;
    resetGithub(): void;
    get githubInput(): LinuxWebAppAuthSettingsGithub | undefined;
    private _google;
    get google(): LinuxWebAppAuthSettingsGoogleOutputReference;
    putGoogle(value: LinuxWebAppAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): LinuxWebAppAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): LinuxWebAppAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: LinuxWebAppAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): LinuxWebAppAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): LinuxWebAppAuthSettingsTwitterOutputReference;
    putTwitter(value: LinuxWebAppAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): LinuxWebAppAuthSettingsTwitter | undefined;
}
export interface LinuxWebAppBackupSchedule {
    /**
    * How often the backup should be executed (e.g. for weekly backup, this should be set to `7` and `frequency_unit` should be set to `Day`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#frequency_interval LinuxWebApp#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * The unit of time for how often the backup should take place. Possible values include: `Day` and `Hour`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#frequency_unit LinuxWebApp#frequency_unit}
    */
    readonly frequencyUnit: string;
    /**
    * Should the service keep at least one backup, regardless of age of backup. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#keep_at_least_one_backup LinuxWebApp#keep_at_least_one_backup}
    */
    readonly keepAtLeastOneBackup?: boolean | cdktf.IResolvable;
    /**
    * After how many days backups should be deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#retention_period_days LinuxWebApp#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
    /**
    * When the schedule should start working in RFC-3339 format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#start_time LinuxWebApp#start_time}
    */
    readonly startTime?: string;
}
export declare function linuxWebAppBackupScheduleToTerraform(struct?: LinuxWebAppBackupScheduleOutputReference | LinuxWebAppBackupSchedule): any;
export declare class LinuxWebAppBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppBackupSchedule | undefined;
    set internalValue(value: LinuxWebAppBackupSchedule | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    private _frequencyUnit?;
    get frequencyUnit(): string;
    set frequencyUnit(value: string);
    get frequencyUnitInput(): string | undefined;
    private _keepAtLeastOneBackup?;
    get keepAtLeastOneBackup(): boolean | cdktf.IResolvable;
    set keepAtLeastOneBackup(value: boolean | cdktf.IResolvable);
    resetKeepAtLeastOneBackup(): void;
    get keepAtLeastOneBackupInput(): boolean | cdktf.IResolvable | undefined;
    get lastExecutionTime(): string;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface LinuxWebAppBackup {
    /**
    * Should this backup job be enabled?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#enabled LinuxWebApp#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name which should be used for this Backup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#name LinuxWebApp#name}
    */
    readonly name: string;
    /**
    * The SAS URL to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#storage_account_url LinuxWebApp#storage_account_url}
    */
    readonly storageAccountUrl: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#schedule LinuxWebApp#schedule}
    */
    readonly schedule: LinuxWebAppBackupSchedule;
}
export declare function linuxWebAppBackupToTerraform(struct?: LinuxWebAppBackupOutputReference | LinuxWebAppBackup): any;
export declare class LinuxWebAppBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppBackup | undefined;
    set internalValue(value: LinuxWebAppBackup | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountUrl?;
    get storageAccountUrl(): string;
    set storageAccountUrl(value: string);
    get storageAccountUrlInput(): string | undefined;
    private _schedule;
    get schedule(): LinuxWebAppBackupScheduleOutputReference;
    putSchedule(value: LinuxWebAppBackupSchedule): void;
    get scheduleInput(): LinuxWebAppBackupSchedule | undefined;
}
export interface LinuxWebAppConnectionString {
    /**
    * The name which should be used for this Connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#name LinuxWebApp#name}
    */
    readonly name: string;
    /**
    * Type of database. Possible values include: `MySQL`, `SQLServer`, `SQLAzure`, `Custom`, `NotificationHub`, `ServiceBus`, `EventHub`, `APIHub`, `DocDb`, `RedisCache`, and `PostgreSQL`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#type LinuxWebApp#type}
    */
    readonly type: string;
    /**
    * The connection string value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#value LinuxWebApp#value}
    */
    readonly value: string;
}
export declare function linuxWebAppConnectionStringToTerraform(struct?: LinuxWebAppConnectionString | cdktf.IResolvable): any;
export declare class LinuxWebAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LinuxWebAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppConnectionStringOutputReference;
}
export interface LinuxWebAppIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#identity_ids LinuxWebApp#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#type LinuxWebApp#type}
    */
    readonly type: string;
}
export declare function linuxWebAppIdentityToTerraform(struct?: LinuxWebAppIdentityOutputReference | LinuxWebAppIdentity): any;
export declare class LinuxWebAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppIdentity | undefined;
    set internalValue(value: LinuxWebAppIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface LinuxWebAppLogsApplicationLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#level LinuxWebApp#level}
    */
    readonly level: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#retention_in_days LinuxWebApp#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#sas_url LinuxWebApp#sas_url}
    */
    readonly sasUrl: string;
}
export declare function linuxWebAppLogsApplicationLogsAzureBlobStorageToTerraform(struct?: LinuxWebAppLogsApplicationLogsAzureBlobStorageOutputReference | LinuxWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare class LinuxWebAppLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: LinuxWebAppLogsApplicationLogsAzureBlobStorage | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    get levelInput(): string | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface LinuxWebAppLogsApplicationLogs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#file_system_level LinuxWebApp#file_system_level}
    */
    readonly fileSystemLevel: string;
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#azure_blob_storage LinuxWebApp#azure_blob_storage}
    */
    readonly azureBlobStorage?: LinuxWebAppLogsApplicationLogsAzureBlobStorage;
}
export declare function linuxWebAppLogsApplicationLogsToTerraform(struct?: LinuxWebAppLogsApplicationLogsOutputReference | LinuxWebAppLogsApplicationLogs): any;
export declare class LinuxWebAppLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppLogsApplicationLogs | undefined;
    set internalValue(value: LinuxWebAppLogsApplicationLogs | undefined);
    private _fileSystemLevel?;
    get fileSystemLevel(): string;
    set fileSystemLevel(value: string);
    get fileSystemLevelInput(): string | undefined;
    private _azureBlobStorage;
    get azureBlobStorage(): LinuxWebAppLogsApplicationLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: LinuxWebAppLogsApplicationLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): LinuxWebAppLogsApplicationLogsAzureBlobStorage | undefined;
}
export interface LinuxWebAppLogsHttpLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#retention_in_days LinuxWebApp#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#sas_url LinuxWebApp#sas_url}
    */
    readonly sasUrl: string;
}
export declare function linuxWebAppLogsHttpLogsAzureBlobStorageToTerraform(struct?: LinuxWebAppLogsHttpLogsAzureBlobStorageOutputReference | LinuxWebAppLogsHttpLogsAzureBlobStorage): any;
export declare class LinuxWebAppLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: LinuxWebAppLogsHttpLogsAzureBlobStorage | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface LinuxWebAppLogsHttpLogsFileSystem {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#retention_in_days LinuxWebApp#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#retention_in_mb LinuxWebApp#retention_in_mb}
    */
    readonly retentionInMb: number;
}
export declare function linuxWebAppLogsHttpLogsFileSystemToTerraform(struct?: LinuxWebAppLogsHttpLogsFileSystemOutputReference | LinuxWebAppLogsHttpLogsFileSystem): any;
export declare class LinuxWebAppLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppLogsHttpLogsFileSystem | undefined;
    set internalValue(value: LinuxWebAppLogsHttpLogsFileSystem | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _retentionInMb?;
    get retentionInMb(): number;
    set retentionInMb(value: number);
    get retentionInMbInput(): number | undefined;
}
export interface LinuxWebAppLogsHttpLogs {
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#azure_blob_storage LinuxWebApp#azure_blob_storage}
    */
    readonly azureBlobStorage?: LinuxWebAppLogsHttpLogsAzureBlobStorage;
    /**
    * file_system block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#file_system LinuxWebApp#file_system}
    */
    readonly fileSystem?: LinuxWebAppLogsHttpLogsFileSystem;
}
export declare function linuxWebAppLogsHttpLogsToTerraform(struct?: LinuxWebAppLogsHttpLogsOutputReference | LinuxWebAppLogsHttpLogs): any;
export declare class LinuxWebAppLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppLogsHttpLogs | undefined;
    set internalValue(value: LinuxWebAppLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): LinuxWebAppLogsHttpLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: LinuxWebAppLogsHttpLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): LinuxWebAppLogsHttpLogsAzureBlobStorage | undefined;
    private _fileSystem;
    get fileSystem(): LinuxWebAppLogsHttpLogsFileSystemOutputReference;
    putFileSystem(value: LinuxWebAppLogsHttpLogsFileSystem): void;
    resetFileSystem(): void;
    get fileSystemInput(): LinuxWebAppLogsHttpLogsFileSystem | undefined;
}
export interface LinuxWebAppLogs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#detailed_error_messages LinuxWebApp#detailed_error_messages}
    */
    readonly detailedErrorMessages?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#failed_request_tracing LinuxWebApp#failed_request_tracing}
    */
    readonly failedRequestTracing?: boolean | cdktf.IResolvable;
    /**
    * application_logs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#application_logs LinuxWebApp#application_logs}
    */
    readonly applicationLogs?: LinuxWebAppLogsApplicationLogs;
    /**
    * http_logs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#http_logs LinuxWebApp#http_logs}
    */
    readonly httpLogs?: LinuxWebAppLogsHttpLogs;
}
export declare function linuxWebAppLogsToTerraform(struct?: LinuxWebAppLogsOutputReference | LinuxWebAppLogs): any;
export declare class LinuxWebAppLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppLogs | undefined;
    set internalValue(value: LinuxWebAppLogs | undefined);
    private _detailedErrorMessages?;
    get detailedErrorMessages(): boolean | cdktf.IResolvable;
    set detailedErrorMessages(value: boolean | cdktf.IResolvable);
    resetDetailedErrorMessages(): void;
    get detailedErrorMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _failedRequestTracing?;
    get failedRequestTracing(): boolean | cdktf.IResolvable;
    set failedRequestTracing(value: boolean | cdktf.IResolvable);
    resetFailedRequestTracing(): void;
    get failedRequestTracingInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLogs;
    get applicationLogs(): LinuxWebAppLogsApplicationLogsOutputReference;
    putApplicationLogs(value: LinuxWebAppLogsApplicationLogs): void;
    resetApplicationLogs(): void;
    get applicationLogsInput(): LinuxWebAppLogsApplicationLogs | undefined;
    private _httpLogs;
    get httpLogs(): LinuxWebAppLogsHttpLogsOutputReference;
    putHttpLogs(value: LinuxWebAppLogsHttpLogs): void;
    resetHttpLogs(): void;
    get httpLogsInput(): LinuxWebAppLogsHttpLogs | undefined;
}
export interface LinuxWebAppSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_azure_fdid LinuxWebApp#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_fd_health_probe LinuxWebApp#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_forwarded_for LinuxWebApp#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_forwarded_host LinuxWebApp#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function linuxWebAppSiteConfigIpRestrictionHeadersToTerraform(struct?: LinuxWebAppSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class LinuxWebAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class LinuxWebAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface LinuxWebAppSiteConfigIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#action LinuxWebApp#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#headers LinuxWebApp#headers}
    */
    readonly headers?: LinuxWebAppSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#ip_address LinuxWebApp#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#name LinuxWebApp#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#priority LinuxWebApp#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#service_tag LinuxWebApp#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#virtual_network_subnet_id LinuxWebApp#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function linuxWebAppSiteConfigIpRestrictionToTerraform(struct?: LinuxWebAppSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class LinuxWebAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): LinuxWebAppSiteConfigIpRestrictionHeadersList;
    putHeaders(value: LinuxWebAppSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | LinuxWebAppSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class LinuxWebAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSiteConfigIpRestrictionOutputReference;
}
export interface LinuxWebAppSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_azure_fdid LinuxWebApp#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_fd_health_probe LinuxWebApp#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_forwarded_for LinuxWebApp#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#x_forwarded_host LinuxWebApp#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function linuxWebAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: LinuxWebAppSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class LinuxWebAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class LinuxWebAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface LinuxWebAppSiteConfigScmIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#action LinuxWebApp#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#headers LinuxWebApp#headers}
    */
    readonly headers?: LinuxWebAppSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#ip_address LinuxWebApp#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#name LinuxWebApp#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#priority LinuxWebApp#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#service_tag LinuxWebApp#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#virtual_network_subnet_id LinuxWebApp#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function linuxWebAppSiteConfigScmIpRestrictionToTerraform(struct?: LinuxWebAppSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class LinuxWebAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): LinuxWebAppSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: LinuxWebAppSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | LinuxWebAppSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class LinuxWebAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSiteConfigScmIpRestrictionOutputReference;
}
export interface LinuxWebAppSiteConfigApplicationStack {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#docker_image LinuxWebApp#docker_image}
    */
    readonly dockerImage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#docker_image_tag LinuxWebApp#docker_image_tag}
    */
    readonly dockerImageTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#dotnet_version LinuxWebApp#dotnet_version}
    */
    readonly dotnetVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#java_server LinuxWebApp#java_server}
    */
    readonly javaServer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#java_server_version LinuxWebApp#java_server_version}
    */
    readonly javaServerVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#java_version LinuxWebApp#java_version}
    */
    readonly javaVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#node_version LinuxWebApp#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#php_version LinuxWebApp#php_version}
    */
    readonly phpVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#python_version LinuxWebApp#python_version}
    */
    readonly pythonVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#ruby_version LinuxWebApp#ruby_version}
    */
    readonly rubyVersion?: string;
}
export declare function linuxWebAppSiteConfigApplicationStackToTerraform(struct?: LinuxWebAppSiteConfigApplicationStackOutputReference | LinuxWebAppSiteConfigApplicationStack): any;
export declare class LinuxWebAppSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfigApplicationStack | undefined;
    set internalValue(value: LinuxWebAppSiteConfigApplicationStack | undefined);
    private _dockerImage?;
    get dockerImage(): string;
    set dockerImage(value: string);
    resetDockerImage(): void;
    get dockerImageInput(): string | undefined;
    private _dockerImageTag?;
    get dockerImageTag(): string;
    set dockerImageTag(value: string);
    resetDockerImageTag(): void;
    get dockerImageTagInput(): string | undefined;
    private _dotnetVersion?;
    get dotnetVersion(): string;
    set dotnetVersion(value: string);
    resetDotnetVersion(): void;
    get dotnetVersionInput(): string | undefined;
    private _javaServer?;
    get javaServer(): string;
    set javaServer(value: string);
    resetJavaServer(): void;
    get javaServerInput(): string | undefined;
    private _javaServerVersion?;
    get javaServerVersion(): string;
    set javaServerVersion(value: string);
    resetJavaServerVersion(): void;
    get javaServerVersionInput(): string | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    private _phpVersion?;
    get phpVersion(): string;
    set phpVersion(value: string);
    resetPhpVersion(): void;
    get phpVersionInput(): string | undefined;
    private _pythonVersion?;
    get pythonVersion(): string;
    set pythonVersion(value: string);
    resetPythonVersion(): void;
    get pythonVersionInput(): string | undefined;
    private _rubyVersion?;
    get rubyVersion(): string;
    set rubyVersion(value: string);
    resetRubyVersion(): void;
    get rubyVersionInput(): string | undefined;
}
export interface LinuxWebAppSiteConfigAutoHealSettingAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#action_type LinuxWebApp#action_type}
    */
    readonly actionType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#minimum_process_execution_time LinuxWebApp#minimum_process_execution_time}
    */
    readonly minimumProcessExecutionTime?: string;
}
export declare function linuxWebAppSiteConfigAutoHealSettingActionToTerraform(struct?: LinuxWebAppSiteConfigAutoHealSettingActionOutputReference | LinuxWebAppSiteConfigAutoHealSettingAction): any;
export declare class LinuxWebAppSiteConfigAutoHealSettingActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfigAutoHealSettingAction | undefined;
    set internalValue(value: LinuxWebAppSiteConfigAutoHealSettingAction | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
    private _minimumProcessExecutionTime?;
    get minimumProcessExecutionTime(): string;
    set minimumProcessExecutionTime(value: string);
    resetMinimumProcessExecutionTime(): void;
    get minimumProcessExecutionTimeInput(): string | undefined;
}
export interface LinuxWebAppSiteConfigAutoHealSettingTriggerRequests {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#count LinuxWebApp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#interval LinuxWebApp#interval}
    */
    readonly interval: string;
}
export declare function linuxWebAppSiteConfigAutoHealSettingTriggerRequestsToTerraform(struct?: LinuxWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference | LinuxWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare class LinuxWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfigAutoHealSettingTriggerRequests | undefined;
    set internalValue(value: LinuxWebAppSiteConfigAutoHealSettingTriggerRequests | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
}
export interface LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#count LinuxWebApp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#interval LinuxWebApp#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#path LinuxWebApp#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#time_taken LinuxWebApp#time_taken}
    */
    readonly timeTaken: string;
}
export declare function linuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestToTerraform(struct?: LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference | LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare class LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    set internalValue(value: LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _timeTaken?;
    get timeTaken(): string;
    set timeTaken(value: string);
    get timeTakenInput(): string | undefined;
}
export interface LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#count LinuxWebApp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#interval LinuxWebApp#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#path LinuxWebApp#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#status_code_range LinuxWebApp#status_code_range}
    */
    readonly statusCodeRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#sub_status LinuxWebApp#sub_status}
    */
    readonly subStatus?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#win32_status LinuxWebApp#win32_status}
    */
    readonly win32Status?: string;
}
export declare function linuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeToTerraform(struct?: LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable): any;
export declare class LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _statusCodeRange?;
    get statusCodeRange(): string;
    set statusCodeRange(value: string);
    get statusCodeRangeInput(): string | undefined;
    private _subStatus?;
    get subStatus(): number;
    set subStatus(value: number);
    resetSubStatus(): void;
    get subStatusInput(): number | undefined;
    private _win32Status?;
    get win32Status(): string;
    set win32Status(value: string);
    resetWin32Status(): void;
    get win32StatusInput(): string | undefined;
}
export declare class LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference;
}
export interface LinuxWebAppSiteConfigAutoHealSettingTrigger {
    /**
    * requests block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#requests LinuxWebApp#requests}
    */
    readonly requests?: LinuxWebAppSiteConfigAutoHealSettingTriggerRequests;
    /**
    * slow_request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#slow_request LinuxWebApp#slow_request}
    */
    readonly slowRequest?: LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest;
    /**
    * status_code block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#status_code LinuxWebApp#status_code}
    */
    readonly statusCode?: LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
}
export declare function linuxWebAppSiteConfigAutoHealSettingTriggerToTerraform(struct?: LinuxWebAppSiteConfigAutoHealSettingTriggerOutputReference | LinuxWebAppSiteConfigAutoHealSettingTrigger): any;
export declare class LinuxWebAppSiteConfigAutoHealSettingTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfigAutoHealSettingTrigger | undefined;
    set internalValue(value: LinuxWebAppSiteConfigAutoHealSettingTrigger | undefined);
    private _requests;
    get requests(): LinuxWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference;
    putRequests(value: LinuxWebAppSiteConfigAutoHealSettingTriggerRequests): void;
    resetRequests(): void;
    get requestsInput(): LinuxWebAppSiteConfigAutoHealSettingTriggerRequests | undefined;
    private _slowRequest;
    get slowRequest(): LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference;
    putSlowRequest(value: LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest): void;
    resetSlowRequest(): void;
    get slowRequestInput(): LinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    private _statusCode;
    get statusCode(): LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeList;
    putStatusCode(value: LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable): void;
    resetStatusCode(): void;
    get statusCodeInput(): cdktf.IResolvable | LinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | undefined;
}
export interface LinuxWebAppSiteConfigAutoHealSetting {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#action LinuxWebApp#action}
    */
    readonly action?: LinuxWebAppSiteConfigAutoHealSettingAction;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#trigger LinuxWebApp#trigger}
    */
    readonly trigger?: LinuxWebAppSiteConfigAutoHealSettingTrigger;
}
export declare function linuxWebAppSiteConfigAutoHealSettingToTerraform(struct?: LinuxWebAppSiteConfigAutoHealSettingOutputReference | LinuxWebAppSiteConfigAutoHealSetting): any;
export declare class LinuxWebAppSiteConfigAutoHealSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfigAutoHealSetting | undefined;
    set internalValue(value: LinuxWebAppSiteConfigAutoHealSetting | undefined);
    private _action;
    get action(): LinuxWebAppSiteConfigAutoHealSettingActionOutputReference;
    putAction(value: LinuxWebAppSiteConfigAutoHealSettingAction): void;
    resetAction(): void;
    get actionInput(): LinuxWebAppSiteConfigAutoHealSettingAction | undefined;
    private _trigger;
    get trigger(): LinuxWebAppSiteConfigAutoHealSettingTriggerOutputReference;
    putTrigger(value: LinuxWebAppSiteConfigAutoHealSettingTrigger): void;
    resetTrigger(): void;
    get triggerInput(): LinuxWebAppSiteConfigAutoHealSettingTrigger | undefined;
}
export interface LinuxWebAppSiteConfigCors {
    /**
    * Specifies a list of origins that should be allowed to make cross-origin calls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#allowed_origins LinuxWebApp#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Are credentials allowed in CORS requests? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#support_credentials LinuxWebApp#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function linuxWebAppSiteConfigCorsToTerraform(struct?: LinuxWebAppSiteConfigCorsOutputReference | LinuxWebAppSiteConfigCors): any;
export declare class LinuxWebAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfigCors | undefined;
    set internalValue(value: LinuxWebAppSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxWebAppSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#always_on LinuxWebApp#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#api_definition_url LinuxWebApp#api_definition_url}
    */
    readonly apiDefinitionUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#api_management_api_id LinuxWebApp#api_management_api_id}
    */
    readonly apiManagementApiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#app_command_line LinuxWebApp#app_command_line}
    */
    readonly appCommandLine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#auto_heal_enabled LinuxWebApp#auto_heal_enabled}
    */
    readonly autoHealEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#container_registry_managed_identity_client_id LinuxWebApp#container_registry_managed_identity_client_id}
    */
    readonly containerRegistryManagedIdentityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#container_registry_use_managed_identity LinuxWebApp#container_registry_use_managed_identity}
    */
    readonly containerRegistryUseManagedIdentity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#default_documents LinuxWebApp#default_documents}
    */
    readonly defaultDocuments?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#ftps_state LinuxWebApp#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * The amount of time in minutes that a node is unhealthy before being removed from the load balancer. Possible values are between `2` and `10`. Defaults to `10`. Only valid in conjunction with `health_check_path`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#health_check_eviction_time_in_min LinuxWebApp#health_check_eviction_time_in_min}
    */
    readonly healthCheckEvictionTimeInMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#health_check_path LinuxWebApp#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#http2_enabled LinuxWebApp#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#ip_restriction LinuxWebApp#ip_restriction}
    */
    readonly ipRestriction?: LinuxWebAppSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#load_balancing_mode LinuxWebApp#load_balancing_mode}
    */
    readonly loadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#local_mysql_enabled LinuxWebApp#local_mysql_enabled}
    */
    readonly localMysqlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#managed_pipeline_mode LinuxWebApp#managed_pipeline_mode}
    */
    readonly managedPipelineMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#minimum_tls_version LinuxWebApp#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#remote_debugging_enabled LinuxWebApp#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#remote_debugging_version LinuxWebApp#remote_debugging_version}
    */
    readonly remoteDebuggingVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#scm_ip_restriction LinuxWebApp#scm_ip_restriction}
    */
    readonly scmIpRestriction?: LinuxWebAppSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#scm_minimum_tls_version LinuxWebApp#scm_minimum_tls_version}
    */
    readonly scmMinimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#scm_use_main_ip_restriction LinuxWebApp#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#use_32_bit_worker LinuxWebApp#use_32_bit_worker}
    */
    readonly use32BitWorker?: boolean | cdktf.IResolvable;
    /**
    * Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#vnet_route_all_enabled LinuxWebApp#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#websockets_enabled LinuxWebApp#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#worker_count LinuxWebApp#worker_count}
    */
    readonly workerCount?: number;
    /**
    * application_stack block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#application_stack LinuxWebApp#application_stack}
    */
    readonly applicationStack?: LinuxWebAppSiteConfigApplicationStack;
    /**
    * auto_heal_setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#auto_heal_setting LinuxWebApp#auto_heal_setting}
    */
    readonly autoHealSetting?: LinuxWebAppSiteConfigAutoHealSetting;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#cors LinuxWebApp#cors}
    */
    readonly cors?: LinuxWebAppSiteConfigCors;
}
export declare function linuxWebAppSiteConfigToTerraform(struct?: LinuxWebAppSiteConfigOutputReference | LinuxWebAppSiteConfig): any;
export declare class LinuxWebAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSiteConfig | undefined;
    set internalValue(value: LinuxWebAppSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _apiDefinitionUrl?;
    get apiDefinitionUrl(): string;
    set apiDefinitionUrl(value: string);
    resetApiDefinitionUrl(): void;
    get apiDefinitionUrlInput(): string | undefined;
    private _apiManagementApiId?;
    get apiManagementApiId(): string;
    set apiManagementApiId(value: string);
    resetApiManagementApiId(): void;
    get apiManagementApiIdInput(): string | undefined;
    private _appCommandLine?;
    get appCommandLine(): string;
    set appCommandLine(value: string);
    resetAppCommandLine(): void;
    get appCommandLineInput(): string | undefined;
    private _autoHealEnabled?;
    get autoHealEnabled(): boolean | cdktf.IResolvable;
    set autoHealEnabled(value: boolean | cdktf.IResolvable);
    resetAutoHealEnabled(): void;
    get autoHealEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _containerRegistryManagedIdentityClientId?;
    get containerRegistryManagedIdentityClientId(): string;
    set containerRegistryManagedIdentityClientId(value: string);
    resetContainerRegistryManagedIdentityClientId(): void;
    get containerRegistryManagedIdentityClientIdInput(): string | undefined;
    private _containerRegistryUseManagedIdentity?;
    get containerRegistryUseManagedIdentity(): boolean | cdktf.IResolvable;
    set containerRegistryUseManagedIdentity(value: boolean | cdktf.IResolvable);
    resetContainerRegistryUseManagedIdentity(): void;
    get containerRegistryUseManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultDocuments?;
    get defaultDocuments(): string[];
    set defaultDocuments(value: string[]);
    resetDefaultDocuments(): void;
    get defaultDocumentsInput(): string[] | undefined;
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckEvictionTimeInMin?;
    get healthCheckEvictionTimeInMin(): number;
    set healthCheckEvictionTimeInMin(value: number);
    resetHealthCheckEvictionTimeInMin(): void;
    get healthCheckEvictionTimeInMinInput(): number | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction;
    get ipRestriction(): LinuxWebAppSiteConfigIpRestrictionList;
    putIpRestriction(value: LinuxWebAppSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | LinuxWebAppSiteConfigIpRestriction[] | undefined;
    get linuxFxVersion(): string;
    private _loadBalancingMode?;
    get loadBalancingMode(): string;
    set loadBalancingMode(value: string);
    resetLoadBalancingMode(): void;
    get loadBalancingModeInput(): string | undefined;
    private _localMysqlEnabled?;
    get localMysqlEnabled(): boolean | cdktf.IResolvable;
    set localMysqlEnabled(value: boolean | cdktf.IResolvable);
    resetLocalMysqlEnabled(): void;
    get localMysqlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedPipelineMode?;
    get managedPipelineMode(): string;
    set managedPipelineMode(value: string);
    resetManagedPipelineMode(): void;
    get managedPipelineModeInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    get remoteDebuggingVersion(): string;
    set remoteDebuggingVersion(value: string);
    resetRemoteDebuggingVersion(): void;
    get remoteDebuggingVersionInput(): string | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): LinuxWebAppSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: LinuxWebAppSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | LinuxWebAppSiteConfigScmIpRestriction[] | undefined;
    private _scmMinimumTlsVersion?;
    get scmMinimumTlsVersion(): string;
    set scmMinimumTlsVersion(value: string);
    resetScmMinimumTlsVersion(): void;
    get scmMinimumTlsVersionInput(): string | undefined;
    get scmType(): string;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorker?;
    get use32BitWorker(): boolean | cdktf.IResolvable;
    set use32BitWorker(value: boolean | cdktf.IResolvable);
    resetUse32BitWorker(): void;
    get use32BitWorkerInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _workerCount?;
    get workerCount(): number;
    set workerCount(value: number);
    resetWorkerCount(): void;
    get workerCountInput(): number | undefined;
    private _applicationStack;
    get applicationStack(): LinuxWebAppSiteConfigApplicationStackOutputReference;
    putApplicationStack(value: LinuxWebAppSiteConfigApplicationStack): void;
    resetApplicationStack(): void;
    get applicationStackInput(): LinuxWebAppSiteConfigApplicationStack | undefined;
    private _autoHealSetting;
    get autoHealSetting(): LinuxWebAppSiteConfigAutoHealSettingOutputReference;
    putAutoHealSetting(value: LinuxWebAppSiteConfigAutoHealSetting): void;
    resetAutoHealSetting(): void;
    get autoHealSettingInput(): LinuxWebAppSiteConfigAutoHealSetting | undefined;
    private _cors;
    get cors(): LinuxWebAppSiteConfigCorsOutputReference;
    putCors(value: LinuxWebAppSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): LinuxWebAppSiteConfigCors | undefined;
}
export interface LinuxWebAppStickySettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#app_setting_names LinuxWebApp#app_setting_names}
    */
    readonly appSettingNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#connection_string_names LinuxWebApp#connection_string_names}
    */
    readonly connectionStringNames?: string[];
}
export declare function linuxWebAppStickySettingsToTerraform(struct?: LinuxWebAppStickySettingsOutputReference | LinuxWebAppStickySettings): any;
export declare class LinuxWebAppStickySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppStickySettings | undefined;
    set internalValue(value: LinuxWebAppStickySettings | undefined);
    private _appSettingNames?;
    get appSettingNames(): string[];
    set appSettingNames(value: string[]);
    resetAppSettingNames(): void;
    get appSettingNamesInput(): string[] | undefined;
    private _connectionStringNames?;
    get connectionStringNames(): string[];
    set connectionStringNames(value: string[]);
    resetConnectionStringNames(): void;
    get connectionStringNamesInput(): string[] | undefined;
}
export interface LinuxWebAppStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#access_key LinuxWebApp#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#account_name LinuxWebApp#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#mount_path LinuxWebApp#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#name LinuxWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#share_name LinuxWebApp#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#type LinuxWebApp#type}
    */
    readonly type: string;
}
export declare function linuxWebAppStorageAccountToTerraform(struct?: LinuxWebAppStorageAccount | cdktf.IResolvable): any;
export declare class LinuxWebAppStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppStorageAccount | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class LinuxWebAppStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppStorageAccountOutputReference;
}
export interface LinuxWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#create LinuxWebApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#delete LinuxWebApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#read LinuxWebApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app#update LinuxWebApp#update}
    */
    readonly update?: string;
}
export declare function linuxWebAppTimeoutsToTerraform(struct?: LinuxWebAppTimeoutsOutputReference | LinuxWebAppTimeouts | cdktf.IResolvable): any;
export declare class LinuxWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app azurerm_linux_web_app}
*/
export declare class LinuxWebApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_linux_web_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/linux_web_app azurerm_linux_web_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LinuxWebAppConfig
    */
    constructor(scope: Construct, id: string, config: LinuxWebAppConfig);
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetClientAffinityEnabled(): void;
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateEnabled?;
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    resetClientCertificateEnabled(): void;
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateMode?;
    get clientCertificateMode(): string;
    set clientCertificateMode(value: string);
    resetClientCertificateMode(): void;
    get clientCertificateModeInput(): string | undefined;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReferenceIdentityId?;
    get keyVaultReferenceIdentityId(): string;
    set keyVaultReferenceIdentityId(value: string);
    resetKeyVaultReferenceIdentityId(): void;
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    get kind(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _servicePlanId?;
    get servicePlanId(): string;
    set servicePlanId(value: string);
    get servicePlanIdInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): LinuxWebAppSiteCredentialList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
    private _zipDeployFile?;
    get zipDeployFile(): string;
    set zipDeployFile(value: string);
    resetZipDeployFile(): void;
    get zipDeployFileInput(): string | undefined;
    private _authSettings;
    get authSettings(): LinuxWebAppAuthSettingsOutputReference;
    putAuthSettings(value: LinuxWebAppAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): LinuxWebAppAuthSettings | undefined;
    private _backup;
    get backup(): LinuxWebAppBackupOutputReference;
    putBackup(value: LinuxWebAppBackup): void;
    resetBackup(): void;
    get backupInput(): LinuxWebAppBackup | undefined;
    private _connectionString;
    get connectionString(): LinuxWebAppConnectionStringList;
    putConnectionString(value: LinuxWebAppConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | LinuxWebAppConnectionString[] | undefined;
    private _identity;
    get identity(): LinuxWebAppIdentityOutputReference;
    putIdentity(value: LinuxWebAppIdentity): void;
    resetIdentity(): void;
    get identityInput(): LinuxWebAppIdentity | undefined;
    private _logs;
    get logs(): LinuxWebAppLogsOutputReference;
    putLogs(value: LinuxWebAppLogs): void;
    resetLogs(): void;
    get logsInput(): LinuxWebAppLogs | undefined;
    private _siteConfig;
    get siteConfig(): LinuxWebAppSiteConfigOutputReference;
    putSiteConfig(value: LinuxWebAppSiteConfig): void;
    get siteConfigInput(): LinuxWebAppSiteConfig | undefined;
    private _stickySettings;
    get stickySettings(): LinuxWebAppStickySettingsOutputReference;
    putStickySettings(value: LinuxWebAppStickySettings): void;
    resetStickySettings(): void;
    get stickySettingsInput(): LinuxWebAppStickySettings | undefined;
    private _storageAccount;
    get storageAccount(): LinuxWebAppStorageAccountList;
    putStorageAccount(value: LinuxWebAppStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | LinuxWebAppStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): LinuxWebAppTimeoutsOutputReference;
    putTimeouts(value: LinuxWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LinuxWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
