# coding: utf-8

"""
    Planetary Data System API

    Federated PDS API which provides actionable end points standardized between the different nodes.   # noqa: E501

    The version of the OpenAPI document: 0.2.dev
    Contact: pds-operator@jpl.nasa.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pds.api_client.configuration import Configuration


class Reference(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'title': 'str',
        'id': 'str',
        'href': 'str',
        'type': 'str',
        'description': 'str'
    }

    attribute_map = {
        'title': 'title',
        'id': 'id',
        'href': 'href',
        'type': 'type',
        'description': 'description'
    }

    def __init__(self, title=None, id=None, href=None, type=None, description=None, local_vars_configuration=None):  # noqa: E501
        """Reference - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._title = None
        self._id = None
        self._href = None
        self._type = None
        self._description = None
        self.discriminator = None

        if title is not None:
            self.title = title
        self.id = id
        if href is not None:
            self.href = href
        if type is not None:
            self.type = type
        if description is not None:
            self.description = description

    @property
    def title(self):
        """Gets the title of this Reference.  # noqa: E501

        name to display for the external reference  # noqa: E501

        :return: The title of this Reference.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Reference.

        name to display for the external reference  # noqa: E501

        :param title: The title of this Reference.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def id(self):
        """Gets the id of this Reference.  # noqa: E501

        external reference, here lidvid urn  # noqa: E501

        :return: The id of this Reference.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Reference.

        external reference, here lidvid urn  # noqa: E501

        :param id: The id of this Reference.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def href(self):
        """Gets the href of this Reference.  # noqa: E501

        external reference url of the current reference resolvable by the current API server, http://pds.nasa.gov/api/products/urn:nasa...  # noqa: E501

        :return: The href of this Reference.  # noqa: E501
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """Sets the href of this Reference.

        external reference url of the current reference resolvable by the current API server, http://pds.nasa.gov/api/products/urn:nasa...  # noqa: E501

        :param href: The href of this Reference.  # noqa: E501
        :type: str
        """

        self._href = href

    @property
    def type(self):
        """Gets the type of this Reference.  # noqa: E501

        type of the external reference, can be displayed as an icon for example  # noqa: E501

        :return: The type of this Reference.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Reference.

        type of the external reference, can be displayed as an icon for example  # noqa: E501

        :param type: The type of this Reference.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def description(self):
        """Gets the description of this Reference.  # noqa: E501

        longer description for the external reference, can be displayed in a tooltip  # noqa: E501

        :return: The description of this Reference.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Reference.

        longer description for the external reference, can be displayed in a tooltip  # noqa: E501

        :param description: The description of this Reference.  # noqa: E501
        :type: str
        """

        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Reference):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Reference):
            return True

        return self.to_dict() != other.to_dict()
