# mypy-boto3-acm-pca

[![PyPI - mypy-boto3-acm-pca](https://img.shields.io/pypi/v/mypy-boto3-acm-pca.svg?color=blue)](https://pypi.org/project/mypy-boto3-acm-pca)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-acm-pca.svg?color=blue)](https://pypi.org/project/mypy-boto3-acm-pca)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ACMPCA 1.12.44](https://boto3.amazonaws.com/v1/documentation/api/1.12.44/reference/services/acm-pca.html#ACMPCA) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.7](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-acm-pca](#mypy-boto3-acm-pca)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ACMPCA` service.

```bash
python -m pip install boto3-stubs[acm-pca]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import acm_pca
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_acm_pca as acm_pca

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("acm-pca")
client: acm_pca.ACMPCAClient = boto3.client("acm-pca")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: acm_pca.ACMPCAClient = session.client("acm-pca")


# Waiters need type annotation on creation
audit_report_created_waiter: acm_pca.AuditReportCreatedWaiter = client.get_waiter("audit_report_created")
certificate_authority_csr_created_waiter: acm_pca.CertificateAuthorityCSRCreatedWaiter = client.get_waiter("certificate_authority_csr_created")
certificate_issued_waiter: acm_pca.CertificateIssuedWaiter = client.get_waiter("certificate_issued")

# Paginators need type annotation on creation
list_certificate_authorities_paginator: acm_pca.ListCertificateAuthoritiesPaginator = client.get_paginator("list_certificate_authorities")
list_permissions_paginator: acm_pca.ListPermissionsPaginator = client.get_paginator("list_permissions")
list_tags_paginator: acm_pca.ListTagsPaginator = client.get_paginator("list_tags")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.