"""
Main interface for acm-pca service.

Usage::

    import boto3
    from mypy_boto3.acm_pca import (
        ACMPCAClient,
        AuditReportCreatedWaiter,
        CertificateAuthorityCSRCreatedWaiter,
        CertificateIssuedWaiter,
        Client,
        ListCertificateAuthoritiesPaginator,
        ListPermissionsPaginator,
        ListTagsPaginator,
        )

    session = boto3.Session()

    client: ACMPCAClient = boto3.client("acm-pca")
    session_client: ACMPCAClient = session.client("acm-pca")

    audit_report_created_waiter: AuditReportCreatedWaiter = client.get_waiter("audit_report_created")
    certificate_authority_csr_created_waiter: CertificateAuthorityCSRCreatedWaiter = client.get_waiter("certificate_authority_csr_created")
    certificate_issued_waiter: CertificateIssuedWaiter = client.get_waiter("certificate_issued")

    list_certificate_authorities_paginator: ListCertificateAuthoritiesPaginator = client.get_paginator("list_certificate_authorities")
    list_permissions_paginator: ListPermissionsPaginator = client.get_paginator("list_permissions")
    list_tags_paginator: ListTagsPaginator = client.get_paginator("list_tags")
"""
from mypy_boto3_acm_pca.client import ACMPCAClient as Client, ACMPCAClient
from mypy_boto3_acm_pca.paginator import (
    ListCertificateAuthoritiesPaginator,
    ListPermissionsPaginator,
    ListTagsPaginator,
)
from mypy_boto3_acm_pca.waiter import (
    AuditReportCreatedWaiter,
    CertificateAuthorityCSRCreatedWaiter,
    CertificateIssuedWaiter,
)


__all__ = (
    "ACMPCAClient",
    "AuditReportCreatedWaiter",
    "CertificateAuthorityCSRCreatedWaiter",
    "CertificateIssuedWaiter",
    "Client",
    "ListCertificateAuthoritiesPaginator",
    "ListPermissionsPaginator",
    "ListTagsPaginator",
)
