import asyncio
import logging
import socket
from picows import WSTransport, WSMsgType
BUFFER = 65536  # Increased from 8KB to 64KB


def tcp_recv(client_socket):
    try:
        data = client_socket.recv(BUFFER)
        if data:
            logging.debug(f"Received {len(data)} bytes")
        if not data:
            return None
        logging.debug("TCP server received: " + str(data))
        return data
    except Exception as e:
        logging.error(f"Error receiving TCP data: {e}")
        return None

def tcp_send(client_socket, data):
    try:
        client_socket.sendall(data)
    except Exception as e:
        logging.error(f"Error sending TCP data: {e}")
        return False
    return True

def udp_recv(sock, buffer_size=BUFFER):
    try:
        data, addr = sock.recvfrom(buffer_size)
        if data:
            logging.debug(f"Received {len(data)} bytes from {addr}")
        return data, addr
    except Exception as e:
        logging.error(f"Error receiving UDP data: {e}")
        return None, None

def udp_send(sock, data, addr):
    try:
        sock.sendto(data, addr)
        return True
    except Exception as e:
        logging.error(f"Error sending UDP data: {e}")
        return False

def websocket_send(transport: WSTransport, data):
    try:
        transport.send(WSMsgType.BINARY, data)
    except Exception as e:
        logging.debug(f"Error sending WebSocket data: {e}")


def try_port(port):
    # Source: https://stackoverflow.com/a/43271125/24191134
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as sock:
        result = False
        try:
            sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
            sock.bind(("127.0.0.1", port))
            result = True
        except socket.error as e:
            pass
        finally:
            sock.close()
        return result

def scan_port():
    available_ports = []
    for i in range(1, 65535):
        if try_port(i):
            available_ports.append(i)
    return available_ports
