
#!/usr/bin/env python
# -*- coding: UTF-8 -*-


d_trie_ku = {'_': ['ku-ring-gai_philharmonic_orchestra',
       'ku-ring-gai_wildflower_garden',
       'ku._ma._balasubramaniam',
       'ku-ring-gai_high_school',
       'ku_leuven_association',
       'ku._sa._krishnamurthy',
       'ku_ikaika_challenge',
       'ku._pa._krishnan',
       'ku_kaeo_district',
       'ku_klux_glam',
       'ku_klux_klan',
       'ku_wai_ming',
       'ku_kam_fai'],
 'a': ['kuala_lumpur-seremban_expressway',
       'kuangquan_subdistrict,_guangzhou',
       'kualanamu_international_airport',
       'kuanzhaixiangzi_alleys_station',
       'kuala_lumpur-karak_expressway',
       'kuala_lumpur-rawang_highway',
       'kuangshi_avenue_subdistrict',
       'kuala_terengganu_drawbridge',
       'kuanjie_protestant_church',
       'kuala_terengganu_district',
       'kuantan_singingi_regency',
       'kuala_selangor_district',
       'kuakini_medical_center',
       'kuala_kangsar_district',
       'kuala_klawang_memorial',
       'kuala_langat_district',
       'kuala_lumpur_hospital',
       'kuakata_national_park',
       'kuang_komuter_station',
       'kuala_lumpur_marathon',
       'kualoa_regional_park',
       'kuala_lumpur_dragons',
       'kuala_belait_highway',
       'kuala_penyu_district',
       'kuala_belait_library',
       'kuala_lumpur_library',
       'kuala_nerus_district',
       'kuala_lumpur_stadium',
       'kuala_pilah_district',
       'kuala_krai_district',
       'kuana_torres_kahele',
       'kuala_lumpur_league',
       'kuala_berang_bridge',
       'kuala_muda_district',
       'kuala_lumpur_summit',
       'kuala_linggi_bridge',
       'kuatun_horned_toad',
       'kuala_lumpur_major',
       'kuala_sungai_buloh',
       'kuara,_west_bengal',
       'kuala_lumpur_tower',
       'kuaitiao_khua_kai',
       'kuala_lumpur_open',
       'kuala_sungai_baru',
       'kuai_kuai_culture',
       'kuala_krai_bridge',
       'kuala_kubu_bharu',
       'kuala_lumpur_bar',
       'kuare_rural_llg',
       'kuala_belait_fc',
       'kuayue_chana_v5',
       'kuan_beng_hong',
       'kuang_si_falls',
       'kuan_kim_seng',
       'kuan_king_lam',
       'kua_kia_soong',
       'kuan_kam_hon',
       'kua_ee_heok'],
 'b': ['kuban_long-barbelled_gudgeon',
       'kubice,_masovian_voivodeship',
       'kubitschek_residence_museum',
       'kubice,_opole_voivodeship',
       'kubote_historical_museum',
       "kuban_people's_republic",
       'kubwimana_kazingufu_ali',
       "kublai_khan's_campaigns",
       'kuban-black_sea_oblast',
       'kuban_state_university',
       'kuben_vocational_arena',
       'kublis_railway_station',
       'kuban_soviet_republic',
       'kubang_pasu_district',
       'kubs_basketball_club',
       'kuber_chandra_biswas',
       'kubasaki_high_school',
       'kuban_nogai_uprising',
       'kubinka_tank_museum',
       'kubah_national_park',
       'kuban_cossack_choir',
       'kubat_pasha_madrasa',
       'kubanka,_altai_krai',
       'kubilius_cabinet_ii',
       'kubinke_the_barber',
       'kuba_drinking_horn',
       'kubrick_by_kubrick',
       'kubaner_idish_wort',
       'kubilius_cabinet_i',
       'kubota_palm_garden',
       'kubra_ocsoy_korkut',
       'kubu_raya_regency',
       'kubi_matthu_iyala',
       'kubicek_m-2_scout',
       'kubutz_and_shuruk',
       'kuber_singh_rana',
       'kubrick_the_dog',
       'kubicki_ikub_i',
       'kuber_nath_rai',
       'kubi_gold_mine'],
 'c': ['kuchwald/abzw_chemnitz-furth-chemnitz-hilbersdorf_railway',
       'kuczyna,_kuyavian-pomeranian_voivodeship',
       'kuczkow,_swietokrzyskie_voivodeship',
       'kuchchaveli_divisional_secretariat',
       'kuchnia,_pomeranian_voivodeship',
       'kuchary,_masovian_voivodeship',
       'kuching_international_airport',
       'kuchary,_silesian_voivodeship',
       'kucukcekmece_railway_station',
       'kuchary,_dzierzoniow_county',
       'kuchipudi,_krishna_district',
       'kucheipadar_tribal_movement',
       'kuchinda_college,_kuchinda',
       'kuchugury,_voronezh_oblast',
       'kuchek_bisheh-ye_mahalleh',
       'kucukyali_railway_station',
       'kuchurhan,_rozdilna_raion',
       'kucin,_bardejov_district',
       'kuchary,_radomsko_county',
       'kuchwald_railway_station',
       'kuchary,_leczyca_county',
       'kuchlak_railway_station',
       'kuchurgan_power_station',
       'kuchek,_west_azerbaijan',
       'kuchali_railway_station',
       'kuching_heroes_cemetery',
       'kuchino_railway_station',
       'kuchary,_gmina_stopnica',
       'kuchary,_gmina_wislica',
       'kuching_old_courthouse',
       'kuczkow,_lowicz_county',
       'kuchary,_olawa_county',
       'kuchibiru_kara_biyaku',
       'kuczkow,_kutno_county',
       'kucze,_mragowo_county',
       'kuche_railway_station',
       'kuchary,_kutno_county',
       'kucuk_mecidiye_mosque',
       'kuching_civic_centre',
       'kuchek_yurt_sheykhan',
       'kuczyn,_monki_county',
       'kucuk_menderes_river',
       'kuchak-e_nazar_khani',
       'kucuk_huseyin_pasha',
       'kuchh_jhuki_palkain',
       'kuchh_bheege_alfaaz',
       'kuckville,_new_york',
       'kuching_high_school',
       'kuching_cat_museum',
       'kuchuk,_altai_krai',
       'kucuk_tavsan_adasi',
       'kuchai_mrt_station',
       'kuchmyn_yar_street',
       'kucze,_elk_county',
       'kuchinotsu_no._37',
       'kuchek_dig_seyyed',
       'kucuk_ahmed_pasha',
       'kuching_city_f.c.',
       'kuch..._diiil_se',
       'kucova_oil_field',
       'kucch_luv_jaisaa',
       'kucher_model_k1',
       'kuch_kar_dikha',
       'kuchiki_no_to',
       'kuchh_na_kaho',
       'kuchh_is_tara',
       'kuch_naa_kaho',
       'kucch_to_hai'],
 'd': ['kudemskaya_narrow-gauge_railway',
       'kudurrus_of_marduk-nadin-ahhe',
       'kudrinskaya_square_building',
       'kudrino,_arkhangelsk_oblast',
       'kudamaloor_karunakaran_nair',
       'kudardup,_western_australia',
       'kudumbam_namukku_sreekovil',
       'kudaldeshkar_gaud_brahmin',
       'kudrino,_astrakhan_oblast',
       'kudurru_for_sitti-marduk',
       'kudchade_railway_station',
       'kuderu,_krishna_district',
       'kudan_project_production',
       'kudanthai_n._ramalingam',
       'kudo_district,_hokkaido',
       'kudypy,_ostroda_county',
       'kudirithe_kappu_coffee',
       'kudla,_south_australia',
       'kudypy,_olsztyn_county',
       'kuda_kala_kamanafaanu',
       'kudla_railway_station',
       'kudurru_of_kastiliasu',
       'kudal_railway_station',
       'kudumbam_oru_kadambam',
       "kudo_be'ur_subregion",
       'kuda_funeral_attack',
       'kudos:_rock_legend',
       'kudumbam_oru_kovil',
       'kudu_power_project',
       'kudlow_and_cramer',
       'kudmul_ranga_rao',
       'kudurru_of_gula',
       'kudu_gas_field',
       'kudos_to_you!',
       'kuda_ulun_fc'],
 'e': ["kuekenthal's_yellow_tiger",
       'kuehn_conservation_area',
       'kue_kembang_goyang',
       'kuei-mei,_a_woman',
       'kue_lidah_kucing',
       'kue_putri_salju',
       'kue_putu_mayang',
       'kuehne_+_nagel',
       'kuei_pin_yeo'],
 'f': ['kufstein_railway_station',
       'kufayrat_abu_khinan',
       'kufayr_al_wakhyan',
       'kufayr_abu_sarbut',
       'kuf_ab_district',
       'kufor_a_sal'],
 'g': ['kuga_district,_yamaguchi',
       'kuguzade_suleyman_pasha',
       'kugu_nganhcara_language',
       'kugluktuk_high_school',
       'kugatsu_no_sotsugyo',
       'kuga_fiber_variety',
       'kugi_uswag_sugbo'],
 'h': ['kuhistoni_mastchoh_district',
       'kuhne_logistics_university',
       'kuhnhenn_brewing_company',
       'kuhsarat_rural_district',
       'kuhestan_rural_district',
       'kuhsangi_rural_district',
       'kuhmareh_rural_district',
       'kuhsaran_rural_district',
       'kuhdasht_rural_district',
       'kuhenjan_rural_district',
       'kuhpayeh_rural_district',
       'kuhsar,_south_khorasan',
       'kuhuri_railway_station',
       'kuh_gari-ye_kheyrabad',
       'kuhgir_rural_district',
       'kuhsar_rural_district',
       'kuhi,_razavi_khorasan',
       'kuhlan_affar_district',
       'kuhak_rural_district',
       'kuh_sefid,_hormozgan',
       'kuhin_rural_district',
       'kuhestan,_kargan_rud',
       'kuh-e_sefid,_markazi',
       "kuhn's_quality_foods",
       'kuh_kamar,_golestan',
       'kuh-e_hajji_koshteh',
       'kuh_shakhen_castle',
       'kuh_borideh_shelal',
       'kuh_kenar,_ardabil',
       'kuh_zar,_khuzestan',
       'kuhn_station_site',
       'kuh-e_safed_khers',
       "kuhl's_creek_frog",
       'kuh_sefid-e_sofla',
       'kuh_zardan_castle',
       'kuhe_haji_ebrahim',
       'kuh_sefid,_kerman',
       'kuh-e_qaleh_sofla',
       'kuhio_beach_park',
       'kuh-e_bon,_gilan',
       'kuh-e_chuk_shakh',
       'kuh_zar,_semnan',
       'kuh_qaen_castle',
       'kuh_sefid,_fars',
       'kuh_kan-e_sofla',
       'kuhl_and_leyton',
       'kuhn_vs._popper',
       'kuh_kan-e_olya',
       'kuh_dim-e_pain',
       'kuh_sefid,_qom',
       'kuhn_and_komor',
       'kuh_dim-e_bala'],
 'i': ['kuibyshevskyi_district,_donetsk',
       'kuiper_airborne_observatory',
       "kuiter's_deepsea_clingfish",
       'kuitpo,_south_australia',
       'kuitan_railway_station',
       'kuiaru_nature_reserve',
       'kuit_vaya,_arizona',
       'kui_buri_district',
       'kui_tatk,_arizona',
       'kuik-e_azizi_amin',
       'kuiqi_lu_station',
       'kuini_te_tau',
       'kui_tan_sc'],
 'j': ['kujawa,_kuyavian-pomeranian_voivodeship',
       'kujawy,_kuyavian-pomeranian_voivodeship',
       'kujawki,_swietokrzyskie_voivodeship',
       'kujawy,_swietokrzyskie_voivodeship',
       'kujawsko-pomorska_digital_library',
       'kujanki,_pomeranian_voivodeship',
       'kujawy,_pomeranian_voivodeship',
       'kujnik,_pozega-slavonia_county',
       'kujnik,_brod-posavina_county',
       'kujawy,_masovian_voivodeship',
       'kujawa,_lubusz_voivodeship',
       'kujawki,_lodz_voivodeship',
       'kujang_chongnyon_station',
       'kuji_district,_ibaraki',
       'kujendra_lal_tripura',
       'kuji_of_colchis'],
 'k': ['kukowo,_kuyavian-pomeranian_voivodeship',
       'kukowo,_warmian-masurian_voivodeship',
       'kukujevci-erdevik_railway_station',
       'kukuriraige_-sanxingdui_fantasy-',
       'kukowo,_pomeranian_voivodeship',
       'kukowo,_podlaskie_voivodeship',
       'kukushkino,_volgograd_oblast',
       'kuksaroy_presidential_palace',
       'kukow,_podlaskie_voivodeship',
       "kuki_students'_organisation",
       'kukawka,_lublin_voivodeship',
       'kukulka,_miedzychod_county',
       'kukerin,_western_australia',
       'kuki_national_organisation',
       'kukowka,_gmina_sierakowice',
       'kukatpally_metro_station',
       'kukutesvara_siva_temple',
       'kuki_baptist_convention',
       'kukawki,_siedlce_county',
       'kukhan,_west_azerbaijan',
       'kukawki,_wolomin_county',
       'kukke_subramanya_temple',
       'kukowka,_gmina_stezyca',
       'kukrail_reserve_forest',
       'kukherd_rural_district',
       'kukeh,_west_azerbaijan',
       'kukulka,_kalisz_county',
       'kuki_christian_church',
       'kuku_nyungkal_dialect',
       'kukaniloko_birth_site',
       'kukka_nature_reserve',
       'kukushka,_perm_krai',
       'kuka_robot_language',
       'kuke,_laane_county',
       'kukui_grove_center',
       'kukak_village_site',
       'kuki_national_army',
       'kuke,_saare_county',
       'kukh-e_hajji_karim',
       'kuke,_parnu_county',
       'kukak_bay_cannery',
       'kukh-e_kani_guyz',
       'kuksha_of_odessa',
       'kuka_teki_huorin',
       'kukna_ajay_singh',
       'kukule_ganga_dam',
       'kuka_muu_muka',
       'kuku_mey_mey',
       'kuk_sool_won',
       'kuka_sa_oot'],
 'l': ['kulin,_kuyavian-pomeranian_voivodeship',
       'kulathur,_gandharvakottai,_pudukkottai',
       'kulesze,_warmian-masurian_voivodeship',
       'kuligi,_warmian-masurian_voivodeship',
       'kulturhistorisches_museum_magdeburg',
       'kulittalai_kadambavaneswarar_temple',
       'kulattur,_avudayarkoil,_pudukkottai',
       'kulik,_warmian-masurian_voivodeship',
       'kulfoldi_magyar_cserkeszszovetseg',
       'kulangsu_international_settlement',
       'kuliyapitiya_electoral_district',
       'kulice,_pomeranian_voivodeship',
       'kulesze,_podlaskie_voivodeship',
       'kuliyapitiya_polling_division',
       'kulczyn,_masovian_voivodeship',
       'kulikovo,_dobryansky_district',
       'kuligi,_podlaskie_voivodeship',
       'kulki,_pomeranian_voivodeship',
       'kuligowo,_miedzyrzecz_county',
       'kulikovsky,_volgograd_oblast',
       'kulykivka,_chernivtsi_oblast',
       'kullman_building_corporation',
       'kulkarni_chaukatla_deshpande',
       'kulyaling,_western_australia',
       'kuliyapitiya_central_college',
       'kulikovo,_arkhangelsk_oblast',
       'kulaghan-e_tuman-e_abdollah',
       'kula_municipality,_bulgaria',
       'kulgera,_northern_territory',
       'kulukkallur_railway_station',
       'kulliparu_conservation_park',
       'kulki,_masovian_voivodeship',
       'kulczyn,_lublin_voivodeship',
       'kulakovka,_voronezh_oblast',
       'kulikovka,_voronezh_oblast',
       'kulathupuzha_sastha_temple',
       'kule,_silesian_voivodeship',
       'kulps_corner,_pennsylvania',
       'kulmbach-class_mine_hunter',
       'kulosaari_secondary_school',
       'kularathna_central_college',
       'kultur_international_films',
       'kuldiha_wildlife_sanctuary',
       'kuleshov,_belgorod_oblast',
       'kulgachia_railway_station',
       'kulik,_lublin_voivodeship',
       'kularathna_maha_vidyalaya',
       'kulikov,_volgograd_oblast',
       'kulotino,_novgorod_oblast',
       'kuleshovka,_rostov_oblast',
       'kulpara,_south_australia',
       'kulpa,_balaghat_district',
       'kulja,_western_australia',
       'kulabad,_west_azerbaijan',
       'kulla_gunnarstorp_castle',
       'kulamba_wildlife_reserve',
       'kulin,_western_australia',
       'kulai_municipal_council',
       'kulosaari_metro_station',
       'kula_shaker_discography',
       'kulpa,_astrakhan_oblast',
       'kulaki,_vladimir_oblast',
       'kulani_secondary_school',
       'kulik_intercity_express',
       'kulm_municipal_airport',
       'kuldip_singh_chandpuri',
       'kuldip_chand_agnihotri',
       'kullfi_kumarr_bajewala',
       'kulab,_razavi_khorasan',
       'kult:_heretic_kingdoms',
       'kullimaa,_parnu_county',
       'kulaura_train_accident',
       'kulwin_railway_station',
       'kulkani_rural_district',
       'kule,_lodz_voivodeship',
       'kullamae,_polva_county',
       'kullimaa,_rapla_county',
       'kuliki,_kwidzyn_county',
       'kulsoom_akhtar_chandio',
       'kulab_railway_station',
       'kulpi_railway_station',
       'kulwant_singh_pandori',
       'kulliyyah_of_medicine',
       'kuldiga_half_marathon',
       'kulia_union,_mollahat',
       'kulu_abdullahi_sifawa',
       'kulem_railway_station',
       'kulungugu_bomb_attack',
       'kuldeep_singh_gangwar',
       'kulai_railway_station',
       'kula_volcanic_geopark',
       'kuljinder_singh_sidhu',
       'kula_botanical_garden',
       'kullal_chickappu_naik',
       'kulamandan_shah_khad',
       'kulen_vakuf_massacre',
       'kul_sorkh,_khuzestan',
       'kuldip_singh_dhingra',
       'kuldip_singh_dhillon',
       'kuliev_cavalry_group',
       'kuliki,_sztum_county',
       'kulothunga_chola_iii',
       'kuldeep_singh_garcha',
       'kul_badam-e_nurmorad',
       'kuldeep_singh_sengar',
       'kullu_manali_circuit',
       'kuliki,_oryol_oblast',
       'kulothunga_chola_ii',
       'kulevi_oil_terminal',
       'kulli,_tartu_county',
       'kulma,_saare_county',
       'kulwin_railway_line',
       'kul_sorkh-e_lirasad',
       'kulli,_valga_county',
       'kulpenberg_tv_tower',
       'kuldip_singh_uijeer',
       'kulon_progo_regency',
       'kulli,_parnu_county',
       'kuldip_singh_bhogal',
       'kulsum_begum_masjid',
       'kulkeh_rash-e_sofla',
       'kulli,_harju_county',
       'kulwant_ram_bazigar',
       'kulwant_singh_pannu',
       'kulovo,_tver_oblast',
       'kulintang_a_tiniok',
       'kulthum_bin_masoud',
       'kulik_lake_airport',
       'kul_ratna_tuladhar',
       'kuldeep_rai_sharma',
       'kulm,_north_dakota',
       'kuldeep_singh_vaid',
       'kulkeh_rash-e_olya',
       'kulwant_singh_gill',
       'kul_bahadur_gurung',
       'kulbir_singh_kaang',
       'kul_bahadur_khadka',
       'kuljit_singh_nagra',
       'kulbakino_air_base',
       'kulwant_singh_virk',
       'kulim_hi-tech_park',
       'kulma,_voru_county',
       'kull_the_conqueror',
       'kula_kei_uluivuya',
       'kul_prasad_uprety',
       'kul_badam-e_yavar',
       'kuldip_singh_brar',
       'kula,_malo_crnice',
       'kulbir_singh_zira',
       'kul_sharif_mosque',
       'kull_of_atlantis',
       'kul_prasad_nepal',
       'kulina_spiny_rat',
       'kulintang_a_kayo',
       'kulam,_sbs_nagar',
       'kuli_khoda_karam',
       'kulture_yabra_fc',
       'kulm_am_zirbitz',
       'kuli_kuli,_inc.',
       'kul_man_ghising',
       'kul_nabi_sahara',
       'kul_bazan-e_yek',
       'kulla_agent_000',
       'kul_marz_sofla',
       'kultur_im_heim',
       'kultur_im_gugg',
       'kul_bahadur_kc',
       'kult_ov_azazel',
       'kul_tepe_jolfa',
       'kultuur_ja_elu',
       'kula_eco_park',
       'kulm_bei_weiz',
       'kul_tak_durak',
       'kul_marz_olya',
       'kul_prasad_kc',
       'kulu_se_mama',
       'kul_med_jul'],
 'm': ['kumbakonam_municipal_corporation',
       'kumbhariya,_banaskantha_district',
       'kumchang-ri_underground_facility',
       'kumeyaay_traditional_narratives',
       'kumbakonam_rajamanickam_pillai',
       'kumamoto_prefectural_gymnasium',
       'kumaka,_east_berbice-corentyne',
       'kumbhalgarh_wildlife_sanctuary',
       'kumasi_metropolitan_assembly',
       'kumgangsan_chongnyon_station',
       'kumaratunga_munidasa_mawatha',
       'kumulamunai_maha_vidhyalayam',
       'kumite_classic_entertainment',
       'kumamoto_prefectural_theater',
       'kumasi_technical_university',
       'kumamoto_asahi_broadcasting',
       'kumarganj,_dakshin_dinajpur',
       'kumpulan_mujahidin_malaysia',
       'kumarina,_western_australia',
       'kummayak_rural_municipality',
       'kumgangsan_electric_railway',
       'kumasi_technical_institute',
       'kumamoto_gakuen_university',
       'kumla_church,_ostergotland',
       'kumeyaay_community_college',
       'kumbheshwar_temple_complex',
       'kumphawapi_railway_station',
       'kumbakonam_railway_station',
       'kumbhariya,_surat_district',
       'kumamoto_at-large_district',
       'kumage_district,_kagoshima',
       'kumage_district,_yamaguchi',
       'kumayri_historic_district',
       'kumarghat_railway_station',
       'kumarganj_railway_station',
       'kumagaya_athletic_stadium',
       'kumarbagh_railway_station',
       'kumho_cultural_foundation',
       'kumar_kashyap_mahasthavir',
       'kumakh_rural_municipality',
       'kumgangsan_chongnyon_line',
       'kumamoto_suizenji_stadium',
       'kumamoto_shintoshin_plaza',
       'kumla_church,_vastmanland',
       'kumamoto_electric_railway',
       'kumanovo_railway_station',
       'kumbhraj_railway_station',
       'kumamoto_castle_marathon',
       'kumbakonam_brahma_temple',
       'kumki,_arunachal_pradesh',
       'kumradol_railway_station',
       'kumpula_allotment_garden',
       'kumagaya_uchiwa_festival',
       'kumasi_military_hospital',
       'kumarakom_bird_sanctuary',
       'kumbakonam_degree_coffee',
       'kumbia_kings_discography',
       'kumnan_methodist_church',
       'kumbalathu_sanku_pillai',
       'kumane,_veliko_gradiste',
       'kuma_district,_kumamoto',
       'kumamoto_renaissance_fc',
       'kumara_krishnappa_nayak',
       'kumbatine_national_park',
       'kumsong_tractor_factory',
       'kumkapi_railway_station',
       'kumari_pennin_ullathile',
       'kumbrabow_state_forest',
       'kumrul_railway_station',
       'kumar_gandharva_samman',
       'kum_kapu_demonstration',
       'kume_district,_okayama',
       'kumino,_vologda_oblast',
       'kumbharia_jain_temples',
       'kumbakonam_jain_temple',
       'kumudini_welfare_trust',
       'kumanovo_town_cemetery',
       'kumar_suvarna_chandrak',
       'kumbla_railway_station',
       'kumudini_boat_massacre',
       'kumho_bmw_championship',
       'kumud_chandra_hazarika',
       'kumano_hayatama_taisha',
       'kumargaon_power_plant',
       'kumta_railway_station',
       'kumho,_south_hamgyong',
       'kumamoto_2nd_district',
       'kumasi_rural_district',
       'kumba_school_massacre',
       'kumar_mohalla_akingam',
       'kumagaya_rugby_ground',
       'kumamoto_4th_district',
       'kume_district,_ehime',
       'kumo_theatre_company',
       'kumar_mangalam_birla',
       'kumanovo_clock_tower',
       'kumud_ranjan_mullick',
       'kumara_swamy_desikar',
       'kumble_r._subbaswamy',
       'kumana_national_park',
       'kum,_west_azerbaijan',
       'kumanovo_bus_station',
       'kumagai_gumi_bruins',
       'kumar_kaibarta_gaon',
       'kumano_nachi_taisha',
       'kumai_bayang_akaahs',
       'kumha_pyakhan_dance',
       'kumla_church,_narke',
       'kumbari_dan_sharefa',
       'kumano_hongu_taisha',
       'kumara,_new_zealand',
       'kumar_mangat_pathak',
       'kumanichi_road_race',
       'kumpati_s._narendra',
       'kumam_samson_singh',
       'kumble_sundara_rao',
       'kumar_g._venkatesh',
       'kuma_reality_games',
       'kumu_kahua_theatre',
       'kumar_suresh_singh',
       'kumho_asiana_group',
       'kumadi_forest_park',
       'kumasi_high_school',
       'kumira_high_school',
       'kuma_von_clifford',
       'kumar_suman_singh',
       'kume_no_heinai-do',
       'kumbia_kings_live',
       'kumkum_the_dancer',
       'kumbo_strikers_fc',
       'kumasi_city_mall',
       'kumbia_all_starz',
       'kumar_deepak_das',
       'kumai_tea_garden',
       'kumharon_ka_bass',
       'kumar_sankar_ray',
       'kumkol_oil_field',
       'kumtor_gold_mine',
       'kumares_c._sinha',
       'kumayl_ibn_ziyad',
       'kumbha_of_mewar',
       'kumite_1_league',
       'kumbha_ram_arya',
       'kum_kum_khanna',
       'kumar_p._barve',
       'kumho_art_hall',
       'kuma_and_panda',
       'kumba_iron_ore',
       'kumo_no_kaidan',
       'kume_no_wakame',
       'kumo_to_tulip',
       'kum_and_go'],
 'n': ['kunowo,_kuyavian-pomeranian_voivodeship',
       'kunstforum_baden-badener_versicherung',
       'kunki,_warmian-masurian_voivodeship',
       'kunming_pharmaceutical_corporation',
       'kunice,_swietokrzyskie_voivodeship',
       'kunigunde_of_brandenburg-kulmbach',
       'kunchaparthy_marremma_devastanam',
       'kunst-wet/arts-loi_metro_station',
       'kunstlerhaus_schloss_wiepersdorf',
       'kundasale_divisional_secretariat',
       'kunwarjibhai_mohanbhai_bavaliya',
       'kunavaram._uppalaguptam_mandal',
       'kunanalling,_western_australia',
       'kunming_international_academy',
       'kun_ystavyyssuhteet_solmitaan',
       'kunstnernes_frie_studieskoler',
       'kungstradgarden_metro_station',
       'kungliga_svenska_skadeplatsen',
       "kunen's_inconsistency_theorem",
       'kungoldingen_railway_station',
       'kunigami-class_patrol_vessel',
       'kundasale_electoral_district',
       'kuntillet_ajrud_inscriptions',
       'kunwar_yashwantsingh_kushwah',
       'kununurra,_western_australia',
       'kungwini_local_municipality',
       'kundala_karaneswarar_temple',
       'kunchacko_boban_filmography',
       'kunsthandlung_julius_bohler',
       'kunnakudi_venkatarama_iyer',
       'kune-vain-tale_nature_park',
       'kundana,_western_australia',
       'kunciran-serpong_toll_road',
       'kunming_medical_university',
       'kunytjanu,_south_australia',
       'kundasale_polling_division',
       'kunming_metallurgy_college',
       'kunigami_district,_okinawa',
       'kunsan_national_university',
       'kunnandarkoil_cave_temple',
       'kundi,_khyber_pakhtunkhwa',
       'kundapura_railway_station',
       'kuntzville,_west_virginia',
       'kuntighat_railway_station',
       'kundrathur_murugan_temple',
       'kundrai_vaendan_karikalan',
       'kunitsyno,_vologda_oblast',
       'kunki,_lublin_voivodeship',
       'kunigunde_of_hohenstaufen',
       'kunduz_hospital_airstrike',
       'kungari_conservation_park',
       'kuningan_botanical_garden',
       'kunhiraman_palat_candeth',
       'kunavaram,_razole_mandal',
       'kunetice_mountain_castle',
       'kungiliya_kalaya_nayanar',
       'kundzicze,_gmina_sokolka',
       'kundelungu_national_park',
       'kunice,_lodz_voivodeship',
       'kuningas_lahtee_ranskaan',
       'kuninga,_viljandi_county',
       'kunowo,_szamotuly_county',
       'kunan_poshpora_incident',
       'kunming_railway_station',
       "kunya's_bent-toed_gecko",
       'kuncice_pod_ondrejnikem',
       'kuna_crest_granodiorite',
       "kung_tayo'y_magkakalayo",
       'kungla,_saaremaa_parish',
       'kunangudi_masthan_sahib',
       'kungalv_school_shooting',
       'kunow,_zgorzelec_county',
       'kundzicze,_gmina_krynki',
       'kuneru_train_derailment',
       'kunshan_railway_station',
       'kunigunde_von_orlamunde',
       'kunowo,_stargard_county',
       'kuntu_repertory_theatre',
       'kunming_military_region',
       'kundara_railway_station',
       'kunigunde_of_rapperswil',
       'kunwar_bahadur_asthana',
       'kunow,_lubartow_county',
       'kunuri_railway_station',
       'kunigunde_of_sternberg',
       'kundala_valley_railway',
       'kunike_barina_chiefdom',
       'kunkilling_forest_park',
       'kundert_medical_clinic',
       'kunice,_slubice_county',
       'kunowo,_gryfino_county',
       'kunzang_palyul_choling',
       'kunstpfad_am_mummelsee',
       'kunzang_dekyong_wangmo',
       'kunda_park,_queensland',
       'kundasang_war_memorial',
       'kundat_djaru_community',
       'kunigunde_of_eisenberg',
       'kunpan_cultural_school',
       'kunki,_gostynin_county',
       'kuno_von_eltz-rubenach',
       'kunstkring_art_gallery',
       'kunwar_manvendra_singh',
       'kunovo,_vologda_oblast',
       'kunduz_madrassa_attack',
       'kunowo,_swidwin_county',
       'kunohe_district,_iwate',
       'kundal_shahi_language',
       'kunowo,_slupca_county',
       'kunstformen_der_natur',
       'kunani_rural_district',
       'kuninga,_parnu_county',
       'kunguma_pottu_gounder',
       'kunow,_wroclaw_county',
       'kungsbacka_piano_trio',
       'kunwar_inderjit_singh',
       'kunowo,_gostyn_county',
       'kunlun_volcanic_group',
       "kunzea_'badja_carpet'",
       'kunri_railway_station',
       'kung_blockfloten_gmbh',
       'kunyang_metro_station',
       'kungsangen_golf_club',
       'kunlun_mountain_fist',
       'kuntala_kumari_sabat',
       'kunwar_sushant_singh',
       'kuno_von_klebelsberg',
       'kunigunde_of_altdorf',
       'kunstschau_wien_1908',
       'kunnenkeril_k._jacob',
       'kunstmuseum_den_haag',
       'kunigunde_of_austria',
       'kunwar_singh_college',
       'kundi,_uttar_pradesh',
       'kunga_lotro_gyaltsen',
       'kungoy_ala-too_range',
       'kunar_cricket_ground',
       'kunigunde_of_bohemia',
       'kunduz_trauma_centre',
       'kunal_rohidas_patil',
       'kunya,_pskov_oblast',
       'kunwar_naveed_jamil',
       'kunwar_vikram_singh',
       'kunigunde_of_poland',
       'kunyang_chhish_east',
       'kunwar_khalid_yunus',
       'kunzler_and_company',
       'kunkhyen_pema_karpo',
       'kuna_srisailam_goud',
       'kunigunda_of_halych',
       'kunratice_u_cvikova',
       'kunki,_mlawa_county',
       'kunta_kinteh_island',
       'kunowo,_pila_county',
       'kun_shan_university',
       'kunwar_suresh_singh',
       'kunyu_wanguo_quantu',
       'kungens_lilla_piga',
       'kunduru_jana_reddy',
       'kundiawa_urban_llg',
       'kundah_power_house',
       'kunz_von_kaufungen',
       'kunwar_singh_tekam',
       'kunal_karan_kapoor',
       'kunst_und_kunstler',
       'kunja_bihari_meher',
       'kunjal_mata_temple',
       'kunzang_c._namgyel',
       'kuno_national_park',
       'kuno-hans_von_both',
       'kunia_camp,_hawaii',
       'kunua_blind_snake',
       'kunga_nima_lepcha',
       'kuno_von_stoffeln',
       'kunwar_singh_negi',
       'kunal_kumar_singh',
       'kunwar_danish_ali',
       'kungota_pri_ptuju',
       'kundan_singh_kush',
       'kuni_no_miyatsuko',
       'kundan_lal_gujral',
       'kunigal_stud_farm',
       'kunama_raju_palem',
       'kuncice_nad_labem',
       'kung_chae_nampla',
       'kunj_yusuf_pasha',
       'kunya,_perm_krai',
       'kunwar_bai_yadav',
       'kuno_von_steuben',
       'kuna_high_school',
       'kung_pao_chicken',
       'kuno_von_westarp',
       'kuna_de_wargandi',
       'kundan_lal_jaggi',
       'kung_mawawala_ka',
       'kung_fu_fighting',
       'kunst_and_albers',
       'kunitomo_air_gun',
       'kundiman_ng_puso',
       'kunaal_roy_kapur',
       'kung_fu_tootsie',
       'kunst_im_tunnel',
       'kung_fu_monster',
       'kung_fu_records',
       'kuno_von_moltke',
       'kune_nane_mawal',
       'kunst_og_kultur',
       'kung_fu_fighter',
       'kung_fu_mahjong',
       'kung_fu_vampire',
       'kunsan_air_base',
       'kung_fu_factory',
       'kung_fu_killers',
       'kunji_lal_meena',
       'kunji_lal_dubey',
       'kungur_ice_cave',
       'kung_karls_jakt',
       'kunua_rural_llg',
       'kung_fu_master',
       'kung_fu_killer',
       'kung_fu_palace',
       'kung_fu_zombie',
       'kung_fu_heroes',
       'kun_iam_temple',
       'kung_fu_kapers',
       'kung_fu_angels',
       'kung_fu_soccer',
       'kung_fu_jungle',
       'kung_fu_rabbit',
       'kunnam_of_elam',
       'kung_fu_ramone',
       'kung_fu_hustle',
       'kung_fu_elliot',
       'kunora_e_lures',
       'kung_fu_chaos',
       'kung_ako_ikaw',
       'kung_fu_panda',
       'kun_en_tigger',
       'kung_fu_divas',
       'kung_fu_style',
       'kung_fu_rider',
       'kun_rud_siahu',
       'kung_fu_chefs',
       'kunde_and_co',
       'kung_fu_kids',
       'kung_fu_dunk',
       'kung_fu_2100',
       'kung_fu_nuns',
       'kung_fu_bear',
       'kung_fu_film',
       'kung_fu_yoga',
       'kung_av_sand',
       'kung_fu_shoe',
       'kung_kao_po',
       'kung_fu_kid',
       'kung_fury_2',
       'kung_fu_tea',
       'kun_for_mig'],
 'o': ['kuopion_reippaan_voimistelijat',
       'kuo-kuang_motor_transportation',
       'kuomintang_islamic_insurgency',
       'kuopio_university_hospital',
       'kuolema_tekee_taiteilijan',
       'kuopio_football_stadium',
       'kuomintang_youth_league',
       'kuopio_railway_station',
       'kuo_chuan_constituency',
       'kuopio_governor_palace',
       'kuopio_school_stabbing',
       'kuopio_market_square',
       'kuokuang_power_plant',
       'kuokkel_mining_field',
       'kuomintang_in_burma',
       'kuopio_market_hall',
       'kuol_manyang_juuk',
       'kuopio_city_hall',
       'kuo_lee_chien-fu',
       'kuopio_ice_hall',
       'kuok_khoon_hong',
       'kuol_deim_kuol',
       'kuok_io_keong',
       'kuo_pao_kun',
       'kuo_yuan_ye'],
 'p': ['kupno,_kuyavian-pomeranian_voivodeship',
       "kupfmuller's_uncertainty_principle",
       'kupno,_podkarpackie_voivodeship',
       'kupiskis_district_municipality',
       'kuppiyawatta_bodhananda_thera',
       'kuperjanov_infantry_battalion',
       'kupriyanovo,_vladimir_oblast',
       'kuppuswami_naidu_veeraswami',
       'kupriyanov,_belgorod_oblast',
       'kupino,_novosibirsk_oblast',
       'kuprilya_springs_pipeline',
       'kupiteh_industrial_estate',
       'kupres,_republika_srpska',
       'kupittaa_railway_station',
       'kupka,_chernivtsi_oblast',
       'kupino,_belgorod_oblast',
       'kupen,_gabrovo_province',
       'kupat_holim_meuhedet',
       'kupin,_elblag_county',
       'kupin,_ilawa_county',
       'kupang_lrt_station',
       'kupa_e_shqiperise',
       'kupal_oil_field',
       'kupol_gold_mine',
       'kup_rural_llg'],
 'q': ['kuqa_qiuci_airport'],
 'r': ['kurowo-kolonia,_kuyavian-pomeranian_voivodeship',
       "kuratowski's_closure-complement_problem",
       'kurschners_deutscher_literatur-kalender',
       'kurschners_deutscher_gelehrten-kalender',
       'kurdistan_region-netherlands_relations',
       'kurowo-kolonia,_podlaskie_voivodeship',
       'kurdistan_region-palestine_relations',
       'kurdistan_region-slovakia_relations',
       'kuranganilmuttam_valeeswarar_temple',
       'kurdistan_region-romania_relations',
       'kurdistan_region-kuwait_relations',
       'kurmanathaswamy_temple,_srikurmam',
       'kurdistan_region-sweden_relations',
       'kurdistan_region-russia_relations',
       'kurunegala_divisional_secretariat',
       'kurow,_swietokrzyskie_voivodeship',
       'kurdistan_region-turkey_relations',
       'kurdistan_region-poland_relations',
       'kurdistan_philharmonic_orchestra',
       'kurdistan_region-spain_relations',
       'kurdistan_region-syria_relations',
       'kurdistan_democratic_party/north',
       'kurdish_revolutionary_hezbollah',
       'kurur_neelakandan_namboodiripad',
       'kuruvita_divisional_secretariat',
       'kurdwanow,_masovian_voivodeship',
       'kurkowo,_pomeranian_voivodeship',
       "kuroko's_basketball_discography",
       'kurkowo,_podlaskie_voivodeship',
       'kurdistan_football_association',
       'kurowice,_masovian_voivodeship',
       'kurumoch_international_airport',
       'kurowo,_pomeranian_voivodeship',
       'kurunegala_electoral_district',
       'kuruvathi_basaveshwara_temple',
       'kurdistan_regional_government',
       'kurdistan_revolutionary_party',
       'kurpie,_podlaskie_voivodeship',
       'kurowo,_podlaskie_voivodeship',
       'kurnool_municipal_corporation',
       'kurzweil_educational_systems',
       'kurrajong,_western_australia',
       'kurdistan_conservative_party',
       'kurikoma_quasi-national_park',
       'kurrawang,_western_australia',
       'kuropatnyky,_ternopil_oblast',
       'kurumbapatti_zoological_park',
       'kurunegala_municipal_council',
       'kurt_von_hammerstein-equord',
       'kurunegala_polling_division',
       'kurnalpi,_western_australia',
       'kurukopru_monumental_church',
       'kurigram_government_college',
       'kurdistan_national_congress',
       'kuruppinte_kanakku_pustakom',
       'kuraszkow,_lodz_voivodeship',
       'kurchenko,_astrakhan_oblast',
       'kurdistan_region_parliament',
       'kurrimine_beach,_queensland',
       'kuraszewo,_gmina_kleszczele',
       'kuressaare,_viljandi_county',
       'kuryu_rakusen-en_sanatorium',
       'kurdistan_communities_union',
       'kurashiki_sakuyo_university',
       'kuragino-kyzyl_railway_line',
       'kurunjang_secondary_college',
       'kuraneh,_sumay-ye_beradust',
       'kurunduwatta_royal_college',
       'kurzacze,_ostrowiec_county',
       'kurunegala_railway_station',
       'kurdish_heritage_institute',
       'kurowice,_lodz_voivodeship',
       'kurdistan_democratic_party',
       'kuresoi_north_constituency',
       'kury,_masovian_voivodeship',
       'kurdistan_islamic_movement',
       'kuresoi_south_constituency',
       'kurdish_tribal_association',
       'kurt_vonnegut_bibliography',
       'kurbatovo,_voronezh_oblast',
       "kurashina_sensei's_passion",
       'kuragino,_krasnoyarsk_krai',
       'kurmanji_kurdish_wikipedia',
       'kurovskoye,_vologda_oblast',
       'kurmodanga_railway_station',
       'kuroshio_current_intrusion',
       'kurai,_khyber_pakhtunkhwa',
       'kuratowski_closure_axioms',
       'kurskoye,_belgorod_oblast',
       'kurian_john_melamparambil',
       'kurokawa_district,_miyagi',
       'kurtoglu_muslihiddin_reis',
       'kurmangazy,_atyrau_region',
       'kurbatovo,_vologda_oblast',
       'kurjenrahka_national_park',
       'kuryanovo_railway_station',
       'kurihara_district,_miyagi',
       'kurowko,_przasnysz_county',
       'kurovskoye,_moscow_oblast',
       'kurtna,_laane-viru_county',
       'kurdish_supreme_committee',
       'kurdish_national_council',
       'kurowo,_przasnysz_county',
       'kurskaya,_stavropol_krai',
       'kursalon,_sklene_teplice',
       'kursk_submarine_disaster',
       'kurna,_laane-viru_county',
       'kurdistan_premier_league',
       'kurukshetra_shiva_temple',
       "kurdistan_toilers'_party",
       "kurdistan_workers'_party",
       'kurate_district,_fukuoka',
       'kuril_islands_earthquake',
       'kurihara_tamachi_station',
       'kurimetsa_nature_reserve',
       'kurian_mathew_vayalunkal',
       'kursi,_laane-viru_county',
       'kuryly,_bialystok_county',
       'kurzacze,_konskie_county',
       'kurnool_revenue_division',
       'kurmahat_railway_station',
       'kuressaare_sports_centre',
       'kurtheater_bad_kissingen',
       'kuroshabad_brick_company',
       'kurtalan_railway_station',
       "kurdistan_women's_league",
       'kurt_olssons_julkalender',
       'kuriakose_elias_chavara',
       'kurhani_railway_station',
       'kurin,_volgograd_oblast',
       'kurissery_gopala_pillai',
       'kurdistan_justice_group',
       'kurow,_belchatow_county',
       'kurrajong_heights_hotel',
       'kurdish_american_caucus',
       'kurdeh,_razavi_khorasan',
       'kuru,_laane-viru_county',
       'kuru-kol_forest_reserve',
       'kurzeme_planning_region',
       'kurt-bertram_von_doring',
       'kuria_east_constituency',
       'kuria_west_constituency',
       'kurgan_state_university',
       'kurdistan_freedom_party',
       'kurgeh,_west_azerbaijan',
       'kurnool_medical_college',
       'kurushima_kaikyo_bridge',
       'kuramey_vadhaaee_salaam',
       'kurier_fur_niederbayern',
       'kurdistan_islamic_union',
       'kurki,_kozienice_county',
       'kurosh_subgroup_theorem',
       'kurhaus_of_scheveningen',
       'kurtna,_ida-viru_county',
       'kursk_vostochny_airport',
       'kurdistan_freedom_hawks',
       'kurakhove_power_station',
       'kurki,_dzialdowo_county',
       'kurita_water_industries',
       'kurt_julius_isselbacher',
       'kurdish_studies_network',
       'kuridala_township_site',
       'kuranda_scenic_railway',
       'kurunegala_clock_tower',
       'kurashiki_city_college',
       'kurevere,_valga_county',
       'kurhaus_of_baden-baden',
       'kura_bolagh,_chaypareh',
       'kurdish_textile_museum',
       'kurunegala_train_crash',
       'kurista,_jogeva_county',
       'kurowo,_koscian_county',
       "kuroiwa's_ground_gecko",
       'kurma_venu_gopalaswamy',
       'kurigalu_saar_kurigalu',
       'kurniawan_dwi_yulianto',
       'kuromajo-san_ga_toru!!',
       'kurisu,_hiiumaa_parish',
       'kurisoo_nature_reserve',
       'kurki,_gmina_szczuczyn',
       'kurt_kankan_spellmeyer',
       'kursk_state_university',
       'kurigram_sadar_upazila',
       'kurzweil_music_systems',
       'kurzeme_district,_riga',
       'kuruman_moffat_mission',
       'kurevere,_saare_county',
       'kurevere,_harju_county',
       'kuryly,_sokolka_county',
       'kurevere,_laane_county',
       'kuran,_east_azerbaijan',
       "kurd's_heritage_museum",
       'kuruva_gorantla_madhav',
       'kursk_magnetic_anomaly',
       'kurevere,_rapla_county',
       'kuraszewo,_gmina_czyze',
       'kurowo_railway_station',
       'kuraby_railway_station',
       'kurraba_and_kirribilli',
       'kurita_district,_shiga',
       'kurowko,_sierpc_county',
       'kurwa_railway_station',
       'kurt_harald_isenstein',
       'kurkino,_kursk_oblast',
       'kuritsa,_kursk_oblast',
       'kurli,_andhra_pradesh',
       'kurecik_radar_station',
       'kurt_martti_wallenius',
       'kurt_julius_goldstein',
       'kurt_walter_bachstitz',
       "kurochkin's_pygmy_owl",
       'kuran,_north_khorasan',
       'kurz_corruption_probe',
       'kurgan,_kurgan_oblast',
       'kurt_frederick_ludwig',
       'kuranda_national_park',
       'kurista,_tartu_county',
       'kurki,_olsztyn_county',
       'kurds_in_turkmenistan',
       'kuratau_power_station',
       'kurung_kumey_district',
       'kurdish_islamic_front',
       'kuroshima_and_taijima',
       'kurdish_dialog_center',
       'kuru,_ida-viru_county',
       'kurdish_sign_language',
       'kurla_railway_station',
       'kurt_adolf_monnington',
       'kuria_railway_station',
       'kurahashi_tameike_dam',
       'kurils_nature_reserve',
       'kurana,_uttar_pradesh',
       'kurowo,_sierpc_county',
       'kurpark_bad_bellingen',
       'kureh_darreh-ye_sofla',
       'kurt_von_tippelskirch',
       'kurland,_western_cape',
       'kuril_islands_dispute',
       'kursi,_jogeva_county',
       'kurt_joachim_fischer',
       'kurleigh_gittens_jr.',
       'kur_cheshmeh,_qazvin',
       'kurobe_senyo_railway',
       'kurds_in_switzerland',
       'kurt_georg_kiesinger',
       'kurt_gustav_wilckens',
       'kurdish_news_network',
       'kurt_von_schmalensee',
       'kurohama_shell_mound',
       'kureh_darreh-ye_olya',
       'kurt_laurenz_metzler',
       'kurkino,_tula_oblast',
       'kurka_rural_district',
       'kur_shurab-e_alishah',
       'kurmangazy_oil_field',
       'kuroda_puppet_troupe',
       'kurki,_gmina_grajewo',
       'kurdish_united_front',
       'kurri_kurri_bulldogs',
       'kurtna,_harju_county',
       'kure_software_koubou',
       'kurobe_gorge_railway',
       'kursaal_of_algeciras',
       'kurt_edward_fishback',
       'kurtna_lake_district',
       'kurt_dietmar_richter',
       'kurt_otto_friedrichs',
       'kurt_von_plettenberg',
       'kurau_phantom_memory',
       'kuri_railway_station',
       'kurdish_red_crescent',
       'kurow,_wielun_county',
       'kurosawa_film_studio',
       'kurt_hugo_schneider',
       'kuri_rural_district',
       'kurt_rudolf_fischer',
       'kurds_in_azerbaijan',
       'kuran,_bandar_abbas',
       'kurmitola_golf_club',
       'kurow,_konin_county',
       'kur_bolagh,_ardabil',
       'kurt_albert_gerlach',
       'kurnool_feeder_road',
       'kura_hulanda_museum',
       'kurt_heinrich_meyer',
       'kursi,_harju_county',
       'kurt_van_raefelghem',
       'kurup_of_travancore',
       'kurki,_mlawa_county',
       'kurnool_train_crash',
       'kuron_peace_village',
       'kurgan,_amur_oblast',
       'kurds_in_kazakhstan',
       'kurtoglu_hizir_reis',
       'kurow,_lukow_county',
       'kure_naval_district',
       'kuril_ainu_language',
       'kurt_c._schlichting',
       'kurt_heinrich_wolff',
       'kurd_lasswitz_award',
       'kurow,_sucha_county',
       'kurna,_harju_county',
       'kurow,_kutno_county',
       'kurtkoy_high_school',
       'kurt_von_priesdorff',
       'kurnool_bus_station',
       'kurt_maschler_award',
       'kurt_von_schleicher',
       'kuroda_normal_form',
       'kuranda_range_road',
       'kurt_w._rothschild',
       'kural_peedam_award',
       'kuruwita_army_camp',
       'kurenai_no_tsubasa',
       'kuron,_south_sudan',
       'kurt_herbert_adler',
       'kur_bolagh-e_sofla',
       'kurokawa_gold_mine',
       'kurgan_oblast_duma',
       'kura_kaupapa_maori',
       'kure_naval_arsenal',
       'kurt_bryan_barbosa',
       'kurt_e._armbruster',
       'kurube_kanga_ruins',
       'kurt_hermann_thoma',
       'kurt_d._engelhardt',
       'kurt_von_falkowski',
       'kurds_in_palestine',
       'kurt_detlev_moller',
       'kurt_walter_leucht',
       'kurobe_dam_station',
       'kurt_godel_society',
       'kurokishi_no_kamen',
       'kura_bolagh,_showt',
       'kurt_karl_eberlein',
       'kurd_von_mosengeil',
       'kurso_de_esperanto',
       'kurt_peter_larsen',
       'kuroneko_no_tango',
       'kurt_and_courtney',
       'kurkir_ibn_justan',
       'kur_river,_russia',
       'kurd_von_schlozer',
       'kursk,_altai_krai',
       'kurt_asle_arvesen',
       'kurage_no_shokudo',
       'kurds_of_khorasan',
       'kurt_vonnegut_sr.',
       'kurt_weill_centre',
       'kurt_f._reinhardt',
       'kurt_eberling_sr.',
       'kurana,_sri_lanka',
       'kurd_von_schoning',
       'kurds_in_pakistan',
       'kurt_von_kleefeld',
       'kurt_joachim_lauk',
       'kurgan,_perm_krai',
       'kurt_von_holleben',
       'kuru_kuru_kururin',
       'kurtz_and_friends',
       'kurt_koffka_medal',
       'kurt_chew-een_lee',
       'kurai_onrum_illai',
       'kurds_in_istanbul',
       'kurd_mehmed_pasha',
       'kurimska_nova_ves',
       'kurds_in_belgium',
       'kurenai_no_tsuki',
       'kurds_in_georgia',
       'kure_v_hodinkach',
       'kurds_in_romania',
       'kurt_a._mccammon',
       'kurt_m._campbell',
       'kurds_in_lebanon',
       'kurt_von_wessely',
       'kurobe_cable_car',
       'kurt_w._petersen',
       'kurt_von_briesen',
       'kur_bolagh-e_yek',
       'kurds_in_armenia',
       'kure_kure_takora',
       'kurtis_sport_car',
       'kurds_in_finland',
       'kurt_oscar_weber',
       'kurt_von_fischer',
       'kurt_m._granberg',
       'kurz_and_allison',
       'kurito_ole_kisio',
       'kurds_in_ukraine',
       'kurt_w._schuller',
       'kurds_in_germany',
       'kurds_in_denmark',
       'kurogane_type_95',
       'kurt_s._browning',
       'kurram_tangi_dam',
       'kursi_aur_qanoon',
       'kurtis_t._wilder',
       'kurds_in_russia',
       'kurds_in_norway',
       'kuran_wa_munjan',
       'kurds_in_jordan',
       'kurt_w._fischer',
       'kurt_l._sonntag',
       'kurt_st._thomas',
       'kuri_jan,_gilan',
       'kurt_ahrens_jr.',
       'kurt_von_trojan',
       'kurt_van_dooren',
       'kurt_r._eissler',
       'kurds_in_turkey',
       'kurt_von_gehlen',
       'kurds_in_france',
       'kurd_fuad_pasha',
       'kurt_von_muhlen',
       'kurds_in_sweden',
       'kurt_von_ruffin',
       'kurki_of_laukko',
       'kurt_van_haaren',
       'kurds_in_israel',
       'kur_bolagh-e_do',
       'kurds_in_greece',
       'kurti_and_doyle',
       'kur_gaz-e_bala',
       'kurt_max_runte',
       'kurt_h._becker',
       'kurds_in_japan',
       'kurt_age_kadiu',
       'kurmuk_qakh_fk',
       'kuro_no_tenshi',
       'kurds_in_syria',
       'kurt_vid_stein',
       'kurt_becker_kg',
       'kurt_von_fritz',
       'kurt_e._kimmel',
       'kurt_a._korber',
       'kur_ec5_class',
       'kurt_von_behr',
       'kur_ec1_class',
       'kurt_von_hess',
       'kurot_sa_puso',
       'kurds_in_iraq',
       'kur_ed1_class',
       'kurds_in_iran',
       'kur_ec3_class',
       'kurt_h._debus',
       'kur_ec4_class',
       'kur_ec2_class',
       'kurt_von_arx',
       'kurt_e._koch',
       'kurt_w._tidd',
       'kur_ea_class',
       'kur_ec_class',
       'kurt_j._ryan',
       'kurt_de_luis',
       'kurt_and_sid'],
 's': ['kusowo,_kuyavian-pomeranian_voivodeship',
       'kushinagar_international_airport',
       'kushiro-shitsugen_national_park',
       'kustom_karnal_blackxploitation',
       'kusowo,_pomeranian_voivodeship',
       'kusumbai_motichand_planetarium',
       'kushtia_polytechnic_institute',
       "kusumanegara_heroes'_cemetery",
       'kushmandi_government_college',
       'kushmandi,_dakshin_dinajpur',
       'kushaverskoye_peat_railway',
       'kuscenneti_railway_station',
       'kushiro_district,_hokkaido',
       'kuscuburun_railway_station',
       'kushkabad,_razavi_khorasan',
       'kusukuntla_prabhakar_reddy',
       'kushtia_government_college',
       'kushkabad,_south_khorasan',
       'kusanagi_athletic_stadium',
       'kushwaha_shivpujan_mehta',
       'kushkan,_razavi_khorasan',
       'kushe_rural_municipality',
       'kushkak,_razavi_khorasan',
       'kushk-e_khaleseh-ye_bala',
       'kushk-e_khaleseh-ye_pain',
       'kushaldeep_singh_dhillon',
       'kusadak_railway_station',
       'kushtia_medical_college',
       'kushkak,_south_khorasan',
       'kusebko_larere_festival',
       'kussam_railway_station',
       'kustav_aleksander_kurg',
       'kushiro_junior_college',
       'kushk,_east_azerbaijan',
       'kusalan_rural_district',
       'kusheh,_south_khorasan',
       'kushok_bakula_rinpoche',
       'kushki,_north_khorasan',
       'kusakaru_ueda_holdings',
       'kusamono_and_shitakusa',
       'kusatsu_special_prison',
       'kushk_talkh-e_darghak',
       'kushabhau_thakre_marg',
       'kusnul_yuli_kurniawan',
       'kushk-e_sofla,_kerman',
       'kushki_kuhna_district',
       'kusalar,_khoda_afarin',
       'kushtia_sadar_upazila',
       'kushki,_pol-e_dokhtar',
       'kushaba_moses_mworeko',
       'kuseh,_north_khorasan',
       'kushk,_south_khorasan',
       'kushk-e_olya,_kerman',
       'kushmore_house_gecko',
       'kushk-e_nar_district',
       'kusile_power_station',
       'kushtia_zilla_school',
       'kushiro_sotokan_road',
       'kushk_rural_district',
       'kushok_chimey_luding',
       'kushan-e_mirza_rahim',
       'kusadasi_clock_tower',
       'kustom_kar_kommandos',
       'kuse_district,_kyoto',
       'kuso_kagaku_dokuhon',
       'kuso_miso_technique',
       'kusalar,_owch_hacha',
       'kushal_konwar_sarma',
       'kushal_singh_dahiya',
       'kushk-e_sofla,_fars',
       'kusgaon_pawan_mawal',
       'kusu_district,_oita',
       'kusanagi_no_tsurugi',
       'kusma,_tartu_county',
       'kushedya_hari_yudo',
       'kusma,_voru_county',
       'kusaka_shell_mound',
       'kuseh,_shahin_dezh',
       'kushk-e_pas_qalat',
       'kushiro_ice_arena',
       'kushiro_coal_mine',
       'kusic,_bela_crkva',
       'kusel_autumn_fair',
       'kusuma_negara_iii',
       'kusum_forest_park',
       'kushal_pal_singh',
       'kushk-e_sar_tang',
       'kusum_kusum_prem',
       'kushk-e_aqa_jan',
       'kusha_las_payas',
       'kusume_rumal_2'],
 't': ['kuty,_warmian-masurian_voivodeship',
       'kutaisi_international_university',
       'kuthur_ramakrishnan_srinivasan',
       'kuttikkattoor_and_velliparamba',
       'kutahya_dumlupinar_university',
       'kuthiravattam_mental_hospital',
       'kuttippuram_block_panchayat',
       'kuttippuram_railway_station',
       'kutahya_archaeology_museum',
       'kut-e_abdollah,_khuzestan',
       'kutai_kartanegara_regency',
       'kutsal_damacana:_dracoola',
       'kuttipuzha_krishna_pillai',
       'kutt_calhoun_discography',
       'kutubi_muhammed_musliyar',
       'kutahya_train_derailment',
       "kutsher's_sports_academy",
       'kutai_kartanegara_bridge',
       'kutilovo,_vologda_oblast',
       'kutabpur_railway_station',
       'kuti,_laane-viru_county',
       'kutno_operational_group',
       'kutahya_railway_station',
       'kutch_bustard_sanctuary',
       'kutupalong_refugee_camp',
       'kuthond,_uttar_pradesh',
       'kutbal_railway_station',
       "kutsher's_camp_anawana",
       'kutcher_string_quartet',
       'kutol_products_company',
       'kutch_gurjar_kshatriya',
       'kutki,_voronezh_oblast',
       'kutak-e_mohammad_karim',
       'kutepova,_kursk_oblast',
       'kutty_kunju_thankachi',
       'kutaisi_city_assembly',
       'kutno_railway_station',
       'kutuleh-ye_baba_karam',
       'kutiah_lungma_glacier',
       'kuty,_ternopil_oblast',
       'kutikuppala_surya_rao',
       'kuttumuck_siva_temple',
       'kutztown_golden_bears',
       'kuttiyadi_saddle_dam',
       'kut_khaopun_district',
       'kutuleh-ye_aziz_khan',
       'kutub_ahmed_mazumder',
       'kutlug_timur_minaret',
       'kutak_rural_district',
       'kutz_memorial_bridge',
       'kutna_hora_district',
       'kutluk_yabgu_khagan',
       'kut-e_seyyed_enayat',
       'kutini_boulder_frog',
       'kutno_rose_festival',
       'kut-e_seyyed_soltan',
       'kutai_national_park',
       'kutman_wine_museum',
       'kutubdia_gas_field',
       'kut-e_seyyed_saleh',
       "kutz's_mill_bridge",
       'kutak-e_jajji_aqa',
       'kuti,_herceg_novi',
       'kut_chum_district',
       'kuta_reh_massacre',
       'kut_chap_district',
       'kut_rang_district',
       'kuta_church_ruins',
       'kut-e_seyyed_naim',
       'kutahya_air_base',
       'kut_bak_district',
       'kutlu_o._ulgen',
       'kutu_ma_kutu'],
 'u': ['kuusiku,_saaremaa_parish',
       'kuura,_laane-viru_county',
       'kuururjuaq_national_park',
       'kuuk_thaayorre_language',
       'kuusinen_club_incident',
       'kuusiku,_tartu_county',
       'kuusiku,_hiiu_county',
       'kuura,_voru_county',
       'kuuk_yak_language',
       'kuu_kuu_harajuku',
       'kuum_ni_airport',
       'kuusalu_jk_rada'],
 'v': ['kuveni_2:_yakshadeshaya',
       'kuvandyksky_urban_okrug',
       'kuvayi_milliye_dernegi',
       'kuva_kuva_vaathugal',
       'kuvend_of_dukagjin',
       'kuva,_perm_krai'],
 'w': ['kuwait_petroleum_international',
       'kuwait-united_states_relations',
       'kuwait-saudi_arabia_relations',
       'kuwait_basketball_association',
       'kuwait_petroleum_corporation',
       'kuwait_international_airport',
       'kuwaiti_progressive_movement',
       'kuwait_investment_authority',
       'kuwait_handball_association',
       'kuwait_football_association',
       'kuwait_international_rally',
       'kuwait-saudi_arabia_border',
       'kuwait_medical_association',
       'kuwait_international_bank',
       'kuwait_international_fair',
       'kuwait_entertainment_city',
       'kuwait_university_stadium',
       "kuwait's_fourth_district",
       "kuwait's_second_district",
       'kuwaiti_family_committee',
       'kuwait_squash_federation',
       'kuwait_olympic_committee',
       'kuwait_technical_college',
       'kuwait_scientific_center',
       'kuwamura_district,_ehime',
       'kuwait_economic_society',
       "kuwait's_first_district",
       "kuwait's_fifth_district",
       "kuwait's_third_district",
       'kuwaiti_nationality_law',
       'kuwait_democratic_forum',
       'kuwait_liberation_medal',
       'kuwait_national_stadium',
       "kuwaiti_women's_league",
       'kuwait_military_forces',
       'kuwait_national_museum',
       'kuwaiti_identity_card',
       'kuwaiti_futsal_league',
       'kuwait_premier_league',
       'kuwait_federation_cup',
       'kuwaiti_sign_language',
       'kuwait_english_school',
       'kuwait_national_guard',
       'kuwait_finance_house',
       'kuwana_district,_mie',
       'kuwaiti_division_one',
       'kuwaiti_minimum_wage',
       'kuwait_hockey_league',
       'kuwait_space_rocket',
       'kuwait_joint_league',
       'kuwait_water_towers',
       'kuwayama_art_museum',
       'kuwait_naval_force',
       'kuwait_news_agency',
       'kuwait_oil_company',
       'kuwaiti_el_clasico',
       'kuwaiti_oil_fires',
       'kuwait_naval_base',
       'kuwait_motor_town',
       'kuwait_air_force',
       'kuwait_super_cup',
       'kuwait_emir_cup',
       'kuwait_red_fort',
       'kuwait_psa_cup'],
 'y': ['kuyavian-pomeranian_regional_assembly',
       'kuybyshevsky_district,_russia',
       'kuybyshev,_novosibirsk_oblast',
       'kuyunba_conservation_reserve',
       'kuybyshev,_volgograd_oblast',
       'kuybyshevo,_rostov_oblast',
       'kuykendall_polygonal_barn',
       'kuy-e_shahid_beheshti',
       'kuy-e_rowshan_shahr',
       'kuyuluk_nature_park',
       'kuyucu_murad_pasha',
       'kuy-e_vali_aser',
       'kuy-e_rah-e_haq'],
 'z': ['kuzniki,_kuyavian-pomeranian_voivodeship',
       'kuznica,_kuyavian-pomeranian_voivodeship',
       'kuznice,_kuyavian-pomeranian_voivodeship',
       'kuznice,_swietokrzyskie_voivodeship',
       'kuznetsov-class_aircraft_carrier',
       'kuzyaka-bucak_merkezi,_kastamonu',
       'kuzminec,_krapina-zagorje_county',
       'kuzniczka,_silesian_voivodeship',
       'kuznica,_pomeranian_voivodeship',
       'kuznica,_podlaskie_voivodeship',
       'kuznocin,_masovian_voivodeship',
       'kuzhandhaigal_kanda_kudiyarasu',
       'kuznik,_pomeranian_voivodeship',
       'kuznica,_masovian_voivodeship',
       'kuznica,_silesian_voivodeship',
       'kuznetsovsky,_voronezh_oblast',
       'kuzniczka,_opole_voivodeship',
       'kuzbassugol_building_complex',
       'kuzie,_podlaskie_voivodeship',
       'kuznia,_masovian_voivodeship',
       'kuzhivelipady_muslim_jamaath',
       'kuznetsov,_volgograd_oblast',
       'kuzmy,_masovian_voivodeship',
       'kuznetsovka,_vologda_oblast',
       'kuzmice,_topolcany_district',
       'kuznetsovo,_vladimir_oblast',
       'kuzehgaran,_west_azerbaijan',
       'kuznica,_opole_voivodeship',
       'kuzminka,_volgograd_oblast',
       'kuznocin,_lodz_voivodeship',
       'kuznik,_lubusz_voivodeship',
       'kuzmice,_trebisov_district',
       'kuzhithura_railway_station',
       'kuznica,_gmina_sulmierzyce',
       'kuzhanthai_velappar_temple',
       'kuznetsy,_vladimir_oblast',
       'kuznica,_radomsko_county',
       'kuzomen,_murmansk_oblast',
       'kuzkin,_volgograd_oblast',
       'kuznetsovo,_amur_oblast',
       'kuzuha,_hirakata,_osaka',
       'kuznetsov_trace_formula',
       'kuznica_railway_station',
       'kuznetsov_naval_academy',
       'kuznetsov_design_bureau',
       'kuzmy,_lodz_voivodeship',
       'kuznica,_wielun_county',
       'kuznetsovo,_altai_krai',
       'kuzman_josifovski_pitu',
       'kuzhikalail_m._abraham',
       'kuznica,_gmina_rusiec',
       'kuznetsky_alatau_mine',
       'kuzhur_narayana_marar',
       'kuzey_kibris_turkcell',
       'kuznya_na_rybalskomu',
       'kuzminka,_altai_krai',
       'kuznica,_gmina_zelow',
       'kuzminka,_perm_krai',
       'kuzure_kesa_gatame',
       'kuzmina,_perm_krai',
       'kuzeh_garan,_gilan',
       'kuz_kunar_district',
       'kuzyk_quantum_gap',
       'kuzych_v_white']}
