/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementGatewayApiConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#api_id ApiManagementGatewayApi#api_id}
    */
    readonly apiId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#gateway_id ApiManagementGatewayApi#gateway_id}
    */
    readonly gatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#id ApiManagementGatewayApi#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#timeouts ApiManagementGatewayApi#timeouts}
    */
    readonly timeouts?: ApiManagementGatewayApiTimeouts;
}
export interface ApiManagementGatewayApiTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#create ApiManagementGatewayApi#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#delete ApiManagementGatewayApi#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#read ApiManagementGatewayApi#read}
    */
    readonly read?: string;
}
export declare function apiManagementGatewayApiTimeoutsToTerraform(struct?: ApiManagementGatewayApiTimeouts | cdktf.IResolvable): any;
export declare function apiManagementGatewayApiTimeoutsToHclTerraform(struct?: ApiManagementGatewayApiTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementGatewayApiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementGatewayApiTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementGatewayApiTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api azurerm_api_management_gateway_api}
*/
export declare class ApiManagementGatewayApi extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_gateway_api";
    /**
    * Generates CDKTF code for importing a ApiManagementGatewayApi resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementGatewayApi to import
    * @param importFromId The id of the existing ApiManagementGatewayApi that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementGatewayApi to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/api_management_gateway_api azurerm_api_management_gateway_api} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementGatewayApiConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementGatewayApiConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    get apiIdInput(): string | undefined;
    private _gatewayId?;
    get gatewayId(): string;
    set gatewayId(value: string);
    get gatewayIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementGatewayApiTimeoutsOutputReference;
    putTimeouts(value: ApiManagementGatewayApiTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementGatewayApiTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
