/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#automation_account_name AutomationModule#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#id AutomationModule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#name AutomationModule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#resource_group_name AutomationModule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * module_link block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#module_link AutomationModule#module_link}
    */
    readonly moduleLink: AutomationModuleModuleLink;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#timeouts AutomationModule#timeouts}
    */
    readonly timeouts?: AutomationModuleTimeouts;
}
export interface AutomationModuleModuleLinkHash {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#algorithm AutomationModule#algorithm}
    */
    readonly algorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#value AutomationModule#value}
    */
    readonly value: string;
}
export declare function automationModuleModuleLinkHashToTerraform(struct?: AutomationModuleModuleLinkHashOutputReference | AutomationModuleModuleLinkHash): any;
export declare function automationModuleModuleLinkHashToHclTerraform(struct?: AutomationModuleModuleLinkHashOutputReference | AutomationModuleModuleLinkHash): any;
export declare class AutomationModuleModuleLinkHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationModuleModuleLinkHash | undefined;
    set internalValue(value: AutomationModuleModuleLinkHash | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface AutomationModuleModuleLink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#uri AutomationModule#uri}
    */
    readonly uri: string;
    /**
    * hash block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#hash AutomationModule#hash}
    */
    readonly hash?: AutomationModuleModuleLinkHash;
}
export declare function automationModuleModuleLinkToTerraform(struct?: AutomationModuleModuleLinkOutputReference | AutomationModuleModuleLink): any;
export declare function automationModuleModuleLinkToHclTerraform(struct?: AutomationModuleModuleLinkOutputReference | AutomationModuleModuleLink): any;
export declare class AutomationModuleModuleLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationModuleModuleLink | undefined;
    set internalValue(value: AutomationModuleModuleLink | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _hash;
    get hash(): AutomationModuleModuleLinkHashOutputReference;
    putHash(value: AutomationModuleModuleLinkHash): void;
    resetHash(): void;
    get hashInput(): AutomationModuleModuleLinkHash | undefined;
}
export interface AutomationModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#create AutomationModule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#delete AutomationModule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#read AutomationModule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#update AutomationModule#update}
    */
    readonly update?: string;
}
export declare function automationModuleTimeoutsToTerraform(struct?: AutomationModuleTimeouts | cdktf.IResolvable): any;
export declare function automationModuleTimeoutsToHclTerraform(struct?: AutomationModuleTimeouts | cdktf.IResolvable): any;
export declare class AutomationModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationModuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationModuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module azurerm_automation_module}
*/
export declare class AutomationModule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_module";
    /**
    * Generates CDKTF code for importing a AutomationModule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationModule to import
    * @param importFromId The id of the existing AutomationModule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationModule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/automation_module azurerm_automation_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationModuleConfig
    */
    constructor(scope: Construct, id: string, config: AutomationModuleConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _moduleLink;
    get moduleLink(): AutomationModuleModuleLinkOutputReference;
    putModuleLink(value: AutomationModuleModuleLink): void;
    get moduleLinkInput(): AutomationModuleModuleLink | undefined;
    private _timeouts;
    get timeouts(): AutomationModuleTimeoutsOutputReference;
    putTimeouts(value: AutomationModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
