/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotChannelWebChatConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#bot_name BotChannelWebChat#bot_name}
    */
    readonly botName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#id BotChannelWebChat#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#location BotChannelWebChat#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#resource_group_name BotChannelWebChat#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#site_names BotChannelWebChat#site_names}
    */
    readonly siteNames?: string[];
    /**
    * site block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#site BotChannelWebChat#site}
    */
    readonly site?: BotChannelWebChatSite[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#timeouts BotChannelWebChat#timeouts}
    */
    readonly timeouts?: BotChannelWebChatTimeouts;
}
export interface BotChannelWebChatSite {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#endpoint_parameters_enabled BotChannelWebChat#endpoint_parameters_enabled}
    */
    readonly endpointParametersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#name BotChannelWebChat#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#storage_enabled BotChannelWebChat#storage_enabled}
    */
    readonly storageEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#user_upload_enabled BotChannelWebChat#user_upload_enabled}
    */
    readonly userUploadEnabled?: boolean | cdktf.IResolvable;
}
export declare function botChannelWebChatSiteToTerraform(struct?: BotChannelWebChatSite | cdktf.IResolvable): any;
export declare function botChannelWebChatSiteToHclTerraform(struct?: BotChannelWebChatSite | cdktf.IResolvable): any;
export declare class BotChannelWebChatSiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BotChannelWebChatSite | cdktf.IResolvable | undefined;
    set internalValue(value: BotChannelWebChatSite | cdktf.IResolvable | undefined);
    private _endpointParametersEnabled?;
    get endpointParametersEnabled(): boolean | cdktf.IResolvable;
    set endpointParametersEnabled(value: boolean | cdktf.IResolvable);
    resetEndpointParametersEnabled(): void;
    get endpointParametersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageEnabled?;
    get storageEnabled(): boolean | cdktf.IResolvable;
    set storageEnabled(value: boolean | cdktf.IResolvable);
    resetStorageEnabled(): void;
    get storageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _userUploadEnabled?;
    get userUploadEnabled(): boolean | cdktf.IResolvable;
    set userUploadEnabled(value: boolean | cdktf.IResolvable);
    resetUserUploadEnabled(): void;
    get userUploadEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class BotChannelWebChatSiteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BotChannelWebChatSite[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BotChannelWebChatSiteOutputReference;
}
export interface BotChannelWebChatTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#create BotChannelWebChat#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#delete BotChannelWebChat#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#read BotChannelWebChat#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#update BotChannelWebChat#update}
    */
    readonly update?: string;
}
export declare function botChannelWebChatTimeoutsToTerraform(struct?: BotChannelWebChatTimeouts | cdktf.IResolvable): any;
export declare function botChannelWebChatTimeoutsToHclTerraform(struct?: BotChannelWebChatTimeouts | cdktf.IResolvable): any;
export declare class BotChannelWebChatTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BotChannelWebChatTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BotChannelWebChatTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat azurerm_bot_channel_web_chat}
*/
export declare class BotChannelWebChat extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bot_channel_web_chat";
    /**
    * Generates CDKTF code for importing a BotChannelWebChat resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BotChannelWebChat to import
    * @param importFromId The id of the existing BotChannelWebChat that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BotChannelWebChat to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/bot_channel_web_chat azurerm_bot_channel_web_chat} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotChannelWebChatConfig
    */
    constructor(scope: Construct, id: string, config: BotChannelWebChatConfig);
    private _botName?;
    get botName(): string;
    set botName(value: string);
    get botNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _siteNames?;
    get siteNames(): string[];
    set siteNames(value: string[]);
    resetSiteNames(): void;
    get siteNamesInput(): string[] | undefined;
    private _site;
    get site(): BotChannelWebChatSiteList;
    putSite(value: BotChannelWebChatSite[] | cdktf.IResolvable): void;
    resetSite(): void;
    get siteInput(): cdktf.IResolvable | BotChannelWebChatSite[] | undefined;
    private _timeouts;
    get timeouts(): BotChannelWebChatTimeoutsOutputReference;
    putTimeouts(value: BotChannelWebChatTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BotChannelWebChatTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
