/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorOriginConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#cdn_frontdoor_origin_group_id CdnFrontdoorOrigin#cdn_frontdoor_origin_group_id}
    */
    readonly cdnFrontdoorOriginGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#certificate_name_check_enabled CdnFrontdoorOrigin#certificate_name_check_enabled}
    */
    readonly certificateNameCheckEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#enabled CdnFrontdoorOrigin#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#health_probes_enabled CdnFrontdoorOrigin#health_probes_enabled}
    */
    readonly healthProbesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#host_name CdnFrontdoorOrigin#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#http_port CdnFrontdoorOrigin#http_port}
    */
    readonly httpPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#https_port CdnFrontdoorOrigin#https_port}
    */
    readonly httpsPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#id CdnFrontdoorOrigin#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#name CdnFrontdoorOrigin#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#origin_host_header CdnFrontdoorOrigin#origin_host_header}
    */
    readonly originHostHeader?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#priority CdnFrontdoorOrigin#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#weight CdnFrontdoorOrigin#weight}
    */
    readonly weight?: number;
    /**
    * private_link block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#private_link CdnFrontdoorOrigin#private_link}
    */
    readonly privateLink?: CdnFrontdoorOriginPrivateLink;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#timeouts CdnFrontdoorOrigin#timeouts}
    */
    readonly timeouts?: CdnFrontdoorOriginTimeouts;
}
export interface CdnFrontdoorOriginPrivateLink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#location CdnFrontdoorOrigin#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#private_link_target_id CdnFrontdoorOrigin#private_link_target_id}
    */
    readonly privateLinkTargetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#request_message CdnFrontdoorOrigin#request_message}
    */
    readonly requestMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#target_type CdnFrontdoorOrigin#target_type}
    */
    readonly targetType?: string;
}
export declare function cdnFrontdoorOriginPrivateLinkToTerraform(struct?: CdnFrontdoorOriginPrivateLinkOutputReference | CdnFrontdoorOriginPrivateLink): any;
export declare function cdnFrontdoorOriginPrivateLinkToHclTerraform(struct?: CdnFrontdoorOriginPrivateLinkOutputReference | CdnFrontdoorOriginPrivateLink): any;
export declare class CdnFrontdoorOriginPrivateLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorOriginPrivateLink | undefined;
    set internalValue(value: CdnFrontdoorOriginPrivateLink | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _privateLinkTargetId?;
    get privateLinkTargetId(): string;
    set privateLinkTargetId(value: string);
    get privateLinkTargetIdInput(): string | undefined;
    private _requestMessage?;
    get requestMessage(): string;
    set requestMessage(value: string);
    resetRequestMessage(): void;
    get requestMessageInput(): string | undefined;
    private _targetType?;
    get targetType(): string;
    set targetType(value: string);
    resetTargetType(): void;
    get targetTypeInput(): string | undefined;
}
export interface CdnFrontdoorOriginTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#create CdnFrontdoorOrigin#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#delete CdnFrontdoorOrigin#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#read CdnFrontdoorOrigin#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#update CdnFrontdoorOrigin#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorOriginTimeoutsToTerraform(struct?: CdnFrontdoorOriginTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorOriginTimeoutsToHclTerraform(struct?: CdnFrontdoorOriginTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorOriginTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorOriginTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorOriginTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin azurerm_cdn_frontdoor_origin}
*/
export declare class CdnFrontdoorOrigin extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_origin";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorOrigin resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorOrigin to import
    * @param importFromId The id of the existing CdnFrontdoorOrigin that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorOrigin to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_origin azurerm_cdn_frontdoor_origin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorOriginConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorOriginConfig);
    private _cdnFrontdoorOriginGroupId?;
    get cdnFrontdoorOriginGroupId(): string;
    set cdnFrontdoorOriginGroupId(value: string);
    get cdnFrontdoorOriginGroupIdInput(): string | undefined;
    private _certificateNameCheckEnabled?;
    get certificateNameCheckEnabled(): boolean | cdktf.IResolvable;
    set certificateNameCheckEnabled(value: boolean | cdktf.IResolvable);
    get certificateNameCheckEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _healthProbesEnabled?;
    get healthProbesEnabled(): boolean | cdktf.IResolvable;
    set healthProbesEnabled(value: boolean | cdktf.IResolvable);
    resetHealthProbesEnabled(): void;
    get healthProbesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _httpPort?;
    get httpPort(): number;
    set httpPort(value: number);
    resetHttpPort(): void;
    get httpPortInput(): number | undefined;
    private _httpsPort?;
    get httpsPort(): number;
    set httpsPort(value: number);
    resetHttpsPort(): void;
    get httpsPortInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _originHostHeader?;
    get originHostHeader(): string;
    set originHostHeader(value: string);
    resetOriginHostHeader(): void;
    get originHostHeaderInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _privateLink;
    get privateLink(): CdnFrontdoorOriginPrivateLinkOutputReference;
    putPrivateLink(value: CdnFrontdoorOriginPrivateLink): void;
    resetPrivateLink(): void;
    get privateLinkInput(): CdnFrontdoorOriginPrivateLink | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorOriginTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorOriginTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorOriginTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
