/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#behavior_on_match CdnFrontdoorRule#behavior_on_match}
    */
    readonly behaviorOnMatch?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#cdn_frontdoor_rule_set_id CdnFrontdoorRule#cdn_frontdoor_rule_set_id}
    */
    readonly cdnFrontdoorRuleSetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#id CdnFrontdoorRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#name CdnFrontdoorRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#order CdnFrontdoorRule#order}
    */
    readonly order: number;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#actions CdnFrontdoorRule#actions}
    */
    readonly actions: CdnFrontdoorRuleActions;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#conditions CdnFrontdoorRule#conditions}
    */
    readonly conditions?: CdnFrontdoorRuleConditions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#timeouts CdnFrontdoorRule#timeouts}
    */
    readonly timeouts?: CdnFrontdoorRuleTimeouts;
}
export interface CdnFrontdoorRuleActionsRequestHeaderAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#header_action CdnFrontdoorRule#header_action}
    */
    readonly headerAction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#header_name CdnFrontdoorRule#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#value CdnFrontdoorRule#value}
    */
    readonly value?: string;
}
export declare function cdnFrontdoorRuleActionsRequestHeaderActionToTerraform(struct?: CdnFrontdoorRuleActionsRequestHeaderAction | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleActionsRequestHeaderActionToHclTerraform(struct?: CdnFrontdoorRuleActionsRequestHeaderAction | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleActionsRequestHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleActionsRequestHeaderAction | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleActionsRequestHeaderAction | cdktf.IResolvable | undefined);
    private _headerAction?;
    get headerAction(): string;
    set headerAction(value: string);
    get headerActionInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CdnFrontdoorRuleActionsRequestHeaderActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleActionsRequestHeaderAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleActionsRequestHeaderActionOutputReference;
}
export interface CdnFrontdoorRuleActionsResponseHeaderAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#header_action CdnFrontdoorRule#header_action}
    */
    readonly headerAction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#header_name CdnFrontdoorRule#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#value CdnFrontdoorRule#value}
    */
    readonly value?: string;
}
export declare function cdnFrontdoorRuleActionsResponseHeaderActionToTerraform(struct?: CdnFrontdoorRuleActionsResponseHeaderAction | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleActionsResponseHeaderActionToHclTerraform(struct?: CdnFrontdoorRuleActionsResponseHeaderAction | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleActionsResponseHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleActionsResponseHeaderAction | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleActionsResponseHeaderAction | cdktf.IResolvable | undefined);
    private _headerAction?;
    get headerAction(): string;
    set headerAction(value: string);
    get headerActionInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CdnFrontdoorRuleActionsResponseHeaderActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleActionsResponseHeaderAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleActionsResponseHeaderActionOutputReference;
}
export interface CdnFrontdoorRuleActionsRouteConfigurationOverrideAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#cache_behavior CdnFrontdoorRule#cache_behavior}
    */
    readonly cacheBehavior?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#cache_duration CdnFrontdoorRule#cache_duration}
    */
    readonly cacheDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#cdn_frontdoor_origin_group_id CdnFrontdoorRule#cdn_frontdoor_origin_group_id}
    */
    readonly cdnFrontdoorOriginGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#compression_enabled CdnFrontdoorRule#compression_enabled}
    */
    readonly compressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#forwarding_protocol CdnFrontdoorRule#forwarding_protocol}
    */
    readonly forwardingProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#query_string_caching_behavior CdnFrontdoorRule#query_string_caching_behavior}
    */
    readonly queryStringCachingBehavior?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#query_string_parameters CdnFrontdoorRule#query_string_parameters}
    */
    readonly queryStringParameters?: string[];
}
export declare function cdnFrontdoorRuleActionsRouteConfigurationOverrideActionToTerraform(struct?: CdnFrontdoorRuleActionsRouteConfigurationOverrideActionOutputReference | CdnFrontdoorRuleActionsRouteConfigurationOverrideAction): any;
export declare function cdnFrontdoorRuleActionsRouteConfigurationOverrideActionToHclTerraform(struct?: CdnFrontdoorRuleActionsRouteConfigurationOverrideActionOutputReference | CdnFrontdoorRuleActionsRouteConfigurationOverrideAction): any;
export declare class CdnFrontdoorRuleActionsRouteConfigurationOverrideActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRuleActionsRouteConfigurationOverrideAction | undefined;
    set internalValue(value: CdnFrontdoorRuleActionsRouteConfigurationOverrideAction | undefined);
    private _cacheBehavior?;
    get cacheBehavior(): string;
    set cacheBehavior(value: string);
    resetCacheBehavior(): void;
    get cacheBehaviorInput(): string | undefined;
    private _cacheDuration?;
    get cacheDuration(): string;
    set cacheDuration(value: string);
    resetCacheDuration(): void;
    get cacheDurationInput(): string | undefined;
    private _cdnFrontdoorOriginGroupId?;
    get cdnFrontdoorOriginGroupId(): string;
    set cdnFrontdoorOriginGroupId(value: string);
    resetCdnFrontdoorOriginGroupId(): void;
    get cdnFrontdoorOriginGroupIdInput(): string | undefined;
    private _compressionEnabled?;
    get compressionEnabled(): boolean | cdktf.IResolvable;
    set compressionEnabled(value: boolean | cdktf.IResolvable);
    resetCompressionEnabled(): void;
    get compressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardingProtocol?;
    get forwardingProtocol(): string;
    set forwardingProtocol(value: string);
    resetForwardingProtocol(): void;
    get forwardingProtocolInput(): string | undefined;
    private _queryStringCachingBehavior?;
    get queryStringCachingBehavior(): string;
    set queryStringCachingBehavior(value: string);
    resetQueryStringCachingBehavior(): void;
    get queryStringCachingBehaviorInput(): string | undefined;
    private _queryStringParameters?;
    get queryStringParameters(): string[];
    set queryStringParameters(value: string[]);
    resetQueryStringParameters(): void;
    get queryStringParametersInput(): string[] | undefined;
}
export interface CdnFrontdoorRuleActionsUrlRedirectAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#destination_fragment CdnFrontdoorRule#destination_fragment}
    */
    readonly destinationFragment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#destination_hostname CdnFrontdoorRule#destination_hostname}
    */
    readonly destinationHostname: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#destination_path CdnFrontdoorRule#destination_path}
    */
    readonly destinationPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#query_string CdnFrontdoorRule#query_string}
    */
    readonly queryString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#redirect_protocol CdnFrontdoorRule#redirect_protocol}
    */
    readonly redirectProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#redirect_type CdnFrontdoorRule#redirect_type}
    */
    readonly redirectType: string;
}
export declare function cdnFrontdoorRuleActionsUrlRedirectActionToTerraform(struct?: CdnFrontdoorRuleActionsUrlRedirectActionOutputReference | CdnFrontdoorRuleActionsUrlRedirectAction): any;
export declare function cdnFrontdoorRuleActionsUrlRedirectActionToHclTerraform(struct?: CdnFrontdoorRuleActionsUrlRedirectActionOutputReference | CdnFrontdoorRuleActionsUrlRedirectAction): any;
export declare class CdnFrontdoorRuleActionsUrlRedirectActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRuleActionsUrlRedirectAction | undefined;
    set internalValue(value: CdnFrontdoorRuleActionsUrlRedirectAction | undefined);
    private _destinationFragment?;
    get destinationFragment(): string;
    set destinationFragment(value: string);
    resetDestinationFragment(): void;
    get destinationFragmentInput(): string | undefined;
    private _destinationHostname?;
    get destinationHostname(): string;
    set destinationHostname(value: string);
    get destinationHostnameInput(): string | undefined;
    private _destinationPath?;
    get destinationPath(): string;
    set destinationPath(value: string);
    resetDestinationPath(): void;
    get destinationPathInput(): string | undefined;
    private _queryString?;
    get queryString(): string;
    set queryString(value: string);
    resetQueryString(): void;
    get queryStringInput(): string | undefined;
    private _redirectProtocol?;
    get redirectProtocol(): string;
    set redirectProtocol(value: string);
    resetRedirectProtocol(): void;
    get redirectProtocolInput(): string | undefined;
    private _redirectType?;
    get redirectType(): string;
    set redirectType(value: string);
    get redirectTypeInput(): string | undefined;
}
export interface CdnFrontdoorRuleActionsUrlRewriteAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#destination CdnFrontdoorRule#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#preserve_unmatched_path CdnFrontdoorRule#preserve_unmatched_path}
    */
    readonly preserveUnmatchedPath?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#source_pattern CdnFrontdoorRule#source_pattern}
    */
    readonly sourcePattern: string;
}
export declare function cdnFrontdoorRuleActionsUrlRewriteActionToTerraform(struct?: CdnFrontdoorRuleActionsUrlRewriteActionOutputReference | CdnFrontdoorRuleActionsUrlRewriteAction): any;
export declare function cdnFrontdoorRuleActionsUrlRewriteActionToHclTerraform(struct?: CdnFrontdoorRuleActionsUrlRewriteActionOutputReference | CdnFrontdoorRuleActionsUrlRewriteAction): any;
export declare class CdnFrontdoorRuleActionsUrlRewriteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRuleActionsUrlRewriteAction | undefined;
    set internalValue(value: CdnFrontdoorRuleActionsUrlRewriteAction | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _preserveUnmatchedPath?;
    get preserveUnmatchedPath(): boolean | cdktf.IResolvable;
    set preserveUnmatchedPath(value: boolean | cdktf.IResolvable);
    resetPreserveUnmatchedPath(): void;
    get preserveUnmatchedPathInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcePattern?;
    get sourcePattern(): string;
    set sourcePattern(value: string);
    get sourcePatternInput(): string | undefined;
}
export interface CdnFrontdoorRuleActions {
    /**
    * request_header_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#request_header_action CdnFrontdoorRule#request_header_action}
    */
    readonly requestHeaderAction?: CdnFrontdoorRuleActionsRequestHeaderAction[] | cdktf.IResolvable;
    /**
    * response_header_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#response_header_action CdnFrontdoorRule#response_header_action}
    */
    readonly responseHeaderAction?: CdnFrontdoorRuleActionsResponseHeaderAction[] | cdktf.IResolvable;
    /**
    * route_configuration_override_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#route_configuration_override_action CdnFrontdoorRule#route_configuration_override_action}
    */
    readonly routeConfigurationOverrideAction?: CdnFrontdoorRuleActionsRouteConfigurationOverrideAction;
    /**
    * url_redirect_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#url_redirect_action CdnFrontdoorRule#url_redirect_action}
    */
    readonly urlRedirectAction?: CdnFrontdoorRuleActionsUrlRedirectAction;
    /**
    * url_rewrite_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#url_rewrite_action CdnFrontdoorRule#url_rewrite_action}
    */
    readonly urlRewriteAction?: CdnFrontdoorRuleActionsUrlRewriteAction;
}
export declare function cdnFrontdoorRuleActionsToTerraform(struct?: CdnFrontdoorRuleActionsOutputReference | CdnFrontdoorRuleActions): any;
export declare function cdnFrontdoorRuleActionsToHclTerraform(struct?: CdnFrontdoorRuleActionsOutputReference | CdnFrontdoorRuleActions): any;
export declare class CdnFrontdoorRuleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRuleActions | undefined;
    set internalValue(value: CdnFrontdoorRuleActions | undefined);
    private _requestHeaderAction;
    get requestHeaderAction(): CdnFrontdoorRuleActionsRequestHeaderActionList;
    putRequestHeaderAction(value: CdnFrontdoorRuleActionsRequestHeaderAction[] | cdktf.IResolvable): void;
    resetRequestHeaderAction(): void;
    get requestHeaderActionInput(): cdktf.IResolvable | CdnFrontdoorRuleActionsRequestHeaderAction[] | undefined;
    private _responseHeaderAction;
    get responseHeaderAction(): CdnFrontdoorRuleActionsResponseHeaderActionList;
    putResponseHeaderAction(value: CdnFrontdoorRuleActionsResponseHeaderAction[] | cdktf.IResolvable): void;
    resetResponseHeaderAction(): void;
    get responseHeaderActionInput(): cdktf.IResolvable | CdnFrontdoorRuleActionsResponseHeaderAction[] | undefined;
    private _routeConfigurationOverrideAction;
    get routeConfigurationOverrideAction(): CdnFrontdoorRuleActionsRouteConfigurationOverrideActionOutputReference;
    putRouteConfigurationOverrideAction(value: CdnFrontdoorRuleActionsRouteConfigurationOverrideAction): void;
    resetRouteConfigurationOverrideAction(): void;
    get routeConfigurationOverrideActionInput(): CdnFrontdoorRuleActionsRouteConfigurationOverrideAction | undefined;
    private _urlRedirectAction;
    get urlRedirectAction(): CdnFrontdoorRuleActionsUrlRedirectActionOutputReference;
    putUrlRedirectAction(value: CdnFrontdoorRuleActionsUrlRedirectAction): void;
    resetUrlRedirectAction(): void;
    get urlRedirectActionInput(): CdnFrontdoorRuleActionsUrlRedirectAction | undefined;
    private _urlRewriteAction;
    get urlRewriteAction(): CdnFrontdoorRuleActionsUrlRewriteActionOutputReference;
    putUrlRewriteAction(value: CdnFrontdoorRuleActionsUrlRewriteAction): void;
    resetUrlRewriteAction(): void;
    get urlRewriteActionInput(): CdnFrontdoorRuleActionsUrlRewriteAction | undefined;
}
export interface CdnFrontdoorRuleConditionsClientPortCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
}
export declare function cdnFrontdoorRuleConditionsClientPortConditionToTerraform(struct?: CdnFrontdoorRuleConditionsClientPortCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsClientPortConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsClientPortCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsClientPortConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsClientPortCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsClientPortCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsClientPortConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsClientPortCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsClientPortConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsCookiesCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#cookie_name CdnFrontdoorRule#cookie_name}
    */
    readonly cookieName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsCookiesConditionToTerraform(struct?: CdnFrontdoorRuleConditionsCookiesCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsCookiesConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsCookiesCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsCookiesConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsCookiesCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsCookiesCondition | cdktf.IResolvable | undefined);
    private _cookieName?;
    get cookieName(): string;
    set cookieName(value: string);
    get cookieNameInput(): string | undefined;
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsCookiesConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsCookiesCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsCookiesConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsHostNameCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsHostNameConditionToTerraform(struct?: CdnFrontdoorRuleConditionsHostNameCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsHostNameConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsHostNameCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsHostNameConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsHostNameCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsHostNameCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsHostNameConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsHostNameCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsHostNameConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsHttpVersionCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator?: string;
}
export declare function cdnFrontdoorRuleConditionsHttpVersionConditionToTerraform(struct?: CdnFrontdoorRuleConditionsHttpVersionCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsHttpVersionConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsHttpVersionCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsHttpVersionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsHttpVersionCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsHttpVersionCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsHttpVersionConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsHttpVersionCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsHttpVersionConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsIsDeviceCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator?: string;
}
export declare function cdnFrontdoorRuleConditionsIsDeviceConditionToTerraform(struct?: CdnFrontdoorRuleConditionsIsDeviceCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsIsDeviceConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsIsDeviceCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsIsDeviceConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsIsDeviceCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsIsDeviceCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsIsDeviceConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsIsDeviceCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsIsDeviceConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsPostArgsCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#post_args_name CdnFrontdoorRule#post_args_name}
    */
    readonly postArgsName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsPostArgsConditionToTerraform(struct?: CdnFrontdoorRuleConditionsPostArgsCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsPostArgsConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsPostArgsCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsPostArgsConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsPostArgsCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsPostArgsCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _postArgsName?;
    get postArgsName(): string;
    set postArgsName(value: string);
    get postArgsNameInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsPostArgsConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsPostArgsCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsPostArgsConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsQueryStringCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsQueryStringConditionToTerraform(struct?: CdnFrontdoorRuleConditionsQueryStringCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsQueryStringConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsQueryStringCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsQueryStringConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsQueryStringCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsQueryStringCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsQueryStringConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsQueryStringCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsQueryStringConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsRemoteAddressCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator?: string;
}
export declare function cdnFrontdoorRuleConditionsRemoteAddressConditionToTerraform(struct?: CdnFrontdoorRuleConditionsRemoteAddressCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsRemoteAddressConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsRemoteAddressCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsRemoteAddressConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsRemoteAddressCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsRemoteAddressCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsRemoteAddressConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsRemoteAddressCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsRemoteAddressConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsRequestBodyCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsRequestBodyConditionToTerraform(struct?: CdnFrontdoorRuleConditionsRequestBodyCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsRequestBodyConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsRequestBodyCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsRequestBodyConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsRequestBodyCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsRequestBodyCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsRequestBodyConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsRequestBodyCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsRequestBodyConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsRequestHeaderCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#header_name CdnFrontdoorRule#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsRequestHeaderConditionToTerraform(struct?: CdnFrontdoorRuleConditionsRequestHeaderCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsRequestHeaderConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsRequestHeaderCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsRequestHeaderConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsRequestHeaderCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsRequestHeaderCondition | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsRequestHeaderConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsRequestHeaderCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsRequestHeaderConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsRequestMethodCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator?: string;
}
export declare function cdnFrontdoorRuleConditionsRequestMethodConditionToTerraform(struct?: CdnFrontdoorRuleConditionsRequestMethodCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsRequestMethodConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsRequestMethodCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsRequestMethodConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsRequestMethodCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsRequestMethodCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsRequestMethodConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsRequestMethodCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsRequestMethodConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsRequestSchemeCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator?: string;
}
export declare function cdnFrontdoorRuleConditionsRequestSchemeConditionToTerraform(struct?: CdnFrontdoorRuleConditionsRequestSchemeCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsRequestSchemeConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsRequestSchemeCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsRequestSchemeConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsRequestSchemeCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsRequestSchemeCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsRequestSchemeConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsRequestSchemeCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsRequestSchemeConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsRequestUriCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsRequestUriConditionToTerraform(struct?: CdnFrontdoorRuleConditionsRequestUriCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsRequestUriConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsRequestUriCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsRequestUriConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsRequestUriCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsRequestUriCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsRequestUriConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsRequestUriCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsRequestUriConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsServerPortCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
}
export declare function cdnFrontdoorRuleConditionsServerPortConditionToTerraform(struct?: CdnFrontdoorRuleConditionsServerPortCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsServerPortConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsServerPortCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsServerPortConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsServerPortCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsServerPortCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsServerPortConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsServerPortCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsServerPortConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsSocketAddressCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator?: string;
}
export declare function cdnFrontdoorRuleConditionsSocketAddressConditionToTerraform(struct?: CdnFrontdoorRuleConditionsSocketAddressCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsSocketAddressConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsSocketAddressCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsSocketAddressConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsSocketAddressCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsSocketAddressCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsSocketAddressConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsSocketAddressCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsSocketAddressConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsSslProtocolCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator?: string;
}
export declare function cdnFrontdoorRuleConditionsSslProtocolConditionToTerraform(struct?: CdnFrontdoorRuleConditionsSslProtocolCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsSslProtocolConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsSslProtocolCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsSslProtocolConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsSslProtocolCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsSslProtocolCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnFrontdoorRuleConditionsSslProtocolConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsSslProtocolCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsSslProtocolConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsUrlFileExtensionCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsUrlFileExtensionConditionToTerraform(struct?: CdnFrontdoorRuleConditionsUrlFileExtensionCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsUrlFileExtensionConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsUrlFileExtensionCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsUrlFileExtensionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsUrlFileExtensionCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsUrlFileExtensionCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsUrlFileExtensionConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsUrlFileExtensionCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsUrlFileExtensionConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsUrlFilenameCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsUrlFilenameConditionToTerraform(struct?: CdnFrontdoorRuleConditionsUrlFilenameCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsUrlFilenameConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsUrlFilenameCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsUrlFilenameConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsUrlFilenameCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsUrlFilenameCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsUrlFilenameConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsUrlFilenameCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsUrlFilenameConditionOutputReference;
}
export interface CdnFrontdoorRuleConditionsUrlPathCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#match_values CdnFrontdoorRule#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#negate_condition CdnFrontdoorRule#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#operator CdnFrontdoorRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#transforms CdnFrontdoorRule#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorRuleConditionsUrlPathConditionToTerraform(struct?: CdnFrontdoorRuleConditionsUrlPathCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleConditionsUrlPathConditionToHclTerraform(struct?: CdnFrontdoorRuleConditionsUrlPathCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleConditionsUrlPathConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorRuleConditionsUrlPathCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleConditionsUrlPathCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorRuleConditionsUrlPathConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorRuleConditionsUrlPathCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorRuleConditionsUrlPathConditionOutputReference;
}
export interface CdnFrontdoorRuleConditions {
    /**
    * client_port_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#client_port_condition CdnFrontdoorRule#client_port_condition}
    */
    readonly clientPortCondition?: CdnFrontdoorRuleConditionsClientPortCondition[] | cdktf.IResolvable;
    /**
    * cookies_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#cookies_condition CdnFrontdoorRule#cookies_condition}
    */
    readonly cookiesCondition?: CdnFrontdoorRuleConditionsCookiesCondition[] | cdktf.IResolvable;
    /**
    * host_name_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#host_name_condition CdnFrontdoorRule#host_name_condition}
    */
    readonly hostNameCondition?: CdnFrontdoorRuleConditionsHostNameCondition[] | cdktf.IResolvable;
    /**
    * http_version_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#http_version_condition CdnFrontdoorRule#http_version_condition}
    */
    readonly httpVersionCondition?: CdnFrontdoorRuleConditionsHttpVersionCondition[] | cdktf.IResolvable;
    /**
    * is_device_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#is_device_condition CdnFrontdoorRule#is_device_condition}
    */
    readonly isDeviceCondition?: CdnFrontdoorRuleConditionsIsDeviceCondition[] | cdktf.IResolvable;
    /**
    * post_args_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#post_args_condition CdnFrontdoorRule#post_args_condition}
    */
    readonly postArgsCondition?: CdnFrontdoorRuleConditionsPostArgsCondition[] | cdktf.IResolvable;
    /**
    * query_string_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#query_string_condition CdnFrontdoorRule#query_string_condition}
    */
    readonly queryStringCondition?: CdnFrontdoorRuleConditionsQueryStringCondition[] | cdktf.IResolvable;
    /**
    * remote_address_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#remote_address_condition CdnFrontdoorRule#remote_address_condition}
    */
    readonly remoteAddressCondition?: CdnFrontdoorRuleConditionsRemoteAddressCondition[] | cdktf.IResolvable;
    /**
    * request_body_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#request_body_condition CdnFrontdoorRule#request_body_condition}
    */
    readonly requestBodyCondition?: CdnFrontdoorRuleConditionsRequestBodyCondition[] | cdktf.IResolvable;
    /**
    * request_header_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#request_header_condition CdnFrontdoorRule#request_header_condition}
    */
    readonly requestHeaderCondition?: CdnFrontdoorRuleConditionsRequestHeaderCondition[] | cdktf.IResolvable;
    /**
    * request_method_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#request_method_condition CdnFrontdoorRule#request_method_condition}
    */
    readonly requestMethodCondition?: CdnFrontdoorRuleConditionsRequestMethodCondition[] | cdktf.IResolvable;
    /**
    * request_scheme_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#request_scheme_condition CdnFrontdoorRule#request_scheme_condition}
    */
    readonly requestSchemeCondition?: CdnFrontdoorRuleConditionsRequestSchemeCondition[] | cdktf.IResolvable;
    /**
    * request_uri_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#request_uri_condition CdnFrontdoorRule#request_uri_condition}
    */
    readonly requestUriCondition?: CdnFrontdoorRuleConditionsRequestUriCondition[] | cdktf.IResolvable;
    /**
    * server_port_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#server_port_condition CdnFrontdoorRule#server_port_condition}
    */
    readonly serverPortCondition?: CdnFrontdoorRuleConditionsServerPortCondition[] | cdktf.IResolvable;
    /**
    * socket_address_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#socket_address_condition CdnFrontdoorRule#socket_address_condition}
    */
    readonly socketAddressCondition?: CdnFrontdoorRuleConditionsSocketAddressCondition[] | cdktf.IResolvable;
    /**
    * ssl_protocol_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#ssl_protocol_condition CdnFrontdoorRule#ssl_protocol_condition}
    */
    readonly sslProtocolCondition?: CdnFrontdoorRuleConditionsSslProtocolCondition[] | cdktf.IResolvable;
    /**
    * url_file_extension_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#url_file_extension_condition CdnFrontdoorRule#url_file_extension_condition}
    */
    readonly urlFileExtensionCondition?: CdnFrontdoorRuleConditionsUrlFileExtensionCondition[] | cdktf.IResolvable;
    /**
    * url_filename_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#url_filename_condition CdnFrontdoorRule#url_filename_condition}
    */
    readonly urlFilenameCondition?: CdnFrontdoorRuleConditionsUrlFilenameCondition[] | cdktf.IResolvable;
    /**
    * url_path_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#url_path_condition CdnFrontdoorRule#url_path_condition}
    */
    readonly urlPathCondition?: CdnFrontdoorRuleConditionsUrlPathCondition[] | cdktf.IResolvable;
}
export declare function cdnFrontdoorRuleConditionsToTerraform(struct?: CdnFrontdoorRuleConditionsOutputReference | CdnFrontdoorRuleConditions): any;
export declare function cdnFrontdoorRuleConditionsToHclTerraform(struct?: CdnFrontdoorRuleConditionsOutputReference | CdnFrontdoorRuleConditions): any;
export declare class CdnFrontdoorRuleConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRuleConditions | undefined;
    set internalValue(value: CdnFrontdoorRuleConditions | undefined);
    private _clientPortCondition;
    get clientPortCondition(): CdnFrontdoorRuleConditionsClientPortConditionList;
    putClientPortCondition(value: CdnFrontdoorRuleConditionsClientPortCondition[] | cdktf.IResolvable): void;
    resetClientPortCondition(): void;
    get clientPortConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsClientPortCondition[] | undefined;
    private _cookiesCondition;
    get cookiesCondition(): CdnFrontdoorRuleConditionsCookiesConditionList;
    putCookiesCondition(value: CdnFrontdoorRuleConditionsCookiesCondition[] | cdktf.IResolvable): void;
    resetCookiesCondition(): void;
    get cookiesConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsCookiesCondition[] | undefined;
    private _hostNameCondition;
    get hostNameCondition(): CdnFrontdoorRuleConditionsHostNameConditionList;
    putHostNameCondition(value: CdnFrontdoorRuleConditionsHostNameCondition[] | cdktf.IResolvable): void;
    resetHostNameCondition(): void;
    get hostNameConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsHostNameCondition[] | undefined;
    private _httpVersionCondition;
    get httpVersionCondition(): CdnFrontdoorRuleConditionsHttpVersionConditionList;
    putHttpVersionCondition(value: CdnFrontdoorRuleConditionsHttpVersionCondition[] | cdktf.IResolvable): void;
    resetHttpVersionCondition(): void;
    get httpVersionConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsHttpVersionCondition[] | undefined;
    private _isDeviceCondition;
    get isDeviceCondition(): CdnFrontdoorRuleConditionsIsDeviceConditionList;
    putIsDeviceCondition(value: CdnFrontdoorRuleConditionsIsDeviceCondition[] | cdktf.IResolvable): void;
    resetIsDeviceCondition(): void;
    get isDeviceConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsIsDeviceCondition[] | undefined;
    private _postArgsCondition;
    get postArgsCondition(): CdnFrontdoorRuleConditionsPostArgsConditionList;
    putPostArgsCondition(value: CdnFrontdoorRuleConditionsPostArgsCondition[] | cdktf.IResolvable): void;
    resetPostArgsCondition(): void;
    get postArgsConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsPostArgsCondition[] | undefined;
    private _queryStringCondition;
    get queryStringCondition(): CdnFrontdoorRuleConditionsQueryStringConditionList;
    putQueryStringCondition(value: CdnFrontdoorRuleConditionsQueryStringCondition[] | cdktf.IResolvable): void;
    resetQueryStringCondition(): void;
    get queryStringConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsQueryStringCondition[] | undefined;
    private _remoteAddressCondition;
    get remoteAddressCondition(): CdnFrontdoorRuleConditionsRemoteAddressConditionList;
    putRemoteAddressCondition(value: CdnFrontdoorRuleConditionsRemoteAddressCondition[] | cdktf.IResolvable): void;
    resetRemoteAddressCondition(): void;
    get remoteAddressConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsRemoteAddressCondition[] | undefined;
    private _requestBodyCondition;
    get requestBodyCondition(): CdnFrontdoorRuleConditionsRequestBodyConditionList;
    putRequestBodyCondition(value: CdnFrontdoorRuleConditionsRequestBodyCondition[] | cdktf.IResolvable): void;
    resetRequestBodyCondition(): void;
    get requestBodyConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsRequestBodyCondition[] | undefined;
    private _requestHeaderCondition;
    get requestHeaderCondition(): CdnFrontdoorRuleConditionsRequestHeaderConditionList;
    putRequestHeaderCondition(value: CdnFrontdoorRuleConditionsRequestHeaderCondition[] | cdktf.IResolvable): void;
    resetRequestHeaderCondition(): void;
    get requestHeaderConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsRequestHeaderCondition[] | undefined;
    private _requestMethodCondition;
    get requestMethodCondition(): CdnFrontdoorRuleConditionsRequestMethodConditionList;
    putRequestMethodCondition(value: CdnFrontdoorRuleConditionsRequestMethodCondition[] | cdktf.IResolvable): void;
    resetRequestMethodCondition(): void;
    get requestMethodConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsRequestMethodCondition[] | undefined;
    private _requestSchemeCondition;
    get requestSchemeCondition(): CdnFrontdoorRuleConditionsRequestSchemeConditionList;
    putRequestSchemeCondition(value: CdnFrontdoorRuleConditionsRequestSchemeCondition[] | cdktf.IResolvable): void;
    resetRequestSchemeCondition(): void;
    get requestSchemeConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsRequestSchemeCondition[] | undefined;
    private _requestUriCondition;
    get requestUriCondition(): CdnFrontdoorRuleConditionsRequestUriConditionList;
    putRequestUriCondition(value: CdnFrontdoorRuleConditionsRequestUriCondition[] | cdktf.IResolvable): void;
    resetRequestUriCondition(): void;
    get requestUriConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsRequestUriCondition[] | undefined;
    private _serverPortCondition;
    get serverPortCondition(): CdnFrontdoorRuleConditionsServerPortConditionList;
    putServerPortCondition(value: CdnFrontdoorRuleConditionsServerPortCondition[] | cdktf.IResolvable): void;
    resetServerPortCondition(): void;
    get serverPortConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsServerPortCondition[] | undefined;
    private _socketAddressCondition;
    get socketAddressCondition(): CdnFrontdoorRuleConditionsSocketAddressConditionList;
    putSocketAddressCondition(value: CdnFrontdoorRuleConditionsSocketAddressCondition[] | cdktf.IResolvable): void;
    resetSocketAddressCondition(): void;
    get socketAddressConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsSocketAddressCondition[] | undefined;
    private _sslProtocolCondition;
    get sslProtocolCondition(): CdnFrontdoorRuleConditionsSslProtocolConditionList;
    putSslProtocolCondition(value: CdnFrontdoorRuleConditionsSslProtocolCondition[] | cdktf.IResolvable): void;
    resetSslProtocolCondition(): void;
    get sslProtocolConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsSslProtocolCondition[] | undefined;
    private _urlFileExtensionCondition;
    get urlFileExtensionCondition(): CdnFrontdoorRuleConditionsUrlFileExtensionConditionList;
    putUrlFileExtensionCondition(value: CdnFrontdoorRuleConditionsUrlFileExtensionCondition[] | cdktf.IResolvable): void;
    resetUrlFileExtensionCondition(): void;
    get urlFileExtensionConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsUrlFileExtensionCondition[] | undefined;
    private _urlFilenameCondition;
    get urlFilenameCondition(): CdnFrontdoorRuleConditionsUrlFilenameConditionList;
    putUrlFilenameCondition(value: CdnFrontdoorRuleConditionsUrlFilenameCondition[] | cdktf.IResolvable): void;
    resetUrlFilenameCondition(): void;
    get urlFilenameConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsUrlFilenameCondition[] | undefined;
    private _urlPathCondition;
    get urlPathCondition(): CdnFrontdoorRuleConditionsUrlPathConditionList;
    putUrlPathCondition(value: CdnFrontdoorRuleConditionsUrlPathCondition[] | cdktf.IResolvable): void;
    resetUrlPathCondition(): void;
    get urlPathConditionInput(): cdktf.IResolvable | CdnFrontdoorRuleConditionsUrlPathCondition[] | undefined;
}
export interface CdnFrontdoorRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#create CdnFrontdoorRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#delete CdnFrontdoorRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#read CdnFrontdoorRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#update CdnFrontdoorRule#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorRuleTimeoutsToTerraform(struct?: CdnFrontdoorRuleTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorRuleTimeoutsToHclTerraform(struct?: CdnFrontdoorRuleTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule azurerm_cdn_frontdoor_rule}
*/
export declare class CdnFrontdoorRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_rule";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorRule to import
    * @param importFromId The id of the existing CdnFrontdoorRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/cdn_frontdoor_rule azurerm_cdn_frontdoor_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorRuleConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorRuleConfig);
    private _behaviorOnMatch?;
    get behaviorOnMatch(): string;
    set behaviorOnMatch(value: string);
    resetBehaviorOnMatch(): void;
    get behaviorOnMatchInput(): string | undefined;
    private _cdnFrontdoorRuleSetId?;
    get cdnFrontdoorRuleSetId(): string;
    set cdnFrontdoorRuleSetId(value: string);
    get cdnFrontdoorRuleSetIdInput(): string | undefined;
    get cdnFrontdoorRuleSetName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
    private _actions;
    get actions(): CdnFrontdoorRuleActionsOutputReference;
    putActions(value: CdnFrontdoorRuleActions): void;
    get actionsInput(): CdnFrontdoorRuleActions | undefined;
    private _conditions;
    get conditions(): CdnFrontdoorRuleConditionsOutputReference;
    putConditions(value: CdnFrontdoorRuleConditions): void;
    resetConditions(): void;
    get conditionsInput(): CdnFrontdoorRuleConditions | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorRuleTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
