/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ChaosStudioExperimentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#id ChaosStudioExperiment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#location ChaosStudioExperiment#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#name ChaosStudioExperiment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#resource_group_name ChaosStudioExperiment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#identity ChaosStudioExperiment#identity}
    */
    readonly identity?: ChaosStudioExperimentIdentity;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#selectors ChaosStudioExperiment#selectors}
    */
    readonly selectors: ChaosStudioExperimentSelectors[] | cdktf.IResolvable;
    /**
    * steps block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#steps ChaosStudioExperiment#steps}
    */
    readonly steps: ChaosStudioExperimentSteps[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#timeouts ChaosStudioExperiment#timeouts}
    */
    readonly timeouts?: ChaosStudioExperimentTimeouts;
}
export interface ChaosStudioExperimentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#identity_ids ChaosStudioExperiment#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#type ChaosStudioExperiment#type}
    */
    readonly type: string;
}
export declare function chaosStudioExperimentIdentityToTerraform(struct?: ChaosStudioExperimentIdentityOutputReference | ChaosStudioExperimentIdentity): any;
export declare function chaosStudioExperimentIdentityToHclTerraform(struct?: ChaosStudioExperimentIdentityOutputReference | ChaosStudioExperimentIdentity): any;
export declare class ChaosStudioExperimentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ChaosStudioExperimentIdentity | undefined;
    set internalValue(value: ChaosStudioExperimentIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ChaosStudioExperimentSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#chaos_studio_target_ids ChaosStudioExperiment#chaos_studio_target_ids}
    */
    readonly chaosStudioTargetIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#name ChaosStudioExperiment#name}
    */
    readonly name: string;
}
export declare function chaosStudioExperimentSelectorsToTerraform(struct?: ChaosStudioExperimentSelectors | cdktf.IResolvable): any;
export declare function chaosStudioExperimentSelectorsToHclTerraform(struct?: ChaosStudioExperimentSelectors | cdktf.IResolvable): any;
export declare class ChaosStudioExperimentSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChaosStudioExperimentSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: ChaosStudioExperimentSelectors | cdktf.IResolvable | undefined);
    private _chaosStudioTargetIds?;
    get chaosStudioTargetIds(): string[];
    set chaosStudioTargetIds(value: string[]);
    get chaosStudioTargetIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ChaosStudioExperimentSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ChaosStudioExperimentSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChaosStudioExperimentSelectorsOutputReference;
}
export interface ChaosStudioExperimentStepsBranchActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#action_type ChaosStudioExperiment#action_type}
    */
    readonly actionType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#duration ChaosStudioExperiment#duration}
    */
    readonly duration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#parameters ChaosStudioExperiment#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#selector_name ChaosStudioExperiment#selector_name}
    */
    readonly selectorName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#urn ChaosStudioExperiment#urn}
    */
    readonly urn?: string;
}
export declare function chaosStudioExperimentStepsBranchActionsToTerraform(struct?: ChaosStudioExperimentStepsBranchActions | cdktf.IResolvable): any;
export declare function chaosStudioExperimentStepsBranchActionsToHclTerraform(struct?: ChaosStudioExperimentStepsBranchActions | cdktf.IResolvable): any;
export declare class ChaosStudioExperimentStepsBranchActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChaosStudioExperimentStepsBranchActions | cdktf.IResolvable | undefined;
    set internalValue(value: ChaosStudioExperimentStepsBranchActions | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _selectorName?;
    get selectorName(): string;
    set selectorName(value: string);
    resetSelectorName(): void;
    get selectorNameInput(): string | undefined;
    private _urn?;
    get urn(): string;
    set urn(value: string);
    resetUrn(): void;
    get urnInput(): string | undefined;
}
export declare class ChaosStudioExperimentStepsBranchActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ChaosStudioExperimentStepsBranchActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChaosStudioExperimentStepsBranchActionsOutputReference;
}
export interface ChaosStudioExperimentStepsBranch {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#name ChaosStudioExperiment#name}
    */
    readonly name: string;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#actions ChaosStudioExperiment#actions}
    */
    readonly actions: ChaosStudioExperimentStepsBranchActions[] | cdktf.IResolvable;
}
export declare function chaosStudioExperimentStepsBranchToTerraform(struct?: ChaosStudioExperimentStepsBranch | cdktf.IResolvable): any;
export declare function chaosStudioExperimentStepsBranchToHclTerraform(struct?: ChaosStudioExperimentStepsBranch | cdktf.IResolvable): any;
export declare class ChaosStudioExperimentStepsBranchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChaosStudioExperimentStepsBranch | cdktf.IResolvable | undefined;
    set internalValue(value: ChaosStudioExperimentStepsBranch | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _actions;
    get actions(): ChaosStudioExperimentStepsBranchActionsList;
    putActions(value: ChaosStudioExperimentStepsBranchActions[] | cdktf.IResolvable): void;
    get actionsInput(): cdktf.IResolvable | ChaosStudioExperimentStepsBranchActions[] | undefined;
}
export declare class ChaosStudioExperimentStepsBranchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ChaosStudioExperimentStepsBranch[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChaosStudioExperimentStepsBranchOutputReference;
}
export interface ChaosStudioExperimentSteps {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#name ChaosStudioExperiment#name}
    */
    readonly name: string;
    /**
    * branch block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#branch ChaosStudioExperiment#branch}
    */
    readonly branch: ChaosStudioExperimentStepsBranch[] | cdktf.IResolvable;
}
export declare function chaosStudioExperimentStepsToTerraform(struct?: ChaosStudioExperimentSteps | cdktf.IResolvable): any;
export declare function chaosStudioExperimentStepsToHclTerraform(struct?: ChaosStudioExperimentSteps | cdktf.IResolvable): any;
export declare class ChaosStudioExperimentStepsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChaosStudioExperimentSteps | cdktf.IResolvable | undefined;
    set internalValue(value: ChaosStudioExperimentSteps | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _branch;
    get branch(): ChaosStudioExperimentStepsBranchList;
    putBranch(value: ChaosStudioExperimentStepsBranch[] | cdktf.IResolvable): void;
    get branchInput(): cdktf.IResolvable | ChaosStudioExperimentStepsBranch[] | undefined;
}
export declare class ChaosStudioExperimentStepsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ChaosStudioExperimentSteps[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChaosStudioExperimentStepsOutputReference;
}
export interface ChaosStudioExperimentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#create ChaosStudioExperiment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#delete ChaosStudioExperiment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#read ChaosStudioExperiment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#update ChaosStudioExperiment#update}
    */
    readonly update?: string;
}
export declare function chaosStudioExperimentTimeoutsToTerraform(struct?: ChaosStudioExperimentTimeouts | cdktf.IResolvable): any;
export declare function chaosStudioExperimentTimeoutsToHclTerraform(struct?: ChaosStudioExperimentTimeouts | cdktf.IResolvable): any;
export declare class ChaosStudioExperimentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ChaosStudioExperimentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ChaosStudioExperimentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment azurerm_chaos_studio_experiment}
*/
export declare class ChaosStudioExperiment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_chaos_studio_experiment";
    /**
    * Generates CDKTF code for importing a ChaosStudioExperiment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ChaosStudioExperiment to import
    * @param importFromId The id of the existing ChaosStudioExperiment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ChaosStudioExperiment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/chaos_studio_experiment azurerm_chaos_studio_experiment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChaosStudioExperimentConfig
    */
    constructor(scope: Construct, id: string, config: ChaosStudioExperimentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _identity;
    get identity(): ChaosStudioExperimentIdentityOutputReference;
    putIdentity(value: ChaosStudioExperimentIdentity): void;
    resetIdentity(): void;
    get identityInput(): ChaosStudioExperimentIdentity | undefined;
    private _selectors;
    get selectors(): ChaosStudioExperimentSelectorsList;
    putSelectors(value: ChaosStudioExperimentSelectors[] | cdktf.IResolvable): void;
    get selectorsInput(): cdktf.IResolvable | ChaosStudioExperimentSelectors[] | undefined;
    private _steps;
    get steps(): ChaosStudioExperimentStepsList;
    putSteps(value: ChaosStudioExperimentSteps[] | cdktf.IResolvable): void;
    get stepsInput(): cdktf.IResolvable | ChaosStudioExperimentSteps[] | undefined;
    private _timeouts;
    get timeouts(): ChaosStudioExperimentTimeoutsOutputReference;
    putTimeouts(value: ChaosStudioExperimentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ChaosStudioExperimentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
