/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsumptionBudgetManagementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#amount ConsumptionBudgetManagementGroup#amount}
    */
    readonly amount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#etag ConsumptionBudgetManagementGroup#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#id ConsumptionBudgetManagementGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#management_group_id ConsumptionBudgetManagementGroup#management_group_id}
    */
    readonly managementGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#time_grain ConsumptionBudgetManagementGroup#time_grain}
    */
    readonly timeGrain?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#filter ConsumptionBudgetManagementGroup#filter}
    */
    readonly filter?: ConsumptionBudgetManagementGroupFilter;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#notification ConsumptionBudgetManagementGroup#notification}
    */
    readonly notification: ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable;
    /**
    * time_period block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#time_period ConsumptionBudgetManagementGroup#time_period}
    */
    readonly timePeriod: ConsumptionBudgetManagementGroupTimePeriod;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#timeouts ConsumptionBudgetManagementGroup#timeouts}
    */
    readonly timeouts?: ConsumptionBudgetManagementGroupTimeouts;
}
export interface ConsumptionBudgetManagementGroupFilterDimension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterDimensionToTerraform(struct?: ConsumptionBudgetManagementGroupFilterDimension | cdktf.IResolvable): any;
export declare function consumptionBudgetManagementGroupFilterDimensionToHclTerraform(struct?: ConsumptionBudgetManagementGroupFilterDimension | cdktf.IResolvable): any;
export declare class ConsumptionBudgetManagementGroupFilterDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupFilterDimension | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterDimension | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class ConsumptionBudgetManagementGroupFilterDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConsumptionBudgetManagementGroupFilterDimensionOutputReference;
}
export interface ConsumptionBudgetManagementGroupFilterNotDimension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterNotDimensionToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference | ConsumptionBudgetManagementGroupFilterNotDimension): any;
export declare function consumptionBudgetManagementGroupFilterNotDimensionToHclTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference | ConsumptionBudgetManagementGroupFilterNotDimension): any;
export declare class ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetManagementGroupFilterNotDimension | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNotDimension | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetManagementGroupFilterNotTag {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterNotTagToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotTagOutputReference | ConsumptionBudgetManagementGroupFilterNotTag): any;
export declare function consumptionBudgetManagementGroupFilterNotTagToHclTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotTagOutputReference | ConsumptionBudgetManagementGroupFilterNotTag): any;
export declare class ConsumptionBudgetManagementGroupFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetManagementGroupFilterNotTag | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNotTag | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetManagementGroupFilterNot {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#dimension ConsumptionBudgetManagementGroup#dimension}
    */
    readonly dimension?: ConsumptionBudgetManagementGroupFilterNotDimension;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#tag ConsumptionBudgetManagementGroup#tag}
    */
    readonly tag?: ConsumptionBudgetManagementGroupFilterNotTag;
}
export declare function consumptionBudgetManagementGroupFilterNotToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotOutputReference | ConsumptionBudgetManagementGroupFilterNot): any;
export declare function consumptionBudgetManagementGroupFilterNotToHclTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotOutputReference | ConsumptionBudgetManagementGroupFilterNot): any;
export declare class ConsumptionBudgetManagementGroupFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetManagementGroupFilterNot | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNot | undefined);
    private _dimension;
    get dimension(): ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference;
    putDimension(value: ConsumptionBudgetManagementGroupFilterNotDimension): void;
    resetDimension(): void;
    get dimensionInput(): ConsumptionBudgetManagementGroupFilterNotDimension | undefined;
    private _tag;
    get tag(): ConsumptionBudgetManagementGroupFilterNotTagOutputReference;
    putTag(value: ConsumptionBudgetManagementGroupFilterNotTag): void;
    resetTag(): void;
    get tagInput(): ConsumptionBudgetManagementGroupFilterNotTag | undefined;
}
export interface ConsumptionBudgetManagementGroupFilterTag {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterTagToTerraform(struct?: ConsumptionBudgetManagementGroupFilterTag | cdktf.IResolvable): any;
export declare function consumptionBudgetManagementGroupFilterTagToHclTerraform(struct?: ConsumptionBudgetManagementGroupFilterTag | cdktf.IResolvable): any;
export declare class ConsumptionBudgetManagementGroupFilterTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupFilterTag | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterTag | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class ConsumptionBudgetManagementGroupFilterTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConsumptionBudgetManagementGroupFilterTagOutputReference;
}
export interface ConsumptionBudgetManagementGroupFilter {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#dimension ConsumptionBudgetManagementGroup#dimension}
    */
    readonly dimension?: ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable;
    /**
    * not block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#not ConsumptionBudgetManagementGroup#not}
    */
    readonly not?: ConsumptionBudgetManagementGroupFilterNot;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#tag ConsumptionBudgetManagementGroup#tag}
    */
    readonly tag?: ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable;
}
export declare function consumptionBudgetManagementGroupFilterToTerraform(struct?: ConsumptionBudgetManagementGroupFilterOutputReference | ConsumptionBudgetManagementGroupFilter): any;
export declare function consumptionBudgetManagementGroupFilterToHclTerraform(struct?: ConsumptionBudgetManagementGroupFilterOutputReference | ConsumptionBudgetManagementGroupFilter): any;
export declare class ConsumptionBudgetManagementGroupFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetManagementGroupFilter | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilter | undefined);
    private _dimension;
    get dimension(): ConsumptionBudgetManagementGroupFilterDimensionList;
    putDimension(value: ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable): void;
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupFilterDimension[] | undefined;
    private _not;
    get not(): ConsumptionBudgetManagementGroupFilterNotOutputReference;
    putNot(value: ConsumptionBudgetManagementGroupFilterNot): void;
    resetNot(): void;
    get notInput(): ConsumptionBudgetManagementGroupFilterNot | undefined;
    private _tag;
    get tag(): ConsumptionBudgetManagementGroupFilterTagList;
    putTag(value: ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupFilterTag[] | undefined;
}
export interface ConsumptionBudgetManagementGroupNotification {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#contact_emails ConsumptionBudgetManagementGroup#contact_emails}
    */
    readonly contactEmails: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#enabled ConsumptionBudgetManagementGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#threshold ConsumptionBudgetManagementGroup#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#threshold_type ConsumptionBudgetManagementGroup#threshold_type}
    */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetManagementGroupNotificationToTerraform(struct?: ConsumptionBudgetManagementGroupNotification | cdktf.IResolvable): any;
export declare function consumptionBudgetManagementGroupNotificationToHclTerraform(struct?: ConsumptionBudgetManagementGroupNotification | cdktf.IResolvable): any;
export declare class ConsumptionBudgetManagementGroupNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupNotification | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupNotification | cdktf.IResolvable | undefined);
    private _contactEmails?;
    get contactEmails(): string[];
    set contactEmails(value: string[]);
    get contactEmailsInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _thresholdType?;
    get thresholdType(): string;
    set thresholdType(value: string);
    resetThresholdType(): void;
    get thresholdTypeInput(): string | undefined;
}
export declare class ConsumptionBudgetManagementGroupNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConsumptionBudgetManagementGroupNotificationOutputReference;
}
export interface ConsumptionBudgetManagementGroupTimePeriod {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#end_date ConsumptionBudgetManagementGroup#end_date}
    */
    readonly endDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#start_date ConsumptionBudgetManagementGroup#start_date}
    */
    readonly startDate: string;
}
export declare function consumptionBudgetManagementGroupTimePeriodToTerraform(struct?: ConsumptionBudgetManagementGroupTimePeriodOutputReference | ConsumptionBudgetManagementGroupTimePeriod): any;
export declare function consumptionBudgetManagementGroupTimePeriodToHclTerraform(struct?: ConsumptionBudgetManagementGroupTimePeriodOutputReference | ConsumptionBudgetManagementGroupTimePeriod): any;
export declare class ConsumptionBudgetManagementGroupTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetManagementGroupTimePeriod | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupTimePeriod | undefined);
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    get startDateInput(): string | undefined;
}
export interface ConsumptionBudgetManagementGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#create ConsumptionBudgetManagementGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#delete ConsumptionBudgetManagementGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#read ConsumptionBudgetManagementGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#update ConsumptionBudgetManagementGroup#update}
    */
    readonly update?: string;
}
export declare function consumptionBudgetManagementGroupTimeoutsToTerraform(struct?: ConsumptionBudgetManagementGroupTimeouts | cdktf.IResolvable): any;
export declare function consumptionBudgetManagementGroupTimeoutsToHclTerraform(struct?: ConsumptionBudgetManagementGroupTimeouts | cdktf.IResolvable): any;
export declare class ConsumptionBudgetManagementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetManagementGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group azurerm_consumption_budget_management_group}
*/
export declare class ConsumptionBudgetManagementGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_consumption_budget_management_group";
    /**
    * Generates CDKTF code for importing a ConsumptionBudgetManagementGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ConsumptionBudgetManagementGroup to import
    * @param importFromId The id of the existing ConsumptionBudgetManagementGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ConsumptionBudgetManagementGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/consumption_budget_management_group azurerm_consumption_budget_management_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsumptionBudgetManagementGroupConfig
    */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetManagementGroupConfig);
    private _amount?;
    get amount(): number;
    set amount(value: number);
    get amountInput(): number | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    get managementGroupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeGrain?;
    get timeGrain(): string;
    set timeGrain(value: string);
    resetTimeGrain(): void;
    get timeGrainInput(): string | undefined;
    private _filter;
    get filter(): ConsumptionBudgetManagementGroupFilterOutputReference;
    putFilter(value: ConsumptionBudgetManagementGroupFilter): void;
    resetFilter(): void;
    get filterInput(): ConsumptionBudgetManagementGroupFilter | undefined;
    private _notification;
    get notification(): ConsumptionBudgetManagementGroupNotificationList;
    putNotification(value: ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable): void;
    get notificationInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupNotification[] | undefined;
    private _timePeriod;
    get timePeriod(): ConsumptionBudgetManagementGroupTimePeriodOutputReference;
    putTimePeriod(value: ConsumptionBudgetManagementGroupTimePeriod): void;
    get timePeriodInput(): ConsumptionBudgetManagementGroupTimePeriod | undefined;
    private _timeouts;
    get timeouts(): ConsumptionBudgetManagementGroupTimeoutsOutputReference;
    putTimeouts(value: ConsumptionBudgetManagementGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
