/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAppEnvironmentCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Custom Domain Certificate Private Key as a base64 encoded PFX or PEM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#certificate_blob_base64 ContainerAppEnvironmentCustomDomain#certificate_blob_base64}
    */
    readonly certificateBlobBase64: string;
    /**
    * The Custom Domain Certificate password.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#certificate_password ContainerAppEnvironmentCustomDomain#certificate_password}
    */
    readonly certificatePassword: string;
    /**
    * The Container App Managed Environment ID to configure this Custom Domain on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#container_app_environment_id ContainerAppEnvironmentCustomDomain#container_app_environment_id}
    */
    readonly containerAppEnvironmentId: string;
    /**
    * The Custom Domain DNS suffix for this Container App Environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#dns_suffix ContainerAppEnvironmentCustomDomain#dns_suffix}
    */
    readonly dnsSuffix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#id ContainerAppEnvironmentCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#timeouts ContainerAppEnvironmentCustomDomain#timeouts}
    */
    readonly timeouts?: ContainerAppEnvironmentCustomDomainTimeouts;
}
export interface ContainerAppEnvironmentCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#create ContainerAppEnvironmentCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#delete ContainerAppEnvironmentCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#read ContainerAppEnvironmentCustomDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#update ContainerAppEnvironmentCustomDomain#update}
    */
    readonly update?: string;
}
export declare function containerAppEnvironmentCustomDomainTimeoutsToTerraform(struct?: ContainerAppEnvironmentCustomDomainTimeouts | cdktf.IResolvable): any;
export declare function containerAppEnvironmentCustomDomainTimeoutsToHclTerraform(struct?: ContainerAppEnvironmentCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class ContainerAppEnvironmentCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppEnvironmentCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppEnvironmentCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain azurerm_container_app_environment_custom_domain}
*/
export declare class ContainerAppEnvironmentCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_app_environment_custom_domain";
    /**
    * Generates CDKTF code for importing a ContainerAppEnvironmentCustomDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerAppEnvironmentCustomDomain to import
    * @param importFromId The id of the existing ContainerAppEnvironmentCustomDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerAppEnvironmentCustomDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/container_app_environment_custom_domain azurerm_container_app_environment_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAppEnvironmentCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAppEnvironmentCustomDomainConfig);
    private _certificateBlobBase64?;
    get certificateBlobBase64(): string;
    set certificateBlobBase64(value: string);
    get certificateBlobBase64Input(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    get certificatePasswordInput(): string | undefined;
    private _containerAppEnvironmentId?;
    get containerAppEnvironmentId(): string;
    set containerAppEnvironmentId(value: string);
    get containerAppEnvironmentIdInput(): string | undefined;
    private _dnsSuffix?;
    get dnsSuffix(): string;
    set dnsSuffix(value: string);
    get dnsSuffixInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): ContainerAppEnvironmentCustomDomainTimeoutsOutputReference;
    putTimeouts(value: ContainerAppEnvironmentCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAppEnvironmentCustomDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
