/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDashboardGrafanaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#id DataAzurermDashboardGrafana#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#name DataAzurermDashboardGrafana#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#resource_group_name DataAzurermDashboardGrafana#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#identity DataAzurermDashboardGrafana#identity}
    */
    readonly identity?: DataAzurermDashboardGrafanaIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#timeouts DataAzurermDashboardGrafana#timeouts}
    */
    readonly timeouts?: DataAzurermDashboardGrafanaTimeouts;
}
export interface DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrations {
}
export declare function dataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrationsToTerraform(struct?: DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrations): any;
export declare function dataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrationsToHclTerraform(struct?: DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrations): any;
export declare class DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrations | undefined;
    set internalValue(value: DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrations | undefined);
    get resourceId(): string;
}
export declare class DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrationsOutputReference;
}
export interface DataAzurermDashboardGrafanaIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#identity_ids DataAzurermDashboardGrafana#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#type DataAzurermDashboardGrafana#type}
    */
    readonly type: string;
}
export declare function dataAzurermDashboardGrafanaIdentityToTerraform(struct?: DataAzurermDashboardGrafanaIdentityOutputReference | DataAzurermDashboardGrafanaIdentity): any;
export declare function dataAzurermDashboardGrafanaIdentityToHclTerraform(struct?: DataAzurermDashboardGrafanaIdentityOutputReference | DataAzurermDashboardGrafanaIdentity): any;
export declare class DataAzurermDashboardGrafanaIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDashboardGrafanaIdentity | undefined;
    set internalValue(value: DataAzurermDashboardGrafanaIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DataAzurermDashboardGrafanaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#read DataAzurermDashboardGrafana#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDashboardGrafanaTimeoutsToTerraform(struct?: DataAzurermDashboardGrafanaTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDashboardGrafanaTimeoutsToHclTerraform(struct?: DataAzurermDashboardGrafanaTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDashboardGrafanaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDashboardGrafanaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDashboardGrafanaTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana azurerm_dashboard_grafana}
*/
export declare class DataAzurermDashboardGrafana extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dashboard_grafana";
    /**
    * Generates CDKTF code for importing a DataAzurermDashboardGrafana resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDashboardGrafana to import
    * @param importFromId The id of the existing DataAzurermDashboardGrafana that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDashboardGrafana to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dashboard_grafana azurerm_dashboard_grafana} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDashboardGrafanaConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDashboardGrafanaConfig);
    get apiKeyEnabled(): cdktf.IResolvable;
    get autoGeneratedDomainNameLabelScope(): string;
    private _azureMonitorWorkspaceIntegrations;
    get azureMonitorWorkspaceIntegrations(): DataAzurermDashboardGrafanaAzureMonitorWorkspaceIntegrationsList;
    get deterministicOutboundIpEnabled(): cdktf.IResolvable;
    get endpoint(): string;
    get grafanaMajorVersion(): string;
    get grafanaVersion(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIps(): string[];
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zoneRedundancyEnabled(): cdktf.IResolvable;
    private _identity;
    get identity(): DataAzurermDashboardGrafanaIdentityOutputReference;
    putIdentity(value: DataAzurermDashboardGrafanaIdentity): void;
    resetIdentity(): void;
    get identityInput(): DataAzurermDashboardGrafanaIdentity | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDashboardGrafanaTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDashboardGrafanaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDashboardGrafanaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
