/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataFactoryTriggerScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule#data_factory_id DataAzurermDataFactoryTriggerSchedule#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule#id DataAzurermDataFactoryTriggerSchedule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule#name DataAzurermDataFactoryTriggerSchedule#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule#timeouts DataAzurermDataFactoryTriggerSchedule#timeouts}
    */
    readonly timeouts?: DataAzurermDataFactoryTriggerScheduleTimeouts;
}
export interface DataAzurermDataFactoryTriggerScheduleScheduleMonthly {
}
export declare function dataAzurermDataFactoryTriggerScheduleScheduleMonthlyToTerraform(struct?: DataAzurermDataFactoryTriggerScheduleScheduleMonthly): any;
export declare function dataAzurermDataFactoryTriggerScheduleScheduleMonthlyToHclTerraform(struct?: DataAzurermDataFactoryTriggerScheduleScheduleMonthly): any;
export declare class DataAzurermDataFactoryTriggerScheduleScheduleMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataFactoryTriggerScheduleScheduleMonthly | undefined;
    set internalValue(value: DataAzurermDataFactoryTriggerScheduleScheduleMonthly | undefined);
    get week(): number;
    get weekday(): string;
}
export declare class DataAzurermDataFactoryTriggerScheduleScheduleMonthlyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataFactoryTriggerScheduleScheduleMonthlyOutputReference;
}
export interface DataAzurermDataFactoryTriggerScheduleSchedule {
}
export declare function dataAzurermDataFactoryTriggerScheduleScheduleToTerraform(struct?: DataAzurermDataFactoryTriggerScheduleSchedule): any;
export declare function dataAzurermDataFactoryTriggerScheduleScheduleToHclTerraform(struct?: DataAzurermDataFactoryTriggerScheduleSchedule): any;
export declare class DataAzurermDataFactoryTriggerScheduleScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataFactoryTriggerScheduleSchedule | undefined;
    set internalValue(value: DataAzurermDataFactoryTriggerScheduleSchedule | undefined);
    get daysOfMonth(): number[];
    get daysOfWeek(): string[];
    get hours(): number[];
    get minutes(): number[];
    private _monthly;
    get monthly(): DataAzurermDataFactoryTriggerScheduleScheduleMonthlyList;
}
export declare class DataAzurermDataFactoryTriggerScheduleScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataFactoryTriggerScheduleScheduleOutputReference;
}
export interface DataAzurermDataFactoryTriggerScheduleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule#read DataAzurermDataFactoryTriggerSchedule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataFactoryTriggerScheduleTimeoutsToTerraform(struct?: DataAzurermDataFactoryTriggerScheduleTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDataFactoryTriggerScheduleTimeoutsToHclTerraform(struct?: DataAzurermDataFactoryTriggerScheduleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataFactoryTriggerScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataFactoryTriggerScheduleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDataFactoryTriggerScheduleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule azurerm_data_factory_trigger_schedule}
*/
export declare class DataAzurermDataFactoryTriggerSchedule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_factory_trigger_schedule";
    /**
    * Generates CDKTF code for importing a DataAzurermDataFactoryTriggerSchedule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDataFactoryTriggerSchedule to import
    * @param importFromId The id of the existing DataAzurermDataFactoryTriggerSchedule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDataFactoryTriggerSchedule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/data_factory_trigger_schedule azurerm_data_factory_trigger_schedule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataFactoryTriggerScheduleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataFactoryTriggerScheduleConfig);
    get activated(): cdktf.IResolvable;
    get annotations(): string[];
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    get description(): string;
    get endTime(): string;
    get frequency(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get interval(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pipelineName(): string;
    private _schedule;
    get schedule(): DataAzurermDataFactoryTriggerScheduleScheduleList;
    get startTime(): string;
    get timeZone(): string;
    private _timeouts;
    get timeouts(): DataAzurermDataFactoryTriggerScheduleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataFactoryTriggerScheduleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDataFactoryTriggerScheduleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
