/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDnsSrvRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record#id DataAzurermDnsSrvRecord#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record#name DataAzurermDnsSrvRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record#resource_group_name DataAzurermDnsSrvRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record#zone_name DataAzurermDnsSrvRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record#timeouts DataAzurermDnsSrvRecord#timeouts}
    */
    readonly timeouts?: DataAzurermDnsSrvRecordTimeouts;
}
export interface DataAzurermDnsSrvRecordRecord {
}
export declare function dataAzurermDnsSrvRecordRecordToTerraform(struct?: DataAzurermDnsSrvRecordRecord): any;
export declare function dataAzurermDnsSrvRecordRecordToHclTerraform(struct?: DataAzurermDnsSrvRecordRecord): any;
export declare class DataAzurermDnsSrvRecordRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDnsSrvRecordRecord | undefined;
    set internalValue(value: DataAzurermDnsSrvRecordRecord | undefined);
    get port(): number;
    get priority(): number;
    get target(): string;
    get weight(): number;
}
export declare class DataAzurermDnsSrvRecordRecordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDnsSrvRecordRecordOutputReference;
}
export interface DataAzurermDnsSrvRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record#read DataAzurermDnsSrvRecord#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDnsSrvRecordTimeoutsToTerraform(struct?: DataAzurermDnsSrvRecordTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDnsSrvRecordTimeoutsToHclTerraform(struct?: DataAzurermDnsSrvRecordTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDnsSrvRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDnsSrvRecordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDnsSrvRecordTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record azurerm_dns_srv_record}
*/
export declare class DataAzurermDnsSrvRecord extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dns_srv_record";
    /**
    * Generates CDKTF code for importing a DataAzurermDnsSrvRecord resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDnsSrvRecord to import
    * @param importFromId The id of the existing DataAzurermDnsSrvRecord that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDnsSrvRecord to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/dns_srv_record azurerm_dns_srv_record} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDnsSrvRecordConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDnsSrvRecordConfig);
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _record;
    get record(): DataAzurermDnsSrvRecordRecordList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get ttl(): number;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDnsSrvRecordTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDnsSrvRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDnsSrvRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
