/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermElasticSanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san#id DataAzurermElasticSan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san#name DataAzurermElasticSan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san#resource_group_name DataAzurermElasticSan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san#timeouts DataAzurermElasticSan#timeouts}
    */
    readonly timeouts?: DataAzurermElasticSanTimeouts;
}
export interface DataAzurermElasticSanSku {
}
export declare function dataAzurermElasticSanSkuToTerraform(struct?: DataAzurermElasticSanSku): any;
export declare function dataAzurermElasticSanSkuToHclTerraform(struct?: DataAzurermElasticSanSku): any;
export declare class DataAzurermElasticSanSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermElasticSanSku | undefined;
    set internalValue(value: DataAzurermElasticSanSku | undefined);
    get name(): string;
    get tier(): string;
}
export declare class DataAzurermElasticSanSkuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermElasticSanSkuOutputReference;
}
export interface DataAzurermElasticSanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san#read DataAzurermElasticSan#read}
    */
    readonly read?: string;
}
export declare function dataAzurermElasticSanTimeoutsToTerraform(struct?: DataAzurermElasticSanTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermElasticSanTimeoutsToHclTerraform(struct?: DataAzurermElasticSanTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermElasticSanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermElasticSanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermElasticSanTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san azurerm_elastic_san}
*/
export declare class DataAzurermElasticSan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_elastic_san";
    /**
    * Generates CDKTF code for importing a DataAzurermElasticSan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermElasticSan to import
    * @param importFromId The id of the existing DataAzurermElasticSan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermElasticSan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/elastic_san azurerm_elastic_san} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermElasticSanConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermElasticSanConfig);
    get baseSizeInTib(): number;
    get extendedSizeInTib(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku;
    get sku(): DataAzurermElasticSanSkuList;
    private _tags;
    get tags(): cdktf.StringMap;
    get totalIops(): number;
    get totalMbps(): number;
    get totalSizeInTib(): number;
    get totalVolumeSizeInGib(): number;
    get volumeGroupCount(): number;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermElasticSanTimeoutsOutputReference;
    putTimeouts(value: DataAzurermElasticSanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermElasticSanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
