/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLbBackendAddressPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool#id DataAzurermLbBackendAddressPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool#loadbalancer_id DataAzurermLbBackendAddressPool#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool#name DataAzurermLbBackendAddressPool#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool#timeouts DataAzurermLbBackendAddressPool#timeouts}
    */
    readonly timeouts?: DataAzurermLbBackendAddressPoolTimeouts;
}
export interface DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMapping {
}
export declare function dataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMappingToTerraform(struct?: DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMapping): any;
export declare function dataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMappingToHclTerraform(struct?: DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMapping): any;
export declare class DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMapping | undefined;
    set internalValue(value: DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMapping | undefined);
    get backendPort(): number;
    get frontendPort(): number;
    get inboundNatRuleName(): string;
}
export declare class DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMappingOutputReference;
}
export interface DataAzurermLbBackendAddressPoolBackendAddress {
}
export declare function dataAzurermLbBackendAddressPoolBackendAddressToTerraform(struct?: DataAzurermLbBackendAddressPoolBackendAddress): any;
export declare function dataAzurermLbBackendAddressPoolBackendAddressToHclTerraform(struct?: DataAzurermLbBackendAddressPoolBackendAddress): any;
export declare class DataAzurermLbBackendAddressPoolBackendAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLbBackendAddressPoolBackendAddress | undefined;
    set internalValue(value: DataAzurermLbBackendAddressPoolBackendAddress | undefined);
    private _inboundNatRulePortMapping;
    get inboundNatRulePortMapping(): DataAzurermLbBackendAddressPoolBackendAddressInboundNatRulePortMappingList;
    get ipAddress(): string;
    get name(): string;
    get virtualNetworkId(): string;
}
export declare class DataAzurermLbBackendAddressPoolBackendAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLbBackendAddressPoolBackendAddressOutputReference;
}
export interface DataAzurermLbBackendAddressPoolBackendIpConfigurations {
}
export declare function dataAzurermLbBackendAddressPoolBackendIpConfigurationsToTerraform(struct?: DataAzurermLbBackendAddressPoolBackendIpConfigurations): any;
export declare function dataAzurermLbBackendAddressPoolBackendIpConfigurationsToHclTerraform(struct?: DataAzurermLbBackendAddressPoolBackendIpConfigurations): any;
export declare class DataAzurermLbBackendAddressPoolBackendIpConfigurationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLbBackendAddressPoolBackendIpConfigurations | undefined;
    set internalValue(value: DataAzurermLbBackendAddressPoolBackendIpConfigurations | undefined);
    get id(): string;
}
export declare class DataAzurermLbBackendAddressPoolBackendIpConfigurationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLbBackendAddressPoolBackendIpConfigurationsOutputReference;
}
export interface DataAzurermLbBackendAddressPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool#read DataAzurermLbBackendAddressPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLbBackendAddressPoolTimeoutsToTerraform(struct?: DataAzurermLbBackendAddressPoolTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermLbBackendAddressPoolTimeoutsToHclTerraform(struct?: DataAzurermLbBackendAddressPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLbBackendAddressPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLbBackendAddressPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLbBackendAddressPoolTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool azurerm_lb_backend_address_pool}
*/
export declare class DataAzurermLbBackendAddressPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_lb_backend_address_pool";
    /**
    * Generates CDKTF code for importing a DataAzurermLbBackendAddressPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermLbBackendAddressPool to import
    * @param importFromId The id of the existing DataAzurermLbBackendAddressPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermLbBackendAddressPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_backend_address_pool azurerm_lb_backend_address_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLbBackendAddressPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLbBackendAddressPoolConfig);
    private _backendAddress;
    get backendAddress(): DataAzurermLbBackendAddressPoolBackendAddressList;
    private _backendIpConfigurations;
    get backendIpConfigurations(): DataAzurermLbBackendAddressPoolBackendIpConfigurationsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get inboundNatRules(): string[];
    get loadBalancingRules(): string[];
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundRules(): string[];
    private _timeouts;
    get timeouts(): DataAzurermLbBackendAddressPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLbBackendAddressPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLbBackendAddressPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
