/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLbRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule#id DataAzurermLbRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule#loadbalancer_id DataAzurermLbRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule#name DataAzurermLbRule#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule#timeouts DataAzurermLbRule#timeouts}
    */
    readonly timeouts?: DataAzurermLbRuleTimeouts;
}
export interface DataAzurermLbRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule#read DataAzurermLbRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLbRuleTimeoutsToTerraform(struct?: DataAzurermLbRuleTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermLbRuleTimeoutsToHclTerraform(struct?: DataAzurermLbRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLbRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLbRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLbRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule azurerm_lb_rule}
*/
export declare class DataAzurermLbRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_lb_rule";
    /**
    * Generates CDKTF code for importing a DataAzurermLbRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermLbRule to import
    * @param importFromId The id of the existing DataAzurermLbRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermLbRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/lb_rule azurerm_lb_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLbRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLbRuleConfig);
    get backendAddressPoolId(): string;
    get backendPort(): number;
    get disableOutboundSnat(): cdktf.IResolvable;
    get enableFloatingIp(): cdktf.IResolvable;
    get enableTcpReset(): cdktf.IResolvable;
    get frontendIpConfigurationName(): string;
    get frontendPort(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idleTimeoutInMinutes(): number;
    get loadDistribution(): string;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get probeId(): string;
    get protocol(): string;
    private _timeouts;
    get timeouts(): DataAzurermLbRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLbRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLbRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
