/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLoadTestConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test#id DataAzurermLoadTest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test#name DataAzurermLoadTest#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test#resource_group_name DataAzurermLoadTest#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test#timeouts DataAzurermLoadTest#timeouts}
    */
    readonly timeouts?: DataAzurermLoadTestTimeouts;
}
export interface DataAzurermLoadTestEncryptionIdentity {
}
export declare function dataAzurermLoadTestEncryptionIdentityToTerraform(struct?: DataAzurermLoadTestEncryptionIdentity): any;
export declare function dataAzurermLoadTestEncryptionIdentityToHclTerraform(struct?: DataAzurermLoadTestEncryptionIdentity): any;
export declare class DataAzurermLoadTestEncryptionIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLoadTestEncryptionIdentity | undefined;
    set internalValue(value: DataAzurermLoadTestEncryptionIdentity | undefined);
    get identityId(): string;
    get type(): string;
}
export declare class DataAzurermLoadTestEncryptionIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLoadTestEncryptionIdentityOutputReference;
}
export interface DataAzurermLoadTestEncryption {
}
export declare function dataAzurermLoadTestEncryptionToTerraform(struct?: DataAzurermLoadTestEncryption): any;
export declare function dataAzurermLoadTestEncryptionToHclTerraform(struct?: DataAzurermLoadTestEncryption): any;
export declare class DataAzurermLoadTestEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLoadTestEncryption | undefined;
    set internalValue(value: DataAzurermLoadTestEncryption | undefined);
    private _identity;
    get identity(): DataAzurermLoadTestEncryptionIdentityList;
    get keyUrl(): string;
}
export declare class DataAzurermLoadTestEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLoadTestEncryptionOutputReference;
}
export interface DataAzurermLoadTestIdentity {
}
export declare function dataAzurermLoadTestIdentityToTerraform(struct?: DataAzurermLoadTestIdentity): any;
export declare function dataAzurermLoadTestIdentityToHclTerraform(struct?: DataAzurermLoadTestIdentity): any;
export declare class DataAzurermLoadTestIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLoadTestIdentity | undefined;
    set internalValue(value: DataAzurermLoadTestIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermLoadTestIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLoadTestIdentityOutputReference;
}
export interface DataAzurermLoadTestTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test#read DataAzurermLoadTest#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLoadTestTimeoutsToTerraform(struct?: DataAzurermLoadTestTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermLoadTestTimeoutsToHclTerraform(struct?: DataAzurermLoadTestTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLoadTestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLoadTestTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLoadTestTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test azurerm_load_test}
*/
export declare class DataAzurermLoadTest extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_load_test";
    /**
    * Generates CDKTF code for importing a DataAzurermLoadTest resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermLoadTest to import
    * @param importFromId The id of the existing DataAzurermLoadTest that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermLoadTest to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/load_test azurerm_load_test} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLoadTestConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLoadTestConfig);
    get dataPlaneUri(): string;
    get description(): string;
    private _encryption;
    get encryption(): DataAzurermLoadTestEncryptionList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermLoadTestIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermLoadTestTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLoadTestTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLoadTestTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
