/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkAttachedDataNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network#id DataAzurermMobileNetworkAttachedDataNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network#mobile_network_data_network_name DataAzurermMobileNetworkAttachedDataNetwork#mobile_network_data_network_name}
    */
    readonly mobileNetworkDataNetworkName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network#mobile_network_packet_core_data_plane_id DataAzurermMobileNetworkAttachedDataNetwork#mobile_network_packet_core_data_plane_id}
    */
    readonly mobileNetworkPacketCoreDataPlaneId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network#timeouts DataAzurermMobileNetworkAttachedDataNetwork#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkAttachedDataNetworkTimeouts;
}
export interface DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange {
}
export declare function dataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform(struct?: DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange): any;
export declare function dataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToHclTerraform(struct?: DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange): any;
export declare class DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange | undefined;
    set internalValue(value: DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange | undefined);
    get maximum(): number;
    get minimum(): number;
}
export declare class DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference;
}
export interface DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslation {
}
export declare function dataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform(struct?: DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslation): any;
export declare function dataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToHclTerraform(struct?: DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslation): any;
export declare class DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslation | undefined;
    set internalValue(value: DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslation | undefined);
    get icmpPinholeTimeoutInSeconds(): number;
    get pinholeMaximumNumber(): number;
    private _portRange;
    get portRange(): DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeList;
    get tcpPinholeTimeoutInSeconds(): number;
    get tcpPortReuseMinimumHoldTimeInSeconds(): number;
    get udpPinholeTimeoutInSeconds(): number;
    get udpPortReuseMinimumHoldTimeInSeconds(): number;
}
export declare class DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference;
}
export interface DataAzurermMobileNetworkAttachedDataNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network#read DataAzurermMobileNetworkAttachedDataNetwork#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkAttachedDataNetworkTimeoutsToTerraform(struct?: DataAzurermMobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMobileNetworkAttachedDataNetworkTimeoutsToHclTerraform(struct?: DataAzurermMobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkAttachedDataNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network}
*/
export declare class DataAzurermMobileNetworkAttachedDataNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_attached_data_network";
    /**
    * Generates CDKTF code for importing a DataAzurermMobileNetworkAttachedDataNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMobileNetworkAttachedDataNetwork to import
    * @param importFromId The id of the existing DataAzurermMobileNetworkAttachedDataNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMobileNetworkAttachedDataNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkAttachedDataNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkAttachedDataNetworkConfig);
    get dnsAddresses(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkDataNetworkName?;
    get mobileNetworkDataNetworkName(): string;
    set mobileNetworkDataNetworkName(value: string);
    get mobileNetworkDataNetworkNameInput(): string | undefined;
    private _mobileNetworkPacketCoreDataPlaneId?;
    get mobileNetworkPacketCoreDataPlaneId(): string;
    set mobileNetworkPacketCoreDataPlaneId(value: string);
    get mobileNetworkPacketCoreDataPlaneIdInput(): string | undefined;
    private _networkAddressPortTranslation;
    get networkAddressPortTranslation(): DataAzurermMobileNetworkAttachedDataNetworkNetworkAddressPortTranslationList;
    private _tags;
    get tags(): cdktf.StringMap;
    get userEquipmentAddressPoolPrefixes(): string[];
    get userEquipmentStaticAddressPoolPrefixes(): string[];
    get userPlaneAccessIpv4Address(): string;
    get userPlaneAccessIpv4Gateway(): string;
    get userPlaneAccessIpv4Subnet(): string;
    get userPlaneAccessName(): string;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkAttachedDataNetworkTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkAttachedDataNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkAttachedDataNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
