/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkSimPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy#id DataAzurermMobileNetworkSimPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy#mobile_network_id DataAzurermMobileNetworkSimPolicy#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy#name DataAzurermMobileNetworkSimPolicy#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy#timeouts DataAzurermMobileNetworkSimPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkSimPolicyTimeouts;
}
export interface DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate {
}
export declare function dataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateToTerraform(struct?: DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate): any;
export declare function dataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateToHclTerraform(struct?: DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate): any;
export declare class DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate | undefined;
    set internalValue(value: DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate | undefined);
    get downlink(): string;
    get uplink(): string;
}
export declare class DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateOutputReference;
}
export interface DataAzurermMobileNetworkSimPolicySliceDataNetwork {
}
export declare function dataAzurermMobileNetworkSimPolicySliceDataNetworkToTerraform(struct?: DataAzurermMobileNetworkSimPolicySliceDataNetwork): any;
export declare function dataAzurermMobileNetworkSimPolicySliceDataNetworkToHclTerraform(struct?: DataAzurermMobileNetworkSimPolicySliceDataNetwork): any;
export declare class DataAzurermMobileNetworkSimPolicySliceDataNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkSimPolicySliceDataNetwork | undefined;
    set internalValue(value: DataAzurermMobileNetworkSimPolicySliceDataNetwork | undefined);
    get additionalAllowedSessionTypes(): string[];
    get allocationAndRetentionPriorityLevel(): number;
    get allowedServicesIds(): string[];
    get dataNetworkId(): string;
    get defaultSessionType(): string;
    get maxBufferedPackets(): number;
    get preemptionCapability(): string;
    get preemptionVulnerability(): string;
    get qosIndicator(): number;
    private _sessionAggregateMaximumBitRate;
    get sessionAggregateMaximumBitRate(): DataAzurermMobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateList;
}
export declare class DataAzurermMobileNetworkSimPolicySliceDataNetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkSimPolicySliceDataNetworkOutputReference;
}
export interface DataAzurermMobileNetworkSimPolicySlice {
}
export declare function dataAzurermMobileNetworkSimPolicySliceToTerraform(struct?: DataAzurermMobileNetworkSimPolicySlice): any;
export declare function dataAzurermMobileNetworkSimPolicySliceToHclTerraform(struct?: DataAzurermMobileNetworkSimPolicySlice): any;
export declare class DataAzurermMobileNetworkSimPolicySliceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkSimPolicySlice | undefined;
    set internalValue(value: DataAzurermMobileNetworkSimPolicySlice | undefined);
    private _dataNetwork;
    get dataNetwork(): DataAzurermMobileNetworkSimPolicySliceDataNetworkList;
    get defaultDataNetworkId(): string;
    get sliceId(): string;
}
export declare class DataAzurermMobileNetworkSimPolicySliceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkSimPolicySliceOutputReference;
}
export interface DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate {
}
export declare function dataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateToTerraform(struct?: DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate): any;
export declare function dataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateToHclTerraform(struct?: DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate): any;
export declare class DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate | undefined;
    set internalValue(value: DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate | undefined);
    get downlink(): string;
    get uplink(): string;
}
export declare class DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateOutputReference;
}
export interface DataAzurermMobileNetworkSimPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy#read DataAzurermMobileNetworkSimPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkSimPolicyTimeoutsToTerraform(struct?: DataAzurermMobileNetworkSimPolicyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMobileNetworkSimPolicyTimeoutsToHclTerraform(struct?: DataAzurermMobileNetworkSimPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkSimPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkSimPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkSimPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy azurerm_mobile_network_sim_policy}
*/
export declare class DataAzurermMobileNetworkSimPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_sim_policy";
    /**
    * Generates CDKTF code for importing a DataAzurermMobileNetworkSimPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMobileNetworkSimPolicy to import
    * @param importFromId The id of the existing DataAzurermMobileNetworkSimPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMobileNetworkSimPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/mobile_network_sim_policy azurerm_mobile_network_sim_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkSimPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkSimPolicyConfig);
    get defaultSliceId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get ratFrequencySelectionPriorityIndex(): number;
    get registrationTimerInSeconds(): number;
    private _slice;
    get slice(): DataAzurermMobileNetworkSimPolicySliceList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _userEquipmentAggregateMaximumBitRate;
    get userEquipmentAggregateMaximumBitRate(): DataAzurermMobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateList;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkSimPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkSimPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkSimPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
