/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkManagerConnectivityConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration#id DataAzurermNetworkManagerConnectivityConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration#name DataAzurermNetworkManagerConnectivityConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration#network_manager_id DataAzurermNetworkManagerConnectivityConfiguration#network_manager_id}
    */
    readonly networkManagerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration#timeouts DataAzurermNetworkManagerConnectivityConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkManagerConnectivityConfigurationTimeouts;
}
export interface DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroup {
}
export declare function dataAzurermNetworkManagerConnectivityConfigurationAppliesToGroupToTerraform(struct?: DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroup): any;
export declare function dataAzurermNetworkManagerConnectivityConfigurationAppliesToGroupToHclTerraform(struct?: DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroup): any;
export declare class DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroup | undefined;
    set internalValue(value: DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroup | undefined);
    get globalMeshEnabled(): cdktf.IResolvable;
    get groupConnectivity(): string;
    get networkGroupId(): string;
    get useHubGateway(): cdktf.IResolvable;
}
export declare class DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroupOutputReference;
}
export interface DataAzurermNetworkManagerConnectivityConfigurationHub {
}
export declare function dataAzurermNetworkManagerConnectivityConfigurationHubToTerraform(struct?: DataAzurermNetworkManagerConnectivityConfigurationHub): any;
export declare function dataAzurermNetworkManagerConnectivityConfigurationHubToHclTerraform(struct?: DataAzurermNetworkManagerConnectivityConfigurationHub): any;
export declare class DataAzurermNetworkManagerConnectivityConfigurationHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetworkManagerConnectivityConfigurationHub | undefined;
    set internalValue(value: DataAzurermNetworkManagerConnectivityConfigurationHub | undefined);
    get resourceId(): string;
    get resourceType(): string;
}
export declare class DataAzurermNetworkManagerConnectivityConfigurationHubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetworkManagerConnectivityConfigurationHubOutputReference;
}
export interface DataAzurermNetworkManagerConnectivityConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration#read DataAzurermNetworkManagerConnectivityConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkManagerConnectivityConfigurationTimeoutsToTerraform(struct?: DataAzurermNetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetworkManagerConnectivityConfigurationTimeoutsToHclTerraform(struct?: DataAzurermNetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkManagerConnectivityConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetworkManagerConnectivityConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration azurerm_network_manager_connectivity_configuration}
*/
export declare class DataAzurermNetworkManagerConnectivityConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_manager_connectivity_configuration";
    /**
    * Generates CDKTF code for importing a DataAzurermNetworkManagerConnectivityConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetworkManagerConnectivityConfiguration to import
    * @param importFromId The id of the existing DataAzurermNetworkManagerConnectivityConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetworkManagerConnectivityConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager_connectivity_configuration azurerm_network_manager_connectivity_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkManagerConnectivityConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkManagerConnectivityConfigurationConfig);
    private _appliesToGroup;
    get appliesToGroup(): DataAzurermNetworkManagerConnectivityConfigurationAppliesToGroupList;
    get connectivityTopology(): string;
    get deleteExistingPeeringEnabled(): cdktf.IResolvable;
    get description(): string;
    get globalMeshEnabled(): cdktf.IResolvable;
    private _hub;
    get hub(): DataAzurermNetworkManagerConnectivityConfigurationHubList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkManagerId?;
    get networkManagerId(): string;
    set networkManagerId(value: string);
    get networkManagerIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermNetworkManagerConnectivityConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkManagerConnectivityConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetworkManagerConnectivityConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
