/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkManagerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager#id DataAzurermNetworkManager#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager#name DataAzurermNetworkManager#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager#resource_group_name DataAzurermNetworkManager#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager#timeouts DataAzurermNetworkManager#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkManagerTimeouts;
}
export interface DataAzurermNetworkManagerCrossTenantScopes {
}
export declare function dataAzurermNetworkManagerCrossTenantScopesToTerraform(struct?: DataAzurermNetworkManagerCrossTenantScopes): any;
export declare function dataAzurermNetworkManagerCrossTenantScopesToHclTerraform(struct?: DataAzurermNetworkManagerCrossTenantScopes): any;
export declare class DataAzurermNetworkManagerCrossTenantScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetworkManagerCrossTenantScopes | undefined;
    set internalValue(value: DataAzurermNetworkManagerCrossTenantScopes | undefined);
    get managementGroups(): string[];
    get subscriptions(): string[];
    get tenantId(): string;
}
export declare class DataAzurermNetworkManagerCrossTenantScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetworkManagerCrossTenantScopesOutputReference;
}
export interface DataAzurermNetworkManagerScope {
}
export declare function dataAzurermNetworkManagerScopeToTerraform(struct?: DataAzurermNetworkManagerScope): any;
export declare function dataAzurermNetworkManagerScopeToHclTerraform(struct?: DataAzurermNetworkManagerScope): any;
export declare class DataAzurermNetworkManagerScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetworkManagerScope | undefined;
    set internalValue(value: DataAzurermNetworkManagerScope | undefined);
    get managementGroupIds(): string[];
    get subscriptionIds(): string[];
}
export declare class DataAzurermNetworkManagerScopeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetworkManagerScopeOutputReference;
}
export interface DataAzurermNetworkManagerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager#read DataAzurermNetworkManager#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkManagerTimeoutsToTerraform(struct?: DataAzurermNetworkManagerTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetworkManagerTimeoutsToHclTerraform(struct?: DataAzurermNetworkManagerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkManagerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetworkManagerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager azurerm_network_manager}
*/
export declare class DataAzurermNetworkManager extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_manager";
    /**
    * Generates CDKTF code for importing a DataAzurermNetworkManager resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetworkManager to import
    * @param importFromId The id of the existing DataAzurermNetworkManager that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetworkManager to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/network_manager azurerm_network_manager} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkManagerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkManagerConfig);
    private _crossTenantScopes;
    get crossTenantScopes(): DataAzurermNetworkManagerCrossTenantScopesList;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scope;
    get scope(): DataAzurermNetworkManagerScopeList;
    get scopeAccesses(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermNetworkManagerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkManagerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetworkManagerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
