/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNginxConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/nginx_configuration#id DataAzurermNginxConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/nginx_configuration#nginx_deployment_id DataAzurermNginxConfiguration#nginx_deployment_id}
    */
    readonly nginxDeploymentId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/nginx_configuration#timeouts DataAzurermNginxConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermNginxConfigurationTimeouts;
}
export interface DataAzurermNginxConfigurationConfigFile {
}
export declare function dataAzurermNginxConfigurationConfigFileToTerraform(struct?: DataAzurermNginxConfigurationConfigFile): any;
export declare function dataAzurermNginxConfigurationConfigFileToHclTerraform(struct?: DataAzurermNginxConfigurationConfigFile): any;
export declare class DataAzurermNginxConfigurationConfigFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxConfigurationConfigFile | undefined;
    set internalValue(value: DataAzurermNginxConfigurationConfigFile | undefined);
    get content(): string;
    get virtualPath(): string;
}
export declare class DataAzurermNginxConfigurationConfigFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxConfigurationConfigFileOutputReference;
}
export interface DataAzurermNginxConfigurationProtectedFile {
}
export declare function dataAzurermNginxConfigurationProtectedFileToTerraform(struct?: DataAzurermNginxConfigurationProtectedFile): any;
export declare function dataAzurermNginxConfigurationProtectedFileToHclTerraform(struct?: DataAzurermNginxConfigurationProtectedFile): any;
export declare class DataAzurermNginxConfigurationProtectedFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxConfigurationProtectedFile | undefined;
    set internalValue(value: DataAzurermNginxConfigurationProtectedFile | undefined);
    get content(): string;
    get virtualPath(): string;
}
export declare class DataAzurermNginxConfigurationProtectedFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxConfigurationProtectedFileOutputReference;
}
export interface DataAzurermNginxConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/nginx_configuration#read DataAzurermNginxConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNginxConfigurationTimeoutsToTerraform(struct?: DataAzurermNginxConfigurationTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNginxConfigurationTimeoutsToHclTerraform(struct?: DataAzurermNginxConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNginxConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNginxConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNginxConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/nginx_configuration azurerm_nginx_configuration}
*/
export declare class DataAzurermNginxConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_nginx_configuration";
    /**
    * Generates CDKTF code for importing a DataAzurermNginxConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNginxConfiguration to import
    * @param importFromId The id of the existing DataAzurermNginxConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/nginx_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNginxConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/nginx_configuration azurerm_nginx_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNginxConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNginxConfigurationConfig);
    private _configFile;
    get configFile(): DataAzurermNginxConfigurationConfigFileList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nginxDeploymentId?;
    get nginxDeploymentId(): string;
    set nginxDeploymentId(value: string);
    get nginxDeploymentIdInput(): string | undefined;
    get packageData(): string;
    private _protectedFile;
    get protectedFile(): DataAzurermNginxConfigurationProtectedFileList;
    get rootFile(): string;
    private _timeouts;
    get timeouts(): DataAzurermNginxConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNginxConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNginxConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
