/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPaloAltoLocalRulestackConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack#id DataAzurermPaloAltoLocalRulestack#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack#name DataAzurermPaloAltoLocalRulestack#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack#resource_group_name DataAzurermPaloAltoLocalRulestack#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack#timeouts DataAzurermPaloAltoLocalRulestack#timeouts}
    */
    readonly timeouts?: DataAzurermPaloAltoLocalRulestackTimeouts;
}
export interface DataAzurermPaloAltoLocalRulestackTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack#read DataAzurermPaloAltoLocalRulestack#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPaloAltoLocalRulestackTimeoutsToTerraform(struct?: DataAzurermPaloAltoLocalRulestackTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPaloAltoLocalRulestackTimeoutsToHclTerraform(struct?: DataAzurermPaloAltoLocalRulestackTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPaloAltoLocalRulestackTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPaloAltoLocalRulestackTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPaloAltoLocalRulestackTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack azurerm_palo_alto_local_rulestack}
*/
export declare class DataAzurermPaloAltoLocalRulestack extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_palo_alto_local_rulestack";
    /**
    * Generates CDKTF code for importing a DataAzurermPaloAltoLocalRulestack resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPaloAltoLocalRulestack to import
    * @param importFromId The id of the existing DataAzurermPaloAltoLocalRulestack that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPaloAltoLocalRulestack to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/palo_alto_local_rulestack azurerm_palo_alto_local_rulestack} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPaloAltoLocalRulestackConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPaloAltoLocalRulestackConfig);
    get antiSpywareProfile(): string;
    get antiVirusProfile(): string;
    get description(): string;
    get dnsSubscription(): string;
    get fileBlockingProfile(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundTrustCertificate(): string;
    get outboundUntrustCertificate(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get urlFilteringProfile(): string;
    get vulnerabilityProfile(): string;
    private _timeouts;
    get timeouts(): DataAzurermPaloAltoLocalRulestackTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPaloAltoLocalRulestackTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPaloAltoLocalRulestackTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
