/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPublicIpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip#id DataAzurermPublicIp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip#name DataAzurermPublicIp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip#resource_group_name DataAzurermPublicIp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip#timeouts DataAzurermPublicIp#timeouts}
    */
    readonly timeouts?: DataAzurermPublicIpTimeouts;
}
export interface DataAzurermPublicIpTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip#read DataAzurermPublicIp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPublicIpTimeoutsToTerraform(struct?: DataAzurermPublicIpTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPublicIpTimeoutsToHclTerraform(struct?: DataAzurermPublicIpTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPublicIpTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPublicIpTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPublicIpTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip azurerm_public_ip}
*/
export declare class DataAzurermPublicIp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_public_ip";
    /**
    * Generates CDKTF code for importing a DataAzurermPublicIp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPublicIp to import
    * @param importFromId The id of the existing DataAzurermPublicIp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPublicIp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_ip azurerm_public_ip} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPublicIpConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPublicIpConfig);
    get allocationMethod(): string;
    get ddosProtectionMode(): string;
    get ddosProtectionPlanId(): string;
    get domainNameLabel(): string;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idleTimeoutInMinutes(): number;
    get ipAddress(): string;
    private _ipTags;
    get ipTags(): cdktf.StringMap;
    get ipVersion(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get reverseFqdn(): string;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermPublicIpTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPublicIpTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPublicIpTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
