/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPublicMaintenanceConfigurationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations#id DataAzurermPublicMaintenanceConfigurations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations#location DataAzurermPublicMaintenanceConfigurations#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations#recur_every DataAzurermPublicMaintenanceConfigurations#recur_every}
    */
    readonly recurEvery?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations#scope DataAzurermPublicMaintenanceConfigurations#scope}
    */
    readonly scope?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations#timeouts DataAzurermPublicMaintenanceConfigurations#timeouts}
    */
    readonly timeouts?: DataAzurermPublicMaintenanceConfigurationsTimeouts;
}
export interface DataAzurermPublicMaintenanceConfigurationsConfigs {
}
export declare function dataAzurermPublicMaintenanceConfigurationsConfigsToTerraform(struct?: DataAzurermPublicMaintenanceConfigurationsConfigs): any;
export declare function dataAzurermPublicMaintenanceConfigurationsConfigsToHclTerraform(struct?: DataAzurermPublicMaintenanceConfigurationsConfigs): any;
export declare class DataAzurermPublicMaintenanceConfigurationsConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPublicMaintenanceConfigurationsConfigs | undefined;
    set internalValue(value: DataAzurermPublicMaintenanceConfigurationsConfigs | undefined);
    get description(): string;
    get duration(): string;
    get id(): string;
    get location(): string;
    get maintenanceScope(): string;
    get name(): string;
    get recurEvery(): string;
    get timeZone(): string;
}
export declare class DataAzurermPublicMaintenanceConfigurationsConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPublicMaintenanceConfigurationsConfigsOutputReference;
}
export interface DataAzurermPublicMaintenanceConfigurationsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations#read DataAzurermPublicMaintenanceConfigurations#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPublicMaintenanceConfigurationsTimeoutsToTerraform(struct?: DataAzurermPublicMaintenanceConfigurationsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPublicMaintenanceConfigurationsTimeoutsToHclTerraform(struct?: DataAzurermPublicMaintenanceConfigurationsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPublicMaintenanceConfigurationsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPublicMaintenanceConfigurationsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPublicMaintenanceConfigurationsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations azurerm_public_maintenance_configurations}
*/
export declare class DataAzurermPublicMaintenanceConfigurations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_public_maintenance_configurations";
    /**
    * Generates CDKTF code for importing a DataAzurermPublicMaintenanceConfigurations resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPublicMaintenanceConfigurations to import
    * @param importFromId The id of the existing DataAzurermPublicMaintenanceConfigurations that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPublicMaintenanceConfigurations to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/public_maintenance_configurations azurerm_public_maintenance_configurations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPublicMaintenanceConfigurationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermPublicMaintenanceConfigurationsConfig);
    private _configs;
    get configs(): DataAzurermPublicMaintenanceConfigurationsConfigsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _recurEvery?;
    get recurEvery(): string;
    set recurEvery(value: string);
    resetRecurEvery(): void;
    get recurEveryInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPublicMaintenanceConfigurationsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPublicMaintenanceConfigurationsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPublicMaintenanceConfigurationsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
