/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSearchServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service#id DataAzurermSearchService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service#name DataAzurermSearchService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service#resource_group_name DataAzurermSearchService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service#timeouts DataAzurermSearchService#timeouts}
    */
    readonly timeouts?: DataAzurermSearchServiceTimeouts;
}
export interface DataAzurermSearchServiceIdentity {
}
export declare function dataAzurermSearchServiceIdentityToTerraform(struct?: DataAzurermSearchServiceIdentity): any;
export declare function dataAzurermSearchServiceIdentityToHclTerraform(struct?: DataAzurermSearchServiceIdentity): any;
export declare class DataAzurermSearchServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSearchServiceIdentity | undefined;
    set internalValue(value: DataAzurermSearchServiceIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermSearchServiceIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSearchServiceIdentityOutputReference;
}
export interface DataAzurermSearchServiceQueryKeys {
}
export declare function dataAzurermSearchServiceQueryKeysToTerraform(struct?: DataAzurermSearchServiceQueryKeys): any;
export declare function dataAzurermSearchServiceQueryKeysToHclTerraform(struct?: DataAzurermSearchServiceQueryKeys): any;
export declare class DataAzurermSearchServiceQueryKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSearchServiceQueryKeys | undefined;
    set internalValue(value: DataAzurermSearchServiceQueryKeys | undefined);
    get key(): string;
    get name(): string;
}
export declare class DataAzurermSearchServiceQueryKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSearchServiceQueryKeysOutputReference;
}
export interface DataAzurermSearchServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service#read DataAzurermSearchService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSearchServiceTimeoutsToTerraform(struct?: DataAzurermSearchServiceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSearchServiceTimeoutsToHclTerraform(struct?: DataAzurermSearchServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSearchServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSearchServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSearchServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service azurerm_search_service}
*/
export declare class DataAzurermSearchService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_search_service";
    /**
    * Generates CDKTF code for importing a DataAzurermSearchService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSearchService to import
    * @param importFromId The id of the existing DataAzurermSearchService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSearchService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/search_service azurerm_search_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSearchServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSearchServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermSearchServiceIdentityList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get partitionCount(): number;
    get primaryKey(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _queryKeys;
    get queryKeys(): DataAzurermSearchServiceQueryKeysList;
    get replicaCount(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryKey(): string;
    private _timeouts;
    get timeouts(): DataAzurermSearchServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSearchServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSearchServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
