/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualDesktopApplicationGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group#id DataAzurermVirtualDesktopApplicationGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group#name DataAzurermVirtualDesktopApplicationGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group#resource_group_name DataAzurermVirtualDesktopApplicationGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group#timeouts DataAzurermVirtualDesktopApplicationGroup#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualDesktopApplicationGroupTimeouts;
}
export interface DataAzurermVirtualDesktopApplicationGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group#read DataAzurermVirtualDesktopApplicationGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualDesktopApplicationGroupTimeoutsToTerraform(struct?: DataAzurermVirtualDesktopApplicationGroupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVirtualDesktopApplicationGroupTimeoutsToHclTerraform(struct?: DataAzurermVirtualDesktopApplicationGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualDesktopApplicationGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualDesktopApplicationGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualDesktopApplicationGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group azurerm_virtual_desktop_application_group}
*/
export declare class DataAzurermVirtualDesktopApplicationGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_desktop_application_group";
    /**
    * Generates CDKTF code for importing a DataAzurermVirtualDesktopApplicationGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVirtualDesktopApplicationGroup to import
    * @param importFromId The id of the existing DataAzurermVirtualDesktopApplicationGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVirtualDesktopApplicationGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/virtual_desktop_application_group azurerm_virtual_desktop_application_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualDesktopApplicationGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualDesktopApplicationGroupConfig);
    get description(): string;
    get friendlyName(): string;
    get hostPoolId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    get workspaceId(): string;
    private _timeouts;
    get timeouts(): DataAzurermVirtualDesktopApplicationGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualDesktopApplicationGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualDesktopApplicationGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
