/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermWindowsFunctionAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app#id DataAzurermWindowsFunctionApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app#name DataAzurermWindowsFunctionApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app#resource_group_name DataAzurermWindowsFunctionApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app#timeouts DataAzurermWindowsFunctionApp#timeouts}
    */
    readonly timeouts?: DataAzurermWindowsFunctionAppTimeouts;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsActiveDirectory {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsActiveDirectoryToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsActiveDirectory): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsActiveDirectoryToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsActiveDirectory): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsActiveDirectory | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsActiveDirectory | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsActiveDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsActiveDirectoryOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsFacebook {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsFacebookToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsFacebook): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsFacebookToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsFacebook): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsFacebook | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsFacebook | undefined);
    get appId(): string;
    get appSecret(): string;
    get appSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsFacebookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsFacebookOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsGithub {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsGithubToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsGithub): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsGithubToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsGithub): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsGithub | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsGithub | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsGithubOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsGoogle {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsGoogleToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsGoogle): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsGoogleToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsGoogle): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsGoogle | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsGoogle | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsGoogleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsGoogleOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsMicrosoft {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsMicrosoftToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsMicrosoft): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsMicrosoftToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsMicrosoft): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsMicrosoft | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsMicrosoft | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsMicrosoftList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsMicrosoftOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsTwitter {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsTwitterToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsTwitter): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsTwitterToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsTwitter): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsTwitter | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsTwitter | undefined);
    get consumerKey(): string;
    get consumerSecret(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsTwitterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsTwitterOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettings {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettings): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettings): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettings | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettings | undefined);
    private _activeDirectory;
    get activeDirectory(): DataAzurermWindowsFunctionAppAuthSettingsActiveDirectoryList;
    private _additionalLoginParameters;
    get additionalLoginParameters(): cdktf.StringMap;
    get allowedExternalRedirectUrls(): string[];
    get defaultProvider(): string;
    get enabled(): cdktf.IResolvable;
    private _facebook;
    get facebook(): DataAzurermWindowsFunctionAppAuthSettingsFacebookList;
    private _github;
    get github(): DataAzurermWindowsFunctionAppAuthSettingsGithubList;
    private _google;
    get google(): DataAzurermWindowsFunctionAppAuthSettingsGoogleList;
    get issuer(): string;
    private _microsoft;
    get microsoft(): DataAzurermWindowsFunctionAppAuthSettingsMicrosoftList;
    get runtimeVersion(): string;
    get tokenRefreshExtensionHours(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    private _twitter;
    get twitter(): DataAzurermWindowsFunctionAppAuthSettingsTwitterList;
    get unauthenticatedClientAction(): string;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2 | undefined);
    get allowedApplications(): string[];
    get allowedAudiences(): string[];
    get allowedGroups(): string[];
    get allowedIdentities(): string[];
    get clientId(): string;
    get clientSecretCertificateThumbprint(): string;
    get clientSecretSettingName(): string;
    get jwtAllowedClientApplications(): string[];
    get jwtAllowedGroups(): string[];
    private _loginParameters;
    get loginParameters(): cdktf.StringMap;
    get tenantAuthEndpoint(): string;
    get wwwAuthenticationDisabled(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2AppleV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2AppleV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2 | undefined);
    get clientId(): string;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2 | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    get clientId(): string;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    get name(): string;
    get nameClaimType(): string;
    get openidConfigurationEndpoint(): string;
    get scopes(): string[];
    get tokenEndpoint(): string;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2 | undefined);
    get appId(): string;
    get appSecretSettingName(): string;
    get graphApiVersion(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2GithubV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2GithubV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2Login {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2LoginToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2Login): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2LoginToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2Login): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2Login | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2Login | undefined);
    get allowedExternalRedirectUrls(): string[];
    get cookieExpirationConvention(): string;
    get cookieExpirationTime(): string;
    get logoutEndpoint(): string;
    get nonceExpirationTime(): string;
    get preserveUrlFragmentsForLogins(): cdktf.IResolvable;
    get tokenRefreshExtensionTime(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    get tokenStorePath(): string;
    get tokenStoreSasSettingName(): string;
    get validateNonce(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2LoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2LoginOutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2 | undefined);
    get consumerKey(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppAuthSettingsV2 {
}
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2ToTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2): any;
export declare function dataAzurermWindowsFunctionAppAuthSettingsV2ToHclTerraform(struct?: DataAzurermWindowsFunctionAppAuthSettingsV2): any;
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppAuthSettingsV2 | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppAuthSettingsV2 | undefined);
    private _activeDirectoryV2;
    get activeDirectoryV2(): DataAzurermWindowsFunctionAppAuthSettingsV2ActiveDirectoryV2List;
    private _appleV2;
    get appleV2(): DataAzurermWindowsFunctionAppAuthSettingsV2AppleV2List;
    get authEnabled(): cdktf.IResolvable;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): DataAzurermWindowsFunctionAppAuthSettingsV2AzureStaticWebAppV2List;
    get configFilePath(): string;
    private _customOidcV2;
    get customOidcV2(): DataAzurermWindowsFunctionAppAuthSettingsV2CustomOidcV2List;
    get defaultProvider(): string;
    get excludedPaths(): string[];
    private _facebookV2;
    get facebookV2(): DataAzurermWindowsFunctionAppAuthSettingsV2FacebookV2List;
    get forwardProxyConvention(): string;
    get forwardProxyCustomHostHeaderName(): string;
    get forwardProxyCustomSchemeHeaderName(): string;
    private _githubV2;
    get githubV2(): DataAzurermWindowsFunctionAppAuthSettingsV2GithubV2List;
    private _googleV2;
    get googleV2(): DataAzurermWindowsFunctionAppAuthSettingsV2GoogleV2List;
    get httpRouteApiPrefix(): string;
    private _login;
    get login(): DataAzurermWindowsFunctionAppAuthSettingsV2LoginList;
    private _microsoftV2;
    get microsoftV2(): DataAzurermWindowsFunctionAppAuthSettingsV2MicrosoftV2List;
    get requireAuthentication(): cdktf.IResolvable;
    get requireHttps(): cdktf.IResolvable;
    get runtimeVersion(): string;
    private _twitterV2;
    get twitterV2(): DataAzurermWindowsFunctionAppAuthSettingsV2TwitterV2List;
    get unauthenticatedAction(): string;
}
export declare class DataAzurermWindowsFunctionAppAuthSettingsV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppAuthSettingsV2OutputReference;
}
export interface DataAzurermWindowsFunctionAppBackupSchedule {
}
export declare function dataAzurermWindowsFunctionAppBackupScheduleToTerraform(struct?: DataAzurermWindowsFunctionAppBackupSchedule): any;
export declare function dataAzurermWindowsFunctionAppBackupScheduleToHclTerraform(struct?: DataAzurermWindowsFunctionAppBackupSchedule): any;
export declare class DataAzurermWindowsFunctionAppBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppBackupSchedule | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppBackupSchedule | undefined);
    get frequencyInterval(): number;
    get frequencyUnit(): string;
    get keepAtLeastOneBackup(): cdktf.IResolvable;
    get lastExecutionTime(): string;
    get retentionPeriodDays(): number;
    get startTime(): string;
}
export declare class DataAzurermWindowsFunctionAppBackupScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppBackupScheduleOutputReference;
}
export interface DataAzurermWindowsFunctionAppBackup {
}
export declare function dataAzurermWindowsFunctionAppBackupToTerraform(struct?: DataAzurermWindowsFunctionAppBackup): any;
export declare function dataAzurermWindowsFunctionAppBackupToHclTerraform(struct?: DataAzurermWindowsFunctionAppBackup): any;
export declare class DataAzurermWindowsFunctionAppBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppBackup | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppBackup | undefined);
    get enabled(): cdktf.IResolvable;
    get name(): string;
    private _schedule;
    get schedule(): DataAzurermWindowsFunctionAppBackupScheduleList;
    get storageAccountUrl(): string;
}
export declare class DataAzurermWindowsFunctionAppBackupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppBackupOutputReference;
}
export interface DataAzurermWindowsFunctionAppConnectionString {
}
export declare function dataAzurermWindowsFunctionAppConnectionStringToTerraform(struct?: DataAzurermWindowsFunctionAppConnectionString): any;
export declare function dataAzurermWindowsFunctionAppConnectionStringToHclTerraform(struct?: DataAzurermWindowsFunctionAppConnectionString): any;
export declare class DataAzurermWindowsFunctionAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppConnectionString | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppConnectionString | undefined);
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermWindowsFunctionAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppConnectionStringOutputReference;
}
export interface DataAzurermWindowsFunctionAppIdentity {
}
export declare function dataAzurermWindowsFunctionAppIdentityToTerraform(struct?: DataAzurermWindowsFunctionAppIdentity): any;
export declare function dataAzurermWindowsFunctionAppIdentityToHclTerraform(struct?: DataAzurermWindowsFunctionAppIdentity): any;
export declare class DataAzurermWindowsFunctionAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppIdentity | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermWindowsFunctionAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppIdentityOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfigAppServiceLogs {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigAppServiceLogsToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigAppServiceLogs): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigAppServiceLogsToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigAppServiceLogs): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigAppServiceLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfigAppServiceLogs | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfigAppServiceLogs | undefined);
    get diskQuotaMb(): number;
    get retentionPeriodDays(): number;
}
export declare class DataAzurermWindowsFunctionAppSiteConfigAppServiceLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigAppServiceLogsOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfigApplicationStack {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigApplicationStackToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigApplicationStack): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigApplicationStackToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigApplicationStack): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfigApplicationStack | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfigApplicationStack | undefined);
    get dotnetVersion(): string;
    get javaVersion(): string;
    get nodeVersion(): string;
    get powershellCoreVersion(): string;
    get useCustomRuntime(): cdktf.IResolvable;
    get useDotnetIsolatedRuntime(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsFunctionAppSiteConfigApplicationStackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigApplicationStackOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfigCors {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigCorsToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigCors): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigCorsToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigCors): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfigCors | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfigCors | undefined);
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsFunctionAppSiteConfigCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigCorsOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeaders {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeaders): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeadersToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeaders): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfigIpRestriction {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigIpRestrictionToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigIpRestriction): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigIpRestrictionToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigIpRestriction): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfigIpRestriction | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfigIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermWindowsFunctionAppSiteConfigIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermWindowsFunctionAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigIpRestrictionOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeaders {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeaders): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeaders): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfigScmIpRestriction {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigScmIpRestriction): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfigScmIpRestriction): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfigScmIpRestriction | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfigScmIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteConfig {
}
export declare function dataAzurermWindowsFunctionAppSiteConfigToTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfig): any;
export declare function dataAzurermWindowsFunctionAppSiteConfigToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteConfig): any;
export declare class DataAzurermWindowsFunctionAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteConfig | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteConfig | undefined);
    get alwaysOn(): cdktf.IResolvable;
    get apiDefinitionUrl(): string;
    get apiManagementApiId(): string;
    get appCommandLine(): string;
    get appScaleLimit(): number;
    private _appServiceLogs;
    get appServiceLogs(): DataAzurermWindowsFunctionAppSiteConfigAppServiceLogsList;
    get applicationInsightsConnectionString(): string;
    get applicationInsightsKey(): string;
    private _applicationStack;
    get applicationStack(): DataAzurermWindowsFunctionAppSiteConfigApplicationStackList;
    private _cors;
    get cors(): DataAzurermWindowsFunctionAppSiteConfigCorsList;
    get defaultDocuments(): string[];
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    get elasticInstanceMinimum(): number;
    get ftpsState(): string;
    get healthCheckEvictionTimeInMin(): number;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    private _ipRestriction;
    get ipRestriction(): DataAzurermWindowsFunctionAppSiteConfigIpRestrictionList;
    get ipRestrictionDefaultAction(): string;
    get loadBalancingMode(): string;
    get managedPipelineMode(): string;
    get minimumTlsVersion(): string;
    get preWarmedInstanceCount(): number;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    get remoteDebuggingVersion(): string;
    get runtimeScaleMonitoringEnabled(): cdktf.IResolvable;
    private _scmIpRestriction;
    get scmIpRestriction(): DataAzurermWindowsFunctionAppSiteConfigScmIpRestrictionList;
    get scmIpRestrictionDefaultAction(): string;
    get scmMinimumTlsVersion(): string;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorker(): cdktf.IResolvable;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
    get windowsFxVersion(): string;
    get workerCount(): number;
}
export declare class DataAzurermWindowsFunctionAppSiteConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteConfigOutputReference;
}
export interface DataAzurermWindowsFunctionAppSiteCredential {
}
export declare function dataAzurermWindowsFunctionAppSiteCredentialToTerraform(struct?: DataAzurermWindowsFunctionAppSiteCredential): any;
export declare function dataAzurermWindowsFunctionAppSiteCredentialToHclTerraform(struct?: DataAzurermWindowsFunctionAppSiteCredential): any;
export declare class DataAzurermWindowsFunctionAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppSiteCredential | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class DataAzurermWindowsFunctionAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppSiteCredentialOutputReference;
}
export interface DataAzurermWindowsFunctionAppStickySettings {
}
export declare function dataAzurermWindowsFunctionAppStickySettingsToTerraform(struct?: DataAzurermWindowsFunctionAppStickySettings): any;
export declare function dataAzurermWindowsFunctionAppStickySettingsToHclTerraform(struct?: DataAzurermWindowsFunctionAppStickySettings): any;
export declare class DataAzurermWindowsFunctionAppStickySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsFunctionAppStickySettings | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppStickySettings | undefined);
    get appSettingNames(): string[];
    get connectionStringNames(): string[];
}
export declare class DataAzurermWindowsFunctionAppStickySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsFunctionAppStickySettingsOutputReference;
}
export interface DataAzurermWindowsFunctionAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app#read DataAzurermWindowsFunctionApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermWindowsFunctionAppTimeoutsToTerraform(struct?: DataAzurermWindowsFunctionAppTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermWindowsFunctionAppTimeoutsToHclTerraform(struct?: DataAzurermWindowsFunctionAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermWindowsFunctionAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermWindowsFunctionAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermWindowsFunctionAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app azurerm_windows_function_app}
*/
export declare class DataAzurermWindowsFunctionApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_windows_function_app";
    /**
    * Generates CDKTF code for importing a DataAzurermWindowsFunctionApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermWindowsFunctionApp to import
    * @param importFromId The id of the existing DataAzurermWindowsFunctionApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermWindowsFunctionApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/data-sources/windows_function_app azurerm_windows_function_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermWindowsFunctionAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermWindowsFunctionAppConfig);
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    private _authSettings;
    get authSettings(): DataAzurermWindowsFunctionAppAuthSettingsList;
    private _authSettingsV2;
    get authSettingsV2(): DataAzurermWindowsFunctionAppAuthSettingsV2List;
    private _backup;
    get backup(): DataAzurermWindowsFunctionAppBackupList;
    get builtinLoggingEnabled(): cdktf.IResolvable;
    get clientCertificateEnabled(): cdktf.IResolvable;
    get clientCertificateExclusionPaths(): string;
    get clientCertificateMode(): string;
    private _connectionString;
    get connectionString(): DataAzurermWindowsFunctionAppConnectionStringList;
    get contentShareForceDisabled(): cdktf.IResolvable;
    get customDomainVerificationId(): string;
    get dailyMemoryTimeQuota(): number;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    get ftpPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    get functionsExtensionVersion(): string;
    get hostingEnvironmentId(): string;
    get httpsOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermWindowsFunctionAppIdentityList;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get servicePlanId(): string;
    private _siteConfig;
    get siteConfig(): DataAzurermWindowsFunctionAppSiteConfigList;
    private _siteCredential;
    get siteCredential(): DataAzurermWindowsFunctionAppSiteCredentialList;
    private _stickySettings;
    get stickySettings(): DataAzurermWindowsFunctionAppStickySettingsList;
    get storageAccountAccessKey(): string;
    get storageAccountName(): string;
    get storageKeyVaultSecretId(): string;
    get storageUsesManagedIdentity(): cdktf.IResolvable;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualNetworkSubnetId(): string;
    get webdeployPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermWindowsFunctionAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermWindowsFunctionAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermWindowsFunctionAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
