/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExpressRouteCircuitConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#allow_classic_operations ExpressRouteCircuit#allow_classic_operations}
    */
    readonly allowClassicOperations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#authorization_key ExpressRouteCircuit#authorization_key}
    */
    readonly authorizationKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#bandwidth_in_gbps ExpressRouteCircuit#bandwidth_in_gbps}
    */
    readonly bandwidthInGbps?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#bandwidth_in_mbps ExpressRouteCircuit#bandwidth_in_mbps}
    */
    readonly bandwidthInMbps?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#express_route_port_id ExpressRouteCircuit#express_route_port_id}
    */
    readonly expressRoutePortId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#id ExpressRouteCircuit#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#location ExpressRouteCircuit#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#name ExpressRouteCircuit#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#peering_location ExpressRouteCircuit#peering_location}
    */
    readonly peeringLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#resource_group_name ExpressRouteCircuit#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#service_provider_name ExpressRouteCircuit#service_provider_name}
    */
    readonly serviceProviderName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#tags ExpressRouteCircuit#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#sku ExpressRouteCircuit#sku}
    */
    readonly sku: ExpressRouteCircuitSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#timeouts ExpressRouteCircuit#timeouts}
    */
    readonly timeouts?: ExpressRouteCircuitTimeouts;
}
export interface ExpressRouteCircuitSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#family ExpressRouteCircuit#family}
    */
    readonly family: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#tier ExpressRouteCircuit#tier}
    */
    readonly tier: string;
}
export declare function expressRouteCircuitSkuToTerraform(struct?: ExpressRouteCircuitSkuOutputReference | ExpressRouteCircuitSku): any;
export declare function expressRouteCircuitSkuToHclTerraform(struct?: ExpressRouteCircuitSkuOutputReference | ExpressRouteCircuitSku): any;
export declare class ExpressRouteCircuitSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteCircuitSku | undefined;
    set internalValue(value: ExpressRouteCircuitSku | undefined);
    private _family?;
    get family(): string;
    set family(value: string);
    get familyInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
}
export interface ExpressRouteCircuitTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#create ExpressRouteCircuit#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#delete ExpressRouteCircuit#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#read ExpressRouteCircuit#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#update ExpressRouteCircuit#update}
    */
    readonly update?: string;
}
export declare function expressRouteCircuitTimeoutsToTerraform(struct?: ExpressRouteCircuitTimeouts | cdktf.IResolvable): any;
export declare function expressRouteCircuitTimeoutsToHclTerraform(struct?: ExpressRouteCircuitTimeouts | cdktf.IResolvable): any;
export declare class ExpressRouteCircuitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteCircuitTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExpressRouteCircuitTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit azurerm_express_route_circuit}
*/
export declare class ExpressRouteCircuit extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_express_route_circuit";
    /**
    * Generates CDKTF code for importing a ExpressRouteCircuit resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExpressRouteCircuit to import
    * @param importFromId The id of the existing ExpressRouteCircuit that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExpressRouteCircuit to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/express_route_circuit azurerm_express_route_circuit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRouteCircuitConfig
    */
    constructor(scope: Construct, id: string, config: ExpressRouteCircuitConfig);
    private _allowClassicOperations?;
    get allowClassicOperations(): boolean | cdktf.IResolvable;
    set allowClassicOperations(value: boolean | cdktf.IResolvable);
    resetAllowClassicOperations(): void;
    get allowClassicOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _authorizationKey?;
    get authorizationKey(): string;
    set authorizationKey(value: string);
    resetAuthorizationKey(): void;
    get authorizationKeyInput(): string | undefined;
    private _bandwidthInGbps?;
    get bandwidthInGbps(): number;
    set bandwidthInGbps(value: number);
    resetBandwidthInGbps(): void;
    get bandwidthInGbpsInput(): number | undefined;
    private _bandwidthInMbps?;
    get bandwidthInMbps(): number;
    set bandwidthInMbps(value: number);
    resetBandwidthInMbps(): void;
    get bandwidthInMbpsInput(): number | undefined;
    private _expressRoutePortId?;
    get expressRoutePortId(): string;
    set expressRoutePortId(value: string);
    resetExpressRoutePortId(): void;
    get expressRoutePortIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peeringLocation?;
    get peeringLocation(): string;
    set peeringLocation(value: string);
    resetPeeringLocation(): void;
    get peeringLocationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceKey(): string;
    private _serviceProviderName?;
    get serviceProviderName(): string;
    set serviceProviderName(value: string);
    resetServiceProviderName(): void;
    get serviceProviderNameInput(): string | undefined;
    get serviceProviderProvisioningState(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _sku;
    get sku(): ExpressRouteCircuitSkuOutputReference;
    putSku(value: ExpressRouteCircuitSku): void;
    get skuInput(): ExpressRouteCircuitSku | undefined;
    private _timeouts;
    get timeouts(): ExpressRouteCircuitTimeoutsOutputReference;
    putTimeouts(value: ExpressRouteCircuitTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExpressRouteCircuitTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
