/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HdinsightKafkaClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#cluster_version HdinsightKafkaCluster#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#encryption_in_transit_enabled HdinsightKafkaCluster#encryption_in_transit_enabled}
    */
    readonly encryptionInTransitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#id HdinsightKafkaCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#location HdinsightKafkaCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#resource_group_name HdinsightKafkaCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#tags HdinsightKafkaCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#tier HdinsightKafkaCluster#tier}
    */
    readonly tier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#tls_min_version HdinsightKafkaCluster#tls_min_version}
    */
    readonly tlsMinVersion?: string;
    /**
    * component_version block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#component_version HdinsightKafkaCluster#component_version}
    */
    readonly componentVersion: HdinsightKafkaClusterComponentVersion;
    /**
    * compute_isolation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#compute_isolation HdinsightKafkaCluster#compute_isolation}
    */
    readonly computeIsolation?: HdinsightKafkaClusterComputeIsolation;
    /**
    * disk_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#disk_encryption HdinsightKafkaCluster#disk_encryption}
    */
    readonly diskEncryption?: HdinsightKafkaClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#extension HdinsightKafkaCluster#extension}
    */
    readonly extension?: HdinsightKafkaClusterExtension;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#gateway HdinsightKafkaCluster#gateway}
    */
    readonly gateway: HdinsightKafkaClusterGateway;
    /**
    * metastores block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#metastores HdinsightKafkaCluster#metastores}
    */
    readonly metastores?: HdinsightKafkaClusterMetastores;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#monitor HdinsightKafkaCluster#monitor}
    */
    readonly monitor?: HdinsightKafkaClusterMonitor;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#network HdinsightKafkaCluster#network}
    */
    readonly network?: HdinsightKafkaClusterNetwork;
    /**
    * private_link_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#private_link_configuration HdinsightKafkaCluster#private_link_configuration}
    */
    readonly privateLinkConfiguration?: HdinsightKafkaClusterPrivateLinkConfiguration;
    /**
    * rest_proxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#rest_proxy HdinsightKafkaCluster#rest_proxy}
    */
    readonly restProxy?: HdinsightKafkaClusterRestProxy;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#roles HdinsightKafkaCluster#roles}
    */
    readonly roles: HdinsightKafkaClusterRoles;
    /**
    * security_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#security_profile HdinsightKafkaCluster#security_profile}
    */
    readonly securityProfile?: HdinsightKafkaClusterSecurityProfile;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#storage_account HdinsightKafkaCluster#storage_account}
    */
    readonly storageAccount?: HdinsightKafkaClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * storage_account_gen2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#storage_account_gen2 HdinsightKafkaCluster#storage_account_gen2}
    */
    readonly storageAccountGen2?: HdinsightKafkaClusterStorageAccountGen2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#timeouts HdinsightKafkaCluster#timeouts}
    */
    readonly timeouts?: HdinsightKafkaClusterTimeouts;
}
export interface HdinsightKafkaClusterComponentVersion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#kafka HdinsightKafkaCluster#kafka}
    */
    readonly kafka: string;
}
export declare function hdinsightKafkaClusterComponentVersionToTerraform(struct?: HdinsightKafkaClusterComponentVersionOutputReference | HdinsightKafkaClusterComponentVersion): any;
export declare function hdinsightKafkaClusterComponentVersionToHclTerraform(struct?: HdinsightKafkaClusterComponentVersionOutputReference | HdinsightKafkaClusterComponentVersion): any;
export declare class HdinsightKafkaClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterComponentVersion | undefined;
    set internalValue(value: HdinsightKafkaClusterComponentVersion | undefined);
    private _kafka?;
    get kafka(): string;
    set kafka(value: string);
    get kafkaInput(): string | undefined;
}
export interface HdinsightKafkaClusterComputeIsolation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#compute_isolation_enabled HdinsightKafkaCluster#compute_isolation_enabled}
    */
    readonly computeIsolationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#host_sku HdinsightKafkaCluster#host_sku}
    */
    readonly hostSku?: string;
}
export declare function hdinsightKafkaClusterComputeIsolationToTerraform(struct?: HdinsightKafkaClusterComputeIsolationOutputReference | HdinsightKafkaClusterComputeIsolation): any;
export declare function hdinsightKafkaClusterComputeIsolationToHclTerraform(struct?: HdinsightKafkaClusterComputeIsolationOutputReference | HdinsightKafkaClusterComputeIsolation): any;
export declare class HdinsightKafkaClusterComputeIsolationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterComputeIsolation | undefined;
    set internalValue(value: HdinsightKafkaClusterComputeIsolation | undefined);
    private _computeIsolationEnabled?;
    get computeIsolationEnabled(): boolean | cdktf.IResolvable;
    set computeIsolationEnabled(value: boolean | cdktf.IResolvable);
    resetComputeIsolationEnabled(): void;
    get computeIsolationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostSku?;
    get hostSku(): string;
    set hostSku(value: string);
    resetHostSku(): void;
    get hostSkuInput(): string | undefined;
}
export interface HdinsightKafkaClusterDiskEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#encryption_algorithm HdinsightKafkaCluster#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#encryption_at_host_enabled HdinsightKafkaCluster#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#key_vault_key_id HdinsightKafkaCluster#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#key_vault_managed_identity_id HdinsightKafkaCluster#key_vault_managed_identity_id}
    */
    readonly keyVaultManagedIdentityId?: string;
}
export declare function hdinsightKafkaClusterDiskEncryptionToTerraform(struct?: HdinsightKafkaClusterDiskEncryption | cdktf.IResolvable): any;
export declare function hdinsightKafkaClusterDiskEncryptionToHclTerraform(struct?: HdinsightKafkaClusterDiskEncryption | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightKafkaClusterDiskEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightKafkaClusterDiskEncryption | cdktf.IResolvable | undefined);
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
    private _keyVaultManagedIdentityId?;
    get keyVaultManagedIdentityId(): string;
    set keyVaultManagedIdentityId(value: string);
    resetKeyVaultManagedIdentityId(): void;
    get keyVaultManagedIdentityIdInput(): string | undefined;
}
export declare class HdinsightKafkaClusterDiskEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightKafkaClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightKafkaClusterDiskEncryptionOutputReference;
}
export interface HdinsightKafkaClusterExtension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#log_analytics_workspace_id HdinsightKafkaCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#primary_key HdinsightKafkaCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightKafkaClusterExtensionToTerraform(struct?: HdinsightKafkaClusterExtensionOutputReference | HdinsightKafkaClusterExtension): any;
export declare function hdinsightKafkaClusterExtensionToHclTerraform(struct?: HdinsightKafkaClusterExtensionOutputReference | HdinsightKafkaClusterExtension): any;
export declare class HdinsightKafkaClusterExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterExtension | undefined;
    set internalValue(value: HdinsightKafkaClusterExtension | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightKafkaClusterGateway {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterGatewayToTerraform(struct?: HdinsightKafkaClusterGatewayOutputReference | HdinsightKafkaClusterGateway): any;
export declare function hdinsightKafkaClusterGatewayToHclTerraform(struct?: HdinsightKafkaClusterGatewayOutputReference | HdinsightKafkaClusterGateway): any;
export declare class HdinsightKafkaClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterGateway | undefined;
    set internalValue(value: HdinsightKafkaClusterGateway | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastoresAmbari {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#database_name HdinsightKafkaCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#server HdinsightKafkaCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresAmbariToTerraform(struct?: HdinsightKafkaClusterMetastoresAmbariOutputReference | HdinsightKafkaClusterMetastoresAmbari): any;
export declare function hdinsightKafkaClusterMetastoresAmbariToHclTerraform(struct?: HdinsightKafkaClusterMetastoresAmbariOutputReference | HdinsightKafkaClusterMetastoresAmbari): any;
export declare class HdinsightKafkaClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterMetastoresAmbari | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastoresAmbari | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastoresHive {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#database_name HdinsightKafkaCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#server HdinsightKafkaCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresHiveToTerraform(struct?: HdinsightKafkaClusterMetastoresHiveOutputReference | HdinsightKafkaClusterMetastoresHive): any;
export declare function hdinsightKafkaClusterMetastoresHiveToHclTerraform(struct?: HdinsightKafkaClusterMetastoresHiveOutputReference | HdinsightKafkaClusterMetastoresHive): any;
export declare class HdinsightKafkaClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterMetastoresHive | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastoresHive | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastoresOozie {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#database_name HdinsightKafkaCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#server HdinsightKafkaCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresOozieToTerraform(struct?: HdinsightKafkaClusterMetastoresOozieOutputReference | HdinsightKafkaClusterMetastoresOozie): any;
export declare function hdinsightKafkaClusterMetastoresOozieToHclTerraform(struct?: HdinsightKafkaClusterMetastoresOozieOutputReference | HdinsightKafkaClusterMetastoresOozie): any;
export declare class HdinsightKafkaClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterMetastoresOozie | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastoresOozie | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightKafkaClusterMetastores {
    /**
    * ambari block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#ambari HdinsightKafkaCluster#ambari}
    */
    readonly ambari?: HdinsightKafkaClusterMetastoresAmbari;
    /**
    * hive block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#hive HdinsightKafkaCluster#hive}
    */
    readonly hive?: HdinsightKafkaClusterMetastoresHive;
    /**
    * oozie block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#oozie HdinsightKafkaCluster#oozie}
    */
    readonly oozie?: HdinsightKafkaClusterMetastoresOozie;
}
export declare function hdinsightKafkaClusterMetastoresToTerraform(struct?: HdinsightKafkaClusterMetastoresOutputReference | HdinsightKafkaClusterMetastores): any;
export declare function hdinsightKafkaClusterMetastoresToHclTerraform(struct?: HdinsightKafkaClusterMetastoresOutputReference | HdinsightKafkaClusterMetastores): any;
export declare class HdinsightKafkaClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterMetastores | undefined;
    set internalValue(value: HdinsightKafkaClusterMetastores | undefined);
    private _ambari;
    get ambari(): HdinsightKafkaClusterMetastoresAmbariOutputReference;
    putAmbari(value: HdinsightKafkaClusterMetastoresAmbari): void;
    resetAmbari(): void;
    get ambariInput(): HdinsightKafkaClusterMetastoresAmbari | undefined;
    private _hive;
    get hive(): HdinsightKafkaClusterMetastoresHiveOutputReference;
    putHive(value: HdinsightKafkaClusterMetastoresHive): void;
    resetHive(): void;
    get hiveInput(): HdinsightKafkaClusterMetastoresHive | undefined;
    private _oozie;
    get oozie(): HdinsightKafkaClusterMetastoresOozieOutputReference;
    putOozie(value: HdinsightKafkaClusterMetastoresOozie): void;
    resetOozie(): void;
    get oozieInput(): HdinsightKafkaClusterMetastoresOozie | undefined;
}
export interface HdinsightKafkaClusterMonitor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#log_analytics_workspace_id HdinsightKafkaCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#primary_key HdinsightKafkaCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightKafkaClusterMonitorToTerraform(struct?: HdinsightKafkaClusterMonitorOutputReference | HdinsightKafkaClusterMonitor): any;
export declare function hdinsightKafkaClusterMonitorToHclTerraform(struct?: HdinsightKafkaClusterMonitorOutputReference | HdinsightKafkaClusterMonitor): any;
export declare class HdinsightKafkaClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterMonitor | undefined;
    set internalValue(value: HdinsightKafkaClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightKafkaClusterNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#connection_direction HdinsightKafkaCluster#connection_direction}
    */
    readonly connectionDirection?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#private_link_enabled HdinsightKafkaCluster#private_link_enabled}
    */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightKafkaClusterNetworkToTerraform(struct?: HdinsightKafkaClusterNetworkOutputReference | HdinsightKafkaClusterNetwork): any;
export declare function hdinsightKafkaClusterNetworkToHclTerraform(struct?: HdinsightKafkaClusterNetworkOutputReference | HdinsightKafkaClusterNetwork): any;
export declare class HdinsightKafkaClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterNetwork | undefined;
    set internalValue(value: HdinsightKafkaClusterNetwork | undefined);
    private _connectionDirection?;
    get connectionDirection(): string;
    set connectionDirection(value: string);
    resetConnectionDirection(): void;
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateLinkEnabled(): void;
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#primary HdinsightKafkaCluster#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#private_ip_address HdinsightKafkaCluster#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#private_ip_allocation_method HdinsightKafkaCluster#private_ip_allocation_method}
    */
    readonly privateIpAllocationMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function hdinsightKafkaClusterPrivateLinkConfigurationIpConfigurationToTerraform(struct?: HdinsightKafkaClusterPrivateLinkConfigurationIpConfigurationOutputReference | HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration): any;
export declare function hdinsightKafkaClusterPrivateLinkConfigurationIpConfigurationToHclTerraform(struct?: HdinsightKafkaClusterPrivateLinkConfigurationIpConfigurationOutputReference | HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration): any;
export declare class HdinsightKafkaClusterPrivateLinkConfigurationIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration | undefined;
    set internalValue(value: HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _privateIpAllocationMethod?;
    get privateIpAllocationMethod(): string;
    set privateIpAllocationMethod(value: string);
    resetPrivateIpAllocationMethod(): void;
    get privateIpAllocationMethodInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export interface HdinsightKafkaClusterPrivateLinkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#group_id HdinsightKafkaCluster#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#ip_configuration HdinsightKafkaCluster#ip_configuration}
    */
    readonly ipConfiguration: HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration;
}
export declare function hdinsightKafkaClusterPrivateLinkConfigurationToTerraform(struct?: HdinsightKafkaClusterPrivateLinkConfigurationOutputReference | HdinsightKafkaClusterPrivateLinkConfiguration): any;
export declare function hdinsightKafkaClusterPrivateLinkConfigurationToHclTerraform(struct?: HdinsightKafkaClusterPrivateLinkConfigurationOutputReference | HdinsightKafkaClusterPrivateLinkConfiguration): any;
export declare class HdinsightKafkaClusterPrivateLinkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterPrivateLinkConfiguration | undefined;
    set internalValue(value: HdinsightKafkaClusterPrivateLinkConfiguration | undefined);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): HdinsightKafkaClusterPrivateLinkConfigurationIpConfigurationOutputReference;
    putIpConfiguration(value: HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration): void;
    get ipConfigurationInput(): HdinsightKafkaClusterPrivateLinkConfigurationIpConfiguration | undefined;
}
export interface HdinsightKafkaClusterRestProxy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#security_group_id HdinsightKafkaCluster#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#security_group_name HdinsightKafkaCluster#security_group_name}
    */
    readonly securityGroupName: string;
}
export declare function hdinsightKafkaClusterRestProxyToTerraform(struct?: HdinsightKafkaClusterRestProxyOutputReference | HdinsightKafkaClusterRestProxy): any;
export declare function hdinsightKafkaClusterRestProxyToHclTerraform(struct?: HdinsightKafkaClusterRestProxyOutputReference | HdinsightKafkaClusterRestProxy): any;
export declare class HdinsightKafkaClusterRestProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterRestProxy | undefined;
    set internalValue(value: HdinsightKafkaClusterRestProxy | undefined);
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    private _securityGroupName?;
    get securityGroupName(): string;
    set securityGroupName(value: string);
    get securityGroupNameInput(): string | undefined;
}
export interface HdinsightKafkaClusterRolesHeadNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#parameters HdinsightKafkaCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#uri HdinsightKafkaCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightKafkaClusterRolesHeadNodeScriptActionsToTerraform(struct?: HdinsightKafkaClusterRolesHeadNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightKafkaClusterRolesHeadNodeScriptActionsToHclTerraform(struct?: HdinsightKafkaClusterRolesHeadNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterRolesHeadNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightKafkaClusterRolesHeadNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesHeadNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightKafkaClusterRolesHeadNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightKafkaClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightKafkaClusterRolesHeadNodeScriptActionsOutputReference;
}
export interface HdinsightKafkaClusterRolesHeadNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#script_actions HdinsightKafkaCluster#script_actions}
    */
    readonly scriptActions?: HdinsightKafkaClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightKafkaClusterRolesHeadNodeToTerraform(struct?: HdinsightKafkaClusterRolesHeadNodeOutputReference | HdinsightKafkaClusterRolesHeadNode): any;
export declare function hdinsightKafkaClusterRolesHeadNodeToHclTerraform(struct?: HdinsightKafkaClusterRolesHeadNodeOutputReference | HdinsightKafkaClusterRolesHeadNode): any;
export declare class HdinsightKafkaClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterRolesHeadNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesHeadNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightKafkaClusterRolesHeadNodeScriptActionsList;
    putScriptActions(value: HdinsightKafkaClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightKafkaClusterRolesHeadNodeScriptActions[] | undefined;
}
export interface HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#parameters HdinsightKafkaCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#uri HdinsightKafkaCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightKafkaClusterRolesKafkaManagementNodeScriptActionsToTerraform(struct?: HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightKafkaClusterRolesKafkaManagementNodeScriptActionsToHclTerraform(struct?: HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterRolesKafkaManagementNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightKafkaClusterRolesKafkaManagementNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightKafkaClusterRolesKafkaManagementNodeScriptActionsOutputReference;
}
export interface HdinsightKafkaClusterRolesKafkaManagementNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#script_actions HdinsightKafkaCluster#script_actions}
    */
    readonly scriptActions?: HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightKafkaClusterRolesKafkaManagementNodeToTerraform(struct?: HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference | HdinsightKafkaClusterRolesKafkaManagementNode): any;
export declare function hdinsightKafkaClusterRolesKafkaManagementNodeToHclTerraform(struct?: HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference | HdinsightKafkaClusterRolesKafkaManagementNode): any;
export declare class HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterRolesKafkaManagementNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesKafkaManagementNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightKafkaClusterRolesKafkaManagementNodeScriptActionsList;
    putScriptActions(value: HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightKafkaClusterRolesKafkaManagementNodeScriptActions[] | undefined;
}
export interface HdinsightKafkaClusterRolesWorkerNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#parameters HdinsightKafkaCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#uri HdinsightKafkaCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightKafkaClusterRolesWorkerNodeScriptActionsToTerraform(struct?: HdinsightKafkaClusterRolesWorkerNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightKafkaClusterRolesWorkerNodeScriptActionsToHclTerraform(struct?: HdinsightKafkaClusterRolesWorkerNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterRolesWorkerNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightKafkaClusterRolesWorkerNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesWorkerNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightKafkaClusterRolesWorkerNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightKafkaClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightKafkaClusterRolesWorkerNodeScriptActionsOutputReference;
}
export interface HdinsightKafkaClusterRolesWorkerNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#number_of_disks_per_node HdinsightKafkaCluster#number_of_disks_per_node}
    */
    readonly numberOfDisksPerNode: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#target_instance_count HdinsightKafkaCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#script_actions HdinsightKafkaCluster#script_actions}
    */
    readonly scriptActions?: HdinsightKafkaClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightKafkaClusterRolesWorkerNodeToTerraform(struct?: HdinsightKafkaClusterRolesWorkerNodeOutputReference | HdinsightKafkaClusterRolesWorkerNode): any;
export declare function hdinsightKafkaClusterRolesWorkerNodeToHclTerraform(struct?: HdinsightKafkaClusterRolesWorkerNodeOutputReference | HdinsightKafkaClusterRolesWorkerNode): any;
export declare class HdinsightKafkaClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterRolesWorkerNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesWorkerNode | undefined);
    private _numberOfDisksPerNode?;
    get numberOfDisksPerNode(): number;
    set numberOfDisksPerNode(value: number);
    get numberOfDisksPerNodeInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightKafkaClusterRolesWorkerNodeScriptActionsList;
    putScriptActions(value: HdinsightKafkaClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightKafkaClusterRolesWorkerNodeScriptActions[] | undefined;
}
export interface HdinsightKafkaClusterRolesZookeeperNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#name HdinsightKafkaCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#parameters HdinsightKafkaCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#uri HdinsightKafkaCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightKafkaClusterRolesZookeeperNodeScriptActionsToTerraform(struct?: HdinsightKafkaClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightKafkaClusterRolesZookeeperNodeScriptActionsToHclTerraform(struct?: HdinsightKafkaClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterRolesZookeeperNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightKafkaClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightKafkaClusterRolesZookeeperNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightKafkaClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightKafkaClusterRolesZookeeperNodeScriptActionsOutputReference;
}
export interface HdinsightKafkaClusterRolesZookeeperNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#password HdinsightKafkaCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#ssh_keys HdinsightKafkaCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#subnet_id HdinsightKafkaCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#username HdinsightKafkaCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#virtual_network_id HdinsightKafkaCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#vm_size HdinsightKafkaCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#script_actions HdinsightKafkaCluster#script_actions}
    */
    readonly scriptActions?: HdinsightKafkaClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightKafkaClusterRolesZookeeperNodeToTerraform(struct?: HdinsightKafkaClusterRolesZookeeperNodeOutputReference | HdinsightKafkaClusterRolesZookeeperNode): any;
export declare function hdinsightKafkaClusterRolesZookeeperNodeToHclTerraform(struct?: HdinsightKafkaClusterRolesZookeeperNodeOutputReference | HdinsightKafkaClusterRolesZookeeperNode): any;
export declare class HdinsightKafkaClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterRolesZookeeperNode | undefined;
    set internalValue(value: HdinsightKafkaClusterRolesZookeeperNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightKafkaClusterRolesZookeeperNodeScriptActionsList;
    putScriptActions(value: HdinsightKafkaClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightKafkaClusterRolesZookeeperNodeScriptActions[] | undefined;
}
export interface HdinsightKafkaClusterRoles {
    /**
    * head_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#head_node HdinsightKafkaCluster#head_node}
    */
    readonly headNode: HdinsightKafkaClusterRolesHeadNode;
    /**
    * kafka_management_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#kafka_management_node HdinsightKafkaCluster#kafka_management_node}
    */
    readonly kafkaManagementNode?: HdinsightKafkaClusterRolesKafkaManagementNode;
    /**
    * worker_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#worker_node HdinsightKafkaCluster#worker_node}
    */
    readonly workerNode: HdinsightKafkaClusterRolesWorkerNode;
    /**
    * zookeeper_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#zookeeper_node HdinsightKafkaCluster#zookeeper_node}
    */
    readonly zookeeperNode: HdinsightKafkaClusterRolesZookeeperNode;
}
export declare function hdinsightKafkaClusterRolesToTerraform(struct?: HdinsightKafkaClusterRolesOutputReference | HdinsightKafkaClusterRoles): any;
export declare function hdinsightKafkaClusterRolesToHclTerraform(struct?: HdinsightKafkaClusterRolesOutputReference | HdinsightKafkaClusterRoles): any;
export declare class HdinsightKafkaClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterRoles | undefined;
    set internalValue(value: HdinsightKafkaClusterRoles | undefined);
    private _headNode;
    get headNode(): HdinsightKafkaClusterRolesHeadNodeOutputReference;
    putHeadNode(value: HdinsightKafkaClusterRolesHeadNode): void;
    get headNodeInput(): HdinsightKafkaClusterRolesHeadNode | undefined;
    private _kafkaManagementNode;
    get kafkaManagementNode(): HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference;
    putKafkaManagementNode(value: HdinsightKafkaClusterRolesKafkaManagementNode): void;
    resetKafkaManagementNode(): void;
    get kafkaManagementNodeInput(): HdinsightKafkaClusterRolesKafkaManagementNode | undefined;
    private _workerNode;
    get workerNode(): HdinsightKafkaClusterRolesWorkerNodeOutputReference;
    putWorkerNode(value: HdinsightKafkaClusterRolesWorkerNode): void;
    get workerNodeInput(): HdinsightKafkaClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    get zookeeperNode(): HdinsightKafkaClusterRolesZookeeperNodeOutputReference;
    putZookeeperNode(value: HdinsightKafkaClusterRolesZookeeperNode): void;
    get zookeeperNodeInput(): HdinsightKafkaClusterRolesZookeeperNode | undefined;
}
export interface HdinsightKafkaClusterSecurityProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#aadds_resource_id HdinsightKafkaCluster#aadds_resource_id}
    */
    readonly aaddsResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#cluster_users_group_dns HdinsightKafkaCluster#cluster_users_group_dns}
    */
    readonly clusterUsersGroupDns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#domain_name HdinsightKafkaCluster#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#domain_user_password HdinsightKafkaCluster#domain_user_password}
    */
    readonly domainUserPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#domain_username HdinsightKafkaCluster#domain_username}
    */
    readonly domainUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#ldaps_urls HdinsightKafkaCluster#ldaps_urls}
    */
    readonly ldapsUrls: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#msi_resource_id HdinsightKafkaCluster#msi_resource_id}
    */
    readonly msiResourceId: string;
}
export declare function hdinsightKafkaClusterSecurityProfileToTerraform(struct?: HdinsightKafkaClusterSecurityProfileOutputReference | HdinsightKafkaClusterSecurityProfile): any;
export declare function hdinsightKafkaClusterSecurityProfileToHclTerraform(struct?: HdinsightKafkaClusterSecurityProfileOutputReference | HdinsightKafkaClusterSecurityProfile): any;
export declare class HdinsightKafkaClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterSecurityProfile | undefined;
    set internalValue(value: HdinsightKafkaClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    get aaddsResourceId(): string;
    set aaddsResourceId(value: string);
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    get clusterUsersGroupDns(): string[];
    set clusterUsersGroupDns(value: string[]);
    resetClusterUsersGroupDns(): void;
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    get domainUserPassword(): string;
    set domainUserPassword(value: string);
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    get domainUsername(): string;
    set domainUsername(value: string);
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    get ldapsUrls(): string[];
    set ldapsUrls(value: string[]);
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    get msiResourceId(): string;
    set msiResourceId(value: string);
    get msiResourceIdInput(): string | undefined;
}
export interface HdinsightKafkaClusterStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#is_default HdinsightKafkaCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#storage_account_key HdinsightKafkaCluster#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#storage_container_id HdinsightKafkaCluster#storage_container_id}
    */
    readonly storageContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#storage_resource_id HdinsightKafkaCluster#storage_resource_id}
    */
    readonly storageResourceId?: string;
}
export declare function hdinsightKafkaClusterStorageAccountToTerraform(struct?: HdinsightKafkaClusterStorageAccount | cdktf.IResolvable): any;
export declare function hdinsightKafkaClusterStorageAccountToHclTerraform(struct?: HdinsightKafkaClusterStorageAccount | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightKafkaClusterStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightKafkaClusterStorageAccount | cdktf.IResolvable | undefined);
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    get storageAccountKeyInput(): string | undefined;
    private _storageContainerId?;
    get storageContainerId(): string;
    set storageContainerId(value: string);
    get storageContainerIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    resetStorageResourceId(): void;
    get storageResourceIdInput(): string | undefined;
}
export declare class HdinsightKafkaClusterStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightKafkaClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightKafkaClusterStorageAccountOutputReference;
}
export interface HdinsightKafkaClusterStorageAccountGen2 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#filesystem_id HdinsightKafkaCluster#filesystem_id}
    */
    readonly filesystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#is_default HdinsightKafkaCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#managed_identity_resource_id HdinsightKafkaCluster#managed_identity_resource_id}
    */
    readonly managedIdentityResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#storage_resource_id HdinsightKafkaCluster#storage_resource_id}
    */
    readonly storageResourceId: string;
}
export declare function hdinsightKafkaClusterStorageAccountGen2ToTerraform(struct?: HdinsightKafkaClusterStorageAccountGen2OutputReference | HdinsightKafkaClusterStorageAccountGen2): any;
export declare function hdinsightKafkaClusterStorageAccountGen2ToHclTerraform(struct?: HdinsightKafkaClusterStorageAccountGen2OutputReference | HdinsightKafkaClusterStorageAccountGen2): any;
export declare class HdinsightKafkaClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterStorageAccountGen2 | undefined;
    set internalValue(value: HdinsightKafkaClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    get filesystemId(): string;
    set filesystemId(value: string);
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    get managedIdentityResourceId(): string;
    set managedIdentityResourceId(value: string);
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    get storageResourceIdInput(): string | undefined;
}
export interface HdinsightKafkaClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#create HdinsightKafkaCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#delete HdinsightKafkaCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#read HdinsightKafkaCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#update HdinsightKafkaCluster#update}
    */
    readonly update?: string;
}
export declare function hdinsightKafkaClusterTimeoutsToTerraform(struct?: HdinsightKafkaClusterTimeouts | cdktf.IResolvable): any;
export declare function hdinsightKafkaClusterTimeoutsToHclTerraform(struct?: HdinsightKafkaClusterTimeouts | cdktf.IResolvable): any;
export declare class HdinsightKafkaClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightKafkaClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightKafkaClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster azurerm_hdinsight_kafka_cluster}
*/
export declare class HdinsightKafkaCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hdinsight_kafka_cluster";
    /**
    * Generates CDKTF code for importing a HdinsightKafkaCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HdinsightKafkaCluster to import
    * @param importFromId The id of the existing HdinsightKafkaCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HdinsightKafkaCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hdinsight_kafka_cluster azurerm_hdinsight_kafka_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HdinsightKafkaClusterConfig
    */
    constructor(scope: Construct, id: string, config: HdinsightKafkaClusterConfig);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _encryptionInTransitEnabled?;
    get encryptionInTransitEnabled(): boolean | cdktf.IResolvable;
    set encryptionInTransitEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionInTransitEnabled(): void;
    get encryptionInTransitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get httpsEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kafkaRestProxyEndpoint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sshEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    get componentVersion(): HdinsightKafkaClusterComponentVersionOutputReference;
    putComponentVersion(value: HdinsightKafkaClusterComponentVersion): void;
    get componentVersionInput(): HdinsightKafkaClusterComponentVersion | undefined;
    private _computeIsolation;
    get computeIsolation(): HdinsightKafkaClusterComputeIsolationOutputReference;
    putComputeIsolation(value: HdinsightKafkaClusterComputeIsolation): void;
    resetComputeIsolation(): void;
    get computeIsolationInput(): HdinsightKafkaClusterComputeIsolation | undefined;
    private _diskEncryption;
    get diskEncryption(): HdinsightKafkaClusterDiskEncryptionList;
    putDiskEncryption(value: HdinsightKafkaClusterDiskEncryption[] | cdktf.IResolvable): void;
    resetDiskEncryption(): void;
    get diskEncryptionInput(): cdktf.IResolvable | HdinsightKafkaClusterDiskEncryption[] | undefined;
    private _extension;
    get extension(): HdinsightKafkaClusterExtensionOutputReference;
    putExtension(value: HdinsightKafkaClusterExtension): void;
    resetExtension(): void;
    get extensionInput(): HdinsightKafkaClusterExtension | undefined;
    private _gateway;
    get gateway(): HdinsightKafkaClusterGatewayOutputReference;
    putGateway(value: HdinsightKafkaClusterGateway): void;
    get gatewayInput(): HdinsightKafkaClusterGateway | undefined;
    private _metastores;
    get metastores(): HdinsightKafkaClusterMetastoresOutputReference;
    putMetastores(value: HdinsightKafkaClusterMetastores): void;
    resetMetastores(): void;
    get metastoresInput(): HdinsightKafkaClusterMetastores | undefined;
    private _monitor;
    get monitor(): HdinsightKafkaClusterMonitorOutputReference;
    putMonitor(value: HdinsightKafkaClusterMonitor): void;
    resetMonitor(): void;
    get monitorInput(): HdinsightKafkaClusterMonitor | undefined;
    private _network;
    get network(): HdinsightKafkaClusterNetworkOutputReference;
    putNetwork(value: HdinsightKafkaClusterNetwork): void;
    resetNetwork(): void;
    get networkInput(): HdinsightKafkaClusterNetwork | undefined;
    private _privateLinkConfiguration;
    get privateLinkConfiguration(): HdinsightKafkaClusterPrivateLinkConfigurationOutputReference;
    putPrivateLinkConfiguration(value: HdinsightKafkaClusterPrivateLinkConfiguration): void;
    resetPrivateLinkConfiguration(): void;
    get privateLinkConfigurationInput(): HdinsightKafkaClusterPrivateLinkConfiguration | undefined;
    private _restProxy;
    get restProxy(): HdinsightKafkaClusterRestProxyOutputReference;
    putRestProxy(value: HdinsightKafkaClusterRestProxy): void;
    resetRestProxy(): void;
    get restProxyInput(): HdinsightKafkaClusterRestProxy | undefined;
    private _roles;
    get roles(): HdinsightKafkaClusterRolesOutputReference;
    putRoles(value: HdinsightKafkaClusterRoles): void;
    get rolesInput(): HdinsightKafkaClusterRoles | undefined;
    private _securityProfile;
    get securityProfile(): HdinsightKafkaClusterSecurityProfileOutputReference;
    putSecurityProfile(value: HdinsightKafkaClusterSecurityProfile): void;
    resetSecurityProfile(): void;
    get securityProfileInput(): HdinsightKafkaClusterSecurityProfile | undefined;
    private _storageAccount;
    get storageAccount(): HdinsightKafkaClusterStorageAccountList;
    putStorageAccount(value: HdinsightKafkaClusterStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | HdinsightKafkaClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    get storageAccountGen2(): HdinsightKafkaClusterStorageAccountGen2OutputReference;
    putStorageAccountGen2(value: HdinsightKafkaClusterStorageAccountGen2): void;
    resetStorageAccountGen2(): void;
    get storageAccountGen2Input(): HdinsightKafkaClusterStorageAccountGen2 | undefined;
    private _timeouts;
    get timeouts(): HdinsightKafkaClusterTimeoutsOutputReference;
    putTimeouts(value: HdinsightKafkaClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HdinsightKafkaClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
